/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.epress;

import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.epress.EPressConf;
import com.trs.components.wcm.epress.EPressHistoryGenerator;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;

public class DocumentLCListener4EPress
implements IObjectLCListenerOnModify,
IObjectLCListenerOnDel {
    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (baseObj == null || baseObj.getWCMType() != 605) {
            return;
        }
        Document document = (Document)baseObj;
        if (!document.isChangeProperty("DOCTITLE")) {
            return;
        }
        this.onEvent(document);
    }

    private void onEvent(Document document) throws WCMException {
        Channel channel = null;
        try {
            channel = document.getChannel().getParent();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (channel == null || !EPressConf.instance().existsEPress(channel.getId())) {
            return;
        }
        String string = document.getPropertyAsString("PUBLISHDATE");
        CMyDateTime cMyDateTime = CMyDateTime.now();
        if (CMyString.isEmpty(string) || cMyDateTime.toString("yyyy.MM.dd").equals(string)) {
            return;
        }
        try {
            cMyDateTime.setDateWithString(string, 1);
        }
        catch (CMyException cMyException) {
            // empty catch block
        }
        EPressHistoryGenerator ePressHistoryGenerator = new EPressHistoryGenerator(channel);
        ePressHistoryGenerator.generate(cMyDateTime);
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        if (baseObj == null || baseObj.getWCMType() != 605) {
            return;
        }
        Document document = (Document)baseObj;
        this.onEvent(document);
    }
}

