/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.customize;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.customize.UserSettings;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import java.sql.SQLException;

public class UserSetting
extends CMSObj {
    public static final int OBJ_TYPE = 314;
    public static final String DB_TABLE_NAME = "WCMUSERSETTING";
    public static final String DB_ID_NAME = "SETTINGID";
    public static final int CHANNEL_GROUP_TYPE = 800;
    public static final int TOP_REGION_NUMBER = 1;
    public static final int BOTTOM_REGION_NUMBER = 2;
    public static final int LEFT_REGION_NUMBER = 3;
    public static final int MIDDLE_REGION_NUMBER = 4;
    public static final int RIGHT_REGION_NUMBER = 5;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 314;
    }

    public String getValue() {
        return this.getPropertyAsString("CVALUE");
    }

    public boolean setValue(String string) throws WCMException {
        return this.setProperty("CVALUE", string);
    }

    public int getRegion() {
        return this.getPropertyAsInt("CREGION", 3);
    }

    public boolean setRegion(int n) throws WCMException {
        return this.setProperty("CREGION", n);
    }

    public int getUser() {
        return this.getPropertyAsInt("USERID", 0);
    }

    public User getOwner() throws WCMException {
        int n = this.getUser();
        return User.findById(n);
    }

    public boolean setUser(int n) throws WCMException {
        if (n <= 0) {
            throw new WCMException(10, I18NMessage.get(UserSetting.class, "UserSetting.label1", "\u65e0\u6548\u7684\u7528\u6237ID(UserSetting.setUser)"));
        }
        User user = User.findById(n);
        if (user == null) {
            throw new WCMException(10, I18NMessage.get(UserSetting.class, "UserSetting.label2", "\u65e0\u6548\u7684\u7528\u6237ID\uff1a\u7528\u6237\u4e0d\u5b58\u5728(UserSetting.setUser)"));
        }
        return this.setProperty("USERID", n);
    }

    public boolean setUser(User user) throws WCMException {
        if (user == null || !user.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(UserSetting.class, "UserSetting.label3", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61(UserSetting.setUser)"));
        }
        return this.setUser(user.getId());
    }

    public int getObjType() {
        return this.getPropertyAsInt("OBJTYPE", 0);
    }

    public boolean setObjType(int n) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(UserSetting.class, "UserSetting.label4", "ObjType\u503c\u4e0d\u5141\u8bb8\u4fee\u6539(UserSetting.setObjType)"));
        }
        return this.setProperty("OBJTYPE", n);
    }

    public int getObjId() {
        return this.getPropertyAsInt("OBJID", 0);
    }

    public boolean setObjId(int n) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(UserSetting.class, "UserSetting.label5", "ObjId\u503c\u4e0d\u5141\u8bb8\u4fee\u6539(UserSetting.setObjId)"));
        }
        if (n < 0) {
            throw new WCMException(1104, I18NMessage.get(UserSetting.class, "UserSetting.label6", "ObjId\u503c\u65e0\u6548(UserSetting.setObjId)"));
        }
        return this.setProperty("OBJID", n);
    }

    public int getOrder() {
        return this.getPropertyAsInt("RANGEINDEX", 0);
    }

    public boolean setOrder(int n) throws WCMException {
        return this.setProperty("RANGEINDEX", n);
    }

    public String getAttribute() {
        return (String)this.getProperty("ATTRIBUTE");
    }

    public boolean setAttribute(String string) throws WCMException {
        return this.setProperty("ATTRIBUTE", string);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void changeOrder(int var1_1) throws WCMException {
        block21: {
            block19: {
                block17: {
                    block18: {
                        var2_2 = null;
                        var3_3 = null;
                        try {
                            try {
                                if (this.isAddMode()) {
                                    var5_4 = "RANGEINDEX>=" + var1_1;
                                    var6_5 = true;
                                } else {
                                    var7_6 = this.getOrder();
                                    if (var1_1 == var7_6) {
                                        var9_9 = null;
                                        if (var3_3 == null) break block17;
                                        break block18;
                                    }
                                    if (var1_1 < var7_6) {
                                        var5_4 = " (RANGEINDEX>=" + var1_1 + ") and (RANGEINDEX<" + var7_6 + ") and USERID=" + this.getUser();
                                        var6_5 = true;
                                    } else {
                                        var5_4 = " (RANGEINDEX>" + var7_6 + ") and (RANGEINDEX<=" + var1_1 + ") and USERID=" + this.getUser();
                                        var6_5 = false;
                                    }
                                }
                                var2_2 = this.getDBManager().getConnection();
                                var3_3 = var2_2.createStatement();
                                var4_15 = "update " + this.getDbTableName() + " set RANGEINDEX=RANGEINDEX" + (var6_5 != false ? "+1" : "-1") + " where " + var5_4;
                                var3_3.executeUpdate(var4_15);
                                break block19;
                            }
                            catch (SQLException var7_7) {
                                throw new WCMException(40, I18NMessage.get(UserSetting.class, "UserSetting.label7", "\u66f4\u65b0\u5c5e\u6027Order\u65f6\u5931\u8d25\uff08UserSetting.changeOrder\uff09"), var7_7);
                            }
                            catch (Exception var7_8) {
                                throw new WCMException(0, I18NMessage.get(UserSetting.class, "UserSetting.label7", "\u66f4\u65b0\u5c5e\u6027Order\u65f6\u5931\u8d25\uff08UserSetting.changeOrder\uff09"), var7_8);
                            }
                        }
                        catch (Throwable var8_16) {
                            var9_11 = null;
                            if (var3_3 != null) {
                                try {
                                    var3_3.close();
                                }
                                catch (Exception var10_14) {
                                    // empty catch block
                                }
                            }
                            if (var2_2 == null) throw var8_16;
                            this.getDBManager().freeConnection(var2_2);
                            throw var8_16;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [7 : 300->309)] { 
lbl46:
                    // 1 sources

                    var3_3.close();
                    break block17;
lbl48:
                    // 1 sources

                    catch (Exception var10_12) {
                        // empty catch block
                    }
                }
                if (var2_2 == null) return;
                this.getDBManager().freeConnection(var2_2);
                return;
            }
            var9_10 = null;
            if (var3_3 != null) {
                ** try [egrp 2[TRYBLOCK] [7 : 300->309)] { 
lbl58:
                // 1 sources

                var3_3.close();
                break block21;
lbl60:
                // 1 sources

                catch (Exception var10_13) {
                    // empty catch block
                }
            }
        }
        if (var2_2 == null) return;
        this.getDBManager().freeConnection(var2_2);
    }

    public boolean isValid() throws WCMException {
        Number number = null;
        if (this.isAddMode()) {
            Number number2 = (Number)this.getAllProperty().get("USERID");
            Number number3 = (Number)this.getAllProperty().get("OBJTYPE");
            Number number4 = (Number)this.getAllProperty().get("OBJID");
            if (number2 == null) {
                throw new WCMException(1106, I18NMessage.get(UserSetting.class, "UserSetting.label8", "\u5c5e\u6027UserId\u6ca1\u6709\u8bbe\u7f6e(UserSetting.isValid)"));
            }
            if (number3 == null) {
                throw new WCMException(1106, I18NMessage.get(UserSetting.class, "UserSetting.label9", "\u5c5e\u6027ObjType\u6ca1\u6709\u8bbe\u7f6e(UserSetting.isValid)"));
            }
            if (number4 == null) {
                throw new WCMException(1106, I18NMessage.get(UserSetting.class, "UserSetting.label10", "\u5c5e\u6027ObjId\u6ca1\u6709\u8bbe\u7f6e(UserSetting.isValid)"));
            }
            number = (Number)this.getAllProperty().get("RANGEINDEX");
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(UserSetting.class, "UserSetting.label11", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(UserSetting.isValid)"));
            }
            number = (Number)this.getNewProperty("RANGEINDEX");
        }
        if (number != null) {
            try {
                this.changeOrder(number.intValue());
            }
            catch (WCMException wCMException) {
                throw new WCMException(1100, I18NMessage.get(UserSetting.class, "UserSetting.label12", "\u8bbe\u7f6e\u5c5e\u6027Order\u65f6\u5931\u8d25(UserSetting.isValid)"), wCMException);
            }
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            super.insert(user);
        }
    }

    public Channel getObjAsChannel(User user) throws WCMException {
        int n = this.getObjType();
        if (n != 101) {
            return null;
        }
        int n2 = this.getObjId();
        return Channel.findById(n2);
    }

    public static final UserSetting findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (UserSetting)BaseObj.findById(UserSetting.class, n);
    }

    public static final UserSetting createNewInstance() throws WCMException {
        return (UserSetting)BaseObj.createNewInstance(UserSetting.class);
    }

    public static final UserSetting findByKey(Object object) throws WCMException {
        return (UserSetting)BaseObj.findByKey(UserSetting.class, object);
    }

    public static final UserSetting findOf(User user, int n, int n2) throws WCMException {
        String string = "USERID=? and ObjType=? and ObjId=?";
        int n3 = n == 800 && n2 == 101 ? 0 : user.getId();
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        wCMFilter.addSearchValues(0, n3);
        wCMFilter.addSearchValues(1, n);
        wCMFilter.addSearchValues(2, n2);
        UserSettings userSettings = UserSettings.openWCMObjs(null, wCMFilter);
        if (userSettings.isEmpty()) {
            return null;
        }
        return (UserSetting)userSettings.getAt(0);
    }
}

