/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.customize;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.customize.UserSetting;
import com.trs.components.wcm.customize.UserSettings;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BaseIdsMan;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;

public class CustomizedChannelIdsMan
extends BaseIdsMan {
    private UserSettings m_customizedChannels;
    private User m_currUser;

    protected CustomizedChannelIdsMan() {
    }

    public CustomizedChannelIdsMan(User user) {
        this.init(user);
    }

    protected int getExistsSize() {
        return this.m_customizedChannels.size();
    }

    protected int getExistsIdAt(int n) {
        return ((UserSetting)this.m_customizedChannels.getAt(n)).getId();
    }

    protected void deleteExists(int n) throws WCMException {
        this.m_customizedChannels.removeAt(n, true);
    }

    protected void addRelation(int n) throws WCMException {
        UserSetting userSetting = new UserSetting();
        userSetting.setUser(this.m_currUser.getId());
        userSetting.setObjId(n);
        userSetting.setObjType(101);
        userSetting.save(this.m_currUser);
    }

    private void init(User user) {
        try {
            this.m_customizedChannels = this.getCustomedChannels(user);
        }
        catch (WCMException wCMException) {
            throw new RuntimeException(wCMException);
        }
        this.m_currUser = user;
    }

    private UserSettings getCustomedChannels(User user) throws WCMException {
        if (user == null) {
            throw new WCMException(10, I18NMessage.get(CustomizedChannelIdsMan.class, "CustomizedChannelIdsMan.label1", "\u65e0\u6548\u7684\u7528\u6237!"));
        }
        WCMFilter wCMFilter = new WCMFilter("", "UserId=" + user.getId() + " AND ObjType=" + 101, "RangeIndex desc,SettingId asc", "ObjId");
        return UserSettings.openWCMObjs(user, wCMFilter);
    }
}

