/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.trsserver;

import com.eprobiti.trs.TRSConnection;
import com.trs.components.wcm.content.trsserver.TRSConnectionPool;
import com.trs.components.wcm.content.trsserver.TRSToWCMFilter;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class KMTRSServer
extends BaseServer {
    private static Logger logger = Logger.getLogger(KMTRSServer.class);
    private static KMTRSServer m_oTRSServer = null;
    protected static TRSConnectionPool connPool = null;
    private static String m_sServer = "";
    private static String m_sServerPort = "";
    private static String m_sUserName = "";
    private static String m_sPassWord = "";
    private static String m_sOpenTRSServerProgram = "C:\\Temp\\tbroker.exe";
    private static boolean m_bStarting = false;
    private static boolean m_bStarted = false;

    public static KMTRSServer getKMTRSServer() {
        if (m_oTRSServer == null) {
            m_oTRSServer = new KMTRSServer();
        }
        if (!m_oTRSServer.isStarted() && !m_oTRSServer.isStarting()) {
            m_oTRSServer.startup();
            if (!m_oTRSServer.isStarted()) {
                throw new RuntimeException("TRS Server startup Error!" + m_oTRSServer.getErrors());
            }
        }
        return m_oTRSServer;
    }

    public String getOpenProgram() {
        return m_sOpenTRSServerProgram;
    }

    private KMTRSServer() {
    }

    protected void doShutdown() {
        KMTRSServer.shutdownWCMForTRS();
    }

    protected boolean doStart() {
        return KMTRSServer.startWCMForTRS();
    }

    public static boolean shutdownWCMForTRS() {
        if (connPool != null) {
            connPool.closeAllConnections();
        }
        m_bStarted = false;
        m_bStarted = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean startWCMForTRS() {
        ConfigServer configServer;
        block6: {
            if (m_bStarted || m_bStarting) {
                return true;
            }
            m_bStarting = true;
            configServer = ConfigServer.getServer();
            m_sServer = configServer.getInitProperty("TRS_SERVER");
            m_sServerPort = configServer.getInitProperty("TRS_SERVER_PORT");
            m_sUserName = configServer.getInitProperty("TRS_USER");
            m_sPassWord = CMyString.showNull(configServer.getInitProperty("TRS_PASSWORD"));
            if (m_sServer != null && m_sServerPort != null && m_sUserName != null) break block6;
            System.out.println(I18NMessage.get(KMTRSServer.class, "KMTRSServer.label1", "TRS\u914d\u7f6e\u4fe1\u606f\u4e0d\u5168\uff01"));
            boolean bl = false;
            Object var4_3 = null;
            m_bStarting = false;
            return bl;
        }
        try {
            block7: {
                try {
                    m_sOpenTRSServerProgram = configServer.getInitProperty("OPEN_TRS_SERVER_PROGRAM");
                    if (m_sOpenTRSServerProgram != null) break block7;
                    KMTRSServer.connectTRS(m_sServer, m_sServerPort, m_sUserName, m_sPassWord);
                }
                catch (Exception exception) {
                    System.out.println(CMyDateTime.now() + I18NMessage.get(KMTRSServer.class, "KMTRSServer.label2", "\uff1a\u542f\u52a8KMForTRS\u5931\u8d25\uff01"));
                    exception.printStackTrace();
                    boolean bl = false;
                    Object var4_5 = null;
                    m_bStarting = false;
                    return bl;
                }
            }
            Object var4_4 = null;
            m_bStarting = false;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            m_bStarting = false;
            throw throwable;
        }
        System.out.println(CMyDateTime.now() + I18NMessage.get(KMTRSServer.class, "KMTRSServer.label3", "\uff1a\u542f\u52a8KMForTRS\u6210\u529f\uff01"));
        m_bStarted = true;
        return true;
    }

    public static boolean connectTRS(String string, String string2, String string3, String string4) {
        m_sServer = string;
        m_sServerPort = string2;
        m_sUserName = string3;
        m_sPassWord = string4;
        return KMTRSServer.reConnectTRS();
    }

    public static boolean reConnectTRS() {
        try {
            System.out.println(CMyDateTime.now() + I18NMessage.get(KMTRSServer.class, "KMTRSServer.label4", "\uff1a\u6b63\u5728\u521d\u59cb\u5316TRS\u7f13\u51b2\u6c60........"));
            boolean bl = KMTRSServer.initConnectionPool();
            System.out.println(CMyDateTime.now() + I18NMessage.get(KMTRSServer.class, "KMTRSServer.label5", "\uff1a\u521d\u59cb\u5316TRS\u7f13\u51b2\u6c60\u5b8c\u6210\uff01"));
            return bl;
        }
        catch (Exception exception) {
            System.out.println(I18NMessage.get(KMTRSServer.class, "KMTRSServer.label6", "\u521d\u59cb\u5316TRS\u7f13\u51b2\u6c60\u5931\u8d25\uff01(DocsFromTRSServer.reConnectTRS)"));
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean initConnectionPool() {
        try {
            if (connPool != null) {
                connPool.closeAllConnections();
                connPool = null;
            }
            int n = 10;
            int n2 = 20;
            connPool = new TRSConnectionPool(m_sServer, m_sServerPort, m_sUserName, m_sPassWord, n, n2, true);
        }
        catch (Exception exception) {
            System.out.println(I18NMessage.get(KMTRSServer.class, "KMTRSServer.label7", "TRS\u8fde\u63a5\u7f13\u51b2\u6c60\u521d\u59cb\u5316\u5931\u8d25(KMTRSServer.initConnectionPool)"));
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void freeConnection(TRSConnection tRSConnection) {
        connPool.free(tRSConnection);
    }

    public TRSConnection getConnection() throws WCMException {
        if (connPool == null) {
            throw new WCMException(1100, I18NMessage.get(KMTRSServer.class, "KMTRSServer.label8", "\u6570\u636e\u5e93\u8fde\u7ed3\u7f13\u51b2\u6c60\u5bf9\u8c61\u4e3a\u7a7a(KMTRSServer.getConnection)"));
        }
        TRSConnection tRSConnection = null;
        try {
            tRSConnection = connPool.getConnection();
        }
        catch (Exception exception) {
            throw new WCMException(41, I18NMessage.get(KMTRSServer.class, "KMTRSServer.label9", "\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u5931\u8d25(KMTRSServer.getConnection)"), exception);
        }
        if (tRSConnection == null) {
            throw new WCMException(41, I18NMessage.get(KMTRSServer.class, "KMTRSServer.label10", "\u6ca1\u6709\u627e\u5230\u6709\u6548\u53ef\u7528\u7684\u6570\u636e\u5e93\u8fde\u63a5(KMTRSServer.getConnection)"));
        }
        return tRSConnection;
    }

    public PreparedStatement setPrepareStatments(TRSToWCMFilter tRSToWCMFilter, PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setString(1, m_sOpenTRSServerProgram);
        preparedStatement.setString(6, "false");
        preparedStatement.setString(2, m_sServer);
        preparedStatement.setString(3, m_sServerPort);
        preparedStatement.setString(4, m_sUserName);
        preparedStatement.setString(5, m_sPassWord);
        logger.info((Object)("TRSWhere:" + tRSToWCMFilter.getTRSWhere()));
        preparedStatement.setString(8, tRSToWCMFilter.getTRSWhere());
        logger.info((Object)("TRSOrder:" + tRSToWCMFilter.getTRSOrder()));
        preparedStatement.setString(9, tRSToWCMFilter.getTRSOrder());
        preparedStatement.setString(10, tRSToWCMFilter.getTRSSelect());
        preparedStatement.setString(11, "false");
        return preparedStatement;
    }
}

