/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.trsserver;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.cache.ICachedPOMgr;
import java.util.Collection;
import java.util.Hashtable;

public class ChannelsWithRightMaker {
    private User m_oCurrUser = null;
    private int m_nRightIndex = -1;
    private StringBuffer m_sbResults = null;
    private Roles m_oRoles = null;
    private Groups m_oGroups = null;
    private Channels m_oChannelsLimmit = null;

    public ChannelsWithRightMaker(User user, int n) {
        this.m_oCurrUser = user;
        this.m_nRightIndex = n;
    }

    public String getChannelIdsWithRight(String string) throws WCMException {
        this.m_oChannelsLimmit = Channels.findByIds(this.m_oCurrUser, string);
        return this.getChannelIdsWithRight();
    }

    public String getChannelIdsWithRight() throws WCMException {
        if (this.m_oCurrUser.isAdministrator()) {
            return "";
        }
        if (this.m_sbResults == null) {
            if (this.m_oChannelsLimmit != null) {
                this.makeChannelIdsWithRightInRegion();
            } else {
                this.makeChannelIdsWithRight();
            }
        }
        if (this.m_sbResults.length() == 0) {
            return null;
        }
        return this.m_sbResults.substring(0, this.m_sbResults.length() - 1);
    }

    private synchronized void makeChannelIdsWithRight() throws WCMException {
        if (this.m_sbResults != null) {
            return;
        }
        this.m_oRoles = this.m_oCurrUser.getRoles();
        Role role = Role.findById(2);
        if (role != null) {
            this.m_oRoles.addElement(role);
        }
        this.m_oGroups = this.m_oCurrUser.getGroups();
        ICachedPOMgr iCachedPOMgr = (ICachedPOMgr)DreamFactory.createObjectById("ICachedPOMgr");
        if (iCachedPOMgr == null) {
            throw new WCMException(10, "ICachedPOMgr Config Error!");
        }
        Hashtable hashtable = iCachedPOMgr.getBuffer(Channel.class);
        this.m_sbResults = new StringBuffer(7 * hashtable.size());
        Collection collection = hashtable.values();
        for (Channel channel : collection) {
            if (channel.isDeleted() || !AuthServer.hasRight(this.m_oCurrUser, (CMSObj)channel, this.m_nRightIndex)) continue;
            this.m_sbResults.append(channel.getId());
            this.m_sbResults.append(",");
        }
    }

    private synchronized void makeChannelIdsWithRightInRegion() throws WCMException {
        if (this.m_sbResults != null) {
            return;
        }
        this.m_oRoles = this.m_oCurrUser.getRoles();
        Role role = Role.findById(2);
        if (role != null) {
            this.m_oRoles.addElement(role);
        }
        this.m_oGroups = this.m_oCurrUser.getGroups();
        this.m_sbResults = new StringBuffer(7 * this.m_oChannelsLimmit.size());
        int n = this.m_oChannelsLimmit.size();
        for (int i = 0; i < n; ++i) {
            Channel channel = (Channel)this.m_oChannelsLimmit.getAt(i);
            if (channel == null || channel.isDeleted() || !AuthServer.hasRight(this.m_oCurrUser, (CMSObj)channel, this.m_nRightIndex)) continue;
            this.m_sbResults.append(channel.getId());
            this.m_sbResults.append(",");
        }
    }

    public static void main(String[] stringArray) {
    }
}

