/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.swf;

import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.util.swf.SWFCreator;
import org.apache.log4j.Logger;

public class DocumentListenerForFileToSWF
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(DocumentListenerForFileToSWF.class);

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof Document)) {
            logger.error((Object)("Listener[" + this.getClass() + "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[" + baseObj.getClass() + "]\u7684\u4fee\u6539\uff01"));
            return;
        }
        Document document = (Document)baseObj;
        if (document.isChangeProperty("DOCTYPE")) {
            int n2 = document.getNewPropertyAsInt("DocType", 0);
            if (n2 == 40) {
                this.convertToSWF(document, document.getNewPropertyAsString("DocFileName"));
            }
        } else if (document.getType() == 40 && document.isChangeProperty("DocFileName")) {
            this.convertToSWF(document, document.getNewPropertyAsString("DocFileName"));
        }
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        if (!(baseObj instanceof Document)) {
            logger.error((Object)("Listener[" + this.getClass() + "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[" + baseObj.getClass() + "]\u7684\u65b0\u589e\uff01"));
            return;
        }
        Document document = (Document)baseObj;
        if (document.getType() != 40) {
            return;
        }
        String string = document.getPropertyAsString("DOCFILENAME");
        this.convertToSWF(document, string);
    }

    private void convertToSWF(Document document, String string) throws WCMException {
        String string2 = FilesMan.getFilesMan().mapFilePath(string, 0) + string;
        try {
            SWFCreator sWFCreator = new SWFCreator(string2);
            sWFCreator.m_nServicePort = Integer.parseInt(ConfigServer.getServer().getSysConfigValue("OPEN_OFFCIE_PORT", "8100"));
            sWFCreator.m_sSWFToollsPath = ConfigServer.getServer().getSysConfigValue("SWF_TOOLS_PATH", sWFCreator.m_sSWFToollsPath);
            sWFCreator.start();
        }
        catch (Throwable throwable) {
            logger.error((Object)("Fail to convert the document " + document + " file!"), throwable);
        }
    }
}

