/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ReplaceCacheMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;

public class Replace
extends CMSObj {
    public static final int OBJ_TYPE = 105;
    public static final String DB_TABLE_NAME = "WCMREPLACE";
    public static final String DB_ID_NAME = "REPLACEID";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 105;
    }

    public boolean isValid() throws WCMException {
        String string = "";
        if (this.isAddMode()) {
            string = (String)this.getAllProperty().get("REPLACENAME");
            if (this.getProperty("REPLACENAME") == null) {
                throw new WCMException(1106, I18NMessage.get(Replace.class, "Replace.label1", "\u5c5e\u6027REPLACENAME\u6ca1\u6709\u8bbe\u7f6e(Replace.isValid)"));
            }
            if (this.getProperty("CHNLID") == null) {
                throw new WCMException(1106, I18NMessage.get(Replace.class, "Replace.label2", "\u5c5e\u6027CHNLID\u6ca1\u6709\u8bbe\u7f6e(Replace.isValid)"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Replace.class, "Replace.label3", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Replace.isValid)"));
            }
            string = (String)this.getNewProperty("REPLACENAME");
        }
        if (string != null) {
            String string2 = " (CHNLID=" + this.getChnlId() + ") and (REPLACENAME='" + CMyString.filterForSQL(string) + "') ";
            if (!this.isAddMode()) {
                string2 = string2 + " and " + this.getIdFieldName() + "<>" + this.getId();
            }
            if (this.checkExists(string2)) {
                throw new WCMException(1108, I18NMessage.get(Replace.class, "Replace.label4", "\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff08Replace.isValid\uff09"));
            }
        }
        return true;
    }

    public boolean setName(String string) throws WCMException {
        return this.setPropertyWithString("REPLACENAME", string);
    }

    public String getName() {
        return this.getPropertyAsString("REPLACENAME");
    }

    public boolean setContent(String string) throws WCMException {
        return this.setPropertyWithString("REPLACECONTENT", string);
    }

    public String getContent() {
        return this.getPropertyAsString("REPLACECONTENT");
    }

    public boolean setChnlId(int n) throws WCMException {
        return this.setProperty("CHNLID", n);
    }

    public int getChnlId() {
        return this.getPropertyAsInt("CHNLID", 0);
    }

    public Channel getChannel() throws WCMException {
        return Channel.findById(this.getChnlId());
    }

    public static final Replace findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (Replace)BaseObj.findById(Replace.class, n);
    }

    public static final Replace createNewInstance() throws WCMException {
        return (Replace)BaseObj.createNewInstance(Replace.class);
    }

    public static final Replace findByKey(Object object) throws WCMException {
        return (Replace)BaseObj.findByKey(Replace.class, object);
    }

    public static final String replace(int n, String string) throws WCMException {
        return Replace.getReplaceCache().getReplaceContent(n, string);
    }

    private static ReplaceCacheMgr getReplaceCache() {
        return (ReplaceCacheMgr)DreamFactory.createObjectById("ReplaceCacheMgr");
    }

    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return this.getName() + I18NMessage.get(Replace.class, "Replace.label5", "[\u66ff\u6362\u5185\u5bb9-") + this.getId() + "]";
    }
}

