/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.DreamFactory;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverter;
import com.trs.infra.persistent.ObjToXmlConverter;
import org.dom4j.Element;

public class DocumentXmlConverter
extends BaseObjToXmlConverter {
    private boolean m_bWithAppendix = false;
    private ObjToXmlConverter m_converter = new ObjToXmlConverter();

    protected Element toXmlElement(BaseObj baseObj, String string) throws WCMException {
        Element element = super.toXmlElement(baseObj, string);
        element.element("PROPERTIES").addElement("CHNLNAME");
        Document document = (Document)baseObj;
        if (document != null) {
            String string2 = document.getChannelName();
            element.element("PROPERTIES").element("CHNLNAME").addCDATA(string2);
            int n = document.getPropertyAsInt("ATTACHPIC", 0);
            if (!this.isWithAppendix() && n > 0) {
                element.element("PROPERTIES").element("ATTACHPIC").addCDATA("0");
            }
        }
        return element;
    }

    protected Element[] getChildElement(BaseObj baseObj) throws WCMException {
        if (this.isWithAppendix()) {
            AppendixMgr appendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
            Appendixes appendixes = appendixMgr.getAppendixes((Document)baseObj, -1);
            return new Element[]{this.m_converter.toXmlElement(appendixes, null)};
        }
        return null;
    }

    public boolean isWithAppendix() {
        return this.m_bWithAppendix;
    }

    public void setWithAppendix(boolean bl) {
        this.m_bWithAppendix = bl;
    }
}

