/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.HTMLContent;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.HitsCount;
import com.trs.components.wcm.content.persistent.HitsCounts;
import com.trs.components.wcm.resource.DocKind;
import com.trs.components.wcm.resource.DocLevel;
import com.trs.components.wcm.resource.Keyword;
import com.trs.components.wcm.resource.Keywords;
import com.trs.components.wcm.resource.Security;
import com.trs.components.wcm.resource.Source;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.NullValue;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.FieldInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class Document
extends CMSObj {
    public static boolean SYNCHRONIZE_PROPERTIES_TO_CHNLDOC = false;
    public static boolean DOCUMENTS_GET_OPTIMIZE = false;
    public static String[] SYNCHRONIZED_FIELDS = new String[]{"DOCRELTIME", "DOCCHANNEL"};
    private HTMLContent m_oHTMLContent = null;
    private static Logger logger = Logger.getLogger(Document.class);
    public static final int OBJ_TYPE = 605;
    public static final String DB_TABLE_NAME = "WCMDOCUMENT";
    public static final String DB_ID_NAME = "DOCID";
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_NORMAL = 10;
    public static final int TYPE_HTML = 20;
    public static final int TYPE_LINK = 30;
    public static final int TYPE_FILE = 40;
    public static final int DOC_TYPE_NORMAL = 10;
    public static final int DOC_TYPE_HTML = 20;
    public static final int DOC_TYPE_LINK = 30;
    public static final int DOC_TYPE_FILE = 40;
    public static final int DOC_FORM_UNKNOWN = 0;
    public static final int DOC_FORM_LITERY = 1;
    public static final int DOC_FORM_PIC = 2;
    public static final int DOC_FORM_AUDIO = 3;
    public static final int DOC_FORM_VIDEO = 4;
    public static final int FLAG_UNKNOWN = -1;
    public static final int FLAG_DEFAULT = 0;
    public static final int FLAG_USER_DEFINE = 20;
    public static final int[] ALL_TYPES = new int[]{10, 20, 30, 40};
    public static final int GET_RELATEDDOC_BY_ALL = 0;
    public static final int GET_RELATEDDOC_BY_KEYWORDS = 10;
    public static final int GET_RELATEDDOC_BY_RELWORDS = 20;
    public static final int GET_RELATEDDOC_BY_RELATION = 30;
    public static final int DOCPIC_IN_APPENDIX = 1;
    public static final int DOCPIC_IN_CONTENT = 2;
    public static final int DOCPIC_IN_APD_AND_CON = 3;
    public static final int DOCPIC_NONE = 0;
    public static final int MIN_WIDTH_PIC_IN_CONTENT = 600;
    public static final int MIN_HEIGHT_PIC_IN_CONTENT = 400;
    static String sContent = "";
    int m_currChnlId = 0;
    protected String m_sTableName = null;
    public boolean g_bXMLforTRS = false;
    public boolean m_bXMLOnlySelf = false;
    private boolean m_bForceAdd = false;
    private static CMyDateTime m_dtPubPathStartTime = null;
    private static boolean m_bSavePubFileByTime = true;

    public static String getTypeString(int n) {
        switch (n) {
            case 10: {
                return I18NMessage.get(Document.class, "Document.label1", "\u7eaf\u6587\u672c");
            }
            case 20: {
                return I18NMessage.get(Document.class, "Document.label2", "Html\u6587\u6863");
            }
            case 30: {
                return I18NMessage.get(Document.class, "Document.label3", "\u94fe\u63a5\u6587\u6863");
            }
            case 40: {
                return I18NMessage.get(Document.class, "Document.label4", "\u5916\u90e8\u6587\u4ef6");
            }
        }
        return I18NMessage.get(Document.class, "Document.label5", "\u672a\u77e5");
    }

    public void setDbTableName(String string) {
        this.m_sTableName = string;
    }

    public String getDbTableName() {
        String string = this.getOtherTableName();
        if (string != null && string.length() > 0) {
            return string;
        }
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 605;
    }

    public int getDocId() {
        return this.getId();
    }

    public boolean isDeleted() {
        return this.getStatusId() < 0;
    }

    public boolean setDeleted(boolean bl) throws WCMException {
        int n = this.getStatusId();
        if (n < 0 == bl) {
            return false;
        }
        return this.setStatus(-n);
    }

    public int getStatusId() {
        return this.getPropertyAsInt("DOCSTATUS", 0);
    }

    public Status getStatus() throws WCMException {
        int n = this.getStatusId();
        if (n < 0) {
            n = -n;
        }
        return Status.findById(n);
    }

    public String getStatusName() throws WCMException {
        if (this.getStatusId() == 0) {
            return "";
        }
        Status status = this.getStatus();
        if (status == null) {
            return I18NMessage.get(Document.class, "Document.label5", "\u672a\u77e5");
        }
        return status.getDisp();
    }

    public boolean setStatus(int n) throws WCMException {
        return this.setProperty("DOCSTATUS", n);
    }

    public boolean setStatus(Status status) throws WCMException {
        return this.setStatus(status, false);
    }

    public boolean setStatus(Status status, boolean bl) throws WCMException {
        if (status == null || !status.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Document.class, "Document.label6", "\u65e0\u6548\u7684\u72b6\u6001\u5bf9\u8c61(Document.setStatus)"));
        }
        return this.setStatus(status.getId() * (bl ? -1 : 1));
    }

    public int getSecurityId() {
        return this.getPropertyAsInt("DOCSECURITY", 0);
    }

    public Security getSecurity() throws WCMException {
        return Security.findById(this.getSecurityId());
    }

    public boolean setSecurity(int n) throws WCMException {
        return this.setProperty("DOCSECURITY", n);
    }

    public boolean setSecurity(Security security) throws WCMException {
        if (security == null || !security.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Document.class, "Document.label7", "\u65e0\u6548\u7684\u5b89\u5168\u7ea7\u522b\u5bf9\u8c61(Document.setSecurity)"));
        }
        return this.setSecurity(security.getId());
    }

    public int getChannelId() {
        int n = this.getPropertyAsInt("DOCCHANNEL", 0);
        if (n < 0) {
            n = -n;
        }
        return n;
    }

    public Channel getChannel() throws WCMException {
        return Channel.findById(this.getChannelId());
    }

    public String getChannelName() throws WCMException {
        if (this.getChannelId() == 0) {
            return "";
        }
        Channel channel = this.getChannel();
        if (channel == null) {
            return I18NMessage.get(Document.class, "Document.label8", "\u672a\u77e5[") + this.getChannelId() + "]";
        }
        return channel.getName();
    }

    public boolean setChannel(int n) throws WCMException {
        return this.setProperty("DOCCHANNEL", n);
    }

    public boolean setChannel(Channel channel) throws WCMException {
        if (channel == null || !channel.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Document.class, "Document.label9", "\u65e0\u6548\u7684\u9891\u9053\u5bf9\u8c61(Document.setChannel)"));
        }
        return this.setChannel(channel.getId());
    }

    public int getSourceId() {
        return this.getPropertyAsInt("DOCSOURCE", 0);
    }

    public Source getSource() throws WCMException {
        return Source.findById(this.getSourceId());
    }

    public boolean setSource(int n) throws WCMException {
        return this.setProperty("DOCSOURCE", n);
    }

    public boolean setSource(Source source) throws WCMException {
        if (source == null || !source.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Document.class, "Document.label10", "\u65e0\u6548\u7684\u6765\u6e90\u5bf9\u8c61(Document.setSource)"));
        }
        return this.setSource(source.getId());
    }

    public CMyDateTime getValidTime() {
        return (CMyDateTime)this.getProperty("DOCVALID");
    }

    public boolean setValidTime(CMyDateTime cMyDateTime) throws WCMException {
        return this.setProperty("DOCVALID", cMyDateTime);
    }

    public String getEditorName() {
        return (String)this.getProperty("DOCEDITOR");
    }

    public User getEditor() {
        return User.findByName(this.getEditorName());
    }

    public boolean setEditor(String string) throws WCMException {
        return this.setProperty("DOCEDITOR", string);
    }

    public boolean setEditor(User user) throws WCMException {
        if (user == null || !user.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Document.class, "Document.label11", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61(Document.setEditor)"));
        }
        return this.setEditor(user.getName());
    }

    public String getAuditorName() {
        return (String)this.getProperty("DOCAUDITOR");
    }

    public User getAuditor() {
        return User.findByName(this.getAuditorName());
    }

    public boolean setAuditor(String string) throws WCMException {
        return this.setProperty("DOCAUDITOR", string);
    }

    public boolean setAuditor(User user) throws WCMException {
        if (user == null || !user.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Document.class, "Document.label12", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61(Document.setAuditor)"));
        }
        return this.setAuditor(user.getName());
    }

    public int getFlag() {
        return this.getPropertyAsInt("DOCFLAG", 0);
    }

    public boolean setFlag(int n) throws WCMException {
        return this.setProperty("DOCFLAG", n);
    }

    public int getHitsCount() {
        return this.getPropertyAsInt("HITSCOUNT", 0);
    }

    public boolean setHitsCount(int n) throws WCMException {
        return this.setProperty("HITSCOUNT", n);
    }

    public int getType() {
        return this.getPropertyAsInt("DOCTYPE", 0);
    }

    public String getTypeString() {
        return Document.getTypeString(this.getType());
    }

    public boolean setType(int n) throws WCMException {
        if (n != 10 && n != 20 && n != 30 && n != 40) {
            throw new WCMException(10, I18NMessage.get(Document.class, "Document.label13", "\u65e0\u6548\u7684\u6587\u6863\u7c7b\u578b(Document.setType)"));
        }
        return this.setProperty("DOCTYPE", n);
    }

    public int getKindId() {
        return this.getPropertyAsInt("DOCKIND", 0);
    }

    public DocKind getKind() throws WCMException {
        return DocKind.findById(this.getKindId());
    }

    public boolean setKind(int n) throws WCMException {
        return this.setProperty("DOCKIND", n);
    }

    public boolean setKind(DocKind docKind) throws WCMException {
        if (docKind == null || !docKind.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Document.class, "Document.label14", "\u65e0\u6548\u7684\u6587\u6863\u7c7b\u522b(Document.setKind)"));
        }
        return this.setKind(docKind.getId());
    }

    public String getTitle() {
        return (String)this.getProperty("DOCTITLE");
    }

    public boolean setTitle(String string) throws WCMException {
        boolean bl = this.setProperty("DOCTITLE", string);
        return bl;
    }

    public String getSubTitle() {
        return (String)this.getProperty("SUBDOCTITLE");
    }

    public boolean setSubTitle(String string) throws WCMException {
        return this.setProperty("SUBDOCTITLE", string);
    }

    public String getTitleColor() {
        return (String)this.getProperty("TitleColor");
    }

    public boolean setTitleColor(String string) throws WCMException {
        return this.setProperty("TitleColor", string);
    }

    public String getPeople() {
        return (String)this.getProperty("DOCPEOPLE");
    }

    public boolean setPeople(String string) throws WCMException {
        return this.setProperty("DOCPEOPLE", string);
    }

    public String getPlace() {
        return (String)this.getProperty("DOCPLACE");
    }

    public boolean setPlace(String string) throws WCMException {
        return this.setProperty("DOCPLACE", string);
    }

    public String getAuthorName() {
        return (String)this.getProperty("DOCAUTHOR");
    }

    public boolean setAuthor(String string) throws WCMException {
        return this.setProperty("DOCAUTHOR", string);
    }

    public String getPubURL() {
        return (String)this.getProperty("DOCPUBURL");
    }

    public boolean setPubURL(String string) throws WCMException {
        return this.setProperty("DOCPUBURL", string);
    }

    public String getContent() {
        if (!this.getProperties(true).containsKey("DOCCONTENT")) {
            try {
                this.loadTextsFromDB("DOCCONTENT");
            }
            catch (Exception exception) {
                logger.error((Object)(I18NMessage.get(Document.class, "Document.label15", "\u8f7d\u5165[") + this + I18NMessage.get(Document.class, "Document.label16", "] DOCONTENT \u5c5e\u6027\u5931\u8d25\uff01")));
                throw new RuntimeException(I18NMessage.get(Document.class, "Document.label15", "\u8f7d\u5165[") + this + I18NMessage.get(Document.class, "Document.label17", "] DOCONTENT \u5c5e\u6027\u5931\u8d25\uff01\n") + CMyException.getStackTraceText(exception));
            }
        }
        return this.getPropertyAsString("DOCCONTENT");
    }

    public boolean setContent(String string) throws WCMException {
        return this.setProperty("DOCCONTENT", new CDBText(this.getDBManager().getDBTypeAsInt(), string));
    }

    public int getWordsCount() {
        return this.getPropertyAsInt("DOCWORDSCOUNT", 0);
    }

    public String getHtmlContent() {
        if (!this.getProperties(true).containsKey("DOCHTMLCON")) {
            try {
                this.loadTextsFromDB("DOCHTMLCON");
            }
            catch (Exception exception) {
                logger.error((Object)(I18NMessage.get(Document.class, "Document.label15", "\u8f7d\u5165[") + this + I18NMessage.get(Document.class, "Document.label18", "] DOCHTMLCON \u5c5e\u6027\u5931\u8d25\uff01")));
                throw new RuntimeException(I18NMessage.get(Document.class, "Document.label15", "\u8f7d\u5165[") + this + I18NMessage.get(Document.class, "Document.label19", "] DOCHTMLCON \u5c5e\u6027\u5931\u8d25\uff01\n") + CMyException.getStackTraceText(exception));
            }
        }
        return this.getPropertyAsString("DOCHTMLCON");
    }

    public boolean setHtmlContent(String string) throws WCMException {
        return this.setTextProperty("DOCHTMLCON", string);
    }

    public String getAbstract() {
        return (String)this.getProperty("DOCABSTRACT");
    }

    public boolean setAbstract(String string) throws WCMException {
        return this.setProperty("DOCABSTRACT", string);
    }

    public String getKeywords() {
        return (String)this.getProperty("DOCKEYWORDS");
    }

    public boolean setKeywords(String string) throws WCMException {
        return this.setProperty("DOCKEYWORDS", string);
    }

    public String getRelateWords() {
        return (String)this.getProperty("DOCRELWORDS");
    }

    public boolean setRelateWords(String string) throws WCMException {
        return this.setProperty("DOCRELWORDS", string);
    }

    public CMyDateTime getPubTime() {
        return (CMyDateTime)this.getProperty("DOCPUBTIME");
    }

    public boolean setPubTime(CMyDateTime cMyDateTime) throws WCMException {
        return this.setProperty("DOCPUBTIME", cMyDateTime);
    }

    public CMyDateTime getReleaseTime() {
        return (CMyDateTime)this.getProperty("DOCRELTIME");
    }

    public boolean setReleaseTime(CMyDateTime cMyDateTime) throws WCMException {
        return this.setProperty("DOCRELTIME", cMyDateTime);
    }

    public int getOutUpId() {
        return this.getPropertyAsInt("DOCOUTUPID", 0);
    }

    public boolean setOutUpId(int n) throws WCMException {
        return this.setProperty("DOCOUTUPID", n);
    }

    public boolean isOutUp() {
        return this.getOutUpId() > 0;
    }

    public int getVersion() {
        return this.getPropertyAsInt("DOCVERSION", 0);
    }

    public boolean setVersion(int n) throws WCMException {
        return this.setProperty("DOCVERSION", n);
    }

    public boolean isRightDefined() {
        return this.getPropertyAsInt("RightDefined", 0) > 0;
    }

    public boolean setRightDefined(boolean bl) throws WCMException {
        return this.setProperty("RightDefined", bl);
    }

    public int getAttachPic() {
        return this.getPropertyAsInt("AttachPic", 0);
    }

    public boolean isAttachPic() {
        return this.getPropertyAsInt("AttachPic", 0) > 0;
    }

    public boolean setAttachPic(int n) throws WCMException {
        return this.setProperty("AttachPic", n);
    }

    public boolean isAttachPic(int n) throws WCMException {
        return this.setProperty("AttachPic", n);
    }

    public boolean isValid() throws WCMException {
        CDBText cDBText = null;
        if (this.isAddMode()) {
            this.setProperty("DOCWORDSCOUNT", 0L);
            if (this.getProperty("DOCKIND") == null) {
                this.setKind(0);
            }
            if (this.getProperty("DOCOUTUPID") == null) {
                this.setProperty("DOCOUTUPID", 0L);
            }
            this.validateAdd();
            cDBText = (CDBText)this.getProperty("DOCCONTENT");
        } else {
            this.validateEdit();
            cDBText = (CDBText)this.getNewProperty("DOCCONTENT");
        }
        if (cDBText != null) {
            this.setProperty("DOCWORDSCOUNT", cDBText.getLength());
        }
        this.setProperty("OperTime", CMyDateTime.now());
        return true;
    }

    private boolean isHTMLBody() {
        if (this.isAddMode() || !this.isChangeProperty("DOCTYPE")) {
            return this.getType() == 20;
        }
        return this.getNewPropertyAsInt("DOCTYPE", 20) == 20;
    }

    private void validateAdd() throws WCMException {
        Object object;
        if (this.getProperty("DOCCHANNEL") == null) {
            this.setChannel(0);
        }
        if (this.getProperty("DOCTYPE") == null) {
            this.setType(10);
        }
        if (this.getProperty("DOCSTATUS") == null) {
            this.setStatus(1);
        }
        if (this.getProperty("DOCSECURITY") == null) {
            this.setSecurity(0);
        }
        if (this.getProperty("DOCSOURCE") == null) {
            this.setSource(0);
        }
        if (this.getProperty("DOCRELTIME") == null) {
            this.setReleaseTime(CMyDateTime.now());
        }
        int n = 0;
        try {
            int n2 = this.getPropertyAsInt("DocChannel", 0);
            object = Channel.findById(n2);
            n = ((Channel)object).getSiteId();
            if (this.getPropertyAsInt("SrcSiteId", 0) == 0) {
                this.setProperty("SrcSiteId", n);
            }
            this.setProperty("SiteId", n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = this.getFinalPropertyAsString("DOCKEYWORDS");
        this.setKeywords(string);
        if (!CMyString.isEmpty(string)) {
            string = string.replaceAll("[\\s, \u3001, ,, \uff1b, \uff0c]", ";");
            object = string.split(";");
            for (int i = 0; i < ((String[])object).length; ++i) {
                WCMFilter wCMFilter = new WCMFilter("", "KNAME=?", "");
                wCMFilter.addSearchValues((String)object[i]);
                Keywords keywords = Keywords.openWCMObjs(null, wCMFilter);
                if (keywords == null || keywords.size() <= 0) continue;
                Keyword keyword = (Keyword)keywords.getAt(0);
                keyword.setKFREQ(keyword.getKFREQ() + 1);
                keyword.save();
            }
        }
        if (CMyString.isEmpty(this.getTitle())) {
            throw new WCMException(1106, I18NMessage.get(Document.class, "Document.label20", "\u5c5e\u6027Title\u6ca1\u6709\u8bbe\u7f6e(Document.isValid)"));
        }
        if (this.getSourceId() == 0 && (object = this.getPropertyAsString("DOCSOURCENAME")) != null && ((String)object).trim().length() > 0) {
            this.setProperty("DOCSOURCE", ((String)object).hashCode());
        }
        int n3 = this.getType();
        switch (n3) {
            case 20: {
                if (this.getProperty("DOCHTMLCON") == null) {
                    throw new WCMException(1106, I18NMessage.get(Document.class, "Document.label21", "\u6ca1\u6709\u8bbe\u7f6eHTML\u6b63\u6587\uff01"));
                }
                this.setHtmlContent(HTMLContent.saveHtmlContent(this.getHtmlContent()));
                this.setPubHtmlContent(this.getHtmlContent());
                if (!CMyString.isEmpty(this.getContent())) break;
                this.setContent(CMyString.innerText(this.getHtmlContent()));
                break;
            }
            case 10: {
                if (this.getProperty("DOCCONTENT") == null) {
                    if (this.getProperty("DOCHTMLCON") == null) {
                        throw new WCMException(1106, I18NMessage.get(Document.class, "Document.label22", "\u6ca1\u6709\u8bbe\u7f6e\u6b63\u6587\uff01"));
                    }
                    this.setContent(this.getPropertyAsString("DOCHTMLCON"));
                }
                if (this.isInfoviewDocument()) {
                    this.setContent(HTMLContent.saveHtmlContent(this.getContent()));
                }
                this.setPubHtmlContent(this.getContent());
                break;
            }
            case 30: 
            case 40: {
                break;
            }
            default: {
                throw new WCMException(10, I18NMessage.get(Document.class, "Document.label23", "\u8bbe\u7f6e\u7684Type\u65e0\u6548\uff01"));
            }
        }
    }

    private boolean isInfoviewDocument() {
        return this.getFlag() > 0;
    }

    private void validateEdit() throws WCMException {
        boolean bl;
        Object object;
        String string;
        if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(Document.class, "Document.label24", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Document.isValid)"));
        }
        String string2 = this.getFinalPropertyAsString("DOCKEYWORDS");
        if (!CMyString.isEmpty(string2)) {
            string2 = string2.replaceAll("[\\s, \u3001, ,, \uff1b, \uff0c]", ";");
            string = CMyString.showNull(this.getProperty("DOCKEYWORDS") == null ? "" : this.getProperty("DOCKEYWORDS").toString());
            String[] stringArray = string2.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl2 = false;
                if (string.indexOf(stringArray[i]) <= -1) {
                    bl2 = true;
                }
                if (!bl2) continue;
                object = new WCMFilter("", "KNAME=?", "");
                ((WCMFilter)object).addSearchValues(stringArray[i]);
                Keywords keywords = Keywords.openWCMObjs(null, (WCMFilter)object);
                if (keywords == null || keywords.size() <= 0) continue;
                Keyword keyword = (Keyword)keywords.getAt(0);
                keyword.setKFREQ(keyword.getKFREQ() + 1);
                keyword.save();
            }
            this.setKeywords(string2);
        }
        if (this.getNewPropertyAsInt("DOCSOURCE", 0) == 0) {
            string = this.getNewPropertyAsString("DOCSOURCENAME");
            if (string != null && string.trim().length() > 0) {
                this.setProperty("DOCSOURCE", string.hashCode());
            } else {
                this.setProperty("DOCSOURCE", 0L);
            }
        }
        int n = (bl = this.isChangeProperty("DOCTYPE")) ? this.getNewPropertyAsInt("DOCTYPE", 20) : this.getType();
        switch (n) {
            case 20: {
                Object object2 = this.getNewProperty("DOCHTMLCON");
                if (bl && object2 == null) {
                    throw new WCMException(1106, I18NMessage.get(Document.class, "Document.label21", "\u6ca1\u6709\u8bbe\u7f6eHTML\u6b63\u6587\uff01"));
                }
                if (object2 == null) {
                    return;
                }
                String string3 = HTMLContent.saveHtmlContent(object2.toString());
                this.setContent(this.getNewPropertyAsString("DOCCONTENT"));
                this.setHtmlContent(string3);
                this.setPubHtmlContent(string3);
                if (!CMyString.isEmpty(this.getNewPropertyAsString("DOCCONTENT"))) break;
                this.setContent(CMyString.innerText(string3));
                break;
            }
            case 10: {
                object = this.getNewProperty("DOCCONTENT");
                if (bl && object == null) {
                    throw new WCMException(1106, I18NMessage.get(Document.class, "Document.label22", "\u6ca1\u6709\u8bbe\u7f6e\u6b63\u6587\uff01"));
                }
                if (object == null) {
                    return;
                }
                if (this.isInfoviewDocument()) {
                    this.setContent(HTMLContent.saveHtmlContent(object.toString()));
                    this.setPubHtmlContent(this.getContent());
                    break;
                }
                this.setPubHtmlContent(object.toString());
                break;
            }
            case 30: 
            case 40: {
                break;
            }
            default: {
                throw new WCMException(10, I18NMessage.get(Document.class, "Document.label23", "\u8bbe\u7f6e\u7684Type\u65e0\u6548\uff01"));
            }
        }
    }

    public boolean isDraft() {
        return this.getChannelId() == 0;
    }

    protected synchronized int getNextId(Connection connection) throws WCMException {
        int n = super.getNextId(connection);
        return n;
    }

    public boolean isDocumentObject() {
        return this.getDbTableName().compareToIgnoreCase(DB_TABLE_NAME) == 0;
    }

    public boolean logicalDelete(User user) throws WCMException {
        return this.doLogicalDelete(user, true);
    }

    public boolean logicalUndelete(User user) throws WCMException {
        return this.doLogicalDelete(user, false);
    }

    private boolean doLogicalDelete(User user, boolean bl) throws WCMException {
        if (!this.isValidInstance()) {
            return false;
        }
        boolean bl2 = false;
        try {
            if (this.isDeleted() == bl) {
                return true;
            }
            if (!this.canEdit(user)) {
                return false;
            }
            bl2 = true;
            this.setDeleted(bl);
            this.update(user);
            return true;
        }
        catch (Exception exception) {
            if (bl2) {
                try {
                    this.cancelUpdate(user);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            throw new WCMException(1100, I18NMessage.get(Document.class, "Document.label25", "\u903b\u8f91\u5220\u9664\u6587\u6863\u5931\u8d25\uff08Document.logicalDelete\uff09"), exception);
        }
    }

    public void updateHitsCount(User user) throws Exception {
        if (user == null) {
            return;
        }
        HitsCount hitsCount = new HitsCount();
        String string = "ObjType=605  and ObjId=" + this.getId() + " and CrUser='" + user.getName() + "'";
        if (!hitsCount.checkExists(string)) {
            String[] stringArray;
            try {
                stringArray = new HitsCounts(user, 1, 1);
                hitsCount = (HitsCount)stringArray.addNew();
                hitsCount.setObjType(605);
                hitsCount.setObjId(this.getId());
                hitsCount.setCrUser(user);
                hitsCount.setProperty("CRTIME", CMyDateTime.now());
                stringArray.update();
                stringArray.clear();
                hitsCount = null;
            }
            catch (Exception exception) {
                throw new WCMException(1100, I18NMessage.get(Document.class, "Document.label26", "\u63d2\u5165\u5f53\u524d\u7528\u6237\u7684\u70b9\u51fb\u8bb0\u5f55\u5931\u8d25\uff01"), exception);
            }
            try {
                stringArray = new String[]{"update WCMDocument set HitsCount=HitsCount+1 where DocId=" + this.getId()};
                this.getDBManager().sqlExecuteUpdate(stringArray);
            }
            catch (Exception exception) {
                throw new WCMException(1100, I18NMessage.get(Document.class, "Document.label27", "\u66f4\u65b0\u6587\u6863\u7684\u70b9\u51fb\u6570\u5c5e\u6027\u5931\u8d25\uff01"), exception);
            }
        }
    }

    public void setMyDocId(int n) {
        this.id = n;
        this.bAddMode = false;
    }

    public String getPubHtmlContent() {
        if (!this.getProperties(true).containsKey("DOCPUBHTMLCON")) {
            try {
                this.loadTextsFromDB("DOCPUBHTMLCON");
            }
            catch (Exception exception) {
                logger.error((Object)(I18NMessage.get(Document.class, "Document.label15", "\u8f7d\u5165[") + this + I18NMessage.get(Document.class, "Document.label29", "] DOCPUBHTMLCON \u5c5e\u6027\u5931\u8d25\uff01")));
                throw new RuntimeException(I18NMessage.get(Document.class, "Document.label15", "\u8f7d\u5165[") + this + I18NMessage.get(Document.class, "Document.label30", "] DOCPUBHTMLCON \u5c5e\u6027\u5931\u8d25\uff01\n") + CMyException.getStackTraceText(exception));
            }
        }
        return this.getPropertyAsString("DOCPUBHTMLCON");
    }

    public boolean setPubHtmlContent(String string) throws WCMException {
        return this.setProperty("DOCPUBHTMLCON", new CDBText(this.getDBManager().getDBTypeAsInt(), string));
    }

    public String getHtmlContentWithImgFilter(String string, boolean bl) throws WCMException {
        return this.getHtmlContentWithImgFilter(string, bl, false);
    }

    public String getHtmlContentWithImgFilter(String string, boolean bl, boolean bl2) throws WCMException {
        if (this.getType() != 20) {
            return "";
        }
        if (this.m_oHTMLContent == null) {
            this.m_oHTMLContent = new HTMLContent(bl2 ? this.getPubHtmlContent() : this.getHtmlContent());
        }
        return this.m_oHTMLContent.parseHTMLContent(string);
    }

    public List getHTMLFiles() throws WCMException {
        if (this.getType() != 20) {
            return new ArrayList();
        }
        if (this.m_oHTMLContent == null) {
            this.m_oHTMLContent = new HTMLContent(this.getHtmlContent());
        }
        return this.m_oHTMLContent.getFiles();
    }

    public List getHTMLWCMFiles() throws WCMException {
        return this.getHTMLWCMFiles(false);
    }

    public List getHTMLWCMFiles(boolean bl) throws WCMException {
        if (this.getType() != 20 && this.getPropertyAsInt("DocFlag", 0) == 0) {
            return new ArrayList();
        }
        if (this.m_oHTMLContent == null) {
            String string;
            String string2 = string = bl ? this.getPubHtmlContent() : this.getHtmlContent();
            if (CMyString.isEmpty(string)) {
                string = this.getContent();
            }
            this.m_oHTMLContent = new HTMLContent(string);
        }
        return this.m_oHTMLContent.getWCMFiles();
    }

    public void setId(int n) {
        this.id = n;
        this.m_bForceAdd = true;
    }

    public boolean isValidInstance() {
        if (this.m_bForceAdd) {
            return true;
        }
        return !this.bAddMode && this.id > 0;
    }

    public boolean isSavePubFileByTime() {
        if (!m_bSavePubFileByTime || this.getCrTime() == null) {
            return false;
        }
        CMyDateTime cMyDateTime = Document.getPubPathStartTime();
        return cMyDateTime != null && cMyDateTime.compareTo(this.getCrTime()) <= 0L;
    }

    public static CMyDateTime getPubPathStartTime() {
        if (m_dtPubPathStartTime == null) {
            String string;
            m_dtPubPathStartTime = new CMyDateTime();
            String string2 = string = "2004-05-01";
            if (ConfigServer.getServer().getInitProperty("PUBPATH_START_DATE") != null) {
                string2 = ConfigServer.getServer().getInitProperty("PUBPATH_START_DATE");
            }
            try {
                m_dtPubPathStartTime.setDateTimeWithString(string2 + " 00:00:00");
            }
            catch (Exception exception) {
                try {
                    m_dtPubPathStartTime.setDateTimeWithString(string + " 00:00:00");
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return m_dtPubPathStartTime;
        }
        return (CMyDateTime)m_dtPubPathStartTime.clone();
    }

    public static void setPubPathStartTime(CMyDateTime cMyDateTime) {
        m_dtPubPathStartTime = (CMyDateTime)cMyDateTime.clone();
    }

    protected int getDocPro() {
        return this.getPropertyAsInt("DOCPRO", 0);
    }

    public boolean hasDocPro(int n) {
        CMyBitsValue cMyBitsValue = new CMyBitsValue(this.getDocPro());
        return cMyBitsValue.getBit(n);
    }

    public void setDocPro(int n, boolean bl) throws WCMException {
        CMyBitsValue cMyBitsValue = new CMyBitsValue(this.getDocPro());
        if (this.getNewProperty("DOCPRO") != null) {
            cMyBitsValue = new CMyBitsValue(this.getNewPropertyAsInt("DOCPRO", 0));
        }
        cMyBitsValue.setBit(n, bl);
        this.setProperty("DOCPRO", cMyBitsValue.getValueAsInt());
    }

    public BaseObj cloneToNewWCMObj() throws WCMException {
        Document document = (Document)super.cloneToNewObj();
        document.setVersion(0);
        document.removeProperty("CRTIME");
        document.setProperty("DOCHTMLCON", new CDBText(this.getDBManager().getDBTypeAsInt(), HTMLContent.saveHtmlContent(this.getHtmlContent(), true, true)));
        return document;
    }

    public static Document findById(int n) throws WCMException {
        return Document.findById(n, "*");
    }

    public static Document findById(int n, String string) throws WCMException {
        return Document.findById(n, string, null);
    }

    public static Document findById(int n, String string, String string2) throws WCMException {
        if (n <= 0) {
            return null;
        }
        Document document = new Document();
        document.setDbTableName(string2);
        document.id = n;
        if (document.loadFromDB(string)) {
            return document;
        }
        return null;
    }

    public static Document createNewInstance() throws WCMException {
        return (Document)BaseObj.createNewInstance(Document.class);
    }

    public static Document findByKey(Object object) throws WCMException {
        return (Document)BaseObj.findByKey(Document.class, object);
    }

    public static void main(String[] stringArray) {
        try {
            Document document = Document.findById(19873);
            System.out.println("currDocument\uff1a" + document);
            if (document != null) {
                System.out.println("currDocument\uff1a" + document.getTitle());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isDoDelete() {
        return this.getPropertyAsInt("DOCSTATUS", 0) * this.getNewPropertyAsInt("DOCSTATUS", 0) < 0 && !this.isDeleted();
    }

    public boolean isDoRecover() {
        return this.getPropertyAsInt("DOCSTATUS", 0) * this.getNewPropertyAsInt("DOCSTATUS", 0) < 0 && this.isDeleted();
    }

    public boolean isDoMove() {
        return !this.isAddMode() && this.isChangeProperty("DOCCHANNEL");
    }

    public int getFromVersion() {
        return this.getPropertyAsInt("DOCFROMVERSION", 0);
    }

    public boolean setFromVersion(int n) throws WCMException {
        return this.setProperty("DOCFROMVERSION", n);
    }

    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getTitle();
        }
        return this.getTitle() + I18NMessage.get(Document.class, "Document.label31", "[\u6587\u6863-") + this.getId() + "]";
    }

    public int delete() throws WCMException {
        this.deleteHTMLContentFiles();
        return super.delete();
    }

    public int delete(User user) throws WCMException {
        this.deleteHTMLContentFiles();
        int n = super.delete(user);
        return n;
    }

    private void deleteHTMLContentFiles() throws WCMException {
        List list = this.getHTMLWCMFiles();
        if (list != null) {
            String string = null;
            for (int i = 0; i < list.size(); ++i) {
                string = (String)list.get(i);
                if (string == null || string.trim().length() <= 0) continue;
                try {
                    FilesMan.getFilesMan().deleteFile(string);
                    continue;
                }
                catch (Exception exception) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)(I18NMessage.get(Document.class, "Document.label32", "\u5220\u9664\u6587\u6863\u5305\u542b\u7684HTML\u6587\u4ef6[") + string + I18NMessage.get(Document.class, "Document.label33", "]\u65f6\u53d1\u751f\u5f02\u5e38\uff01")));
                }
            }
        }
    }

    protected void updateOthersAfterModified() {
        super.updateOthersAfterModified();
        if (SYNCHRONIZE_PROPERTIES_TO_CHNLDOC) {
            try {
                this.synchroizeToChnlDoc();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                logger.error((Object)I18NMessage.get(Document.class, "Document.label34", "\u540c\u6b65WCMDocument\u4fe1\u606f\u5230WCMChnlDoc\u53d1\u751f\u5f02\u5e38\uff01"), (Throwable)exception);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void synchroizeToChnlDoc() throws WCMException {
        String string = this.makeUpdateChnlDocSQL();
        if (string == null) {
            return;
        }
        DBManager dBManager = DBManager.getDBManager();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = dBManager.getConnection();
                preparedStatement = connection.prepareStatement(string);
                this.setSynChnlDocParameters(preparedStatement);
                preparedStatement.execute();
            }
            catch (SQLException sQLException) {
                throw new WCMException(I18NMessage.get(Document.class, "Document.label35", "\u63d2\u5165\u6570\u636e\u5931\u8d25\uff1aSQL=") + string, sQLException);
            }
            catch (Exception exception) {
                throw new WCMException(I18NMessage.get(Document.class, "Document.label35", "\u63d2\u5165\u6570\u636e\u5931\u8d25\uff1aSQL=") + string, exception);
            }
            Object var7_5 = null;
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
            if (preparedStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
            if (preparedStatement == null) throw throwable;
            try {
                preparedStatement.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        preparedStatement.close();
        return;
    }

    private void setSynChnlDocParameters(PreparedStatement preparedStatement) throws WCMException {
        String string = null;
        Object object = null;
        DBType dBType = this.getDBManager().getDBType();
        try {
            int n = 0;
            for (int i = 0; i < SYNCHRONIZED_FIELDS.length; ++i) {
                string = SYNCHRONIZED_FIELDS[i];
                if (!this.isChangeProperty(string)) continue;
                ++n;
                object = this.getNewProperty(string);
                if (object == null) {
                    FieldInfo fieldInfo = this.getDBManager().getFieldInfo(DB_TABLE_NAME, string);
                    preparedStatement.setNull(n, fieldInfo.getDataType().getType());
                    continue;
                }
                if (object instanceof NullValue) {
                    preparedStatement.setNull(n, ((NullValue)object).getDataType());
                    continue;
                }
                if (object instanceof Long) {
                    preparedStatement.setLong(n, (Long)object);
                    continue;
                }
                if (object instanceof Double) {
                    preparedStatement.setDouble(n, (Double)object);
                    continue;
                }
                if (object instanceof Integer) {
                    preparedStatement.setInt(n, (Integer)object);
                    continue;
                }
                if (object instanceof String) {
                    object = dBType.encodeStrToWrite((String)object);
                    int n2 = this.getDBManager().getFieldInfo(this.getDbTableName(), string).getDataType().getType();
                    if (n2 == 12) {
                        dBType.setStringFieldValue(preparedStatement, n, (String)object);
                        continue;
                    }
                    preparedStatement.setNull(n, n2);
                    continue;
                }
                if (object instanceof CMyDateTime) {
                    preparedStatement.setTimestamp(n, ((CMyDateTime)object).toTimestamp());
                    continue;
                }
                if (object instanceof CDBText) {
                    if (!dBType.canWriteTextDirectly()) continue;
                    preparedStatement.setString(n, dBType.encodeStrToWrite(((CDBText)object).getText()));
                    continue;
                }
                throw new WCMException(1103, I18NMessage.get(Document.class, "Document.label36", "\u672a\u77e5\u7684\u5bf9\u8c61") + string + I18NMessage.get(Document.class, "Document.label37", "\u5c5e\u6027\u7c7b\u578b\uff1a(") + this.getClass().getName() + ".setParameters)");
            }
            preparedStatement.setInt(++n, this.getId());
        }
        catch (Exception exception) {
            throw new WCMException(1001, I18NMessage.get(Document.class, "Document.label38", "\u8bbe\u7f6e\u5b57\u6bb5[") + string + I18NMessage.get(Document.class, "Document.label39", "]\u7684\u503c[") + object + I18NMessage.get(Document.class, "Document.label40", "]\u5931\u8d25\uff01"));
        }
    }

    private String makeUpdateChnlDocSQL() {
        String string = null;
        for (int i = 0; i < SYNCHRONIZED_FIELDS.length; ++i) {
            String string2 = SYNCHRONIZED_FIELDS[i];
            if (!this.isChangeProperty(string2)) continue;
            string = string == null ? "" : string + ",";
            string = string + string2 + "=?";
        }
        if (string == null) {
            return null;
        }
        return "update WCMChnlDoc set " + string + " where DocId=?";
    }

    public boolean setOtherTableName(String string) throws WCMException {
        return this.setProperty("OTHERTABLE", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getOtherTableName() {
        block10: {
            block11: {
                if (this.m_sTableName != null && this.m_sTableName.length() > 0) {
                    return this.m_sTableName;
                }
                Object object = this.getProperty("OTHERTABLE");
                if (object == null) break block10;
                this.m_sTableName = object.toString().trim();
                if (this.m_sTableName.length() <= 0) break block10;
                if (this.id <= 0) {
                    Connection connection = null;
                    connection = this.getDBManager().getConnection();
                    this.getNextId(connection, DB_TABLE_NAME, DB_ID_NAME);
                    Object var5_3 = null;
                    try {
                        this.getDBManager().freeConnection(connection);
                    }
                    catch (Exception exception) {}
                    break block11;
                    {
                        catch (WCMException wCMException) {
                            wCMException.printStackTrace();
                            Object var5_4 = null;
                            try {
                                this.getDBManager().freeConnection(connection);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        try {
                            this.getDBManager().freeConnection(connection);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            return this.m_sTableName;
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public void insertOtherTable(User user, String string) throws WCMException {
        block13: {
            String string2;
            PreparedStatement preparedStatement;
            Connection connection;
            block12: {
                this.getProperties().put("CRUSER", user.getName());
                this.loadTextsFromDB(false);
                this.getProperties().put("OTHERTABLE", "");
                this.setDbTableName(string);
                this.bAddMode = true;
                connection = null;
                preparedStatement = null;
                string2 = this.createInsertSQL();
                connection = this.getDBManager().getConnection();
                preparedStatement = connection.prepareStatement(string2);
                this.setParameters(preparedStatement);
                preparedStatement.executeUpdate();
                if (this.sClobFields_toUpdate != null) {
                    this.updateClobFields(connection, true);
                }
                this.bAddMode = false;
                Object var8_6 = null;
                if (preparedStatement == null) break block12;
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (connection != null) {
                this.getDBManager().freeConnection(connection);
            }
            break block13;
            {
                catch (SQLException sQLException) {
                    throw new WCMException(40, I18NMessage.get(Document.class, "Document.label41", "\u6dfb\u52a0\u5bf9\u8c61\u4fe1\u606f\u5230\u6570\u636e\u5e93\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".insert).SQL:\n" + string2, sQLException);
                }
                catch (Exception exception) {
                    throw new WCMException(0, I18NMessage.get(Document.class, "Document.label41", "\u6dfb\u52a0\u5bf9\u8c61\u4fe1\u606f\u5230\u6570\u636e\u5e93\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".insert).", exception);
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    this.getDBManager().freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    public boolean setRandomSerial(String string) throws WCMException {
        if (!CMyString.isEmpty(string)) {
            string = this.isAddMode() ? string + "-" + this.getNextId() : string + "-" + this.getId();
            return this.setProperty("RANDOMSERIAL", string);
        }
        return true;
    }

    public String getRandomSerial() {
        return this.getPropertyAsString("RANDOMSERIAL");
    }

    public DocLevel getDocLevel() throws WCMException {
        int n = this.getDocLevleId();
        if (n == 0) {
            return DocLevel.findById(1);
        }
        return DocLevel.findById(n);
    }

    public boolean setDocLevel(DocLevel docLevel) throws WCMException {
        if (docLevel == null) {
            return this.setDocLevel(0);
        }
        return this.setDocLevel(docLevel.getId());
    }

    public int getDocLevleId() {
        return this.getPropertyAsInt("DOCLEVEL", 0);
    }

    public boolean setDocLevel(int n) throws WCMException {
        return this.setProperty("DOCLEVEL", n);
    }

    public String getDocLevelName() throws WCMException {
        if (this.getDocId() == 0) {
            return "";
        }
        DocLevel docLevel = this.getDocLevel();
        if (docLevel == null) {
            return "\u672a\u77e5";
        }
        return docLevel.getLName();
    }

    public boolean hasImgInDocContent() throws WCMException {
        String string = this.getHtmlContent();
        if (string == null || string.trim().equals("")) {
            return false;
        }
        String string2 = "(?is)<img\\b[^>]*\\bsrc=\"([^\"]+)?\"[^>]*?>";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        String string3 = null;
        boolean bl = false;
        while (matcher.find()) {
            string3 = matcher.group(1);
            if (string3 == null || string3.trim().length() == 0) continue;
            int n = string3.lastIndexOf("/");
            if (n < 0) {
                n = string3.lastIndexOf("\\");
            }
            if (n >= 0) {
                string3 = string3.substring(n + 1);
            }
            if (!Document.validConPic(string3)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean validConPic(String string) throws WCMException {
        String string2;
        try {
            string2 = FilesMan.getFilesMan().mapFilePath(string, 0) + string;
        }
        catch (WCMException wCMException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u6839\u636e\u6587\u4ef6\u540d[" + string + "]\u83b7\u53d6\u6587\u4ef6\u8def\u5f84\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)wCMException);
            }
            return false;
        }
        String string3 = ConfigServer.getServer().getSysConfigValue("DOCCONTENTPIC_VALID_MIN_LIMIT", "600,400");
        int[] nArray = CMyString.splitToInt(string3, ",");
        return CMyFile.validImageFile(string2, nArray[0], nArray[1]);
    }
}

