/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.ContentLinkType;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;

public class ContentLink
extends CMSObj {
    public static final int OBJ_TYPE = 106;
    public static final String DB_TABLE_NAME = "WCMCONTENTLINK";
    public static final String DB_ID_NAME = "CONTENTLINKID";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 106;
    }

    public boolean isValid() throws WCMException {
        String string = null;
        if (this.isAddMode()) {
            if (this.getProperty("LINKNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(ContentLink.class, "ContentLink.label1", "\u5c5e\u6027LINKNAME\u6ca1\u6709\u8bbe\u7f6e(ContentLink.isValid)"));
            }
            if (this.getProperty("SITEID") == null) {
                throw new WCMException(1106, I18NMessage.get(ContentLink.class, "ContentLink.label2", "\u5c5e\u6027SITEID\u6ca1\u6709\u8bbe\u7f6e(ContentLink.isValid)"));
            }
            if (this.getProperty("LINKURL") == null) {
                throw new WCMException(1106, I18NMessage.get(ContentLink.class, "ContentLink.label3", "\u5c5e\u6027LINKURL\u6ca1\u6709\u8bbe\u7f6e(ContentLink.isValid)"));
            }
            string = this.getPropertyAsString("LINKNAME");
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(ContentLink.class, "ContentLink.label4", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(ContentLink.isValid)"));
            }
            if (this.isChangeProperty("LINKNAME")) {
                string = this.getNewPropertyAsString("LINKNAME");
            }
        }
        if (!CMyString.isEmpty(string)) {
            string = string.toUpperCase();
            this.setProperty("LINKNAME", string);
        }
        return true;
    }

    public boolean setName(String string) throws WCMException {
        return this.setPropertyWithString("LINKNAME", string);
    }

    public String getName() {
        return this.getPropertyAsString("LINKNAME");
    }

    public boolean setLinkUrl(String string) throws WCMException {
        return this.setPropertyWithString("LINKURL", string);
    }

    public String getLinkUrl() {
        return this.getPropertyAsString("LINKURL");
    }

    public boolean setLinkTitle(String string) throws WCMException {
        return this.setPropertyWithString("LINKTITLE", string);
    }

    public String getLinkTitle() {
        return this.getPropertyAsString("LINKTITLE");
    }

    public boolean setSiteId(int n) throws WCMException {
        return this.setProperty("SITEID", n);
    }

    public int getSiteId() {
        return this.getPropertyAsInt("SITEID", 0);
    }

    public WebSite getSite() throws WCMException {
        return WebSite.findById(this.getSiteId());
    }

    public static final ContentLink findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (ContentLink)BaseObj.findById(ContentLink.class, n);
    }

    public static final ContentLink createNewInstance() throws WCMException {
        return (ContentLink)BaseObj.createNewInstance(ContentLink.class);
    }

    public static final ContentLink findByKey(Object object) throws WCMException {
        return (ContentLink)BaseObj.findByKey(ContentLink.class, object);
    }

    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return this.getName() + I18NMessage.get(ContentLink.class, "ContentLink.label5", "[\u5185\u5bb9\u8d85\u94fe\u63a5-") + this.getId() + "]";
    }

    public int getLinkType() {
        return this.getPropertyAsInt("CONTENTLINKTYPE", 0);
    }

    public boolean setLinkType(int n) throws WCMException {
        return this.setProperty("CONTENTLINKTYPE", n);
    }

    public String getLinkTypeName() throws WCMException {
        int n = this.getLinkType();
        ContentLinkType contentLinkType = ContentLinkType.findById(n);
        return contentLinkType != null ? contentLinkType.getTypeName() : I18NMessage.get(ContentLink.class, "ContentLink.label6", "\u672a\u77e5");
    }
}

