/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.resource.DocLevel;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import java.sql.Timestamp;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class ChnlDoc
extends CMSObj {
    private static Logger logger = Logger.getLogger(ChnlDoc.class);
    public static final int OBJ_TYPE = 614;
    public static final String DB_TABLE_NAME = "WCMCHNLDOC";
    public static final String DB_ID_NAME = "RECID";
    public static boolean IS_ORDER_BY_PRI = true;
    public static int PRI_DOCS_SIZE = 100;
    public static int NOT_ON_TOP = 0;
    private Document m_oDocument = null;
    public static final Hashtable H_DB_DOCUMENT_PROPERTIES = new Hashtable(3);
    public static final int MODAL_ALL = 0;
    public static final int MODAL_ENTITY = 1;
    public static final int MODAL_LINK = 2;
    public static final int MODAL_MIRROR = 3;
    private static final String UPDATE_DOCORDERPRI_SQLWHERE = " WHERE DocOrderPri>0 AND DocOrderPri<=";
    public static String DB_DOCUMENT_FIELDS = "";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 614;
    }

    public int getSiteId() {
        return this.getPropertyAsInt("SITEID", 0);
    }

    public boolean setSiteId(int n) throws WCMException {
        return this.setProperty("SITEID", n);
    }

    public int getChannelId() {
        return this.getPropertyAsInt("CHNLID", 0);
    }

    public Channel getChannel() throws WCMException {
        int n = this.getChannelId();
        if (n == 0) {
            return null;
        }
        return Channel.findById(Math.abs(n));
    }

    public boolean setChannelId(int n) throws WCMException {
        return this.setProperty("CHNLID", n);
    }

    public int getDocId() {
        return this.getPropertyAsInt("DOCID", 0);
    }

    public boolean setDeleted(boolean bl) throws WCMException {
        int n = this.getStatusId();
        if (n < 0 == bl) {
            return false;
        }
        return this.setStatusId(-n);
    }

    public boolean setDocId(int n) throws WCMException {
        return this.setProperty("DOCID", n);
    }

    public boolean setDocument(Document document, boolean bl) throws WCMException {
        this.m_oDocument = document;
        if (bl) {
            return true;
        }
        return this.setProperty("DOCID", document.getId());
    }

    public int getStatusId() {
        return this.getPropertyAsInt("DOCSTATUS", 0);
    }

    public Status getStatus() throws WCMException {
        int n = this.getStatusId();
        if (n < 0) {
            n = -n;
        }
        return Status.findById(n);
    }

    public String getStatusName() throws WCMException {
        if (this.getStatusId() == 0) {
            return "";
        }
        Status status = this.getStatus();
        if (status == null) {
            return I18NMessage.get(ChnlDoc.class, "ChnlDoc.label1", "\u672a\u77e5");
        }
        return status.getDisp();
    }

    public boolean setStatusId(int n) throws WCMException {
        return this.setProperty("DOCSTATUS", n);
    }

    public int getDocOrder() {
        return this.getPropertyAsInt("DOCORDER", 0);
    }

    public boolean setDocOrder(int n) throws WCMException {
        return this.setProperty("DOCORDER", n);
    }

    public CMyDateTime getDocPubTime() {
        return (CMyDateTime)this.getProperty("DOCPUBTIME");
    }

    public boolean setDocPubTime(CMyDateTime cMyDateTime) throws WCMException {
        return this.setProperty("DOCPUBTIME", cMyDateTime);
    }

    public String getDocPubURL() {
        return this.getPropertyAsString("DOCPUBURL");
    }

    public boolean setDocPubURL(String string) throws WCMException {
        return this.setProperty("DOCPUBURL", string);
    }

    public int getDocOrderPri() {
        return this.getDocOrderPri(false);
    }

    public int getDocOrderPri(boolean bl) {
        int n = this.getPropertyAsInt("DOCORDERPRI", 0);
        if (bl) {
            return n;
        }
        return n == 0 ? 0 : PRI_DOCS_SIZE - n + 1;
    }

    public boolean setDocOrderPri(int n) throws WCMException {
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        if (n < 0) {
            throw new WCMException(10, I18NMessage.get(ChnlDoc.class, "ChnlDoc.label2", "\u5bf9\u4e0d\u8d77,\u7f6e\u9876\u987a\u5e8f\u4e0d\u80fd\u5c0f\u4e8e0!"));
        }
        if (n > documentMgr.getMaxToppedNum()) {
            throw new WCMException(10, I18NMessage.get(ChnlDoc.class, "ChnlDoc.label3", "\u5bf9\u4e0d\u8d77,\u7f6e\u9876\u987a\u5e8f\u4e0d\u80fd\u8d85\u8fc7\u6700\u5927\u503c[+") + documentMgr.getMaxToppedNum() + "!");
        }
        int n2 = documentMgr.getMaxToppedNum() + 1 - n;
        if (n == NOT_ON_TOP) {
            return this.setProperty("DOCORDERPRI", n);
        }
        return this.setProperty("DOCORDERPRI", n2);
    }

    public boolean setDocTopPriOrder(int n) throws WCMException {
        if (n < 0 || n > PRI_DOCS_SIZE) {
            throw new WCMException(1104, I18NMessage.get(ChnlDoc.class, "ChnlDoc.label4", "\u65e0\u6548\u7684\u7f6e\u9876\u4f4d\u7f6e!"));
        }
        int n2 = 0;
        if (n == NOT_ON_TOP) {
            if (this.isTopped()) {
                n2 = PRI_DOCS_SIZE - this.getDocOrderPri() + 1;
                String string = "UPDATE " + this.getDbTableName() + " SET DocOrderPri=(DocOrderPri+1) " + UPDATE_DOCORDERPRI_SQLWHERE + n2 + " AND ChnlId=" + this.getChannelId();
                DBManager.getDBManager().sqlExecuteUpdate(string);
            }
            n2 = NOT_ON_TOP;
        } else {
            n2 = PRI_DOCS_SIZE - n + 1;
            String string = "UPDATE " + this.getDbTableName() + " SET DocOrderPri=(DocOrderPri-1) " + UPDATE_DOCORDERPRI_SQLWHERE + n2 + " AND ChnlId=" + this.getChannelId();
            DBManager.getDBManager().sqlExecuteUpdate(string);
        }
        return this.setProperty("DOCORDERPRI", n2);
    }

    public boolean isTopped() {
        return this.getPropertyAsInt("DOCORDERPRI", 0) > 0;
    }

    public CMyDateTime getInvalidTime() {
        return (CMyDateTime)this.getProperty("INVALIDTIME");
    }

    public boolean setInvalidTime(CMyDateTime cMyDateTime) throws WCMException {
        return this.setProperty("INVALIDTIME", cMyDateTime);
    }

    public boolean isDeleted() {
        return this.getStatusId() < 0;
    }

    public void setId(int n) {
        this.id = n;
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getAllProperty().get("CHNLID") == null) {
                throw new WCMException(1106, I18NMessage.get(ChnlDoc.class, "ChnlDoc.label5", "\u5c5e\u6027ChannelId\u6ca1\u6709\u8bbe\u7f6e(ChnlDoc.isValid)"));
            }
            if (this.getAllProperty().get("DOCID") == null) {
                throw new WCMException(1106, I18NMessage.get(ChnlDoc.class, "ChnlDoc.label6", "\u5c5e\u6027DocId\u6ca1\u6709\u8bbe\u7f6e(ChnlDoc.isValid)"));
            }
            if (this.getAllProperty().get("DOCSTATUS") == null) {
                throw new WCMException(1106, I18NMessage.get(ChnlDoc.class, "ChnlDoc.label7", "\u5c5e\u6027StatusId\u6ca1\u6709\u8bbe\u7f6e(ChnlDoc.isValid)"));
            }
            if (this.getAllProperty().get("DOCORDER") == null) {
                throw new WCMException(1106, I18NMessage.get(ChnlDoc.class, "ChnlDoc.label8", "\u5c5e\u6027DocOrder\u6ca1\u6709\u8bbe\u7f6e(ChnlDoc.isValid)"));
            }
            if (this.getAllProperty().get("MODAL") == null) {
                throw new WCMException(1106, I18NMessage.get(ChnlDoc.class, "ChnlDoc.label9", "\u5c5e\u6027Modal\u6ca1\u6709\u8bbe\u7f6e(ChnlDoc.isValid)"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(ChnlDoc.class, "ChnlDoc.label10", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(ChnlDoc.isValid)"));
            }
            if (this.isEntity() && this.isChangeProperty("ChnlId") && this.containsProperty("DocChannel")) {
                this.setProperty("DocChannel", this.getNewProperty("ChnlId"));
            }
        }
        this.setProperty("OperTime", CMyDateTime.now());
        return true;
    }

    public boolean setOperUser(User user) throws WCMException {
        if (user == null || !user.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(ChnlDoc.class, "ChnlDoc.label11", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61(") + this.getClass().getName() + ".setOperUser)");
        }
        return this.setOperUser(user.getName());
    }

    public boolean setOperUser(String string) throws WCMException {
        return this.setProperty("OPERUSER", string);
    }

    public User getOperUser() {
        String string = this.getOperUserName();
        return string == null ? null : User.findByName(string);
    }

    public String getOperUserName() {
        return (String)this.getProperty("OPERUSER");
    }

    public boolean setOperTime() throws WCMException {
        return this.setProperty("OPERTIME", CMyDateTime.now());
    }

    public CMyDateTime getOperTime() {
        return (CMyDateTime)this.getProperty("OPERTIME");
    }

    public int getModal() {
        return this.getPropertyAsInt("MODAL", 0);
    }

    public boolean isEntity() {
        return this.getModal() == 1;
    }

    public boolean setModal(int n) throws WCMException {
        return this.setProperty("MODAL", n);
    }

    public DocLevel getDocLevel() throws WCMException {
        int n = this.getDocLevleId();
        if (n == 0) {
            return DocLevel.findById(1);
        }
        return DocLevel.findById(n);
    }

    public boolean setDocLevel(DocLevel docLevel) throws WCMException {
        if (docLevel == null) {
            return this.setDocLevel(0);
        }
        return this.setDocLevel(docLevel.getId());
    }

    public int getDocLevleId() {
        return this.getPropertyAsInt("DOCLEVEL", 0);
    }

    public boolean setDocLevel(int n) throws WCMException {
        return this.setProperty("DOCLEVEL", n);
    }

    public String getDocLevelName() throws WCMException {
        if (this.getDocId() == 0) {
            return "";
        }
        DocLevel docLevel = this.getDocLevel();
        if (docLevel == null) {
            return I18NMessage.get(ChnlDoc.class, "ChnlDoc.label1", "\u672a\u77e5");
        }
        return docLevel.getLName();
    }

    public static final ChnlDoc findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (ChnlDoc)BaseObj.findById(ChnlDoc.class, n);
    }

    public static final ChnlDoc createNewInstance() throws WCMException {
        return (ChnlDoc)BaseObj.createNewInstance(ChnlDoc.class);
    }

    public static final ChnlDoc findByKey(Object object) throws WCMException {
        return (ChnlDoc)BaseObj.findByKey(ChnlDoc.class, object);
    }

    public Document getDocument() throws WCMException {
        if (this.m_oDocument != null) {
            return this.m_oDocument;
        }
        int n = this.getDocId();
        if (n == 0) {
            return null;
        }
        this.m_oDocument = Document.findById(n);
        return this.m_oDocument;
    }

    public int getDocumentId() {
        return this.getPropertyAsInt("DOCID", 0);
    }

    protected void deleteOthersBeforeDelete() {
        super.deleteOthersBeforeDelete();
        if (this.getModal() == 1) {
            try {
                Document document = this.getDocument();
                if (document != null) {
                    document.delete();
                }
            }
            catch (WCMException wCMException) {
                logger.error((Object)(I18NMessage.get(ChnlDoc.class, "ChnlDoc.label12", "\u540c\u6b65\u5220\u9664\u6587\u6863[") + this.getDocId() + I18NMessage.get(ChnlDoc.class, "ChnlDoc.label13", "]\u5931\u8d25\uff01")), (Throwable)wCMException);
                throw new RuntimeException(I18NMessage.get(ChnlDoc.class, "ChnlDoc.label12", "\u540c\u6b65\u5220\u9664\u6587\u6863[") + this.getDocId() + I18NMessage.get(ChnlDoc.class, "ChnlDoc.label13", "]\u5931\u8d25\uff01"), wCMException);
            }
        }
    }

    protected void updateOthersAfterModified() {
        super.updateOthersAfterModified();
        if (this.getModal() == 1) {
            try {
                Object[] objectArray;
                Object object;
                if (this.isChangeProperty("DOCSTATUS")) {
                    int n = this.getNewPropertyAsInt("DOCSTATUS", 0);
                    object = "update WCMDocument set DocStatus=?, OperUser=?, OperTime=? where DOCID=?";
                    objectArray = new Integer(n);
                    Integer n2 = new Integer(this.getDocId());
                    Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                    String string = this.getLockerUserName();
                    Object[] objectArray2 = new Object[]{objectArray, string, timestamp, n2};
                    this.getDBManager().sqlExecuteUpdate(new String[]{object}, objectArray2);
                    object = "update WCMChnlDoc set DocStatus=?, OperUser=?, OperTime=? where DOCID=?";
                    this.getDBManager().sqlExecuteUpdate(new String[]{object}, objectArray2);
                    if (n < 0) {
                        String string2 = "update WCMChnlDoc set Modal=-Modal where DOCID=? and Modal>0 and Modal<>1";
                        Object[] objectArray3 = new Object[]{n2};
                        this.getDBManager().sqlExecuteUpdate(new String[]{string2}, objectArray3);
                        string2 = "update WCMChnlDoc set OperUser=?, OperTime=? where DOCID=? and DocStatus>0";
                        objectArray3 = new Object[]{string, timestamp, n2};
                        this.getDBManager().sqlExecuteUpdate(new String[]{string2}, objectArray3);
                    } else if (this.getStatusId() < 0 & n > 0) {
                        String string3 = "update WCMChnlDoc set Modal=-Modal where DOCID=? and Modal<0";
                        Object[] objectArray4 = new Object[]{n2};
                        this.getDBManager().sqlExecuteUpdate(new String[]{string3}, objectArray4);
                        string3 = "update WCMChnlDoc set OperUser=?, OperTime=? where DOCID=? and DocStatus>0";
                        objectArray4 = new Object[]{string, timestamp, n2};
                        this.getDBManager().sqlExecuteUpdate(new String[]{string3}, objectArray4);
                    }
                }
                if (this.isChangeProperty("CHNLID")) {
                    String string = "update WCMDocument set DOCCHANNEL=" + this.getNewPropertyAsInt("CHNLID", 0) + " where DOCID=" + this.getDocId();
                    object = "update WCMChnlDoc set DOCCHANNEL=" + this.getNewPropertyAsInt("CHNLID", 0) + " where DOCID=" + this.getDocId();
                    this.getDBManager().sqlExecuteUpdate(new String[]{string, object});
                }
                if (this.isChangeProperty("DOCPUBTIME")) {
                    String string = "update WCMDocument set DOCPUBTIME=? where DOCID=" + this.getDocId();
                    object = new String[]{string};
                    objectArray = new Object[]{(CMyDateTime)this.getNewProperty("DOCPUBTIME")};
                    this.getDBManager().sqlExecuteUpdate((String[])object, objectArray);
                }
            }
            catch (WCMException wCMException) {
                logger.error((Object)(I18NMessage.get(ChnlDoc.class, "ChnlDoc.label14", "\u540c\u6b65\u6587\u6863[") + this.getDocId() + I18NMessage.get(ChnlDoc.class, "ChnlDoc.label15", "]\u5c5e\u6027\u5931\u8d25\uff01")), (Throwable)wCMException);
                throw new RuntimeException(I18NMessage.get(ChnlDoc.class, "ChnlDoc.label14", "\u540c\u6b65\u6587\u6863[") + this.getDocId() + I18NMessage.get(ChnlDoc.class, "ChnlDoc.label15", "]\u5c5e\u6027\u5931\u8d25\uff01"), wCMException);
            }
        }
    }

    public static final ChnlDoc findByDocAndChnl(Document document, Channel channel) throws WCMException {
        if (document == null || channel == null) {
            return null;
        }
        if (document.getChannelId() != channel.getId() && channel.isOnlySearch()) {
            return ChnlDoc.findByDocument(document);
        }
        String string = "ChnlId=? and DocId=?";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        wCMFilter.addSearchValues(0, channel.getId());
        wCMFilter.addSearchValues(1, document.getId());
        wCMFilter.setMaxRowNumber(1);
        ChnlDocs chnlDocs = ChnlDocs.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        if (!chnlDocs.isEmpty()) {
            return (ChnlDoc)chnlDocs.getAt(0);
        }
        return ChnlDoc.findByDocAndChnl(document.getId(), -channel.getId());
    }

    public static ChnlDoc findByDocAndChnl(int n, int n2) throws WCMException {
        String string = "DocId=? and ChnlId=?";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        wCMFilter.addSearchValues(0, n);
        wCMFilter.addSearchValues(1, n2);
        wCMFilter.setMaxRowNumber(1);
        ChnlDocs chnlDocs = new ChnlDocs(null);
        chnlDocs.open(wCMFilter);
        if (chnlDocs.isEmpty()) {
            wCMFilter.addSearchValues(1, -n2);
            chnlDocs.open(wCMFilter);
        }
        if (!chnlDocs.isEmpty()) {
            return (ChnlDoc)chnlDocs.getAt(0);
        }
        return null;
    }

    public static final ChnlDoc findByDocument(Document document) throws WCMException {
        return ChnlDoc.findByDocAndChnl(document, document.getChannel());
    }

    public boolean isPublished() {
        return this.getStatusId() == 10;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(this.getDocument().getTitle());
        }
        catch (Exception exception) {
            stringBuffer.append(I18NMessage.get(ChnlDoc.class, "ChnlDoc.label16", "\u6587\u6863"));
        }
        stringBuffer.append("[DOCID=");
        stringBuffer.append(this.getDocId());
        stringBuffer.append(", CHNLID=");
        stringBuffer.append(this.getChannelId());
        stringBuffer.append(", MODAL=");
        stringBuffer.append(this.getModal());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static {
        String string = "DOCSTATUS";
        String string2 = "DOCSTATUS";
        H_DB_DOCUMENT_PROPERTIES.put(string, string2);
        DB_DOCUMENT_FIELDS = "WCMCHNLDOC." + string2 + " AS " + string;
        string = "DOCORDER";
        string2 = "DOCORDER";
        H_DB_DOCUMENT_PROPERTIES.put(string, string2);
        DB_DOCUMENT_FIELDS = DB_DOCUMENT_FIELDS + ",WCMCHNLDOC." + string2 + " AS " + string;
        string = "DOCPUBTIME";
        string2 = "DOCPUBTIME";
        H_DB_DOCUMENT_PROPERTIES.put(string, string2);
        DB_DOCUMENT_FIELDS = DB_DOCUMENT_FIELDS + ",WCMCHNLDOC." + string2 + " AS " + string;
        string = "DOCPUBURL";
        string2 = "DOCPUBURL";
        H_DB_DOCUMENT_PROPERTIES.put(string, string2);
        DB_DOCUMENT_FIELDS = DB_DOCUMENT_FIELDS + ",WCMCHNLDOC." + string2 + " AS " + string;
        string = "NEWCRUSER";
        string2 = "CRUSER";
        H_DB_DOCUMENT_PROPERTIES.put(string, string2);
        DB_DOCUMENT_FIELDS = DB_DOCUMENT_FIELDS + ",WCMCHNLDOC." + string2 + " AS " + string;
        string = "NEWCRTIME";
        string2 = "CRTIME";
        H_DB_DOCUMENT_PROPERTIES.put(string, string2);
        DB_DOCUMENT_FIELDS = DB_DOCUMENT_FIELDS + ",WCMCHNLDOC." + string2 + " AS " + string;
        try {
            ConfigServer configServer = ConfigServer.getServer();
            String string3 = configServer.getSysConfigValue("PRI_DOCS_SIZE", "");
            if (string3.length() > 0) {
                PRI_DOCS_SIZE = Integer.parseInt(string3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

