/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfigs;
import com.trs.components.common.publish.persistent.template.TempAppendixXmlConverter;
import com.trs.components.common.publish.persistent.template.TempAppendixes;
import com.trs.components.common.publish.persistent.template.TemplateArguments;
import com.trs.components.common.publish.persistent.template.TemplateEmploys;
import com.trs.components.common.publish.persistent.template.TemplateXmlConverter;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.domain.ContentExtFieldMgr;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ContentExtFieldXmlConverter;
import com.trs.components.wcm.content.persistent.ContentExtFields;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.WCMPubStatusConfig;
import com.trs.components.wcm.publish.WCMPubStatusConfigs;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverter;
import com.trs.infra.persistent.ObjToXmlConverter;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.util.List;
import org.dom4j.Element;

public class ChannelXmlConverter
extends BaseObjToXmlConverter {
    private String m_sChannelFieldList = null;
    private String m_sSiteFieldList = null;
    private boolean m_bWithChildren = false;
    private boolean m_bWithExtField = false;
    private boolean m_bWithTemp = false;
    private String m_sTempApdsPath;
    private TemplateEmployMgr m_employMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
    private ContentExtFieldMgr m_extFieldMgr = (ContentExtFieldMgr)DreamFactory.createObjectById("ContentExtFieldMgr");
    private TemplateMgr m_templateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
    private User m_currUser = User.getSystem();
    private ObjToXmlConverter m_converter;
    private ContentExtFieldXmlConverter m_extFieldConverter = new ContentExtFieldXmlConverter();

    public ChannelXmlConverter(String string, String string2) {
        this.m_sChannelFieldList = string2;
        this.m_sSiteFieldList = string;
    }

    protected Element[] getChildElement(BaseObj baseObj) throws WCMException {
        if (baseObj == null) {
            throw new WCMException(10, I18NMessage.get(ChannelXmlConverter.class, "ChannelXmlConverter.label1", "\u65e0\u6548\u7684\u5bf9\u8c61[null]!"));
        }
        BaseChannel baseChannel = (BaseChannel)baseObj;
        Element[] elementArray = new Element[8];
        this.m_converter = new ObjToXmlConverter();
        elementArray[1] = this.getFolderPubConfsEl(baseChannel);
        elementArray[2] = this.getPubStatusConfsEl(baseChannel);
        elementArray[3] = this.getChildrenEl(baseChannel);
        if (this.isWithExtField()) {
            elementArray[4] = this.getExtFieldsEl(baseChannel);
        }
        if (this.isWithTemplates()) {
            elementArray[0] = this.getTempEmploysEl(baseChannel);
            elementArray[5] = this.getTemplatesEl(baseChannel);
            elementArray[6] = this.getTempApdsEl(baseChannel);
        }
        elementArray[7] = this.getTemplateArgs(baseChannel);
        return elementArray;
    }

    private Element getTemplateArgs(BaseChannel baseChannel) throws WCMException {
        if (baseChannel.isSite()) {
            return null;
        }
        TemplateArguments templateArguments = new TemplateArguments(null);
        WCMFilter wCMFilter = new WCMFilter("", "employertype=? and employerid=?", "");
        wCMFilter.addSearchValues(baseChannel.getWCMType());
        wCMFilter.addSearchValues(baseChannel.getId());
        templateArguments.open(wCMFilter);
        return this.m_converter.toXmlElement(templateArguments, null);
    }

    private Element getTempEmploysEl(BaseChannel baseChannel) throws WCMException {
        TemplateEmploys templateEmploys = this.m_employMgr.getEmploysOfEmployer(baseChannel.getWCMType(), baseChannel.getId());
        return this.m_converter.toXmlElement(templateEmploys, null);
    }

    private Element getFolderPubConfsEl(BaseChannel baseChannel) throws WCMException {
        FolderPublishConfig folderPublishConfig = FolderPublishConfig.findOf(baseChannel.getWCMType(), baseChannel.getId());
        FolderPublishConfigs folderPublishConfigs = FolderPublishConfigs.createNewInstance(this.m_currUser);
        if (folderPublishConfig != null) {
            folderPublishConfigs.addElement(folderPublishConfig);
        }
        return this.m_converter.toXmlElement(folderPublishConfigs, null);
    }

    private Element getPubStatusConfsEl(BaseChannel baseChannel) throws WCMException {
        WCMPubStatusConfig wCMPubStatusConfig = WCMPubStatusConfig.findOf(baseChannel.getWCMType(), baseChannel.getId());
        WCMPubStatusConfigs wCMPubStatusConfigs = WCMPubStatusConfigs.createNewInstance(this.m_currUser);
        if (wCMPubStatusConfig != null) {
            wCMPubStatusConfigs.addElement(wCMPubStatusConfig);
        }
        return this.m_converter.toXmlElement(wCMPubStatusConfigs, null);
    }

    private Element getChildrenEl(BaseChannel baseChannel) throws WCMException {
        if (this.isWithChildren()) {
            List list = baseChannel.getChildren(this.m_currUser);
            return this.toXmlElement(list, null);
        }
        return this.m_converter.toXmlElement(Channels.createNewInstance(this.m_currUser), null);
    }

    private Element getExtFieldsEl(BaseChannel baseChannel) throws WCMException {
        ContentExtFields contentExtFields = null;
        contentExtFields = this.isWithExtField() ? this.m_extFieldMgr.getExtFields(baseChannel, null) : ContentExtFields.createNewInstance(this.m_currUser);
        return this.m_extFieldConverter.toXmlElement(contentExtFields, null);
    }

    private Element getTemplatesEl(BaseChannel baseChannel) throws WCMException {
        Templates templates = null;
        TemplateXmlConverter templateXmlConverter = new TemplateXmlConverter();
        if (this.isWithTemplates()) {
            if (baseChannel.isSite()) {
                IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(baseChannel);
                templates = this.m_templateMgr.getManagedTemplates(iPublishFolder, -1, null, true);
            } else {
                templates = Templates.createNewInstance(this.m_currUser);
            }
        } else {
            return null;
        }
        return templateXmlConverter.toXmlElement(templates, null);
    }

    private Element getTempApdsEl(BaseChannel baseChannel) throws WCMException {
        if (this.isWithTemplates() && baseChannel.isSite()) {
            TempAppendixes tempAppendixes = this.m_templateMgr.getTempAppendixesInRoot(baseChannel.getWCMType(), baseChannel.getId(), null);
            TempAppendixXmlConverter tempAppendixXmlConverter = new TempAppendixXmlConverter();
            tempAppendixXmlConverter.initConverter(baseChannel.getWCMType(), baseChannel.getId(), this.m_sTempApdsPath);
            return tempAppendixXmlConverter.toXmlElement(tempAppendixes, null);
        }
        TempAppendixes tempAppendixes = TempAppendixes.createNewInstance(this.m_currUser);
        return this.m_converter.toXmlElement(tempAppendixes, null);
    }

    public boolean isWithChildren() {
        return this.m_bWithChildren;
    }

    public void setWithChildren(boolean bl) {
        this.m_bWithChildren = bl;
    }

    public boolean isWithExtField() {
        return this.m_bWithExtField;
    }

    public void setWithExtField(boolean bl) {
        this.m_bWithExtField = bl;
    }

    public boolean isWithTemplates() {
        return this.m_bWithTemp && this.m_sTempApdsPath != null;
    }

    public void setWithTemp(boolean bl, String string) throws WCMException {
        this.m_bWithTemp = bl;
        if (bl) {
            this.assertNotEmptyPath(string);
            this.m_sTempApdsPath = CMyString.setStrEndWith(string, File.separatorChar);
        }
    }

    private void assertNotEmptyPath(String string) throws WCMException {
        if (string == null || string.trim().length() == 0) {
            throw new WCMException(10, I18NMessage.get(ChannelXmlConverter.class, "ChannelXmlConverter.label2", "\u65e0\u6548\u7684\u8def\u5f84!"));
        }
    }

    protected String getFieldList(BaseObj baseObj) {
        if (baseObj instanceof Channel) {
            return this.m_sChannelFieldList;
        }
        if (baseObj instanceof WebSite) {
            return this.m_sSiteFieldList;
        }
        return super.getFieldList(baseObj);
    }
}

