/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;

public class ChannelContentLink
extends CMSObj {
    public static final int OBJ_TYPE = 1952046669;
    public static final String DB_TABLE_NAME = "WCMCHANNELCONTENTLINK";
    public static final String DB_ID_NAME = "LINKID";
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;

    public int getWCMType() {
        return 1952046669;
    }

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public boolean isValid() throws WCMException {
        String string = null;
        if (this.isAddMode()) {
            if (this.getProperty("LINKNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(ChannelContentLink.class, "ChannelContentLink.label1", "\u5c5e\u6027LINKNAME\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("CHANNELID") == null) {
                throw new WCMException(1106, I18NMessage.get(ChannelContentLink.class, "ChannelContentLink.label2", "\u5c5e\u6027CHANNELID\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("LINKURL") == null) {
                throw new WCMException(1106, I18NMessage.get(ChannelContentLink.class, "ChannelContentLink.label3", "\u5c5e\u6027LINKURL\u6ca1\u6709\u8bbe\u7f6e"));
            }
            string = this.getPropertyAsString("LINKNAME");
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(ChannelContentLink.class, "ChannelContentLink.label4", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(ContentLink.isValid)"));
            }
            if (this.isChangeProperty("LINKNAME")) {
                string = this.getNewPropertyAsString("LINKNAME");
            }
        }
        if (!CMyString.isEmpty(string)) {
            string = string.toUpperCase();
            this.setProperty("LINKNAME", string);
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("LinkName='").append(string).append("'");
            if (this.getSiteId() == 0) {
                stringBuffer.append(" AND ChannelId=").append(this.getChnlId());
            } else {
                stringBuffer.append(" AND SiteId=").append(this.getSiteId());
            }
            stringBuffer.append(" AND NOT LinkId=").append(this.id);
            if (this.checkExists(stringBuffer.toString())) {
                throw new WCMException(1108, I18NMessage.get(ChannelContentLink.class, "ChannelContentLink.label5", "\u5df2\u5b58\u5728\u540d\u79f0\u4e3a[") + string + I18NMessage.get(ChannelContentLink.class, "ChannelContentLink.label6", "]\u7684\u70ed\u8bcd!"));
            }
        }
        this.changeOrder();
        return true;
    }

    private void changeOrder() throws WCMException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.getOrder();
        if (this.isAddMode()) {
            n2 = n6;
            n = this.getMaxOrder();
            if (n2 == -1) {
                n2 = n + 1;
            } else {
                n5 = 1;
                n4 = n;
                n3 = n2;
            }
        } else {
            if (!this.isChangeProperty("LinkOrder")) {
                return;
            }
            n2 = this.getNewPropertyAsInt("LinkOrder", -1);
            if (n2 == -1) {
                n = this.getMaxOrder();
                if (n == n6) {
                    n2 = n6;
                } else {
                    n5 = -1;
                    n4 = n;
                    n3 = n6 + 1;
                    n2 = n;
                }
            } else if (n2 > n6) {
                n5 = -1;
                n4 = --n2;
                n3 = n6 + 1;
            } else {
                n5 = 1;
                n4 = n6 - 1;
                n3 = n2;
            }
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("UPDATE ").append(DB_TABLE_NAME);
        stringBuffer.append(" SET LinkOrder=LinkOrder+(");
        stringBuffer.append(n5);
        stringBuffer.append(")");
        stringBuffer.append(" WHERE ");
        stringBuffer.append("LinkOrder>=").append(n3);
        stringBuffer.append(" AND LinkOrder<=").append(n4);
        stringBuffer.append(" AND ChannelId=").append(this.getChnlId());
        DBManager.getDBManager().sqlExecuteUpdate(stringBuffer.toString());
        this.setOrder(n2);
    }

    private synchronized int getMaxOrder() throws WCMException {
        int n = this.getChnlId();
        StringBuffer stringBuffer = new StringBuffer("SELECT MAX(LinkOrder) FROM ");
        stringBuffer.append(DB_TABLE_NAME);
        stringBuffer.append(" WHERE ChannelId=");
        stringBuffer.append(n);
        return DBManager.getDBManager().sqlExecuteIntQuery(stringBuffer.toString());
    }

    public boolean setName(String string) throws WCMException {
        return this.setPropertyWithString("LINKNAME", string);
    }

    public String getName() {
        return this.getPropertyAsString("LINKNAME");
    }

    public boolean setLinkUrl(String string) throws WCMException {
        return this.setPropertyWithString("LINKURL", string);
    }

    public String getLinkUrl() {
        return this.getPropertyAsString("LINKURL");
    }

    public boolean setLinkTitle(String string) throws WCMException {
        return this.setPropertyWithString("LINKTITLE", string);
    }

    public String getLinkTitle() {
        return this.getPropertyAsString("LINKTITLE");
    }

    public int getOrder() {
        return this.getPropertyAsInt("LINKORDER", 0);
    }

    public boolean setOrder(int n) throws WCMException {
        return this.setProperty("LINKORDER", n);
    }

    public boolean setChnlId(int n) throws WCMException {
        return this.setProperty("CHANNELID", n);
    }

    public int getChnlId() {
        return this.getPropertyAsInt("CHANNELID", 0);
    }

    public boolean setSiteId(int n) throws WCMException {
        return this.setProperty("SITEID", n);
    }

    public int getSiteId() {
        return this.getPropertyAsInt("SITEID", 0);
    }

    public Channel getChannel() throws WCMException {
        return Channel.findById(this.getChnlId());
    }

    public int getSysContentLinkId() {
        return this.getPropertyAsInt("SYSCONTENTLINKID", 0);
    }

    public boolean setSysContentLinkId(int n) throws WCMException {
        return this.setProperty("SYSCONTENTLINKID", n);
    }

    public boolean isUsedInChildren() {
        return this.getPropertyAsBoolean("IsUsedInChildren", false);
    }

    public boolean setUsedInChildren(boolean bl) throws WCMException {
        return this.setProperty("IsUsedInChildren", bl);
    }

    public static final ChannelContentLink findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (ChannelContentLink)BaseObj.findById(ChannelContentLink.class, n);
    }

    public static final ChannelContentLink createNewInstance() throws WCMException {
        return (ChannelContentLink)BaseObj.createNewInstance(ChannelContentLink.class);
    }

    public static final ChannelContentLink findByKey(Object object) throws WCMException {
        return (ChannelContentLink)BaseObj.findByKey(ChannelContentLink.class, object);
    }

    public static void main(String[] stringArray) {
        System.out.println(ChannelContentLink.class.getName().hashCode());
    }
}

