/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.IChannelNameMgr;
import com.trs.components.wcm.content.persistent.Replaces;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class Channel
extends BaseChannel {
    private static Logger m_oLogger = Logger.getLogger(Channel.class);
    public static final int OBJ_TYPE = 101;
    public static final String DB_TABLE_NAME = "WCMCHANNEL";
    public static final String DB_ID_NAME = "CHANNELID";
    public static final int SET_ONLYSEARCH = 1;
    public static final int SET_CANPUB = 2;
    public static final int SET_ONLYMANAGER = 3;
    public static final int SET_INHERIT_DETAIL = 4;
    public static final int SET_INHERIT_OUTLINE = 5;
    public static final int SET_INHERIT_RIGHT = 6;
    public static final int SET_INHERIT_EXTEND = 7;
    public static final int SET_CLICK_PREVIEW = 8;
    public static final int SET_CHNL_USER = 9;
    public static final int DO_DEPT_FILTER = 11;
    public static final int TYPE_NORM = 0;
    public static final int TYPE_TOP_PICS = 1;
    public static final int TYPE_TOP_NEWS = 2;
    public static final int TYPE_LINK = 11;
    public static final int TYPE_SUREFORM = 12;
    public static final int TYPE_INFOVIEW = 13;
    public static final int TYPE_DEFINE_MAX = 20;
    public static final int EXCLUDE_FROM_ORDER_MAX = 10;
    public static final int MOVE_AS_BROTHER = 0;
    public static final int MOVE_AS_CHILD = 1;
    public static final String SUREFORM_ATTR = "SUREFORMFILE";
    public static final String DEFAULT_CONTENTLISTPAGE = "../document/document_list_of_channel.jsp";
    public static final String DEFAULT_CONTENTADDEDITPAGE = "../document/document_addedit.jsp";
    public static final String DEFAULT_CONTENTSHOWPAGE = "../document/document_show.jsp";
    public static final String DEFAULT_LINKCHANNELPAGE = "../document/document_list_of_linkchannel.jsp";
    public static final int DRAFT_CHANNEL_ID = 0;
    public static final Channel DRAFT_CHANNEL = new Channel(){

        public String toString() {
            return I18NMessage.get(Channel.class, "Channel.label1", "\u8349\u7a3f\u7bb1");
        }
    };
    private byte[] DOC_ORDER_LOCK = new byte[0];
    public static final int TIME_LIMITED_NOT = 0;
    public static final int TIME_LIMITED_DEFAULT = 1;
    public static final int TIME_LIMITED_SPECIAL_RANGE = 2;
    public static final int TIME_LIMITED_SPECIAL_POINT = 3;
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 101;
    }

    public int getSiteId() {
        return this.getPropertyAsInt("SITEID", 0);
    }

    public WebSite getSite() throws WCMException {
        int n = this.getSiteId();
        if (n == 0) {
            return null;
        }
        return WebSite.findById(n);
    }

    public boolean setSite(int n) throws WCMException {
        WebSite webSite = WebSite.findById(n);
        return this.setSite(webSite);
    }

    public boolean setSite(WebSite webSite) throws WCMException {
        if (!this.isAddMode()) {
            m_oLogger.debug((Object)I18NMessage.get(Channel.class, "Channel.label2", "\u5728\u9891\u9053\u4e0d\u662f\u65b0\u589e\u72b6\u6001\u4e0b\uff0c\u4fee\u6539\u4e86\u9891\u9053\u6240\u5c5e\u7ad9\u70b9\uff0c\u4e00\u822c\u7528\u4e8e\u9891\u9053\u8de8\u7ad9\u70b9\u79fb\u52a8\uff0c\u5176\u5b83\u64cd\u4f5c\u5e94\u4e3a\u975e\u6cd5\u3002"));
        }
        if (webSite == null || !webSite.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Channel.class, "Channel.label3", "\u65e0\u6548\u7684\u7ad9\u70b9\u5bf9\u8c61(Channel.setSite)"));
        }
        return this.setProperty("SITEID", webSite.getId());
    }

    public String getName() {
        return (String)this.getProperty("CHNLNAME");
    }

    public boolean setName(String string) throws WCMException {
        return this.setProperty("CHNLNAME", string);
    }

    public String getDesc() {
        return (String)this.getProperty("CHNLDESC");
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("CHNLDESC", string);
    }

    public String getTable() {
        return (String)this.getProperty("CHNLTABLE");
    }

    public boolean setTable(String string) throws WCMException {
        return this.setProperty("CHNLTABLE", string);
    }

    public String getQuery() {
        return (String)this.getProperty("CHNLQUERY");
    }

    public boolean setQuery(String string) throws WCMException {
        return this.setProperty("CHNLQUERY", string);
    }

    public int getChnlProperty() {
        return this.getPropertyAsInt("CHNLPROP", 0);
    }

    public boolean setChnlProperty(int n) throws WCMException {
        return this.setProperty("CHNLPROP", n);
    }

    public int getParentId() {
        return this.getPropertyAsInt("PARENTID", 0);
    }

    public Channel getParent() throws WCMException {
        if (this.getParentId() <= 0) {
            return null;
        }
        return Channel.findById(this.getParentId());
    }

    public boolean setParent(BaseChannel baseChannel) throws WCMException {
        if (baseChannel == null || baseChannel.isSite()) {
            return this.setParent(0);
        }
        if (!baseChannel.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Channel.class, "Channel.label4", "\u65e0\u6548\u7684\u7236\u9891\u9053\u5bf9\u8c61(Channel.setParent)"));
        }
        return this.setParent(baseChannel.getId());
    }

    public boolean setParent(int n) throws WCMException {
        return this.setProperty("PARENTID", n);
    }

    public int getOrder() {
        return this.getPropertyAsInt("CHNLORDER", 0);
    }

    public boolean setOrder(int n) throws WCMException {
        return this.setProperty("CHNLORDER", n);
    }

    public String getOrderBy() {
        return (String)this.getProperty("CHNLORDERBY");
    }

    public boolean setOrderBy(String string) throws WCMException {
        return this.setProperty("CHNLORDERBY", string);
    }

    public int getStatus() {
        return this.getPropertyAsInt("STATUS", 0);
    }

    public boolean setStatus(int n) throws WCMException {
        return this.setProperty("STATUS", n);
    }

    public int getType() {
        return this.getPropertyAsInt("CHNLTYPE", 0);
    }

    public String getTypeDesc() {
        String string = I18NMessage.get(Channel.class, "Channel.label5", "\u672a\u77e5\u7c7b\u578b");
        switch (this.getType()) {
            case 0: {
                string = I18NMessage.get(Channel.class, "Channel.label6", "\u666e\u901a");
                break;
            }
            case 1: {
                string = I18NMessage.get(Channel.class, "Channel.label7", "\u56fe\u7247");
                break;
            }
            case 2: {
                string = I18NMessage.get(Channel.class, "Channel.label8", "\u5934\u6761");
                break;
            }
            case 11: {
                string = I18NMessage.get(Channel.class, "Channel.label9", "\u94fe\u63a5");
                break;
            }
            case 13: {
                string = I18NMessage.get(Channel.class, "Channel.label10", "\u8868\u5355");
                break;
            }
        }
        return string;
    }

    public boolean setType(int n) throws WCMException {
        return this.setProperty("CHNLTYPE", n);
    }

    public boolean isNormType() {
        return this.getType() == 0;
    }

    public boolean isLink() {
        return this.getType() == 11;
    }

    public String getLinkUrl() {
        return this.getPropertyAsString("LINKURL");
    }

    public boolean setLinkUrl(String string) throws WCMException {
        return this.setProperty("LINKURL", string);
    }

    public boolean isOnlySearch() {
        return CMyBitsValue.getBit(this.getChnlProperty(), 1);
    }

    public boolean setOnlySearch(boolean bl) throws WCMException {
        return this.setChnlProp(1, bl);
    }

    public boolean isCanPub() {
        if (this.getType() == 2 || this.getType() == 1) {
            return true;
        }
        return CMyBitsValue.getBit(this.getChnlProperty(), 2);
    }

    public boolean setCanPub(boolean bl) throws WCMException {
        return this.setChnlProp(2, bl);
    }

    private boolean setChnlProp(int n, boolean bl) throws WCMException {
        Object object;
        CMyBitsValue cMyBitsValue = new CMyBitsValue(this.getChnlProperty());
        if (!this.isAddMode() && (object = this.getNewProperty("CHNLPROP")) != null) {
            cMyBitsValue.setValue(((Number)object).longValue());
        }
        cMyBitsValue.setBit(n, bl);
        return this.setChnlProperty(cMyBitsValue.getValueAsInt());
    }

    public boolean isOnlyManager() {
        return CMyBitsValue.getBit(this.getChnlProperty(), 3);
    }

    public boolean setOnlyManager(boolean bl) throws WCMException {
        return this.setChnlProp(3, bl);
    }

    public boolean isClickPreview() {
        return CMyBitsValue.getBit(this.getChnlProperty(), 8);
    }

    public boolean setClickPreview(boolean bl) throws WCMException {
        return this.setChnlProp(8, bl);
    }

    public boolean isToChnlUser() {
        return CMyBitsValue.getBit(this.getChnlProperty(), 9);
    }

    public boolean setToChnlUser(boolean bl) throws WCMException {
        return this.setChnlProp(9, bl);
    }

    public boolean isInheritDetail() {
        return CMyBitsValue.getBit(this.getChnlProperty(), 4);
    }

    public boolean setInheritDetail(boolean bl) throws WCMException {
        return this.setChnlProp(4, bl);
    }

    public boolean isInheritOutline() {
        return CMyBitsValue.getBit(this.getChnlProperty(), 5);
    }

    public boolean setInheritOutline(boolean bl) throws WCMException {
        return this.setChnlProp(5, bl);
    }

    public boolean isInheritRight() {
        return CMyBitsValue.getBit(this.getChnlProperty(), 6);
    }

    public boolean isInheritExtend() {
        return CMyBitsValue.getBit(this.getChnlProperty(), 7);
    }

    public boolean setInheritExtend(boolean bl) throws WCMException {
        return this.setChnlProp(7, bl);
    }

    public boolean isDoDeptFilter() {
        return CMyBitsValue.getBit(this.getChnlProperty(), 11);
    }

    public boolean setDoDeptFilter(boolean bl) throws WCMException {
        return this.setChnlProp(11, bl);
    }

    private synchronized int getMaxOrder() throws WCMException {
        int n = this.getNewParentId();
        StringBuffer stringBuffer = new StringBuffer("SELECT max(ChnlOrder) FROM ");
        stringBuffer.append(DB_TABLE_NAME).append(" WHERE ParentId=").append(n);
        stringBuffer.append(" AND (ChnlType>10 OR ChnlType=0)");
        if (n == 0) {
            stringBuffer.append(" AND SiteID=").append(this.getSiteId());
        }
        return DBManager.getDBManager().sqlExecuteIntQuery(stringBuffer.toString());
    }

    private int getNewParentId() {
        int n = this.getParentId();
        if (this.isChangeProperty("PARENTID")) {
            n = this.getNewPropertyAsInt("PARENTID", 0);
        }
        return n;
    }

    private int getNewSiteId() {
        int n = this.getSiteId();
        if (this.isChangeProperty("SiteId")) {
            n = this.getNewPropertyAsInt("SiteId", 0);
        }
        return n;
    }

    public boolean isValid() throws WCMException {
        Object object;
        Object object2;
        String string = null;
        int n = 0;
        if (this.isAddMode()) {
            string = (String)this.getProperty("CHNLNAME");
            if (string == null) {
                throw new WCMException(1106, I18NMessage.get(Channel.class, "Channel.label11", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(Channel.isValid)"));
            }
            if (this.getProperty("PARENTID") != null && this.getProperty("SITEID") == null) {
                object2 = Channel.findById(this.getParentId());
                if (object2 == null) {
                    throw new WCMException(I18NMessage.get(Channel.class, "Channel.label12", "\u6307\u5b9a\u7684\u7236\u7ed3\u70b9[") + this.getParentId() + I18NMessage.get(Channel.class, "Channel.label13", "]\u4e0d\u5b58\u5728\uff01"));
                }
                this.setSite(((Channel)object2).getSiteId());
            }
            if (this.getProperty("SITEID") == null) {
                throw new WCMException(1106, I18NMessage.get(Channel.class, "Channel.label14", "\u5c5e\u6027SiteId\u6ca1\u6709\u8bbe\u7f6e(Channel.isValid)"));
            }
            if (this.getProperty("PARENTID") == null) {
                throw new WCMException(1106, I18NMessage.get(Channel.class, "Channel.label15", "\u5c5e\u6027ParentId\u6ca1\u6709\u8bbe\u7f6e(Channel.isValid)"));
            }
            if (this.getProperty("CHNLTYPE") == null) {
                this.setType(0);
            }
            n = this.getType();
        } else {
            int n2;
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Channel.class, "Channel.label16", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u4fee\u6539(Channel.isValid)"));
            }
            n = this.isChangeProperty("CHNLTYPE") ? this.getNewPropertyAsInt("CHNLTYPE", n) : this.getType();
            string = (String)this.getNewProperty("CHNLNAME");
            if (this.isChangeProperty("PARENTID") && (n2 = this.getNewPropertyAsInt("PAERNTID", 0)) > 0) {
                object = Channel.findById(n2);
                if (object == null) {
                    throw new WCMException(10, I18NMessage.get(Channel.class, "Channel.label17", "\u65b0\u8bbe\u7f6e\u7684\u7236\u680f\u76ee\u4e0d\u5b58\u5728!"));
                }
                this.validLoop((Channel)object);
            }
        }
        if (string != null) {
            object2 = " (SiteId=" + this.getSiteId() + ") and (ChnlName='" + CMyString.filterForSQL(string) + "') ";
            if (!this.isAddMode()) {
                object2 = (String)object2 + " and " + this.getIdFieldName() + "<>" + this.getId();
            }
            if (this.checkExists((String)object2)) {
                throw new WCMException(1108, I18NMessage.get(Channel.class, "Channel.label18", "\u680f\u76ee\u552f\u4e00\u6807\u8bc6\u5df2\u7ecf\u5b58\u5728\uff08Channel.isValid\uff09"));
            }
        }
        if (n == 2 || n == 1) {
            int n3 = this.getParentId();
            if (this.isChangeProperty("PARENTID")) {
                n3 = this.getNewPropertyAsInt("PARENTID", 0);
            }
            object = " (SiteId=" + this.getSiteId() + ") and (ParentId=" + n3 + ") and (CHNLTYPE=" + n + ") ";
            if (!this.isAddMode()) {
                object = (String)object + " and " + this.getIdFieldName() + "<>" + this.getId();
            }
            if (this.checkExists((String)object)) {
                throw new WCMException(1108, I18NMessage.get(Channel.class, "Channel.label19", "\u5728\u540c\u4e00\u7ea7\u680f\u76ee\u4e2d\u5df2\u7ecf\u5b58\u5728[") + this.getSpecialTypeName(n) + I18NMessage.get(Channel.class, "Channel.label20", "]\u7684\u680f\u76ee,\u6b64\u7c7b\u578b\u7684\u680f\u76ee\u5728\u540c\u4e00\u7ea7\u680f\u76ee\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a!"));
            }
        }
        this.changeOrder();
        return true;
    }

    private String getSpecialTypeName(int n) {
        switch (n) {
            case 2: {
                return I18NMessage.get(Channel.class, "Channel.label21", "\u5934\u6761\u65b0\u95fb");
            }
            case 1: {
                return I18NMessage.get(Channel.class, "Channel.label22", "\u56fe\u7247\u65b0\u95fb");
            }
        }
        return "";
    }

    protected int deleteMySelf(User user) throws WCMException {
        return super.delete(user);
    }

    public int delete(User user) throws WCMException {
        if (!this.isValidInstance()) {
            return 0;
        }
        return this.deleteMySelf(user);
    }

    public boolean isVirtual() {
        return this.getType() == 2 || this.getType() == 1 || this.getType() == 11 || this.isOnlySearch();
    }

    public Replaces getReplaces(User user) throws WCMException {
        Replaces replaces = new Replaces(user);
        WCMFilter wCMFilter = new WCMFilter("", " CHNLID=" + this.getId(), "", "ReplaceId");
        replaces.open(wCMFilter);
        return replaces;
    }

    public boolean setInputFile(String string) throws WCMException {
        return this.setAttribute("INPUTFILE", string);
    }

    public String getInputFile() {
        String string = "/wcm/doc/post_document.jsp";
        String string2 = this.getAttributeValue("INPUTFILE");
        if (string2 == null || string2.trim().length() == 0) {
            return string;
        }
        return string2;
    }

    public boolean setEditFile(String string) throws WCMException {
        return this.setAttribute("EDITFILE", string);
    }

    public String getEditFile() {
        String string = "/wcm/doc/edit_document.jsp";
        String string2 = this.getAttributeValue("EDITFILE");
        if (string2 == null || string2.trim().length() == 0) {
            return string;
        }
        return string2;
    }

    public boolean setOutlineFile(String string) throws WCMException {
        return this.setAttribute("OUTLINEFILE", string);
    }

    public String getOutlineFile() {
        String string = "/wcm/doc/list_document.jsp";
        String string2 = this.getAttributeValue("OUTLINEFILE");
        if (string2 == null || string2.trim().length() == 0) {
            return string;
        }
        return string2;
    }

    public boolean setDetailFile(String string) throws WCMException {
        return this.setAttribute("DETAILFILE", string);
    }

    public String getDetailFile() {
        String string = "/wcm/doc/show_doc.jsp";
        String string2 = this.getAttributeValue("DETAILFILE");
        if (string2 == null || string2.trim().length() == 0) {
            return string;
        }
        return string2;
    }

    public String getTimeWhere() throws Exception {
        if (!this.isListByTimeRange()) {
            return "";
        }
        String string = "WCMChnlDoc.CRTIME";
        String string2 = "";
        String string3 = "";
        int n = this.getTimeLimitedMode();
        switch (n) {
            case 1: 
            case 2: {
                int n2 = this.getTimeRange(n == 1);
                CMyDateTime cMyDateTime = CMyDateTime.now().dateAdd(3, -n2);
                string2 = cMyDateTime.toString("yyyy-MM-dd");
                string3 = CMyDateTime.now().toString("yyyy-MM-dd");
                break;
            }
            case 3: {
                string2 = this.getStartTime();
                string3 = this.getEndTime();
                break;
            }
            default: {
                return "";
            }
        }
        String string4 = string + ">=" + this.getDBManager().getDBType().sqlDateTime(string2 + " 00:00:00", "YYYY-MM-DD HH24:MI:SS");
        string4 = string4 + " and ";
        string4 = string4 + string + "<=" + this.getDBManager().getDBType().sqlDateTime(string3 + " 23:59:59", "YYYY-MM-DD HH24:MI:SS");
        return string4;
    }

    public boolean isListByTimeRange() {
        return this.isListByTimeRange(false);
    }

    public boolean isListByTimeRange(boolean bl) {
        if (bl) {
            String string = ConfigServer.getServer().getInitProperty("LIST_BY_TIME_RANGE");
            if (string == null) {
                return false;
            }
            return string.trim().toUpperCase().equals("TRUE");
        }
        int n = this.getTimeLimitedMode();
        if (n == 1) {
            return this.isListByTimeRange(true);
        }
        return n > 1;
    }

    public int getTimeRange() {
        return this.getTimeRange(false);
    }

    public int getTimeRange(boolean bl) {
        if (bl) {
            int n = 0;
            String string = ConfigServer.getServer().getInitProperty("DAYS_IN_TIME_RANGE");
            if (string == null || string.trim().length() <= 0) {
                return n;
            }
            try {
                n = Integer.parseInt(string.trim());
            }
            catch (Exception exception) {
                n = 7;
            }
            return n;
        }
        int n = 7;
        String string = this.getAttributeValue("DAYS_IN_TIME_RANGE");
        if (string == null) {
            return this.getTimeRange(true);
        }
        try {
            n = Integer.parseInt(string.trim());
        }
        catch (Exception exception) {
            n = this.getTimeRange(true);
        }
        return n;
    }

    public void setTimeRange(int n) throws Exception {
        this.setAttribute("DAYS_IN_TIME_RANGE", String.valueOf(n));
    }

    public String getStartTime() {
        if (this == null) {
            return "";
        }
        String string = this.getAttributeValue("START_TIME_RANGE");
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    public void setStartTime(CMyDateTime cMyDateTime) throws Exception {
        String string = "";
        if (cMyDateTime != null && !cMyDateTime.isNull()) {
            string = cMyDateTime.toString("yyyy-MM-dd");
        }
        this.setAttribute("START_TIME_RANGE", string);
    }

    public String getEndTime() {
        String string = this.getAttributeValue("END_TIME_RANGE");
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    public void setEndTime(CMyDateTime cMyDateTime) throws Exception {
        String string = "";
        if (cMyDateTime != null && !cMyDateTime.isNull()) {
            string = cMyDateTime.toString("yyyy-MM-dd");
        }
        this.setAttribute("END_TIME_RANGE", string);
    }

    public int getTimeLimitedMode() {
        String string = this.getAttributeValue("TIME_LIMITED_MODE");
        if (string == null) {
            return 1;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 1;
        }
    }

    public void setTimeLimitedMode(int n) throws Exception {
        if (n < 0 || n > 3) {
            return;
        }
        this.setAttribute("TIME_LIMITED_MODE", String.valueOf(n));
    }

    public boolean isSite() {
        return false;
    }

    public synchronized void update(User user) throws WCMException {
        int n;
        int n2 = n = this.isAddMode() ? this.getParentId() : this.getNewPropertyAsInt("PARENTID", 0);
        if (n == this.getId()) {
            throw new WCMException(10, I18NMessage.get(Channel.class, "Channel.label23", "\u7531\u4e8e\u4e0d\u53ef\u9884\u77e5\u7684\u95ee\u9898\uff0c\u4f60\u5c06\u8981\u8fdb\u884c\u7684\u64cd\u4f5c\u4f1a\u5f71\u54cd\u7cfb\u7edf\u7684\u7a33\u5b9a\u6027\uff0c\u672c\u64cd\u4f5c\u5c06\u88ab\u53d6\u6d88\uff08Channel.update(parentid=id)\uff09\uff01\u8bf7\u60a8\u8bb0\u5f55\u4e0b\u60a8\u6b63\u5728\u8fdb\u884c\u7684\u64cd\u4f5c\u5e76\u548c\u7ba1\u7406\u5458\u8054\u7cfb\u3002\u8c22\u8c22\uff01"));
        }
        this.setProperty("OPERUSER", user.getName());
        this.setProperty("OPERTIME", CMyDateTime.now());
        super.update(user);
    }

    public static final Channel findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (Channel)BaseObj.findById(Channel.class, n);
    }

    public static final Channel createNewInstance() throws WCMException {
        return (Channel)BaseObj.createNewInstance(Channel.class);
    }

    public static final Channel findByKey(Object object) throws WCMException {
        return (Channel)BaseObj.findByKey(Channel.class, object);
    }

    public BaseChannel getHost() throws WCMException {
        if (this.getParentId() == 0) {
            return this.getSite();
        }
        return this.getParent();
    }

    private static IChannelNameMgr getChannelNameMgr() throws WCMException {
        IChannelNameMgr iChannelNameMgr = (IChannelNameMgr)DreamFactory.createObjectById("IChannelNameMgr");
        if (iChannelNameMgr == null) {
            throw new WCMException(10, "IChannelNameMgr Config Error!");
        }
        return iChannelNameMgr;
    }

    public static Channel findByName(int n, String string) {
        try {
            return Channel.getChannelNameMgr().findByName(n, string);
        }
        catch (WCMException wCMException) {
            wCMException.printStackTrace();
            return null;
        }
    }

    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getDesc();
        }
        return this.getDesc() + I18NMessage.get(Channel.class, "Channel.label24", "[\u680f\u76ee-") + this.getId() + "]";
    }

    public void validLoop() throws WCMException {
        this.validLoop(this.getParent());
    }

    protected void validLoop(Channel channel) throws WCMException {
        if (channel == null) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        arrayList.add(this.getKey());
        channel.validLoop(arrayList);
    }

    protected void validLoop(List list) throws WCMException {
        if (list.indexOf(this.getKey()) >= 0) {
            throw new WCMException(10, I18NMessage.get(Channel.class, "Channel.label25", "\u680f\u76ee\u7684\u7236\u5b50\u7ee7\u627f\u6811\u4e0a\u6709\u56de\u8def!"));
        }
        if (this.getParent() == null) {
            return;
        }
        list.add(this.getKey());
        this.getParent().validLoop(list);
    }

    public boolean setSureFormFile(String string) throws WCMException {
        return this.setAttribute(SUREFORM_ATTR, string);
    }

    public String getSureFormFileName() {
        if (this.getType() != 12) {
            return null;
        }
        return this.getAttributeValue(SUREFORM_ATTR);
    }

    public String getNewSureFormFileName() {
        return this.getNewAttributeValue(SUREFORM_ATTR);
    }

    public String getContentListPage() {
        if (this.getType() == 11) {
            return DEFAULT_LINKCHANNELPAGE;
        }
        String string = this.getPropertyAsString("ContentListPage");
        if (CMyString.isEmpty(string)) {
            return DEFAULT_CONTENTLISTPAGE;
        }
        return string;
    }

    public String getContentAddEditPage() {
        String string = this.getPropertyAsString("ContentAddEditPage");
        if (CMyString.isEmpty(string)) {
            return DEFAULT_CONTENTADDEDITPAGE;
        }
        return string;
    }

    public String getContentShowPage() {
        String string = this.getPropertyAsString("ContentShowPage");
        if (CMyString.isEmpty(string)) {
            return DEFAULT_CONTENTSHOWPAGE;
        }
        return string;
    }

    public String getInfo() {
        return "[channel-" + this.getId() + "]" + this.getName();
    }

    public String getOutlineFields() {
        String string = this.getPropertyAsString("OutlineFileds");
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        return string;
    }

    public boolean setOutlineFields(String string) throws WCMException {
        return this.setProperty("OutlineFileds", string);
    }

    public boolean isCluster() {
        return this.getPropertyAsBoolean("IsCluster", false);
    }

    public boolean setCluster(boolean bl) throws WCMException {
        return this.setProperty("IsCluster", bl);
    }

    public boolean isContainsChildren() {
        return this.getPropertyAsBoolean("isContainsChildren", false);
    }

    public boolean setContainsChildren(boolean bl) throws WCMException {
        return this.setProperty("isContainsChildren", bl);
    }

    public String getMetaSynFields() {
        return this.getPropertyAsString("MetaSynFields", "docTitle=&docContent=");
    }

    public boolean setMetaSynFields(String string) throws WCMException {
        return this.setProperty("MetaSynFields", string);
    }

    private void changeOrder() throws WCMException {
        int n;
        int n2;
        if (this.getType() == 2 || this.getType() == 1) {
            if (this.isAddMode()) {
                this.setOrder(this.getMaxOrder() + 1);
            }
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.isAddMode()) {
            n2 = this.getOrder();
            n = this.getMaxOrder();
            if (n2 == -1) {
                n2 = n + 1;
            } else {
                n5 = 1;
                n4 = n;
                n3 = n2;
            }
        } else {
            if (!this.isChangeProperty("ChnlOrder") && !this.isChangeProperty("PARENTID")) {
                return;
            }
            n2 = this.getNewPropertyAsInt("ChnlOrder", -1);
            if (n2 == -1) {
                n = this.getMaxOrder();
                if (this.isChangeProperty("PARENTID")) {
                    n2 = n + 1;
                } else if (n == this.getOrder()) {
                    n2 = this.getOrder();
                } else {
                    n5 = -1;
                    n4 = n;
                    n3 = this.getOrder() + 1;
                    n2 = n;
                }
            } else if (this.isChangeProperty("PARENTID")) {
                n2 = this.getMaxOrder() + 1;
            } else if (n2 > this.getOrder()) {
                n5 = -1;
                n4 = --n2;
                n3 = this.getOrder() + 1;
            } else {
                n5 = 1;
                n4 = this.getOrder() - 1;
                n3 = n2;
            }
        }
        String string = "ChnlOrder>=" + n3 + " AND ChnlOrder <= " + n4 + " and ParentId=" + this.getNewParentId() + " and SiteId=" + this.getNewSiteId();
        String string2 = "UPDATE WCMChannel SET ChnlOrder = ChnlOrder+(" + n5 + ") WHERE " + string;
        WCMFilter wCMFilter = new WCMFilter("", string, "ChnlOrder desc");
        Channels channels = Channels.openWCMObjs(null, wCMFilter);
        DBManager.getDBManager().sqlExecuteUpdate(string2);
        for (int i = 0; i < channels.size(); ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            channel.refreshProperty("ChnlOrder", channel.getOrder() + n5);
        }
        this.setOrder(n2);
    }

    public boolean isUseDocLevel() {
        return this.getPropertyAsBoolean("UseDocLevel", false);
    }

    public boolean setUseDocLevel(boolean bl) throws WCMException {
        return this.setProperty("UseDocLevel", bl);
    }

    public Object getDocOrderLock() {
        return this.DOC_ORDER_LOCK;
    }
}

