/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.IChildrenMgr;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseChannel
extends CMSObj {
    public static final int STATUS_NORM = 0;
    public static final int STATUS_DEL = -1;
    public static final int STATUS_PARENT_DEL = -2;
    public static final int TYPE_ALL = -1;

    public boolean isDeleted() {
        return this.getStatus() < 0;
    }

    public int getStatus() {
        return this.getPropertyAsInt("Status", 0);
    }

    public boolean setStatus(int n) throws WCMException {
        return this.setProperty("Status", n);
    }

    public boolean setDeleted(boolean bl) throws WCMException {
        return this.setStatus(bl ? -2 : -1);
    }

    public boolean restore(boolean bl) throws WCMException {
        if (bl && this.getStatus() != -2) {
            return false;
        }
        return this.setStatus(0);
    }

    public boolean setOperUser(User user) throws WCMException {
        if (user == null || !user.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(BaseChannel.class, "BaseChannel.label1", "\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u65e0\u6548!"));
        }
        return this.setOperUser(user.getName());
    }

    public boolean setOperUser(String string) throws WCMException {
        return this.setProperty("OperUser", string);
    }

    public boolean setOperTime() throws WCMException {
        return this.setProperty("OperTime", CMyDateTime.now());
    }

    public int getParentId() {
        return this.getPropertyAsInt("ParentId", 0);
    }

    public abstract boolean isSite();

    public abstract WebSite getSite() throws WCMException;

    public abstract int getSiteId();

    public abstract String getDesc();

    public String getDispDesc() {
        String string = this.getDesc();
        if (string == null || string.length() == 0) {
            string = this.getName();
        }
        return string;
    }

    public abstract String getInfo();

    public abstract String getName();

    public abstract boolean setName(String var1) throws WCMException;

    public abstract boolean setParent(int var1) throws WCMException;

    public abstract int getOrder();

    public abstract BaseChannel getHost() throws WCMException;

    public List getChildren(User user, int n) throws WCMException {
        return this.getChildrenCacheMgr().listChildren(user, this, n);
    }

    public List getChildren(User user, int[] nArray) throws WCMException {
        return this.getChildrenCacheMgr().listChildren(user, this, nArray);
    }

    private IChildrenMgr getChildrenCacheMgr() {
        IChildrenMgr iChildrenMgr = (IChildrenMgr)DreamFactory.createObjectById("IChildrenMgr");
        return iChildrenMgr;
    }

    public List getChildren(User user) throws WCMException {
        return this.getChildren(user, -1);
    }

    public List getAllChildren(User user) throws WCMException {
        String string = "";
        string = this.isSite() ? "ParentId=0 and SiteId=" + this.getId() : "ParentId=" + this.getId();
        WCMFilter wCMFilter = new WCMFilter("", string, "ChnlOrder desc");
        Channels channels = Channels.openWCMObjs(user, wCMFilter);
        int n = channels.size();
        ArrayList<Channel> arrayList = new ArrayList<Channel>(n);
        for (int i = 0; i < n; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            arrayList.add(channel);
        }
        return arrayList;
    }

    public Channel getChildAt(int n) throws WCMException {
        return this.getChildrenCacheMgr().getChildAt(this, n);
    }

    public int getSiblingIndex() throws WCMException {
        return this.getChildrenCacheMgr().getSiblingIndex(this);
    }

    public int getChildrenSize(User user) throws WCMException {
        return this.getChildrenCacheMgr().getChildrenSize(user, this);
    }
}

