/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.resource.FileType;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import org.apache.log4j.Logger;

public class Appendix
extends CMSObj {
    private static Logger logger = Logger.getLogger(Appendix.class);
    public static final int OBJ_TYPE = 601;
    public static final String DB_TABLE_NAME = "WCMAPPENDIX";
    public static final String DB_ID_NAME = "APPENDIXID";
    private static final int FLAG_UNKNOWN = -1;
    public static final int FLAG_DOCCON = 0;
    public static final int FLAG_DOCAPD = 10;
    public static final int FLAG_DOCPIC = 20;
    public static final int FLAG_HTMLPIC = 30;
    public static final int FLAG_LINK = 40;
    public static final int FLAG_ALL_APD = 50;
    public static final int FLAG_ALL = -1;
    public static final int APPENDIX_FLAG_DOCCON = 0;
    public static final int APPENDIX_FLAG_DOCAPD = 10;
    public static final int APPENDIX_FLAG_DOCPIC = 20;
    public static final int APPENDIX_FLAG_HTMLPIC = 30;
    public static final int APPENDIX_FLAG_LINK = 40;
    public static final int APPENDIX_FLAG_ALL = -1;
    private boolean m_bForceAdd = false;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 601;
    }

    public boolean isDeleted() {
        return this.getId() < 0;
    }

    public int getDocId() {
        return this.getPropertyAsInt("APPDOCID", 0);
    }

    public boolean setDocId(int n) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(Appendix.class, "Appendix.label1", "\u6587\u6863\u7f16\u53f7\u4e0d\u5141\u8bb8\u4fee\u6539(Appendix.setDocId)"));
        }
        return this.setProperty("APPDOCID", n);
    }

    public int getFlag() {
        return this.getPropertyAsInt("APPFLAG", -1);
    }

    public String getFlagString() {
        return Appendix.getFlagString(this.getFlag());
    }

    public static String getFlagString(int n) {
        switch (n) {
            case 0: {
                return I18NMessage.get(Appendix.class, "Appendix.label2", "\u6b63\u6587\u9644\u4ef6");
            }
            case 10: {
                return I18NMessage.get(Appendix.class, "Appendix.label3", "\u6587\u6863\u9644\u4ef6");
            }
            case 20: {
                return I18NMessage.get(Appendix.class, "Appendix.label4", "\u6587\u6863\u56fe\u7247");
            }
            case 30: {
                return I18NMessage.get(Appendix.class, "Appendix.label5", "HTML\u56fe\u7247");
            }
            case 40: {
                return I18NMessage.get(Appendix.class, "Appendix.label6", "\u94fe\u63a5\u9644\u4ef6");
            }
        }
        return I18NMessage.get(Appendix.class, "Appendix.label7", "\u672a\u77e5");
    }

    public boolean setFlag(int n) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(Appendix.class, "Appendix.label8", "\u9644\u4ef6\u6807\u8bc6\u4e0d\u5141\u8bb8\u4fee\u6539(Appendix.setFlag)"));
        }
        if (n != 0 && n != 10 && n != 20 && n != 30 && n != 40) {
            throw new WCMException(10, I18NMessage.get(Appendix.class, "Appendix.label9", "\u65e0\u6548\u7684\u9644\u4ef6\u7c7b\u578b\u6807\u8bc6(Appendix.setFlag)"));
        }
        return this.setProperty("APPFLAG", n);
    }

    public void setId(int n) {
        this.id = n;
        if (n > 0) {
            this.m_bForceAdd = true;
        }
    }

    public void setNextId() throws WCMException {
        this.id = this.getNextId();
    }

    public int getFileTypeId() {
        return this.getPropertyAsInt("APPFILETYPE", 0);
    }

    public FileType getFileType() throws WCMException {
        return FileType.findById(this.getFileTypeId());
    }

    public String getFile() {
        return (String)this.getProperty("APPFILE");
    }

    public boolean setFile(String string) throws WCMException {
        return this.setProperty("APPFILE", string);
    }

    public String getDesc() {
        return (String)this.getProperty("APPDESC");
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("APPDESC", string);
    }

    public String getAlt() {
        return (String)this.getProperty("APPLINKALT");
    }

    public boolean setAlt(String string) throws WCMException {
        return this.setProperty("APPLINKALT", string);
    }

    public int getApdProperty() {
        return this.getPropertyAsInt("APPPROP", 0);
    }

    public boolean setApdProperty(int n) throws WCMException {
        return this.setProperty("APPPROP", n);
    }

    public CMyDateTime getTime() {
        return this.getPropertyAsDateTime("APPTIME");
    }

    public boolean setTime(CMyDateTime cMyDateTime) throws WCMException {
        return this.setProperty("APPTIME", cMyDateTime);
    }

    public String getEditor() {
        return (String)this.getProperty("APPEDITOR");
    }

    public boolean setEditor(String string) throws WCMException {
        return this.setProperty("APPEDITOR", string);
    }

    public String getAuthor() {
        return (String)this.getProperty("APPAUTHOR");
    }

    public boolean setAuthor(String string) throws WCMException {
        return this.setProperty("APPAUTHOR", string);
    }

    public String getAttribute() {
        return (String)this.getProperty("APPATTIBUTE");
    }

    public boolean setAttribute(String string) throws WCMException {
        return this.setProperty("APPATTIBUTE", string);
    }

    public String getSrcFile() {
        return (String)this.getProperty("SRCFILE");
    }

    public boolean setSrcFile(String string) throws WCMException {
        return this.setProperty("SRCFILE", string);
    }

    public String getFileExt() {
        String string = (String)this.getProperty("FILEEXT");
        if (string == null) {
            string = CMyFile.extractFileExt(this.getFile());
        }
        return string;
    }

    public boolean setFileExt(String string) throws WCMException {
        return this.setProperty("FILEEXT", string);
    }

    public int getSerialNo() {
        return this.getPropertyAsInt("APPSERN", 0);
    }

    public void setSerialNo(int n) throws WCMException {
        this.setProperty("APPSERN", n);
    }

    private long getUsedVersionsAsLong() {
        return this.getPropertyAsLong("USEDVERSIONS", 0L);
    }

    public CMyBitsValue getUsedVersions() {
        return new CMyBitsValue(this.getUsedVersionsAsLong());
    }

    public boolean setUsedVersions(long l) throws WCMException {
        return this.setProperty("USEDVERSIONS", l);
    }

    public boolean isUsedByVersion(int n) {
        return CMyBitsValue.getBit(this.getUsedVersionsAsLong(), n);
    }

    public boolean isNotUsed() {
        return this.getUsedVersionsAsLong() == 0L;
    }

    public boolean setUsedByVersion(int n, boolean bl) throws WCMException {
        Object object;
        long l = -1L;
        if (!this.isAddMode() && this.isModified() && (object = this.getNewProperty("USEDVERSIONS")) != null) {
            l = ((Number)object).longValue();
        }
        if (l < 0L) {
            l = this.getUsedVersionsAsLong();
        }
        l = CMyBitsValue.setBit(l, n, bl);
        return this.setUsedVersions(l);
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            if (this.getSerialNo() == 0) {
                this.setSerialNo();
            }
            super.insert(user);
        }
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("APPDOCID") == null) {
                throw new WCMException(1106, I18NMessage.get(Appendix.class, "Appendix.label11", "\u5c5e\u6027DocId\u6ca1\u6709\u8bbe\u7f6e(Appendix.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(Appendix.class, "Appendix.label12", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Appendix.isValid)"));
        }
        return true;
    }

    public int delete(User user) throws WCMException {
        String string = this.getFile();
        int n = super.delete(user);
        if (this.getFlag() == 40 || this.getFlag() == 30) {
            return n;
        }
        if (string != null && string.trim().length() > 0 && this.getProperty("RelatePhotoIds") == null) {
            try {
                FilesMan.getFilesMan().deleteFile(string);
            }
            catch (Exception exception) {
                logger.debug((Object)(I18NMessage.get(Appendix.class, "Appendix.label13", "\u5220\u9664\u9644\u4ef6\u6587\u4ef6[") + string + I18NMessage.get(Appendix.class, "Appendix.label14", "]\u65f6\u53d1\u751f\u5f02\u5e38\uff01")));
            }
        }
        return n;
    }

    public synchronized BaseObj cloneToNewWCMObj() throws WCMException {
        FilesMan filesMan;
        Appendix appendix = (Appendix)super.cloneToNewObj();
        appendix.removeProperty("USEDVERSIONS");
        String string = "P0";
        if (appendix.getFlag() == 20) {
            string = "W0";
        }
        String string2 = appendix.getFile();
        if (appendix.getFlag() != 40 && string2 != null && string2.trim().length() > 0 && (filesMan = FilesMan.getFilesMan()).fileExists(string2)) {
            string2 = filesMan.copyWCMFile(string2, string);
        }
        appendix.setFile(string2);
        return appendix;
    }

    public static final Appendix findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (Appendix)BaseObj.findById(Appendix.class, n);
    }

    public static final Appendix createNewInstance() throws WCMException {
        return (Appendix)BaseObj.createNewInstance(Appendix.class);
    }

    public static final Appendix findByKey(Object object) throws WCMException {
        return (Appendix)BaseObj.findByKey(Appendix.class, object);
    }

    private void setSerialNo() throws WCMException {
        int n = 0;
        String string = "select max(APPSERN) from " + this.getDbTableName() + " where (APPDOCID=" + this.getDocId() + ") ";
        n = this.getDBManager().sqlExecuteIntQuery(string);
        n = n < 0 ? 0 : ++n;
        this.setSerialNo(n);
    }

    public boolean setPropertyWithString(String string, String string2) throws WCMException {
        if ("APPFILE".equalsIgnoreCase(string) && string2 != null) {
            string2 = string2.trim();
        }
        return super.setPropertyWithString(string, string2);
    }

    public boolean setRelatedColumn(String string) throws WCMException {
        return this.setProperty("RelatedColumn", string);
    }

    public String getRelatedColumn() {
        return this.getPropertyAsString("RelatedColumn");
    }

    public boolean isValidInstance() {
        if (this.m_bForceAdd) {
            return true;
        }
        return !this.bAddMode && this.id > 0;
    }
}

