/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain.auth;

import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.IRightHost;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.domain.auth.ChannelRightHostImpl;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSiteSubstanceImplBase;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.List;

public class WebSiteRightHostImpl
extends WebSiteSubstanceImplBase
implements IRightHost {
    private static final String[] RIGHT_TYPE_IDS = new String[]{"site", "channel", "document", "template", "flow"};
    private static final String[] RIGHT_TYPE_NAMES = new String[]{I18NMessage.get(WebSiteRightHostImpl.class, "WebSiteRightHostImpl.label1", "\u7ad9\u70b9\u7c7b"), I18NMessage.get(WebSiteRightHostImpl.class, "WebSiteRightHostImpl.label2", "\u680f\u76ee\u7c7b"), I18NMessage.get(WebSiteRightHostImpl.class, "WebSiteRightHostImpl.label3", "\u6587\u6863\u7c7b"), I18NMessage.get(WebSiteRightHostImpl.class, "WebSiteRightHostImpl.label4", "\u6a21\u677f\u7c7b"), I18NMessage.get(WebSiteRightHostImpl.class, "WebSiteRightHostImpl.label5", "\u5de5\u4f5c\u6d41\u7c7b")};

    public WebSiteRightHostImpl() {
    }

    public WebSiteRightHostImpl(int n) throws WCMException {
        super(n);
    }

    public WebSiteRightHostImpl(CMSObj cMSObj) {
        super(cMSObj);
    }

    public void validateCanDoSetRight(User user) throws WCMException {
        if (this.m_oCurrWebSite == null) {
            throw new WCMException(I18NMessage.get(WebSiteRightHostImpl.class, "WebSiteRightHostImpl.label6", "\u6ca1\u6709\u6307\u5b9a\u7ad9\u70b9\uff01"));
        }
        if (this.m_oCurrWebSite.isDeleted()) {
            throw new WCMException(I18NMessage.get(WebSiteRightHostImpl.class, "WebSiteRightHostImpl.label7", "\u6307\u5b9a\u7ad9\u70b9[") + this.m_oCurrWebSite.getName() + "][ID=" + this.m_oCurrWebSite.getId() + I18NMessage.get(WebSiteRightHostImpl.class, "WebSiteRightHostImpl.label8", "]\u5df2\u7ecf\u88ab\u5220\u9664\uff01"));
        }
        if (!AuthServer.hasRight(user, (CMSObj)this.m_oCurrWebSite, 7)) {
            throw new WCMException(CMyString.format(I18NMessage.get(ChannelRightHostImpl.class, "WebSiteRightHostImpl.label9", "\u7528\u6237[{0}]\u5bf9\u4e8e\u6307\u5b9a\u7684\u7ad9\u70b9[{1}][ID={2}]\u4e0d\u80fd\u8bbe\u7f6e\u6743\u9650\uff01"), new String[]{user.getName(), this.m_oCurrWebSite.getName(), String.valueOf(this.m_oCurrWebSite.getId())}));
        }
    }

    public IRightHost[] getChildren() throws WCMException {
        List list = this.m_oCurrWebSite.getChildren(null);
        if (list == null || list.isEmpty()) {
            return null;
        }
        IRightHost[] iRightHostArray = new IRightHost[list.size()];
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Channel channel = (Channel)list.get(i);
            iRightHostArray[i] = channel == null ? null : new ChannelRightHostImpl(channel);
        }
        return iRightHostArray;
    }

    public String[] getRightTypeIds() {
        return RIGHT_TYPE_IDS;
    }

    public String[] getRightTypeNames() {
        return RIGHT_TYPE_NAMES;
    }

    public IRightHost getParent() {
        return null;
    }
}

