/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.resource.Securities;
import com.trs.components.wcm.resource.Security;
import com.trs.components.wcm.resource.Source;
import com.trs.components.wcm.resource.Sources;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.AbstractXmlToObjConverter;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;

public final class XmlToDocumentConverter
extends AbstractXmlToObjConverter {
    private static final String PROP_DOCSECURITY = "DOCSECURITY";
    private static final String PROP_DOCSOURCE = "DOCSOURCE";
    private static final String PROP_DOCSRCNAME = "DOCSOURCENAME";
    private static boolean DOC_HAS_DOCSRCNAME_PROP = true;
    public HashMap Doc_ChannelName = new HashMap();

    public XmlToDocumentConverter(int n) {
        super(n);
    }

    protected Map processSpecialProperties(Element element) throws WCMException {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        String string = element.elementTextTrim(PROP_DOCSRCNAME);
        if (!CMyString.isEmpty(string)) {
            hashMap.put(PROP_DOCSOURCE, "0");
        } else {
            string = element.elementText(PROP_DOCSOURCE);
            if (!CMyString.isEmpty(string)) {
                try {
                    Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (DOC_HAS_DOCSRCNAME_PROP) {
                        hashMap.put(PROP_DOCSOURCE, "0");
                        hashMap.put(PROP_DOCSRCNAME, string);
                    }
                    hashMap.put(PROP_DOCSOURCE, this.processDocSource(string));
                }
            }
        }
        String string2 = element.elementText(PROP_DOCSECURITY);
        if (!CMyString.isEmpty(string2)) {
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                hashMap.put(PROP_DOCSECURITY, this.processDocSecurity(string2));
            }
        }
        return hashMap;
    }

    private String processDocSource(String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "SRCNAME=?", "");
        wCMFilter.addSearchValues(0, string);
        wCMFilter.setMaxRowNumber(1);
        User user = ContextHelper.getLoginUser();
        Sources sources = new Sources(user);
        sources.open(wCMFilter);
        Source source = null;
        if (sources.isEmpty()) {
            source = new Source();
            source.setName(string);
            source.insert(user);
        } else {
            source = (Source)sources.getAt(0);
        }
        return String.valueOf(source.getId());
    }

    private String processDocSecurity(String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "SNAME=? OR SDISP=?", "");
        wCMFilter.addSearchValues(0, string);
        wCMFilter.addSearchValues(1, string);
        wCMFilter.setMaxRowNumber(1);
        User user = ContextHelper.getLoginUser();
        Securities securities = new Securities(user);
        securities.open(wCMFilter);
        int n = 0;
        Security security = null;
        if (!securities.isEmpty()) {
            security = (Security)securities.getAt(0);
            n = security.getId();
        }
        return String.valueOf(n);
    }

    protected void setProperty(BaseObj baseObj, String string, String string2) throws WCMException {
        block3: {
            try {
                baseObj.setPropertyWithString(string, string2);
            }
            catch (WCMException wCMException) {
                if (wCMException.getErrNo() != 1101) {
                    throw wCMException;
                }
                if (!"CHNLNAME".equalsIgnoreCase(string)) break block3;
                this.Doc_ChannelName.put(baseObj.getPropertyAsString("DocId"), string2);
            }
        }
    }

    static {
        try {
            Document document = new Document();
            document.setProperty(PROP_DOCSRCNAME, "test");
        }
        catch (WCMException wCMException) {
            DOC_HAS_DOCSRCNAME_PROP = 1101 == wCMException.getErrNo();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

