/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.components.wcm.content.domain.IDocumentsTimeRangeMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.util.CMyDateTime;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DocumentsTimeRangeMgrImpl
implements IDocumentsTimeRangeMgr {
    private static Logger logger = Logger.getLogger(DocumentsTimeRangeMgrImpl.class);
    public static final String DOCUMENTS_TIMERANGE_INI = "Documents.Time.Range.ini";
    private HashMap m_hmChannelsSetTimeRange = new HashMap(20);
    private HashMap m_hmObjectSetTimeRange = new HashMap(30);
    private int m_nDefaultTimeRange = 7;
    private Integer m_iDefaultTimeRange = new Integer(this.m_nDefaultTimeRange);

    public DocumentsTimeRangeMgrImpl() {
        this.init();
    }

    public void reloadTimeRangeConfig() {
        this.m_hmChannelsSetTimeRange.clear();
        this.m_nDefaultTimeRange = 7;
        this.m_iDefaultTimeRange = new Integer(this.m_nDefaultTimeRange);
        this.m_hmObjectSetTimeRange.clear();
        this.init();
    }

    public boolean isSetTimeRange(int n) {
        return this.m_hmChannelsSetTimeRange.containsKey(new Integer(n));
    }

    public int getTimeRange(int n) {
        Integer n2 = (Integer)this.m_hmChannelsSetTimeRange.get(new Integer(n));
        if (n2 == null) {
            return -1;
        }
        return n2;
    }

    public CMyDateTime getStartDateTime(int n) {
        if (!this.isSetTimeRange(n)) {
            return null;
        }
        CMyDateTime cMyDateTime = CMyDateTime.now();
        try {
            return cMyDateTime.dateAdd(3, -this.getTimeRange(n));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void init() {
        block20: {
            String string;
            InputStreamReader inputStreamReader = null;
            FileInputStream fileInputStream = null;
            BufferedReader bufferedReader = null;
            fileInputStream = new FileInputStream(ConfigConstants.DIR_APPROOT + DOCUMENTS_TIMERANGE_INI);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "GBK"));
            int n = 101;
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() == 0 || string.charAt(0) == '#') continue;
                if (string.charAt(0) == 'S' || string.charAt(0) == 's') {
                    n = 103;
                    string = string.substring(1);
                } else {
                    n = 101;
                }
                this.dowithChannelTimeRange(n, string);
            }
            Object var7_7 = null;
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                break block20;
            }
            catch (Exception exception) {}
            break block20;
            {
                catch (Exception exception) {
                    logger.error((Object)I18NMessage.get(DocumentsTimeRangeMgrImpl.class, "DocumentsTimeRangeMgrImpl.label1", "\u521d\u59cb\u5316\u9891\u9053\u65f6\u95f4\u9650\u5b9a\u53d1\u751f\u5f02\u5e38!"), (Throwable)exception);
                    Object var7_8 = null;
                    try {
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                        }
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block20;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void dowithChannelTimeRange(int n, String string) {
        int n2 = n;
        int n3 = string.indexOf(58);
        int n4 = -1;
        if (n3 > 0 && n3 < string.length() - 1) {
            String string2 = string.substring(n3 + 1).trim();
            try {
                n4 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        } else if (n3 < 0) {
            n3 = string.length();
        }
        int n5 = -1;
        String string3 = string.substring(0, n3).trim();
        try {
            n5 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (n5 == 0) {
            if (n4 > 0) {
                this.m_nDefaultTimeRange = n4;
                this.m_iDefaultTimeRange = new Integer(this.m_nDefaultTimeRange);
            }
            return;
        }
        Integer n6 = n4 > 0 ? new Integer(n4) : this.m_iDefaultTimeRange;
        if (n2 == 101) {
            this.m_hmChannelsSetTimeRange.put(new Integer(n5), n6);
        }
        this.m_hmObjectSetTimeRange.put(this.makeTimeRangeObjectKey(n2, n5), n6);
    }

    public boolean isSetTimeRange(int n, int n2) {
        return this.m_hmObjectSetTimeRange.containsKey(this.makeTimeRangeObjectKey(n2, n));
    }

    public int getTimeRange(int n, int n2) {
        Integer n3 = (Integer)this.m_hmObjectSetTimeRange.get(this.makeTimeRangeObjectKey(n2, n));
        if (n3 == null) {
            return -1;
        }
        return n3;
    }

    private String makeTimeRangeObjectKey(int n, int n2) {
        return n + "." + n2;
    }

    public CMyDateTime getStartDateTime(int n, int n2) {
        if (!this.isSetTimeRange(n, n2)) {
            return null;
        }
        CMyDateTime cMyDateTime = CMyDateTime.now();
        try {
            return cMyDateTime.dateAdd(3, -this.getTimeRange(n, n2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

