/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.wcm.content.domain.IDocumentsTimeRangeMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import java.io.File;
import org.apache.log4j.Logger;

public class DocumentsGetHelper {
    private static final String REG_CONTAINS_WCMDOCUMENT = "(?ism).*WCMDOCUMENT.*";
    private static Logger logger = Logger.getLogger(DocumentsGetHelper.class);
    private static IDocumentsTimeRangeMgr m_oTimeRangeMgr = null;

    public static Documents getDocuments(Channel channel, WCMFilter wCMFilter) throws WCMException {
        return DocumentsGetHelper.getDocuments(channel, wCMFilter, true);
    }

    public static Documents getDocuments(Channel channel, WCMFilter wCMFilter, boolean bl) throws WCMException {
        WCMFilter wCMFilter2 = DocumentsGetHelper.makeChannelFilter(channel, wCMFilter, bl, false);
        wCMFilter2.setForceFirstLoadIds(true);
        return Documents.openWCMObjs(null, wCMFilter2);
    }

    public static WCMFilter makeChannelFilter(Channel channel, WCMFilter wCMFilter) throws WCMException {
        return DocumentsGetHelper.makeChannelFilter(channel, wCMFilter, false, false);
    }

    public static WCMFilter makeChannelFilter(Channel channel, WCMFilter wCMFilter, boolean bl, boolean bl2) throws WCMException {
        return DocumentsGetHelper.makeChannelFilter(channel, wCMFilter, bl, bl2, 0);
    }

    public static WCMFilter makeChannelFilter(Channel channel, WCMFilter wCMFilter, boolean bl, boolean bl2, int n) throws WCMException {
        String string;
        if (m_oTimeRangeMgr == null) {
            m_oTimeRangeMgr = (IDocumentsTimeRangeMgr)DreamFactory.createObjectById("IDocumentsTimeRangeMgr");
        }
        if (DocumentsGetHelper.isQueryInDocument(wCMFilter, channel)) {
            return DocumentsGetHelper.makeChannelFilterInDocument(channel, wCMFilter, bl, bl2, n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = channel.getQuery();
        boolean bl3 = !channel.isOnlySearch();
        boolean bl4 = false;
        if (bl3) {
            stringBuffer.append("CHNLID=?");
            bl4 = true;
        }
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(bl4 ? " and (" : "(").append(string2).append(')');
        }
        String string3 = stringBuffer.toString();
        stringBuffer.setLength(0);
        String string4 = string3.toUpperCase();
        if (string4.indexOf("SRCCHNLID=0") >= 0) {
            string3 = string4 = CMyString.replaceStr(string4, "SRCCHNLID=0", "MODAL=1");
        }
        if (string4.indexOf("WCMDOCUMENT.DOCID=WCMCHNLDOC.DOCID") >= 0) {
            string3 = string4 = CMyString.replaceStr(string4, "WCMDOCUMENT.DOCID=WCMCHNLDOC.DOCID", "1=1");
        }
        String string5 = null;
        if (wCMFilter != null && wCMFilter.getWhere() != null && (string5 = wCMFilter.getWhere().trim().toUpperCase()).length() == 0) {
            string5 = null;
        }
        if ((string5 == null || string5.indexOf("DOCSTATUS") < 0) && string4.indexOf("DOCSTATUS") < 0) {
            stringBuffer.append(bl2 ? " (DOCSTATUS<0 or Modal<0 or DocChannel<0)" : " DOCSTATUS>0 and Modal>0 and DocChannel>0");
        } else {
            stringBuffer.append(bl2 ? " (Modal<0 or DocChannel<0)" : " Modal>0 and DocChannel>0");
        }
        if ((string5 == null || string5.indexOf("CHNLID") < 0) && string4.indexOf("CHNLID") < 0) {
            stringBuffer.append(bl2 ? "" : " and CHNLID>0");
        }
        string3 = string3 + " AND (" + stringBuffer.toString() + ")";
        if (bl) {
            string = channel.getOrderBy();
            if (!(string != null && string.trim().length() != 0 || (string = channel.getSite().getOrderBy()) != null && string.trim().length() != 0)) {
                string = "DOCORDERPRI desc, DocOrder desc";
            }
        } else {
            string = "";
        }
        WCMFilter wCMFilter2 = new WCMFilter("WCMCHNLDOC", string3, string);
        if (bl3) {
            wCMFilter2.addSearchValues(channel.getId());
        }
        wCMFilter2.mergeWith(wCMFilter);
        CMyDateTime cMyDateTime = m_oTimeRangeMgr.getStartDateTime(channel.getId());
        if (cMyDateTime != null) {
            string3 = wCMFilter2.getWhere();
            if (string3.length() > 0) {
                string3 = string3 + " and ";
            }
            string3 = string3 + "CrTime >= ?";
            wCMFilter2.setWhere(string3);
            int n2 = 0;
            if (wCMFilter2.getSearchValues() != null) {
                n2 = wCMFilter2.getSearchValues().size();
            }
            wCMFilter2.addSearchValues(n2, cMyDateTime);
        }
        return wCMFilter2;
    }

    private static WCMFilter makeChannelFilterInDocument(Channel channel, WCMFilter wCMFilter, boolean bl, boolean bl2, int n) throws WCMException {
        String string;
        boolean bl3;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WCMDocument.DocId=WCMChnlDoc.DocId");
        String string2 = channel.getQuery();
        boolean bl4 = bl3 = !channel.isOnlySearch();
        if (bl3) {
            stringBuffer.append(" and WCMChnlDoc.CHNLID=?");
        }
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(" AND (").append(string2).append(')');
        }
        String string3 = stringBuffer.toString();
        stringBuffer.setLength(0);
        String string4 = string3.toUpperCase();
        if (string4.indexOf("SRCCHNLID=0") >= 0) {
            string3 = string4 = CMyString.replaceStr(string4, "SRCCHNLID=0", "MODAL=1");
        }
        String string5 = null;
        if (wCMFilter != null && wCMFilter.getWhere() != null && (string5 = wCMFilter.getWhere().trim().toUpperCase()).length() == 0) {
            string5 = null;
        }
        if ((string5 == null || string5.indexOf("DOCSTATUS") < 0) && string4.indexOf("DOCSTATUS") < 0) {
            stringBuffer.append(bl2 ? " ( WCMChnlDoc.DOCSTATUS<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : " WCMChnlDoc.DOCSTATUS>0 and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        } else {
            stringBuffer.append(bl2 ? "( WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : "WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        }
        if ((string5 == null || string5.indexOf("CHNLID") < 0) && string4.indexOf("CHNLID") < 0) {
            stringBuffer.append(bl2 ? "" : " and WCMChnlDoc.CHNLID>0");
        }
        string3 = string3 + " AND (" + stringBuffer.toString() + ")";
        if (bl) {
            WebSite webSite;
            string = channel.getOrderBy();
            if (!(string != null && string.trim().length() != 0 || (webSite = channel.getSite()) != null && (string = webSite.getOrderBy()) != null && string.trim().length() != 0)) {
                string = "WCMChnlDoc.DOCORDERPRI desc, WCMChnlDoc.DocOrder desc";
            }
        } else {
            string = "";
        }
        int n2 = 0;
        WCMFilter wCMFilter2 = null;
        IMetaViewEmployerMgr iMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
        Channel channel2 = Channel.findById(n);
        MetaView metaView = null;
        if (channel2 != null) {
            metaView = iMetaViewEmployerMgr.getViewOfEmployer(channel2);
        }
        wCMFilter2 = metaView != null ? new WCMFilter("WCMChnlDoc,WCMDocument," + metaView.getTrueTableName(), string3, string) : new WCMFilter("WCMCHNLDOC,WCMDocument", string3, string);
        if (bl3) {
            wCMFilter2.addSearchValues(n2++, channel.getId());
        }
        wCMFilter2.mergeWith(wCMFilter);
        CMyDateTime cMyDateTime = m_oTimeRangeMgr.getStartDateTime(channel.getId());
        if (cMyDateTime != null) {
            string3 = wCMFilter2.getWhere();
            if (string3.length() > 0) {
                string3 = string3 + " and ";
            }
            string3 = string3 + "WCMDocument.CrTime >= ?";
            wCMFilter2.setWhere(string3);
            int n3 = 0;
            if (wCMFilter2.getSearchValues() != null) {
                n3 = wCMFilter2.getSearchValues().size();
            }
            wCMFilter2.addSearchValues(n3, cMyDateTime);
        }
        return wCMFilter2;
    }

    public static WCMFilter makeFilter(WebSite webSite, WCMFilter wCMFilter, boolean bl, boolean bl2) {
        CMyDateTime cMyDateTime;
        if (DocumentsGetHelper.isQueryInDocument(wCMFilter, null)) {
            return DocumentsGetHelper.makeFilterInDocument(webSite, wCMFilter, bl, bl2);
        }
        WCMFilter wCMFilter2 = new WCMFilter("WCMCHNLDOC", null, null);
        String string = "exists(Select WCMChannel.ChannelId from WCMChannel where " + (bl2 ? "(WCMChnlDoc.CHNLID=WCMChannel.ChannelId or WCMChnlDoc.CHNLID=-WCMChannel.ChannelId)" : "WCMChnlDoc.CHNLID=WCMChannel.ChannelId") + " and SiteId=?)";
        String string2 = null;
        if (wCMFilter != null && wCMFilter.getWhere() != null && (string2 = wCMFilter.getWhere().trim().toUpperCase()).length() == 0) {
            string2 = null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 40);
        stringBuffer.append(string);
        if (string2 == null || string2.indexOf("DOCSTATUS") < 0) {
            stringBuffer.append(bl2 ? " and (DocStatus<0 or Modal<0 or DocChannel<0 or ChnlId<0)" : " and DOCSTATUS>0 and Modal>0 and DocChannel>0");
        } else {
            stringBuffer.append(bl2 ? " and (Modal<0 or DocChannel<0 or ChnlId<0)" : " and Modal>0 and DocChannel>0");
        }
        wCMFilter2.setWhere(stringBuffer.toString());
        wCMFilter2.addSearchValues(webSite.getId());
        String string3 = bl ? "CrTime Desc" : "";
        wCMFilter2.setOrder(string3);
        wCMFilter2.mergeWith(wCMFilter);
        if (m_oTimeRangeMgr == null) {
            m_oTimeRangeMgr = (IDocumentsTimeRangeMgr)DreamFactory.createObjectById("IDocumentsTimeRangeMgr");
        }
        if ((cMyDateTime = m_oTimeRangeMgr.getStartDateTime(webSite.getId(), 103)) != null) {
            string = wCMFilter2.getWhere();
            if (string.length() > 0) {
                string = string + " and ";
            }
            string = string + "CrTime >= ?";
            wCMFilter2.setWhere(string);
            wCMFilter2.addSearchValues(cMyDateTime);
        }
        return wCMFilter2;
    }

    private static WCMFilter makeFilterInDocument(WebSite webSite, WCMFilter wCMFilter, boolean bl, boolean bl2) {
        CMyDateTime cMyDateTime;
        WCMFilter wCMFilter2 = new WCMFilter("WCMCHNLDOC,WCMDOCUMENT", null, null);
        String string = "exists(Select WCMChannel.ChannelId from WCMChannel where " + (bl2 ? "(WCMChnlDoc.CHNLID=WCMChannel.ChannelId or WCMChnlDoc.CHNLID=-WCMChannel.ChannelId)" : "WCMChnlDoc.CHNLID=WCMChannel.ChannelId") + " and SiteId=?)" + " and WCMChnlDoc.DocId=WCMDocument.DocId";
        String string2 = null;
        if (wCMFilter != null && wCMFilter.getWhere() != null && (string2 = wCMFilter.getWhere().trim().toUpperCase()).length() == 0) {
            string2 = null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 40);
        stringBuffer.append(string);
        if (string2 == null || string2.indexOf("DOCSTATUS") < 0) {
            stringBuffer.append(bl2 ? " and (WCMChnlDoc.DOCSTATUS<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0 or WCMChnlDoc.ChnlId<0)" : " and WCMChnlDoc.DOCSTATUS>0 and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        } else {
            stringBuffer.append(bl2 ? " and (WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0 or WCMChnlDoc.ChnlId<0)" : " and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        }
        wCMFilter2.setWhere(stringBuffer.toString());
        wCMFilter2.addSearchValues(webSite.getId());
        String string3 = bl ? "WCMChnlDoc.CrTime Desc" : "";
        wCMFilter2.setOrder(string3);
        wCMFilter2.mergeWith(wCMFilter);
        if (m_oTimeRangeMgr == null) {
            m_oTimeRangeMgr = (IDocumentsTimeRangeMgr)DreamFactory.createObjectById("IDocumentsTimeRangeMgr");
        }
        if ((cMyDateTime = m_oTimeRangeMgr.getStartDateTime(webSite.getId(), 103)) != null) {
            string = wCMFilter2.getWhere();
            if (string.length() > 0) {
                string = string + " and ";
            }
            string = string + "WCMChnlDoc.CrTime >= ?";
            wCMFilter2.setWhere(string);
            wCMFilter2.addSearchValues(cMyDateTime);
        }
        return wCMFilter2;
    }

    public static WCMFilter makeFilter(WebSites webSites, WCMFilter wCMFilter, boolean bl, boolean bl2) {
        if (webSites == null || webSites.isEmpty()) {
            return null;
        }
        if (webSites.size() == 1) {
            return DocumentsGetHelper.makeFilter((WebSite)webSites.getAt(0), wCMFilter, bl, bl2);
        }
        if (DocumentsGetHelper.isQueryInDocument(wCMFilter, null)) {
            return DocumentsGetHelper.makeFilterInDocument(webSites, wCMFilter, bl, bl2);
        }
        WCMFilter wCMFilter2 = new WCMFilter("WCMCHNLDOC", null, null);
        StringBuffer stringBuffer = new StringBuffer(300 + webSites.size() * 2);
        stringBuffer.append("exists(Select WCMChannel.ChannelId from WCMChannel where WCMChnlDoc.CHNLID=WCMChannel.ChannelId and SiteId in(?");
        wCMFilter2.addSearchValues(webSites.getIdAt(0));
        int n = webSites.size();
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(",?");
            wCMFilter2.addSearchValues(webSites.getIdAt(i));
        }
        stringBuffer.append("))");
        stringBuffer.append(bl2 ? " and (DocChannel<0 or Modal<0)" : " and DocChannel>0");
        String string = null;
        if (wCMFilter != null && wCMFilter.getWhere() != null && (string = wCMFilter.getWhere().trim().toUpperCase()).length() == 0) {
            string = null;
        }
        if (string == null || string.indexOf("DOCSTATUS") < 0) {
            stringBuffer.append(bl2 ? " and DOCSTATUS<0" : " and DOCSTATUS>0");
        }
        wCMFilter2.setWhere(stringBuffer.toString());
        String string2 = bl ? "CrTime Desc" : "";
        wCMFilter2.setOrder(string2);
        wCMFilter2.mergeWith(wCMFilter);
        return wCMFilter2;
    }

    private static WCMFilter makeFilterInDocument(WebSites webSites, WCMFilter wCMFilter, boolean bl, boolean bl2) {
        WCMFilter wCMFilter2 = new WCMFilter("WCMCHNLDOC,WCMDOCUMENT", null, null);
        StringBuffer stringBuffer = new StringBuffer(300 + webSites.size() * 2);
        stringBuffer.append("exists(Select WCMChannel.ChannelId from WCMChannel where WCMChnlDoc.CHNLID=WCMChannel.ChannelId and SiteId in(?");
        wCMFilter2.addSearchValues(webSites.getIdAt(0));
        int n = webSites.size();
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(",?");
            wCMFilter2.addSearchValues(webSites.getIdAt(i));
        }
        stringBuffer.append(")) and WCMChnlDoc.DocId=WCMDocument.DocId");
        String string = null;
        if (wCMFilter != null && wCMFilter.getWhere() != null && (string = wCMFilter.getWhere().trim().toUpperCase()).length() == 0) {
            string = null;
        }
        if (string == null || string.indexOf("DOCSTATUS") < 0) {
            stringBuffer.append(bl2 ? " and (WCMChnlDoc.DOCSTATUS<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : " and WCMChnlDoc.DOCSTATUS>0 and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        } else {
            stringBuffer.append(bl2 ? " and (WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : " and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        }
        wCMFilter2.setWhere(stringBuffer.toString());
        String string2 = bl ? "WCMChnlDoc.CrTime Desc" : "";
        wCMFilter2.setOrder(string2);
        wCMFilter2.mergeWith(wCMFilter);
        return wCMFilter2;
    }

    public static WCMFilter makeChannelFilter(Channels channels, WCMFilter wCMFilter, boolean bl) throws WCMException {
        if (channels.isEmpty()) {
            return null;
        }
        if (channels.size() == 1) {
            return DocumentsGetHelper.makeChannelFilter((Channel)channels.getAt(0), wCMFilter, true, bl);
        }
        if (DocumentsGetHelper.isQueryInDocument(wCMFilter, null)) {
            return DocumentsGetHelper.makeChannelFilterInDocument(channels, wCMFilter, bl);
        }
        String string = bl ? "(WCMChnlDoc.DocStatus<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : "WCMChnlDoc.DocChannel>0 and WCMChnlDoc.DocStatus>0 and WCMChnlDoc.Modal>0";
        WCMFilter wCMFilter2 = new WCMFilter("", "", "");
        StringBuffer stringBuffer = new StringBuffer(channels.size() * 2 + string.length() + 16);
        if (!channels.isEmpty()) {
            stringBuffer.append("ChnlId in(");
        }
        int n = channels.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("?");
            wCMFilter2.addSearchValues(channels.getIdAt(i));
        }
        if (!channels.isEmpty()) {
            stringBuffer.append(") and ");
        }
        stringBuffer.append(string);
        wCMFilter2.setWhere(stringBuffer.toString());
        wCMFilter2.mergeWith(wCMFilter);
        return wCMFilter2;
    }

    private static WCMFilter makeChannelFilterInDocument(Channels channels, WCMFilter wCMFilter, boolean bl) {
        String string = (bl ? " (WCMChnlDoc.DocStatus<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : " WCMChnlDoc.DocStatus>0 and WCMChnlDoc.DocChannel>0 and WCMChnlDoc.Modal>0") + " and WCMDocument.DocId=WCMChnlDoc.DocId";
        WCMFilter wCMFilter2 = new WCMFilter("WCMChnlDoc,WCMDocument", "", "");
        StringBuffer stringBuffer = new StringBuffer(channels.size() * 2 + string.length() + 16);
        if (!channels.isEmpty()) {
            stringBuffer.append("WCMChnlDoc.ChnlId in(");
        }
        int n = channels.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("?");
            wCMFilter2.addSearchValues(channels.getIdAt(i));
        }
        if (!channels.isEmpty()) {
            stringBuffer.append(") and ");
        }
        stringBuffer.append(string);
        wCMFilter2.setWhere(stringBuffer.toString());
        wCMFilter2.mergeWith(wCMFilter);
        return wCMFilter2;
    }

    private static boolean isQueryInDocument(WCMFilter wCMFilter, Channel channel) {
        if (wCMFilter != null) {
            if (wCMFilter.getWhere() != null && wCMFilter.getWhere().matches(REG_CONTAINS_WCMDOCUMENT)) {
                return true;
            }
            if (wCMFilter.getOrder() != null && wCMFilter.getOrder().matches(REG_CONTAINS_WCMDOCUMENT)) {
                return true;
            }
            if (wCMFilter.getSelect() != null && wCMFilter.getSelect().matches(REG_CONTAINS_WCMDOCUMENT)) {
                return true;
            }
        }
        if (channel == null) {
            return false;
        }
        String string = channel.getQuery();
        if (string != null && string.matches(REG_CONTAINS_WCMDOCUMENT)) {
            return true;
        }
        String string2 = channel.getOrderBy();
        return string2 != null && string2.matches(REG_CONTAINS_WCMDOCUMENT);
    }

    public static void main(String[] stringArray) {
        File[] fileArray;
        Object object;
        String[] stringArray2 = new String[]{"D:\\YHIntranet\\webapps\\wcm\\wcm_use\\", "D:\\YHIntranet\\webapps\\wcm\\test\\", "D:\\YHIntranet\\webapps\\wcm\\temp\\"};
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.println(I18NMessage.get(DocumentsGetHelper.class, "DocumentsGetHelper.label1", "\u76ee\u5f55:") + stringArray2[i] + "<BR>");
            object = new File(stringArray2[i]);
            fileArray = ((File)object).listFiles();
            for (int j = 0; j < fileArray.length; ++j) {
                if (fileArray[j].getName().indexOf("jsp") > 0) {
                    System.out.println(I18NMessage.get(DocumentsGetHelper.class, "DocumentsGetHelper.label2", "\u6587\u4ef6:") + fileArray[j].getName());
                }
                if (!fileArray[j].isDirectory()) continue;
                System.out.println(I18NMessage.get(DocumentsGetHelper.class, "DocumentsGetHelper.label1", "\u76ee\u5f55:") + fileArray[j].getName());
            }
        }
        try {
            DebugTimer debugTimer = new DebugTimer();
            object = null;
            fileArray = new WCMFilter();
            fileArray.setMaxRowNumber(1);
            WCMFilter wCMFilter = new WCMFilter("", "", "ChannelId");
            Channels channels = Channels.openWCMObjs(null, wCMFilter);
            int n = channels.size();
            for (int i = 0; i < n; ++i) {
                Channel channel = (Channel)channels.getAt(i);
                if (channel == null) continue;
                debugTimer.start();
                try {
                    object = DocumentsGetHelper.getDocuments(channel, (WCMFilter)fileArray);
                }
                catch (Throwable throwable) {
                    logger.error((Object)("[" + channel + I18NMessage.get(DocumentsGetHelper.class, "DocumentsGetHelper.label4", "]\u51fa\u73b0\u5f02\u5e38!")), throwable);
                }
                debugTimer.stop();
                if (debugTimer.getTime() > 2000L) {
                    logger.info((Object)("Long!!! get [" + channel + "] documents use[" + debugTimer.getTime() + "]ms [" + ((Documents)object).size() + "] SQL:" + ((BaseObjs)object).getFilter().toSQL()));
                }
                ((Documents)object).clear();
            }
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(DocumentsGetHelper.class, "DocumentsGetHelper.label5", "\u6d4b\u8bd5\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)exception);
        }
    }
}

