/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;

public class DocumentLCListenerForExternalFile
implements IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    private FilesMan m_filesman = FilesMan.getFilesMan();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setDocFile(BaseObj baseObj, String string) throws WCMException {
        String string2 = this.m_filesman.getNextFileName("P0", CMyFile.extractFileExt(string), null, true);
        User user = ContextHelper.getLoginUser();
        Document document = (Document)baseObj;
        try {
            try {
                CMyFile.copyFile(string, string2);
                document.canEdit(user);
                baseObj.setProperty("DOCFILENAME", CMyFile.extractFileName(string2));
                document.update(user);
            }
            catch (CMyException cMyException) {
                throw new WCMException(1100, I18NMessage.get(DocumentLCListenerForExternalFile.class, "DocumentLCListenerForExternalFile.label1", "\u5904\u7406\u6587\u4ef6\u5931\u8d25!"), cMyException);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            String string3 = CMyFile.extractFileName(string);
            if (string3.indexOf("U0") != 0) throw throwable;
            CMyFile.deleteFile(string);
            throw throwable;
        }
        String string4 = CMyFile.extractFileName(string);
        if (string4.indexOf("U0") != 0) return;
        CMyFile.deleteFile(string);
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        String string;
        if (this.isListening(baseObj) && CMyFile.fileExists(string = this.getDocFile(baseObj))) {
            CMyFile.deleteFile(string);
        }
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (this.isListening(baseObj) && baseObj.isChangeProperty("DOCFILENAME")) {
            String string = this.getDocFile(baseObj);
            String string2 = baseObj.getNewPropertyAsString("DOCFILENAME");
            if (string2.indexOf("U0") != 0) {
                return;
            }
            if (CMyFile.fileExists(string) && this.unUsedByDocBak(baseObj.getId(), string)) {
                CMyFile.deleteFile(string);
            }
            String string3 = this.m_filesman.mapFilePath(string2, 0);
            this.setDocFile(baseObj, string3 + string2);
        }
    }

    private boolean unUsedByDocBak(int n, String string) throws WCMException {
        String string2 = "SELECT COUNT(DocId) FROM WCMDOCBAK WHERE DocId=" + n + " AND DocFileName='" + CMyFile.extractFileName(string) + "'";
        return DBManager.getDBManager().sqlExecuteIntQuery(string2) == 0;
    }

    private String getDocFile(BaseObj baseObj) throws WCMException {
        String string = baseObj.getPropertyAsString("DOCFILENAME");
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        String string2 = this.m_filesman.mapFilePath(string, 0);
        return string2 + string;
    }

    private boolean isListening(BaseObj baseObj) {
        if (baseObj != null && baseObj instanceof Document) {
            return ((Document)baseObj).getType() == 40;
        }
        return false;
    }
}

