/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.HTMLContent;
import com.trs.components.ckm.ICKMServer;
import com.trs.components.ckm.TRSCKMServer;
import com.trs.components.infoview.InfoViewEmployMgr;
import com.trs.components.infoview.InfoviewDataProcessor;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.IDocumentImporterConverter;
import com.trs.components.wcm.content.domain.XmlToDocumentConverter;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.Reports;
import com.trs.infra.util.WCMDiscoveryFactory;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class DocumentImporter {
    private static final String DEFINE_XML_FILE = "define.xml";
    private static final String TRS_XSL_FILE = "trs.xsl";
    private static final String CHILD_TAG_APPENDIXES = "WCMAPPENDIXS";
    private static final String CHILD_TAG_CHNLDOCS = "WCMCHNLDOCS";
    private static Logger s_logger = Logger.getLogger(DocumentImporter.class);
    private DocumentMgr m_documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
    private static final String FILEEXT_ZIP = "zip";
    private static final String FILEEXT_XML = "xml";
    private static final String FILEEXT_HTML = "html";
    private static final String FILEEXT_HTM = "htm";
    private static final int TYPE_ZIP = 1;
    private static final int TYPE_XML = 2;
    private static final int TYPE_HTML = 3;
    private static final int TYPE_UNSUPPORT = 4;
    private boolean m_bImportFromTRS = false;
    private XmlToDocumentConverter m_converter = new XmlToDocumentConverter(1);
    private Reports m_importReports;
    private static String m_sSourceFilePath;
    private static String[] HTML_TAG_NAMES;
    private static String[] HTML_TAG_SRCS;
    private boolean m_bImportCurrent;
    private static List implementors;

    public DocumentImporter() {
        this.m_converter.registPersistentObj("WCMDOCUMENT", Document.class);
        this.m_converter.registPersistentObj("WCMCHNLDOC", ChnlDoc.class);
        this.m_converter.registPersistentObj("WCMAPPENDIX", Appendix.class);
        try {
            this.m_bImportCurrent = "true".equals(ConfigServer.getServer().getInitProperty("IMPORTDOC_TOCURR_WHEN_SCNOTEXISTS"));
        }
        catch (Exception exception) {
            if (s_logger.isDebugEnabled()) {
                s_logger.error((Object)"faile to read init config", (Throwable)exception);
            }
            this.m_bImportCurrent = false;
        }
        try {
            List list = DocumentImporter.getImplementors();
            for (IDocumentImporterConverter iDocumentImporterConverter : list) {
                iDocumentImporterConverter.registerConverter(this.m_converter);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static List getImplementors() throws Exception {
        String string = IDocumentImporterConverter.class.getName();
        if (implementors == null) {
            Iterator iterator = WCMDiscoveryFactory.getDiscovery().getImplementors(string);
            implementors = new ArrayList();
            while (iterator != null && iterator.hasNext()) {
                String string2 = (String)iterator.next();
                implementors.add(Class.forName(string2).newInstance());
            }
        }
        return implementors;
    }

    public Reports importFromFile(String string, Channel channel, String string2, boolean bl, boolean bl2, boolean bl3) throws WCMException {
        if (bl2) {
            return this.importFromFile(string, channel, string2, bl, bl2);
        }
        return this.importFromFileByName(string, channel, string2, bl, bl2, bl3);
    }

    public Reports importFromFileByName(String string, Channel channel, String string2, boolean bl, boolean bl2, boolean bl3) throws WCMException {
        if (bl2 && channel == null) {
            throw new WCMException(10, I18NMessage.get(DocumentImporter.class, "DocumentImporter.label1", "\u6ca1\u6709\u6307\u5b9a\u5bfc\u5165\u6587\u6863\u7684\u76ee\u6807\u680f\u76ee!"));
        }
        this.m_importReports = new Reports("");
        String string3 = this.getFullFileName(string);
        String string4 = this.getXslFileFullName(this.getLoginUser(), string2);
        if (!bl3) {
            this.importDocuments(string3, channel, string4, bl, bl2);
        } else {
            this.importDocuments(string3, channel, string4, bl, bl2, bl3);
        }
        this.setReportsTitle();
        return this.m_importReports;
    }

    public Reports importFromFile(String string, Channel channel, String string2, boolean bl, boolean bl2) throws WCMException {
        return this.importFromFileByName(string, channel, string2, bl, bl2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reports importFromTRSFile(String string, Channel channel, String string2, boolean bl, boolean bl2) throws WCMException {
        if (bl2 && channel == null) {
            throw new WCMException(10, I18NMessage.get(DocumentImporter.class, "DocumentImporter.label1", "\u6ca1\u6709\u6307\u5b9a\u5bfc\u5165\u6587\u6863\u7684\u76ee\u6807\u680f\u76ee!"));
        }
        if (string2 == null || string2.trim().length() == 0) {
            throw new WCMException(10, I18NMessage.get(DocumentImporter.class, "DocumentImporter.label2", "\u6ca1\u6709\u6307\u5b9a\u4eceTRS Server\u5bfc\u5165\u65f6\u7684\u6620\u5c04\u6587\u4ef6!"));
        }
        this.m_importReports = new Reports("");
        String string3 = this.getFullFileName(string);
        String string4 = DocumentImporter.getMyDocumentImportSourceFilePath(this.getLoginUser());
        String string5 = string4 + "temp" + System.currentTimeMillis() + File.separator;
        if (!CMyFile.fileExists(string2)) {
            string2 = string4 + string2;
        }
        try {
            CMyFile.copyFile(string2, string5 + DEFINE_XML_FILE);
            CMyFile.copyFile(DocumentImporter.getImportsrcPath() + TRS_XSL_FILE, string5 + TRS_XSL_FILE);
        }
        catch (CMyException cMyException) {
            CMyFile.deleteDir(string5);
            throw new WCMException(1100, I18NMessage.get(DocumentImporter.class, "DocumentImporter.label3", "\u83b7\u53d6TRS\u6620\u5c04\u6587\u4ef6\u5931\u8d25!"), cMyException);
        }
        try {
            this.m_bImportFromTRS = true;
            this.importDocuments(string3, channel, string5 + TRS_XSL_FILE, bl, bl2);
            this.setReportsTitle();
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            CMyFile.deleteDir(string5);
            throw throwable;
        }
        CMyFile.deleteDir(string5);
        return this.m_importReports;
    }

    private static String getImportsrcPath() {
        if (m_sSourceFilePath == null) {
            m_sSourceFilePath = FilesMan.getFilesMan().getPathConfigValue("DS", 0) + "importresource" + File.separator;
        }
        return m_sSourceFilePath;
    }

    private String getFullFileName(String string) throws WCMException {
        String string2 = string;
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!CMyFile.fileExists(string)) {
            String string3 = filesMan.mapFilePath(string, 0);
            string2 = string3 + string;
        }
        return string2;
    }

    private void importDocuments(String string, Channel channel, String string2, boolean bl, boolean bl2, boolean bl3) throws WCMException {
        int n = this.getImportFileType(string);
        switch (n) {
            case 1: {
                this.importFromZip(string, channel, string2, bl, bl2, bl3);
                break;
            }
            case 2: {
                this.importFromXml(string, channel, string2, bl, bl2, bl3);
                break;
            }
            case 3: {
                this.importFromHtml(string, channel, false);
                break;
            }
            case 4: {
                throw new WCMException(1200, I18NMessage.get(DocumentImporter.class, "DocumentImporter.label4", "\u4e0d\u652f\u6301[") + CMyFile.extractFileExt(string) + I18NMessage.get(DocumentImporter.class, "DocumentImporter.label5", "]\u683c\u5f0f\u6587\u4ef6\u7684\u5bfc\u5165!"));
            }
        }
    }

    private void importDocuments(String string, Channel channel, String string2, boolean bl, boolean bl2) throws WCMException {
        this.importDocuments(string, channel, string2, bl, bl2, false);
    }

    private void setReportsTitle() {
        int n = this.m_importReports.getSucessedReporter().size();
        int n2 = this.m_importReports.getFailedReporter().size();
        String string = CMyString.format(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label7", "{0}\u7bc7\u5bfc\u5165\u6210\u529f,"), new int[]{n});
        String string2 = CMyString.format(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label9", "{0}\u7bc7\u5bfc\u5165\u5931\u8d25,"), new int[]{n2});
        this.m_importReports.setTitle(CMyString.format(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label10", "\u5171\u5904\u7406{0}\u7bc7\u6587\u6863."), new int[]{n + n2}) + string + string2);
    }

    private int getImportFileType(String string) {
        String string2 = CMyFile.extractFileExt(string).toLowerCase();
        if (FILEEXT_ZIP.equals(string2)) {
            return 1;
        }
        if (FILEEXT_XML.equals(string2)) {
            return 2;
        }
        if (FILEEXT_HTM.equals(string2) || FILEEXT_HTML.equals(string2)) {
            return 3;
        }
        return 4;
    }

    private void importFromZip(String string, Channel channel, String string2, boolean bl, boolean bl2, boolean bl3) throws WCMException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("import Documents From [" + string + "]"));
        }
        String string3 = CMyFile.extractFilePath(string);
        string3 = string3 + CMyFile.extractMainFileName(string) + File.separator;
        CMyUnZipFile cMyUnZipFile = new CMyUnZipFile(string, string3);
        try {
            cMyUnZipFile.addFileExtFilters(FILEEXT_XML);
            cMyUnZipFile.doUnZipAnd();
            if (!s_logger.isDebugEnabled()) {
                CMyFile.deleteFile(string);
            }
        }
        catch (CMyException cMyException) {
            throw new WCMException(200, I18NMessage.get(DocumentImporter.class, "DocumentImporter.label12", "Zip\u6587\u4ef6\u89e3\u538b\u5931\u8d25!"), cMyException);
        }
        ArrayList arrayList = cMyUnZipFile.getFilteredFiles();
        String string4 = null;
        XmlObject[] xmlObjectArray = null;
        if (arrayList != null) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                string4 = (String)arrayList.get(i);
                if (this.isExportedFileForOfflineView(CMyFile.extractFileName(string4)) || FilesMan.isValidFile(CMyFile.extractFileName(string4), "P0")) continue;
                xmlObjectArray = this.m_converter.convertXml(string4, string2, null);
                if (this.m_bImportFromTRS && xmlObjectArray.length == 0) {
                    throw new WCMException(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label13", "\u60a8\u9009\u62e9\u4e86\u5bfc\u5165\u7531TRS\u6570\u636e\u5e93\u5bfc\u51fa\u7684\u6587\u4ef6,\u4f46\u662f\u6ca1\u6709\u627e\u5230\u6709\u6548\u7684TRS\u6587\u6863\u63cf\u8ff0\u6587\u4ef6.\u8bf7\u68c0\u67e5\u76f8\u5e94\u7684\u6570\u636e\u6e90"));
                }
                this.add(xmlObjectArray, channel, string3, bl, bl2, bl3);
            }
        }
        File[] fileArray = CMyFile.listFiles(string3, FILEEXT_HTML);
        for (int i = 0; i < fileArray.length; ++i) {
            this.importFromZipHtmlFiles(string3, fileArray[i].getName(), channel);
        }
        File[] fileArray2 = CMyFile.listFiles(string3, FILEEXT_HTM);
        for (int i = 0; i < fileArray2.length; ++i) {
            this.importFromZipHtmlFiles(string3, fileArray2[i].getName(), channel);
        }
        if (!s_logger.isDebugEnabled()) {
            CMyFile.deleteFile(string);
            CMyFile.deleteDir(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFromXml(String string, Channel channel, String string2, boolean bl, boolean bl2, boolean bl3) throws WCMException {
        try {
            XmlObject[] xmlObjectArray = this.m_converter.convertXml(string, string2, null);
            this.add(xmlObjectArray, channel, null, bl, bl2, bl3);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            CMyFile.deleteFile(string);
            throw throwable;
        }
        CMyFile.deleteFile(string);
    }

    private void importFromZipHtmlFiles(String string, String string2, Channel channel) {
        if (this.isExportedFileForOfflineView(string2) || FilesMan.isValidFile(string2, "P0")) {
            return;
        }
        this.importFromHtml(string + string2, channel, true);
    }

    private boolean isExportedFileForOfflineView(String string) {
        return "trs_wcm_viewer_index.htm".equals(string) || "trs_wcm_viewer_doview.htm".equals(string) || "resource.xml".equals(string) || "reference.xml".equals(string);
    }

    private void importFromHtml(String string, Channel channel, boolean bl) {
        String string2 = null;
        try {
            Document document = Document.createNewInstance();
            string2 = CMyFile.extractFileName(string);
            String string3 = CMyFile.readFile(string);
            String string4 = HTMLContent.getBodyContent(string3);
            document.setHtmlContent(string4);
            if (bl) {
                document = this.processHtmlContent(document, CMyFile.extractFilePath(string));
            }
            document.setContent(string4);
            document.setTitle(string2);
            document.setProperty("CrTime", CMyDateTime.now());
            if (channel != null) {
                document.setChannel(channel);
            }
            document.setType(20);
            this.m_documentMgr.save(document);
            this.m_importReports.addSucessedReport(CMyString.format(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label14", "{0}\u5bfc\u5165\u6210\u529f!"), new Object[]{document}));
            if (!s_logger.isDebugEnabled()) {
                CMyFile.deleteFile(string);
            }
        }
        catch (CMyException cMyException) {
            s_logger.error((Object)"failed import document from html file!", (Throwable)cMyException);
            this.m_importReports.addFailedReport(CMyString.format(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label15", "{0}\u6587\u6863\u5bfc\u5165\u5931\u8d25!"), new String[]{string2}), cMyException);
        }
    }

    private void add(XmlObject[] xmlObjectArray, Channel channel, String string, boolean bl, boolean bl2, boolean bl3) throws WCMException {
        User user = this.getLoginUser();
        XmlObject xmlObject = null;
        Document document = null;
        for (int i = xmlObjectArray.length - 1; i >= 0; --i) {
            Object object;
            xmlObject = xmlObjectArray[i];
            document = (Document)xmlObject.getCurrentObj();
            if (document == null) {
                throw new WCMException(1100, I18NMessage.get(DocumentImporter.class, "DocumentImporter.label16", "\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u6b63\u786e,xml\u6587\u4ef6\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u6587\u6863\u63cf\u8ff0\u6587\u4ef6!"));
            }
            boolean bl4 = document.getFlag() > 0;
            try {
                CMyDateTime cMyDateTime;
                String string2;
                int n;
                Object object2;
                String string3;
                object = null;
                if (bl3) {
                    string3 = (String)this.m_converter.Doc_ChannelName.get(document.getPropertyAsString("DocId"));
                    int n2 = channel.getSiteId();
                    object = Channel.findByName(n2, string3);
                    if (object != null) {
                        document.setChannel((Channel)object);
                    }
                } else {
                    object = document.getChannel();
                }
                if (bl2 || object == null && this.m_bImportCurrent) {
                    document.setChannel(channel);
                } else {
                    if (object == null) {
                        string3 = "omited a document import because the original channel do not existed!";
                        this.m_importReports.addFailedReport(CMyString.format(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label17", "\u5ffd\u7565{0}\u7684\u5bfc\u5165"), new String[]{document.toString()}), new WCMException(I18NMessage.makeObjectNotFound(new String[]{String.valueOf(document.getChannelId()), WCMTypes.getLowerObjName(101)})));
                        s_logger.warn((Object)string3);
                        continue;
                    }
                    if (((Channel)object).getStatus() < 0) {
                        string3 = "omited a document import because the original channel[name:" + document.getChannelName() + " id:" + document.getChannelId() + "] is in recycle bin!";
                        this.m_importReports.addFailedReport(CMyString.format(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label17", "\u5ffd\u7565{0}\u7684\u5bfc\u5165"), new String[]{document.toString()}), new WCMException(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label21", "\u6587\u6863\u7684\u539f\u59cb\u680f\u76ee") + object + I18NMessage.get(DocumentImporter.class, "DocumentImporter.label22", "\u5df2\u7ecf\u88ab\u653e\u5165\u56de\u6536\u7ad9!")));
                        s_logger.warn((Object)string3);
                        continue;
                    }
                }
                if (bl) {
                    boolean bl5 = false;
                    ICKMServer iCKMServer = (ICKMServer)DreamFactory.createObjectById("ICKMServer");
                    boolean bl6 = iCKMServer.isEnableSimSearch();
                    if (bl6) {
                        object2 = this.searchSimDocs(document);
                        if (!((BaseObjs)object2).isEmpty()) {
                            bl5 = true;
                        }
                    } else if (this.exsitedDocument(document)) {
                        bl5 = true;
                    }
                    if (bl5) {
                        object2 = "omited a document import because a same document[" + document.getTitle() + "] had existed in[" + document.getChannelName() + "]!";
                        this.m_importReports.addFailedReport(CMyString.format(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label17", "\u5ffd\u7565{0}\u7684\u5bfc\u5165!"), new String[]{document.getTitle()}), new WCMException(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label24", "\u56e0\u4e3a\u60a8\u9009\u62e9\u4e86\u5f53\u680f\u76ee\u6709\u91cd\u590d\u6807\u9898" + (bl6 ? "\u6216\u6b63\u6587" : "") + "\u6587\u6863\u65f6\u5ffd\u7565\u5bfc\u5165!")));
                        s_logger.warn(object2);
                        continue;
                    }
                }
                if ((n = document.getPropertyAsInt("DocStatus", 0)) == 0) {
                    document.setStatus(1);
                }
                if ((string2 = document.getPropertyAsString("CrUser")) == null || User.findByName(string2) == null) {
                    document.setCrUser(this.getLoginUser());
                }
                if ((cMyDateTime = document.getPropertyAsDateTime("CrTime")) == null) {
                    document.setProperty("CrTime", CMyDateTime.now());
                }
                document.removeProperty("DOCPUBTIME");
                if (bl4) {
                    Object object3;
                    object2 = document.getChannel();
                    InfoViewEmployMgr infoViewEmployMgr = (InfoViewEmployMgr)DreamFactory.createObjectById("InfoViewEmployMgr");
                    List list = infoViewEmployMgr.getEmployedInfoViews((CMSObj)object2);
                    if (list != null && !list.isEmpty()) {
                        object3 = (InfoView)list.get(0);
                        if (document.getFlag() != ((BaseObj)object3).getId()) {
                            document.setFlag(((BaseObj)object3).getId());
                        }
                    }
                    object3 = new InfoviewDataProcessor(user, string);
                    ((InfoviewDataProcessor)object3).processInfoViewAppendix(document);
                } else {
                    document = this.processHtmlContent(document, string);
                    this.processExternalFileIfNecessary(document, string);
                }
                this.m_documentMgr.save(document);
            }
            catch (Throwable throwable) {
                this.m_importReports.addFailedReport(CMyString.format(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label15", "{0}\u6587\u6863\u5bfc\u5165\u5931\u8d25!"), new Object[]{document}), throwable);
                continue;
            }
            this.m_importReports.addSucessedReport(CMyString.format(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label14", "{0}\u5bfc\u5165\u6210\u529f!"), new Object[]{document}));
            this.processQuote(xmlObject, document);
            if (!bl4) {
                this.processAppendix(xmlObject, document.getId(), string);
            }
            if (!"true".equalsIgnoreCase((String)(object = ConfigServer.getServer().getSysConfigValue("DOCIMPORT_INTO_FLOW", "false")))) continue;
            WCMProcessServiceHelper.startDocumentInFlow(document.getCrUser(), document, true);
        }
    }

    private void processQuote(XmlObject xmlObject, Document document) {
        XmlObject[] xmlObjectArray = xmlObject.getChild(CHILD_TAG_CHNLDOCS);
        if (xmlObjectArray == null || xmlObjectArray.length == 0) {
            return;
        }
        User user = this.getLoginUser();
        for (int i = xmlObjectArray.length - 1; i >= 0; --i) {
            ChnlDoc chnlDoc = (ChnlDoc)xmlObjectArray[i].getCurrentObj();
            Channel channel = null;
            try {
                channel = chnlDoc.getChannel();
            }
            catch (WCMException wCMException) {
                // empty catch block
            }
            if (channel == null) {
                if (!s_logger.isDebugEnabled()) continue;
                s_logger.debug((Object)"import quote err,no channel.");
                continue;
            }
            if (channel.getId() == document.getChannelId()) continue;
            ChnlDoc chnlDoc2 = null;
            try {
                chnlDoc2 = this.m_documentMgr.createChnlDocWithEntity(document, channel, true);
                chnlDoc2.setModal(chnlDoc.getModal() == 3 ? 3 : 2);
                chnlDoc2.save(user);
                continue;
            }
            catch (WCMException wCMException) {
                // empty catch block
            }
        }
    }

    private boolean exsitedDocument(Document document) throws WCMException {
        String string = document.getTitle();
        int n = document.getChannelId();
        Documents documents = new Documents(this.getLoginUser());
        CMyDateTime cMyDateTime = null;
        int n2 = -3;
        try {
            cMyDateTime = CMyDateTime.now().dateAdd(3, n2);
        }
        catch (CMyException cMyException) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"failed to date operate!", (Throwable)cMyException);
            }
            return false;
        }
        String string2 = "DocTitle=? AND DocChannel=? AND CrTime>=?";
        WCMFilter wCMFilter = new WCMFilter("", string2, "");
        wCMFilter.addSearchValues(CMyString.filterForSQL(string));
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(cMyDateTime);
        wCMFilter.setMaxRowNumber(1);
        documents.open(wCMFilter);
        return !documents.isEmpty();
    }

    private Documents searchSimDocs(Document document) {
        Documents documents = new Documents(this.getLoginUser());
        String string = document.getTitle();
        int n = document.getId();
        String string2 = document.getContent();
        ICKMServer iCKMServer = TRSCKMServer.getInstance();
        documents = iCKMServer.simSearch(n, string + string2);
        return documents;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private Document processHtmlContent(Document document, String string) {
        if (20 != document.getType()) {
            return document;
        }
        String string2 = document.getHtmlContent();
        if (string2 == null || string2.length() == 0) {
            return document;
        }
        try {
            HashMap hashMap = this.getPicFiles(document, string);
            string2 = HTMLContent.saveHTMLContentFromOut(string2, hashMap);
            document.setHtmlContent(string2);
        }
        catch (WCMException wCMException) {
            this.m_importReports.addWarnedReport(I18NMessage.get(DocumentImporter.class, "DocumentImporter.label26", "\u5904\u7406") + document + I18NMessage.get(DocumentImporter.class, "DocumentImporter.label27", "\u7684\u5185\u5bb9\u5931\u8d25!"), wCMException);
        }
        return document;
    }

    private void processExternalFileIfNecessary(Document document, String string) throws WCMException {
        if (40 != document.getType()) {
            return;
        }
        String string2 = document.getPropertyAsString("DOCFILENAME");
        if (CMyString.isEmpty(string2)) {
            return;
        }
        if (!CMyFile.fileExists(string + string2)) {
            throw new WCMException(1100, I18NMessage.get(DocumentImporter.class, "DocumentImporter.label28", "\u5bfc\u5165\u7684\u662f\u5916\u90e8\u6587\u4ef6\u578b\u6587\u6863,\u4f46\u5916\u90e8\u6587\u4ef6\u4e0d\u5b58\u5728!"));
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String string3 = filesMan.getNextFileName("U0", CMyFile.extractFileExt(string2), null, true);
        try {
            CMyFile.copyFile(string + string2, string3);
        }
        catch (CMyException cMyException) {
            throw new WCMException(1100, I18NMessage.get(DocumentImporter.class, "DocumentImporter.label29", "\u5bfc\u5165\u5916\u90e8\u6587\u4ef6\u578b\u6587\u6863,\u5916\u90e8\u6587\u4ef6\u5bfc\u5165\u5931\u8d25!"), cMyException);
        }
        document.setProperty("DOCFILENAME", CMyFile.extractFileName(string3));
    }

    private HashMap getPicFiles(Document document, String string) throws WCMException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = this.getTagNames();
        if (stringArray == null) {
            return hashMap;
        }
        String[] stringArray2 = this.getTagAttrsrcNames();
        String string2 = document.getHtmlContent();
        HtmlElementFinder htmlElementFinder = null;
        HtmlElement htmlElement = null;
        try {
            for (int i = 0; i < stringArray.length && i < stringArray2.length; ++i) {
                String string3 = stringArray[i];
                String string4 = stringArray2[i];
                htmlElementFinder = new HtmlElementFinder(string2);
                while ((htmlElement = htmlElementFinder.findNextElement(string3, true)) != null) {
                    String string5 = htmlElement.getAttributeValue(string4);
                    if (CMyString.isEmpty(string5)) continue;
                    if (File.separatorChar != '/') {
                        string5 = CMyString.replaceStr(string5, "/", File.separator);
                    }
                    if (!DocumentImporter.isNeedDownload(htmlElement, string5)) continue;
                    string5 = CMyFile.extractFileName(string5);
                    hashMap.put(string5.toLowerCase(), string + string5);
                }
            }
            return hashMap;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(DocumentImporter.class, "DocumentImporter.label30", "\u83b7\u53d6\u6b63\u6587\u4e2d\u9700\u8981\u5904\u7406\u7684\u7f6e\u6807\u8d44\u6e90\u5931\u8d25!"), exception);
        }
    }

    private String[] getTagNames() {
        if (HTML_TAG_NAMES != null) {
            return HTML_TAG_NAMES;
        }
        ConfigServer configServer = ConfigServer.getServer();
        String string = configServer.getInitProperty("DOC_HTML_TAG_NAMES");
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            HTML_TAG_NAMES = CMyString.split(string, ",");
        }
        catch (Exception exception) {
            HTML_TAG_NAMES = null;
        }
        return HTML_TAG_NAMES;
    }

    private String[] getTagAttrsrcNames() {
        if (HTML_TAG_SRCS != null) {
            return HTML_TAG_SRCS;
        }
        ConfigServer configServer = ConfigServer.getServer();
        String string = configServer.getInitProperty("DOC_HTML_TAG_SRCS");
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            HTML_TAG_SRCS = CMyString.split(string, ",");
        }
        catch (Exception exception) {
            HTML_TAG_SRCS = null;
        }
        return HTML_TAG_SRCS;
    }

    private void processAppendix(XmlObject xmlObject, int n, String string) throws WCMException {
        int n2;
        User user = this.getLoginUser();
        XmlObject[] xmlObjectArray = xmlObject.getChild(CHILD_TAG_APPENDIXES);
        if (xmlObjectArray.length == 0) {
            return;
        }
        Appendix appendix = null;
        String string2 = null;
        String string3 = null;
        FilesMan filesMan = FilesMan.getFilesMan();
        String string4 = string;
        boolean bl = false;
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            boolean bl2;
            String string5;
            appendix = (Appendix)xmlObjectArray[i].getCurrentObj();
            appendix.setDocId(n);
            n2 = appendix.getFlag();
            if (n2 != 40) {
                if (n2 == 30) continue;
                appendix.setSrcFile(appendix.getFile());
                string5 = appendix.getDesc();
                if (string5 == null || string5.length() == 0) {
                    appendix.setDesc(appendix.getFile());
                }
                string2 = n2 == 20 ? filesMan.getNextFileName("W0", appendix.getFileExt()) : filesMan.getNextFileName("P0", appendix.getFileExt());
                string3 = filesMan.mapFilePath(string2, 0);
                try {
                    CMyFile.copyFile(string4 + appendix.getFile(), string3 + string2);
                }
                catch (CMyException cMyException) {
                    s_logger.error((Object)("Exception to copy file![SrcFile=" + string4 + appendix.getFile() + ", DstFile=" + string3 + string2 + "]"), (Throwable)cMyException);
                    continue;
                }
                appendix.setFile(string2);
            }
            appendix.setUsedByVersion(1, true);
            appendix.save(user);
            if (bl || n2 != 20 && n2 != 30) continue;
            string5 = ConfigServer.getServer().getSysConfigValue("DOCPICAPPENDIX_VALID_MIN_LIMIT", "0,0");
            int[] nArray = CMyString.splitToInt(string5, ",");
            bl = bl2 = CMyFile.validImageFile(string3 + string2, nArray[0], nArray[1]);
        }
        Document document = Document.findById(n);
        n2 = document.hasImgInDocContent();
        if (n2 != 0 && !bl) {
            document.setAttachPic(2);
        } else if (n2 == 0 && bl) {
            document.setAttachPic(1);
        } else if (n2 != 0 && bl) {
            document.setAttachPic(3);
        } else {
            document.setAttachPic(0);
        }
        document.validCanEditAndLock(user);
        document.save(user);
    }

    public Reports getImportReports() {
        return this.m_importReports;
    }

    public static File[] getExistedXslFiles(User user) throws WCMException {
        DocumentImporter.assertNotNull(user);
        String string = DocumentImporter.getMyDocumentImportSourceFilePath(user);
        File[] fileArray = CMyFile.listFiles(string, "xsl");
        if (fileArray == null) {
            return new File[0];
        }
        return fileArray;
    }

    public static File[] getExistedMapingFiles(User user) throws WCMException {
        DocumentImporter.assertNotNull(user);
        String string = DocumentImporter.getMyDocumentImportSourceFilePath(user);
        File[] fileArray = CMyFile.listFiles(string, FILEEXT_XML);
        if (fileArray == null) {
            return new File[0];
        }
        return fileArray;
    }

    public static String getMyDocumentImportSourceFilePath(User user) throws WCMException {
        DocumentImporter.assertNotNull(user);
        String string = DocumentImporter.getImportsrcPath() + DocumentImporter.makePath(user);
        if (!CMyFile.pathExists(string)) {
            CMyFile.makeDir(string, true);
        }
        return string;
    }

    private static void assertNotNull(User user) throws WCMException {
        if (user == null) {
            throw new WCMException(10, I18NMessage.get(DocumentImporter.class, "DocumentImporter.label31", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61!"));
        }
    }

    private static String makePath(User user) {
        return user.getId() + File.separator;
    }

    private String getXslFileFullName(User user, String string) throws WCMException {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        if (CMyFile.fileExists(string)) {
            return string;
        }
        return DocumentImporter.getMyDocumentImportSourceFilePath(user) + string;
    }

    private static boolean isNeedDownload(HtmlElement htmlElement, String string) {
        char c = string.charAt(string.length() - 1);
        if (c == '/' || c == '\\') {
            return false;
        }
        boolean bl = true;
        if (htmlElement.getName().equalsIgnoreCase("A")) {
            bl = htmlElement.getAttribute("NeedDownload") != null && !DocumentImporter.isHTMLContent(string);
            htmlElement.removeAttribute("NeedDownload");
        }
        return bl;
    }

    private static boolean isHTMLContent(String string) {
        String string2 = CMyFile.extractFileExt(string).toLowerCase();
        if (string2.indexOf(FILEEXT_HTM) >= 0) {
            return true;
        }
        if (string2.indexOf("asp") >= 0) {
            return true;
        }
        if (string2.indexOf("jsp") >= 0) {
            return true;
        }
        return string2.indexOf("php") >= 0;
    }

    static {
        HTML_TAG_NAMES = null;
        HTML_TAG_SRCS = null;
        implementors = null;
    }
}

