/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.ExtendedField;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ContentExtField;
import com.trs.components.wcm.content.persistent.ContentExtFields;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.DocumentXmlConverter;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.resource.Securities;
import com.trs.components.wcm.resource.Sources;
import com.trs.components.wcm.resource.Statuses;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverter;
import com.trs.infra.persistent.ObjToXmlConverter;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyZip;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class DocumentExporter {
    private static final String TRSWCM_EXPORTDOCUMENTS_HOLDER = "${TRSWCM_EXPORTDOCUMENTS}";
    private static final String FILE_ENCODING = "UTF-8";
    private static final String HTMFILE_DOCUMENT_VIEW_SRC = "document_view.htm";
    public static final String HTMFILE_DOCUMENT_VIEW_EXPORT = "trs_wcm_viewer_doview.htm";
    private static final String HTMFILE_DOCUMENT_LIST_SRC = "document_list.htm";
    public static final String HTMFILE_DOCUMENT_LIST_EXPORT = "trs_wcm_viewer_index.htm";
    public static final String RESOURCE_XML = "resource.xml";
    public static final String REFERENCE_XML = "reference.xml";
    private DocumentXmlConverter m_docconverter = new DocumentXmlConverter();
    private static Logger s_logger = Logger.getLogger(DocumentExporter.class);
    protected static ObjToXmlConverter m_converter = new ObjToXmlConverter();
    private static String FILE_CONTENT_LIST;
    private static String FILE_CONTENT_VIEW;
    private static String EXPORTSRC_PATH;
    private static String EXPORTRESOURCE_PATH;
    private static final BaseObj RESOURCE;

    public String export(int n, String string, boolean bl) throws WCMException {
        Documents documents = Documents.findByIds(this.getLoginUser(), String.valueOf(n));
        if (documents == null) {
            throw new WCMException(200006, I18NMessage.get(DocumentExporter.class, "DocumentExporter.label1", "\u6ca1\u6709\u627e\u5230\u6587\u6863,id[") + n + "]!");
        }
        return this.export(documents, string, bl);
    }

    public String export(Document document, String string, boolean bl) throws WCMException {
        if (document == null) {
            throw new WCMException(10, I18NMessage.get(DocumentExporter.class, "DocumentExporter.label2", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61,\u65e0\u6cd5\u5bfc\u51fa!"));
        }
        Documents documents = Documents.createNewInstance(this.getLoginUser());
        documents.addElement(document);
        return this.export(documents, string, bl);
    }

    public String export(String string, String string2, boolean bl) throws WCMException {
        Documents documents = Documents.findByIds(this.getLoginUser(), string);
        if (documents == null || documents.isEmpty()) {
            throw new WCMException(200006, I18NMessage.get(DocumentExporter.class, "DocumentExporter.label3", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6587\u6863!ID:[") + string + "]");
        }
        return this.export(documents, string2, bl);
    }

    public String export(Documents documents, String string, boolean bl) throws WCMException {
        if (documents == null || documents.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(DocumentExporter.class, "DocumentExporter.label4", "\u6ca1\u6709\u6307\u5b9a\u8981\u5bfc\u51fa\u7684\u6587\u6863!"));
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String string2 = filesMan.getNextFileName("ST", "xml", null, true);
        this.m_docconverter.setWithAppendix(bl);
        this.m_docconverter.toXMLFile(documents, string2, null, string);
        String string3 = filesMan.getNextFileName("ST", "zip", null, true);
        CMyZip cMyZip = new CMyZip();
        try {
            try {
                cMyZip.setZipFileName(string3);
                cMyZip.addToZip(string2, false);
            }
            catch (CMyException cMyException) {
                throw new WCMException(54, I18NMessage.get(DocumentExporter.class, "DocumentExporter.label5", "\u521b\u5efaZip\u6587\u4ef6\u5931\u8d25!"), cMyException);
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            CMyFile.deleteFile(string2);
            throw throwable;
        }
        CMyFile.deleteFile(string2);
        try {
            cMyZip = this.exportRelateFiles(cMyZip, documents, bl);
        }
        catch (CMyException cMyException) {
            throw new WCMException(1100, I18NMessage.get(DocumentExporter.class, "DocumentExporter.label6", "\u6dfb\u52a0\u6587\u6863\u76f8\u5173\u8d44\u6e90\u6587\u4ef6\u5230zip\u6587\u4ef6\u4e2d\u5931\u8d25!"), cMyException);
        }
        try {
            this.exportResourcesForOffLineView(cMyZip, documents, string2);
            cMyZip.done();
        }
        catch (CMyException cMyException) {
            throw new WCMException(1100, I18NMessage.get(DocumentExporter.class, "DocumentExporter.label7", "\u6dfb\u52a0\u79bb\u7ebf\u6d4f\u8d44\u6e90\u6587\u4ef6\u5230zip\u6587\u4ef6\u5931\u8d25!"), cMyException);
        }
        return CMyFile.extractFileName(string3);
    }

    private CMyZip exportRelateFiles(CMyZip cMyZip, Documents documents, boolean bl) throws WCMException, CMyException {
        AppendixMgr appendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        Document document = null;
        Appendixes appendixes = null;
        for (int i = 0; i < documents.size(); ++i) {
            document = (Document)documents.getAt(i);
            if (document == null) continue;
            if (bl) {
                appendixes = appendixMgr.getAppendixes(document, 50);
                cMyZip = this.exportAppendixes(cMyZip, appendixes);
            }
            this.exportExternalFileIfNecessary(cMyZip, document);
            if (document.getType() != 20 && document.getPropertyAsInt("DocFlag", 0) <= 0) continue;
            cMyZip = this.processPicFiles(document, cMyZip);
        }
        return cMyZip;
    }

    private void exportExternalFileIfNecessary(CMyZip cMyZip, Document document) throws CMyException {
        if (40 != document.getType()) {
            return;
        }
        String string = document.getPropertyAsString("DOCFILENAME");
        if (string == null || (string = string.trim()).length() == 0) {
            return;
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String string2 = filesMan.mapFilePath(string, 0) + string;
        if (CMyFile.fileExists(string2)) {
            cMyZip.addToZip(string2, false);
        }
    }

    private CMyZip processPicFiles(Document document, CMyZip cMyZip) throws CMyException {
        FilesMan filesMan = FilesMan.getFilesMan();
        List list = document.getHTMLWCMFiles();
        String string = null;
        for (int i = 0; i < list.size(); ++i) {
            string = (String)list.get(i);
            if (!CMyFile.fileExists(string = filesMan.mapFilePath(string, 0) + string)) continue;
            cMyZip.addToZip(string, false);
        }
        return cMyZip;
    }

    private CMyZip exportAppendixes(CMyZip cMyZip, Appendixes appendixes) throws WCMException, CMyException {
        FilesMan filesMan = FilesMan.getFilesMan();
        Appendix appendix = null;
        String string = null;
        for (int i = 0; i < appendixes.size(); ++i) {
            appendix = (Appendix)appendixes.getAt(i);
            if (appendix == null || appendix.getFlag() == 40) continue;
            string = filesMan.mapFilePath(appendix.getFile(), 0) + appendix.getFile();
            if (!CMyFile.fileExists(string)) {
                s_logger.warn((Object)("missing the appendix file:" + string));
                continue;
            }
            cMyZip.addToZip(string, false);
        }
        return cMyZip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportResourcesForOffLineView(CMyZip cMyZip, Documents documents, String string) throws CMyException {
        if (EXPORTSRC_PATH == null) {
            this.initExportHtmFileContent();
        }
        ResourceXmlConverter resourceXmlConverter = new ResourceXmlConverter(documents);
        String string2 = EXPORTSRC_PATH + "viewer" + File.separator + RESOURCE_XML;
        try {
            resourceXmlConverter.toXMLFile(RESOURCE, string2);
            this.updateHtmlFile(string);
            cMyZip.setZipWithChildDirPath(true);
            cMyZip.addToZip(EXPORTSRC_PATH, false);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            CMyFile.deleteFile(string2);
            throw throwable;
        }
        CMyFile.deleteFile(string2);
    }

    private synchronized void initExportHtmFileContent() {
        try {
            EXPORTRESOURCE_PATH = FilesMan.getFilesMan().getPathConfigValue("DS", 0) + "exportresource" + File.separator;
            EXPORTSRC_PATH = EXPORTRESOURCE_PATH + "exportsrc" + File.separator;
            String string = EXPORTRESOURCE_PATH + HTMFILE_DOCUMENT_LIST_SRC;
            FILE_CONTENT_LIST = CMyFile.readFile(string, FILE_ENCODING);
            String string2 = EXPORTRESOURCE_PATH + HTMFILE_DOCUMENT_VIEW_SRC;
            FILE_CONTENT_VIEW = CMyFile.readFile(string2, FILE_ENCODING);
        }
        catch (CMyException cMyException) {
            throw new RuntimeException(cMyException);
        }
    }

    private void updateHtmlFile(String string) throws CMyException {
        String string2 = CMyFile.extractFileName(string);
        String string3 = EXPORTSRC_PATH + HTMFILE_DOCUMENT_LIST_EXPORT;
        String string4 = CMyString.replaceStr(FILE_CONTENT_LIST, TRSWCM_EXPORTDOCUMENTS_HOLDER, string2);
        CMyFile.writeFile(string3, string4, FILE_ENCODING);
        String string5 = EXPORTSRC_PATH + HTMFILE_DOCUMENT_VIEW_EXPORT;
        String string6 = CMyString.replaceStr(FILE_CONTENT_VIEW, TRSWCM_EXPORTDOCUMENTS_HOLDER, string2);
        CMyFile.writeFile(string5, string6, FILE_ENCODING);
    }

    protected User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    static {
        RESOURCE = new BaseObj(){

            public int getWCMType() {
                return -2;
            }

            public String getDbTableName() {
                return "RESOURCE";
            }

            public String getIdFieldName() {
                return "RESOURCEID";
            }

            public boolean isValid() {
                return false;
            }
        };
        RESOURCE.setProperties(new Hashtable());
    }

    protected class NullBaseObj
    extends BaseObj {
        private String DB_TABLE_NAME = null;

        protected NullBaseObj() {
        }

        public int getWCMType() {
            return -1;
        }

        public String getDbTableName() {
            return this.DB_TABLE_NAME;
        }

        public String getIdFieldName() {
            return null;
        }

        public boolean isValid() {
            return false;
        }

        public void setDbTableName(String string) {
            this.DB_TABLE_NAME = string;
        }
    }

    private class ResourceXmlConverter
    extends BaseObjToXmlConverter {
        private String m_sChannelIds = null;
        private User m_user = null;
        private Documents m_oDocuments;
        private Map m_oContext = null;

        public ResourceXmlConverter(Documents documents) {
            this.m_oDocuments = documents;
            this.m_user = DocumentExporter.this.getLoginUser();
        }

        private void buildContext() throws WCMException {
            if (this.m_oContext != null) {
                return;
            }
            this.m_oContext = new HashMap();
            Channels channels = Channels.createNewInstance(this.m_user);
            Statuses statuses = Statuses.createNewInstance(this.m_user);
            Sources sources = Sources.createNewInstance(this.m_user);
            Securities securities = Securities.createNewInstance(this.m_user);
            int n = this.m_oDocuments.size();
            for (int i = 0; i < n; ++i) {
                int n2;
                Document document = (Document)this.m_oDocuments.getAt(i);
                if (document == null) continue;
                channels.addElement(document.getChannelId());
                statuses.addElement(document.getStatusId());
                int n3 = document.getSourceId();
                if (n3 > 0) {
                    sources.addElement(n3);
                }
                if ((n2 = document.getSecurityId()) <= 0) continue;
                securities.addElement(n2);
            }
            this.m_oContext.put("channels", channels);
            this.m_oContext.put("statuses", statuses);
            this.m_oContext.put("sources", sources);
            this.m_oContext.put("securities", securities);
        }

        protected Element[] getChildElement(BaseObj baseObj) throws WCMException {
            Element[] elementArray = new Element[]{this.getChannelsEl(), this.getStatusesEl(), this.getDocSourcesEl(), this.getDocSecuritiesEl(), this.getExtFieldsEl()};
            return elementArray;
        }

        private Element getChannelsEl() throws WCMException {
            this.buildContext();
            String string = "ChannelId,ChnlName,ChnlDesc";
            Channels channels = (Channels)this.m_oContext.get("channels");
            this.setChannelIds(channels.getIdListAsString());
            return m_converter.toXmlElement(channels, string);
        }

        private void setChannelIds(String string) {
            this.m_sChannelIds = string;
        }

        private Element getStatusesEl() throws WCMException {
            this.buildContext();
            String string = "StatusId,SName,SDesc,SDisp";
            Statuses statuses = (Statuses)this.m_oContext.get("statuses");
            return m_converter.toXmlElement(statuses, string);
        }

        private Element getDocSourcesEl() throws WCMException {
            this.buildContext();
            String string = "SourceId,SrcName";
            Sources sources = (Sources)this.m_oContext.get("sources");
            return m_converter.toXmlElement(sources, string);
        }

        private Element getDocSecuritiesEl() throws WCMException {
            this.buildContext();
            String string = "SecurityId,SName";
            Securities securities = (Securities)this.m_oContext.get("securities");
            return m_converter.toXmlElement(securities, string);
        }

        private Element getExtFieldsEl() throws WCMException {
            if (this.m_sChannelIds == null) {
                return null;
            }
            String string = "ObjId,EXTFIELDID,LOGICFIELDDESC";
            String string2 = "ObjId IN(" + this.m_sChannelIds + ") AND ObjType=" + 101;
            ContentExtFields contentExtFields = new ContentExtFields(this.m_user);
            WCMFilter wCMFilter = new WCMFilter("", string2, "", string);
            contentExtFields.open(wCMFilter);
            ArrayList<NullBaseObj> arrayList = new ArrayList<NullBaseObj>(contentExtFields.size());
            for (int i = 0; i < contentExtFields.size(); ++i) {
                ContentExtField contentExtField = (ContentExtField)contentExtFields.getAt(i);
                if (contentExtField == null) continue;
                NullBaseObj nullBaseObj = new NullBaseObj();
                nullBaseObj.setDbTableName("DOCEXTENDEDFIELD");
                Hashtable<String, String> hashtable = new Hashtable<String, String>(3);
                hashtable.put("DOCCHANNEL", String.valueOf(contentExtField.getObjId()));
                ExtendedField extendedField = ExtendedField.findById(contentExtField.getExtFieldId());
                String string3 = extendedField.getName();
                hashtable.put("REALFIELD", string3);
                hashtable.put("LOGICFIELDDESC", CMyString.showNull(contentExtField.getDesc(), string3));
                hashtable.put("FIELDTYPE", CMyString.showNull(extendedField.getAttributeValue("FIELDTYPE")));
                hashtable.put("ENMVALUE", CMyString.showNull(extendedField.getAttributeValue("ENMVALUE")));
                nullBaseObj.setProperties(hashtable);
                arrayList.add(nullBaseObj);
            }
            return m_converter.toXmlElement(arrayList, null);
        }
    }
}

