/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.job.BaseScheduleWorker;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import org.apache.log4j.Logger;

public class DocPriDisableWorker
extends BaseScheduleWorker {
    private static Logger m_oLogger = Logger.getLogger(DocPriDisableWorker.class);

    protected int getChnlDocId() {
        return Integer.parseInt(this.getArgAsString("CHNLDOCID"));
    }

    protected void execute() {
        ChnlDoc chnlDoc = null;
        boolean bl = true;
        try {
            chnlDoc = ChnlDoc.findById(this.getChnlDocId());
            if (chnlDoc == null) {
                throw new WCMException(10, I18NMessage.get(DocPriDisableWorker.class, "DocPriDisableWorker.label1", "\u65e0\u6cd5\u627e\u5230\u9700\u8981\u64a4\u9500\u7f6e\u9876\u7684\u9891\u9053\u6587\u6863!"));
            }
            User user = User.getSystem();
            try {
                user = ContextHelper.getLoginUser();
            }
            catch (Exception exception) {
                ContextHelper.initContext(user);
            }
            chnlDoc.canEdit(user);
            chnlDoc.setDocTopPriOrder(ChnlDoc.NOT_ON_TOP);
            chnlDoc.save(user);
        }
        catch (WCMException wCMException) {
            m_oLogger.error((Object)"failed to set chnldoc not on top", (Throwable)wCMException);
            bl = false;
        }
        if (bl && chnlDoc != null) {
            try {
                this.refreshPage(chnlDoc.getChannel());
            }
            catch (Exception exception) {
                m_oLogger.warn((Object)"failed to refresh outline page on undocpri.", (Throwable)exception);
            }
        }
    }

    private void refreshPage(Channel channel) throws WCMException {
        if (channel == null) {
            m_oLogger.warn((Object)"no channel to refresh.");
            return;
        }
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
        PublishServer.getInstance().publishFolder(iPublishFolder, 8);
    }
}

