/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.IDepartmentMgr;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.wcm.content.domain.DocumentsGetHelper;
import com.trs.components.wcm.content.domain.IDocumentsTimeRangeMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.resource.DocLevel;
import com.trs.components.wcm.resource.DocLevelMgr;
import com.trs.components.wcm.resource.DocLevels;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import java.io.File;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class DatasWithChnlDocFilterHelper {
    private String m_sRegContainsDataTable = "(?ism).*WCMDOCUMENT.*";
    private static Logger logger = Logger.getLogger(DatasWithChnlDocFilterHelper.class);
    private static IDocumentsTimeRangeMgr m_oTimeRangeMgr = null;
    private IMetaViewEmployerMgr m_oMetaViewEmployerMgr = null;
    private String m_sTableName = "WCMDOCUMENT";
    private String m_sIdFieldName = "DOCID";
    private boolean m_bNeedWithAuthFilter = false;
    private User m_oLoginUser = null;
    private int m_nRightIndex = 34;

    public DatasWithChnlDocFilterHelper() {
        this.m_oLoginUser = ContextHelper.getLoginUser();
    }

    public DatasWithChnlDocFilterHelper(String string, String string2) {
        this.m_sTableName = string.toUpperCase();
        this.m_sIdFieldName = string2;
        this.m_sRegContainsDataTable = "(?ism).*" + this.m_sTableName + ".*";
        this.m_oLoginUser = ContextHelper.getLoginUser();
    }

    public WCMFilter makeChannelFilter(Channel channel, WCMFilter wCMFilter) throws WCMException {
        return this.makeChannelFilter(channel, wCMFilter, false, false);
    }

    public WCMFilter makeChannelFilter(Channel channel, WCMFilter wCMFilter, boolean bl, boolean bl2) throws WCMException {
        String string;
        String string2;
        MetaView metaView;
        if (m_oTimeRangeMgr == null) {
            m_oTimeRangeMgr = (IDocumentsTimeRangeMgr)DreamFactory.createObjectById("IDocumentsTimeRangeMgr");
        }
        if (this.m_oMetaViewEmployerMgr == null) {
            this.m_oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
        }
        if ((metaView = this.m_oMetaViewEmployerMgr.getViewOfEmployer(channel)) != null) {
            this.m_sTableName = !metaView.isMultiTable() ? MetaDataConstants.makeTrueTableName(metaView.getName()) : metaView.getName();
            this.m_sIdFieldName = "MetaDataId";
            this.m_sRegContainsDataTable = "(?ism).*" + this.m_sTableName + ".*";
        }
        if (this.isQueryInDocument(wCMFilter, channel)) {
            return this.makeChannelFilterWithJoin(channel, wCMFilter, bl, bl2);
        }
        WCMFilter wCMFilter2 = new WCMFilter("WCMCHNLDOC", null, null);
        StringBuffer stringBuffer = new StringBuffer();
        if (!channel.isOnlySearch()) {
            stringBuffer.append("CHNLID=?");
            wCMFilter2.addSearchValues(channel.getId());
        }
        if (!CMyString.isEmpty(string2 = channel.getQuery())) {
            stringBuffer.append(stringBuffer.length() > 0 ? " and (" : "(");
            stringBuffer.append(string2);
            stringBuffer.append(')');
        }
        if (this.m_bNeedWithAuthFilter) {
            boolean bl3 = AuthServer.hasRight(this.m_oLoginUser, (CMSObj)channel, this.m_nRightIndex);
            if (bl3) {
                if (!this.m_oLoginUser.isAdministrator() && !channel.getCrUserName().equalsIgnoreCase(this.m_oLoginUser.getName()) && channel.isUseDocLevel()) {
                    this.makeDocLevelWhere(wCMFilter2, stringBuffer);
                }
            } else {
                stringBuffer.append(" and CrUser=?");
                wCMFilter2.addSearchValues(this.m_oLoginUser.getName());
            }
        }
        String string3 = stringBuffer.toString();
        stringBuffer.setLength(0);
        String string4 = string3.toUpperCase();
        if (string4.indexOf("SRCCHNLID=0") >= 0) {
            string3 = string4 = CMyString.replaceStr(string4, "SRCCHNLID=0", "MODAL=1");
        }
        if (string4.indexOf("WCMDOCUMENT.DOCID=WCMCHNLDOC.DOCID") >= 0) {
            string3 = string4 = CMyString.replaceStr(string4, "WCMDOCUMENT.DOCID=WCMCHNLDOC.DOCID", "1=1");
        }
        String string5 = null;
        if (wCMFilter != null && wCMFilter.getWhere() != null && (string5 = wCMFilter.getWhere().trim().toUpperCase()).length() == 0) {
            string5 = null;
        }
        if ((string5 == null || string5.indexOf("DOCSTATUS") < 0) && string4.indexOf("DOCSTATUS") < 0) {
            stringBuffer.append(bl2 ? " (WCMChnlDoc.DOCSTATUS<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : " WCMChnlDoc.DOCSTATUS>0 and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        } else {
            stringBuffer.append(bl2 ? " (WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : " WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        }
        if ((string5 == null || string5.indexOf("CHNLID") < 0) && string4.indexOf("CHNLID") < 0) {
            stringBuffer.append(bl2 ? "" : " and WCMChnlDoc.CHNLID>0");
        }
        string3 = string3 + " AND (" + stringBuffer.toString() + ")";
        if (bl) {
            string = channel.getOrderBy();
            if (!(string != null && string.trim().length() != 0 || (string = channel.getSite().getOrderBy()) != null && string.trim().length() != 0)) {
                string = "WCMChnlDoc.DOCORDERPRI desc, WCMChnlDoc.DocOrder desc";
            }
        } else {
            string = "";
        }
        wCMFilter2.setWhere(string3);
        wCMFilter2.setOrder(string);
        wCMFilter2.mergeWith(wCMFilter);
        CMyDateTime cMyDateTime = m_oTimeRangeMgr.getStartDateTime(channel.getId());
        if (cMyDateTime != null) {
            string3 = wCMFilter2.getWhere();
            if (string3.length() > 0) {
                string3 = string3 + " and ";
            }
            string3 = string3 + "CrTime >= ?";
            wCMFilter2.setWhere(string3);
            int n = 0;
            if (wCMFilter2.getSearchValues() != null) {
                n = wCMFilter2.getSearchValues().size();
            }
            wCMFilter2.addSearchValues(n, cMyDateTime);
        }
        wCMFilter2.mergeWith(this.makeDeptFilter(channel));
        return wCMFilter2;
    }

    private WCMFilter makeChannelFilterWithJoin(Channel channel, WCMFilter wCMFilter, boolean bl, boolean bl2) throws WCMException {
        Cloneable cloneable;
        String string;
        String string2;
        WCMFilter wCMFilter2 = new WCMFilter("WCMCHNLDOC," + this.m_sTableName, null, null);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WCMChnlDoc.DocId=" + this.m_sTableName + "." + this.m_sIdFieldName);
        if (!channel.isOnlySearch()) {
            stringBuffer.append(" and WCMChnlDoc.CHNLID=?");
            wCMFilter2.addSearchValues(channel.getId());
        }
        if (!CMyString.isEmpty(string2 = channel.getQuery())) {
            stringBuffer.append(" AND (").append(string2).append(')');
        }
        if (this.m_bNeedWithAuthFilter) {
            boolean bl3 = AuthServer.hasRight(this.m_oLoginUser, (CMSObj)channel, this.m_nRightIndex);
            if (bl3) {
                if (!this.m_oLoginUser.isAdministrator() && !channel.getCrUserName().equalsIgnoreCase(this.m_oLoginUser.getName()) && channel.isUseDocLevel()) {
                    this.makeDocLevelWhere(wCMFilter2, stringBuffer);
                }
            } else {
                stringBuffer.append(" and WCMChnlDoc.CrUser=?");
                wCMFilter2.addSearchValues(this.m_oLoginUser.getName());
            }
        }
        String string3 = stringBuffer.toString();
        stringBuffer.setLength(0);
        String string4 = string3.toUpperCase();
        if (string4.indexOf("SRCCHNLID=0") >= 0) {
            string3 = string4 = CMyString.replaceStr(string4, "SRCCHNLID=0", "MODAL=1");
        }
        String string5 = null;
        if (wCMFilter != null && wCMFilter.getWhere() != null && (string5 = wCMFilter.getWhere().trim().toUpperCase()).length() == 0) {
            string5 = null;
        }
        if ((string5 == null || string5.indexOf("DOCSTATUS") < 0) && string4.indexOf("DOCSTATUS") < 0) {
            stringBuffer.append(bl2 ? " ( WCMChnlDoc.DOCSTATUS<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : " WCMChnlDoc.DOCSTATUS>0 and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        } else {
            stringBuffer.append(bl2 ? "( WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : "WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        }
        if ((string5 == null || string5.indexOf("CHNLID") < 0) && string4.indexOf("CHNLID") < 0) {
            stringBuffer.append(bl2 ? "" : " and WCMChnlDoc.CHNLID>0");
        }
        string3 = string3 + " AND (" + stringBuffer.toString() + ")";
        if (bl) {
            string = channel.getOrderBy();
            if (!(string != null && string.trim().length() != 0 || (cloneable = channel.getSite()) != null && (string = cloneable.getOrderBy()) != null && string.trim().length() != 0)) {
                string = "WCMChnlDoc.DOCORDERPRI desc, WCMChnlDoc.DocOrder desc";
            }
        } else {
            string = "";
        }
        wCMFilter2.setWhere(string3);
        wCMFilter2.setOrder(string);
        wCMFilter2.mergeWith(wCMFilter);
        cloneable = m_oTimeRangeMgr.getStartDateTime(channel.getId());
        if (cloneable != null) {
            string3 = wCMFilter2.getWhere();
            if (string3.length() > 0) {
                string3 = string3 + " and ";
            }
            string3 = string3 + this.m_sTableName + ".CrTime >= ?";
            wCMFilter2.setWhere(string3);
            wCMFilter2.addSearchValues((CMyDateTime)cloneable);
        }
        return wCMFilter2;
    }

    public WCMFilter makeFilter(WebSite webSite, WCMFilter wCMFilter, boolean bl, boolean bl2) {
        CMyDateTime cMyDateTime;
        if (this.isQueryInDocument(wCMFilter, null)) {
            return this.makeFilterWithJoin(webSite, wCMFilter, bl, bl2);
        }
        String string = "WCMChnlDoc.CHNLID=WCMChannel.ChannelId";
        if (bl2) {
            string = "(WCMChnlDoc.CHNLID=WCMChannel.ChannelId or WCMChnlDoc.CHNLID=-WCMChannel.ChannelId)";
            try {
                if (DBManager.getDBManager().getTableInfo("WCMCHNLDOC").getFieldInfo("POSCHNLID") != null) {
                    string = "(WCMChnlDoc.POSCHNLID=WCMChannel.ChannelId)";
                }
            }
            catch (WCMException wCMException) {
                logger.warn((Object)"WCMCHNLDOC\u8868\u4e2d\u4e0d\u5b58\u5728\u5b57\u6bb5POSCHNLID");
            }
        }
        WCMFilter wCMFilter2 = new WCMFilter("WCMCHNLDOC", null, null);
        String string2 = "exists(Select WCMChannel.ChannelId from WCMChannel where " + string + " and Status>=0 and SiteId=?)";
        String string3 = null;
        if (wCMFilter != null && wCMFilter.getWhere() != null && (string3 = wCMFilter.getWhere().trim().toUpperCase()).length() == 0) {
            string3 = null;
        }
        StringBuffer stringBuffer = new StringBuffer(string2.length() + 40);
        stringBuffer.append(string2);
        if (string3 == null || string3.indexOf("DOCSTATUS") < 0) {
            stringBuffer.append(bl2 ? " and (WCMChnlDoc.DocStatus<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0 or WCMChnlDoc.ChnlId<0)" : " and WCMChnlDoc.DOCSTATUS>0 and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        } else {
            stringBuffer.append(bl2 ? " and (WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0 or WCMChnlDoc.ChnlId<0)" : " and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        }
        wCMFilter2.setWhere(stringBuffer.toString());
        wCMFilter2.addSearchValues(webSite.getId());
        String string4 = bl ? "WCMChnlDoc.CrTime Desc" : "";
        wCMFilter2.setOrder(string4);
        wCMFilter2.mergeWith(wCMFilter);
        if (m_oTimeRangeMgr == null) {
            m_oTimeRangeMgr = (IDocumentsTimeRangeMgr)DreamFactory.createObjectById("IDocumentsTimeRangeMgr");
        }
        if ((cMyDateTime = m_oTimeRangeMgr.getStartDateTime(webSite.getId(), 103)) != null) {
            string2 = wCMFilter2.getWhere();
            if (string2.length() > 0) {
                string2 = string2 + " and ";
            }
            string2 = string2 + "WCMChnlDoc.CrTime >= ?";
            wCMFilter2.setWhere(string2);
            wCMFilter2.addSearchValues(cMyDateTime);
        }
        return wCMFilter2;
    }

    private WCMFilter makeFilterWithJoin(WebSite webSite, WCMFilter wCMFilter, boolean bl, boolean bl2) {
        CMyDateTime cMyDateTime;
        WCMFilter wCMFilter2 = new WCMFilter("WCMCHNLDOC," + this.m_sTableName, null, null);
        String string = "exists(Select WCMChannel.ChannelId from WCMChannel where " + (bl2 ? "(WCMChnlDoc.CHNLID=WCMChannel.ChannelId or WCMChnlDoc.CHNLID=-WCMChannel.ChannelId)" : "WCMChnlDoc.CHNLID=WCMChannel.ChannelId") + " and SiteId=?)" + " and WCMChnlDoc.DocId=" + this.m_sTableName + "." + this.m_sIdFieldName;
        String string2 = null;
        if (wCMFilter != null && wCMFilter.getWhere() != null && (string2 = wCMFilter.getWhere().trim().toUpperCase()).length() == 0) {
            string2 = null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 40);
        stringBuffer.append(string);
        if (string2 == null || string2.indexOf("DOCSTATUS") < 0) {
            stringBuffer.append(bl2 ? " and (WCMChnlDoc.DOCSTATUS<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0 or WCMChnlDoc.ChnlId<0)" : " and WCMChnlDoc.DOCSTATUS>0 and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        } else {
            stringBuffer.append(bl2 ? " and (WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0 or WCMChnlDoc.ChnlId<0)" : " and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        }
        wCMFilter2.setWhere(stringBuffer.toString());
        wCMFilter2.addSearchValues(webSite.getId());
        String string3 = bl ? "WCMChnlDoc.CrTime Desc" : "";
        wCMFilter2.setOrder(string3);
        wCMFilter2.mergeWith(wCMFilter);
        if (m_oTimeRangeMgr == null) {
            m_oTimeRangeMgr = (IDocumentsTimeRangeMgr)DreamFactory.createObjectById("IDocumentsTimeRangeMgr");
        }
        if ((cMyDateTime = m_oTimeRangeMgr.getStartDateTime(webSite.getId(), 103)) != null) {
            string = wCMFilter2.getWhere();
            if (string.length() > 0) {
                string = string + " and ";
            }
            string = string + "WCMChnlDoc.CrTime >= ?";
            wCMFilter2.setWhere(string);
            wCMFilter2.addSearchValues(cMyDateTime);
        }
        return wCMFilter2;
    }

    public WCMFilter makeFilter(WebSites webSites, WCMFilter wCMFilter, boolean bl, boolean bl2) {
        if (webSites == null || webSites.isEmpty()) {
            return null;
        }
        if (webSites.size() == 1) {
            return this.makeFilter((WebSite)webSites.getAt(0), wCMFilter, bl, bl2);
        }
        if (this.isQueryInDocument(wCMFilter, null)) {
            return this.makeFilterWithJoin(webSites, wCMFilter, bl, bl2);
        }
        WCMFilter wCMFilter2 = new WCMFilter("WCMCHNLDOC", null, null);
        StringBuffer stringBuffer = new StringBuffer(300 + webSites.size() * 2);
        stringBuffer.append("exists(Select WCMChannel.ChannelId from WCMChannel where WCMChnlDoc.CHNLID=WCMChannel.ChannelId and Status>=0 and SiteId in(?");
        wCMFilter2.addSearchValues(webSites.getIdAt(0));
        int n = webSites.size();
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(",?");
            wCMFilter2.addSearchValues(webSites.getIdAt(i));
        }
        stringBuffer.append("))");
        stringBuffer.append(bl2 ? " and (WCMChnlDoc.DocChannel<0 or WCMChnlDoc.Modal<0)" : " and WCMChnlDoc.DocChannel>0");
        String string = null;
        if (wCMFilter != null && wCMFilter.getWhere() != null && (string = wCMFilter.getWhere().trim().toUpperCase()).length() == 0) {
            string = null;
        }
        if (string == null || string.indexOf("DOCSTATUS") < 0) {
            stringBuffer.append(bl2 ? " and (WCMChnlDoc.Modal<0 and WCMChnlDoc.DOCSTATUS<0)" : " and (WCMChnlDoc.Modal>0 and WCMChnlDoc.DOCSTATUS>0)");
        }
        wCMFilter2.setWhere(stringBuffer.toString());
        String string2 = bl ? "WCMChnlDoc.CrTime Desc" : "";
        wCMFilter2.setOrder(string2);
        wCMFilter2.mergeWith(wCMFilter);
        return wCMFilter2;
    }

    private WCMFilter makeFilterWithJoin(WebSites webSites, WCMFilter wCMFilter, boolean bl, boolean bl2) {
        WCMFilter wCMFilter2 = new WCMFilter("WCMCHNLDOC," + this.m_sTableName, null, null);
        StringBuffer stringBuffer = new StringBuffer(300 + webSites.size() * 2);
        stringBuffer.append("exists(Select WCMChannel.ChannelId from WCMChannel where WCMChnlDoc.CHNLID=WCMChannel.ChannelId and SiteId in(?");
        wCMFilter2.addSearchValues(webSites.getIdAt(0));
        int n = webSites.size();
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(",?");
            wCMFilter2.addSearchValues(webSites.getIdAt(i));
        }
        stringBuffer.append(")) and WCMChnlDoc.DocId=" + this.m_sTableName + "." + this.m_sIdFieldName);
        String string = null;
        if (wCMFilter != null && wCMFilter.getWhere() != null && (string = wCMFilter.getWhere().trim().toUpperCase()).length() == 0) {
            string = null;
        }
        if (string == null || string.indexOf("DOCSTATUS") < 0) {
            stringBuffer.append(bl2 ? " and (WCMChnlDoc.DOCSTATUS<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : " and WCMChnlDoc.DOCSTATUS>0 and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        } else {
            stringBuffer.append(bl2 ? " and (WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : " and WCMChnlDoc.Modal>0 and WCMChnlDoc.DocChannel>0");
        }
        wCMFilter2.setWhere(stringBuffer.toString());
        String string2 = bl ? "WCMChnlDoc.CrTime Desc" : "";
        wCMFilter2.setOrder(string2);
        wCMFilter2.mergeWith(wCMFilter);
        return wCMFilter2;
    }

    public WCMFilter makeChannelFilter(Channels channels, WCMFilter wCMFilter, boolean bl) throws WCMException {
        if (channels.isEmpty()) {
            return null;
        }
        if (channels.size() == 1) {
            return this.makeChannelFilter((Channel)channels.getAt(0), wCMFilter, true, bl);
        }
        if (this.isQueryInDocument(wCMFilter, null)) {
            return this.makeChannelFilterWithJoin(channels, wCMFilter, bl);
        }
        WCMFilter wCMFilter2 = new WCMFilter("", "", "WCMChnlDoc.CrTime Desc");
        StringBuffer stringBuffer = new StringBuffer(channels.size() * 10 + 16);
        StringBuffer stringBuffer2 = new StringBuffer(channels.size() * 2 + 16);
        StringBuffer stringBuffer3 = new StringBuffer(channels.size() * 2 + 16);
        this.makeChnlIdWhere(channels, wCMFilter2, stringBuffer, stringBuffer2, stringBuffer3);
        String string = bl ? "(WCMChnlDoc.DocStatus<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : "WCMChnlDoc.DocChannel>0 and WCMChnlDoc.DocStatus>0 and WCMChnlDoc.Modal>0";
        StringBuffer stringBuffer4 = new StringBuffer(channels.size() * 2 + string.length() + 16);
        if (stringBuffer2.length() > 0) {
            stringBuffer4.append("(");
            stringBuffer4.append(stringBuffer2);
            stringBuffer4.append(")");
        }
        if (stringBuffer.length() > 0) {
            if (stringBuffer4.length() > 0) {
                stringBuffer4.append(" or ");
            }
            stringBuffer4.append("(");
            stringBuffer4.append(stringBuffer);
            stringBuffer4.append(")");
        }
        if (stringBuffer3.length() > 0) {
            if (stringBuffer4.length() > 0) {
                stringBuffer4.append(" or ");
            }
            stringBuffer4.append("(");
            stringBuffer4.append(stringBuffer3);
            stringBuffer4.append(")");
        }
        stringBuffer4.insert(0, '(').insert(stringBuffer4.length(), ')');
        stringBuffer4.append(" and ");
        stringBuffer4.append(string);
        wCMFilter2.setWhere(stringBuffer4.toString());
        wCMFilter2.mergeWith(wCMFilter);
        wCMFilter2.mergeWith(this.makeDeptFilter(channels));
        return wCMFilter2;
    }

    private void makeChnlIdWhere(Channels channels, WCMFilter wCMFilter, StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) throws WCMException {
        int n;
        int n2 = channels.size();
        if (n2 >= 1000) {
            this.makeChnlIdWhereWithOr(channels, wCMFilter, stringBuffer, stringBuffer2, stringBuffer3);
            return;
        }
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = this.m_oLoginUser.isAdministrator();
        for (n = 0; n < n2; ++n) {
            Channel channel = (Channel)channels.getAt(n);
            if (this.m_bNeedWithAuthFilter) {
                if (!AuthServer.hasRight(this.m_oLoginUser, (CMSObj)channel, this.m_nRightIndex)) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    } else {
                        stringBuffer.append("WCMChnlDoc.ChnlId in(");
                    }
                    stringBuffer.append("?");
                    nArray2[n4++] = channel.getId();
                    continue;
                }
                if (bl || channel.getCrUserName().equalsIgnoreCase(this.m_oLoginUser.getName()) || !channel.isUseDocLevel()) {
                    if (stringBuffer2.length() > 0) {
                        stringBuffer2.append(",");
                    } else {
                        stringBuffer2.append("WCMChnlDoc.ChnlId in(");
                    }
                    stringBuffer2.append("?");
                    nArray[n3++] = channel.getId();
                    continue;
                }
                if (stringBuffer3.length() > 0) {
                    stringBuffer3.append(",");
                } else {
                    stringBuffer3.append("WCMChnlDoc.ChnlId in(");
                }
                stringBuffer3.append("?");
                nArray3[n5++] = channel.getId();
                continue;
            }
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(",");
            } else {
                stringBuffer2.append("WCMChnlDoc.ChnlId in(");
            }
            stringBuffer2.append("?");
            nArray[n3++] = channel.getId();
        }
        for (n = 0; n < n2 && nArray[n] > 0; ++n) {
            wCMFilter.addSearchValues(nArray[n]);
        }
        for (n = 0; n < n2 && nArray2[n] > 0; ++n) {
            wCMFilter.addSearchValues(nArray2[n]);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append(") and WCMChnlDoc.CrUser=?");
            wCMFilter.addSearchValues(this.m_oLoginUser.getName());
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer2.append(")");
        }
        for (n = 0; n < n2 && nArray3[n] > 0; ++n) {
            wCMFilter.addSearchValues(nArray3[n]);
        }
        if (stringBuffer3.length() > 0) {
            stringBuffer3.append(")");
            this.makeDocLevelWhere(wCMFilter, stringBuffer3);
        }
    }

    private void makeChnlIdWhereWithOr(Channels channels, WCMFilter wCMFilter, StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) throws WCMException {
        this.makeChnlIdWhereWithOr2(channels, wCMFilter, stringBuffer, stringBuffer2, stringBuffer3);
    }

    private void makeChnlIdWhereWithOr2(Channels channels, WCMFilter wCMFilter, StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) throws WCMException {
        int n = channels.size();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Channel channel = null;
        boolean bl = this.m_oLoginUser.isAdministrator();
        for (int i = 0; i < n; ++i) {
            channel = (Channel)channels.getAt(i);
            if (this.m_bNeedWithAuthFilter) {
                if (!AuthServer.hasRight(this.m_oLoginUser, (CMSObj)channel, this.m_nRightIndex)) {
                    nArray2[n3++] = channel.getId();
                    continue;
                }
                if (bl || channel.getCrUserName().equalsIgnoreCase(this.m_oLoginUser.getName()) || !channel.isUseDocLevel()) {
                    nArray[n2++] = channel.getId();
                    continue;
                }
                nArray3[n4++] = channel.getId();
                continue;
            }
            nArray[n2++] = channel.getId();
        }
        if (n3 > 0) {
            int[] nArray4 = new int[n3];
            System.arraycopy(nArray2, 0, nArray4, 0, n3);
            nArray2 = null;
            this.appendParams(nArray4, wCMFilter, stringBuffer);
        }
        if (n2 > 0) {
            int[] nArray5 = new int[n2];
            System.arraycopy(nArray, 0, nArray5, 0, n2);
            nArray = null;
            this.appendParams(nArray5, wCMFilter, stringBuffer2);
        }
        if (n4 > 0) {
            int[] nArray6 = new int[n4];
            System.arraycopy(nArray3, 0, nArray6, 0, n4);
            nArray3 = null;
            this.appendParams(nArray6, wCMFilter, stringBuffer3);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, '(');
            stringBuffer.append(") and WCMChnlDoc.CrUser=?");
            wCMFilter.addSearchValues(ContextHelper.getLoginUser().getName());
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer2.insert(0, '(');
            stringBuffer2.append(")");
        }
        if (stringBuffer3.length() > 0) {
            stringBuffer3.insert(0, '(');
            this.makeDocLevelWhere(wCMFilter, stringBuffer3);
            stringBuffer3.append(")");
        }
    }

    private void appendParams(int[] nArray, WCMFilter wCMFilter, StringBuffer stringBuffer) {
        Arrays.sort(nArray);
        StringBuffer stringBuffer2 = new StringBuffer(768);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = n2 = nArray[i];
            while (i < n - 1 && nArray[i + 1] == n2 + 1) {
                n2 = nArray[++i];
            }
            if (n3 == n2) {
                stringBuffer2.append(" or WCMChnlDoc.ChnlId=?");
                wCMFilter.addSearchValues(n3);
                continue;
            }
            stringBuffer2.append(" or WCMChnlDoc.ChnlId>=?");
            stringBuffer2.append(" and WCMChnlDoc.ChnlId<=?");
            wCMFilter.addSearchValues(n3);
            wCMFilter.addSearchValues(n2);
        }
        stringBuffer.append(stringBuffer2.substring(4));
    }

    private WCMFilter makeChannelFilterWithJoin(Channels channels, WCMFilter wCMFilter, boolean bl) throws WCMException {
        String string = (bl ? " (WCMChnlDoc.DocStatus<0 or WCMChnlDoc.Modal<0 or WCMChnlDoc.DocChannel<0)" : " WCMChnlDoc.DocStatus>0 and WCMChnlDoc.DocChannel>0 and WCMChnlDoc.Modal>0") + " and WCMChnlDoc.DocId=" + this.m_sTableName + "." + this.m_sIdFieldName;
        WCMFilter wCMFilter2 = new WCMFilter("WCMChnlDoc," + this.m_sTableName, null, null);
        StringBuffer stringBuffer = new StringBuffer(channels.size() * 10 + 16);
        StringBuffer stringBuffer2 = new StringBuffer(channels.size() * 2 + 16);
        StringBuffer stringBuffer3 = new StringBuffer(channels.size() * 2 + 16);
        this.makeChnlIdWhere(channels, wCMFilter2, stringBuffer, stringBuffer2, stringBuffer3);
        StringBuffer stringBuffer4 = new StringBuffer(channels.size() * 2 + string.length() + 16);
        if (stringBuffer2.length() > 0) {
            stringBuffer4.append("(");
            stringBuffer4.append(stringBuffer2);
            stringBuffer4.append(")");
        }
        if (stringBuffer.length() > 0) {
            if (stringBuffer4.length() > 0) {
                stringBuffer4.append(" or ");
            }
            stringBuffer4.append("(");
            stringBuffer4.append(stringBuffer);
            stringBuffer4.append(")");
        }
        if (stringBuffer3.length() > 0) {
            if (stringBuffer4.length() > 0) {
                stringBuffer4.append(" or ");
            }
            stringBuffer4.append("(");
            stringBuffer4.append(stringBuffer3);
            stringBuffer4.append(")");
        }
        if (stringBuffer4.length() > 0) {
            stringBuffer4.insert(0, '(').append(")").append(" and ");
        }
        stringBuffer4.append(string);
        wCMFilter2.setWhere(stringBuffer4.toString());
        wCMFilter2.mergeWith(wCMFilter);
        return wCMFilter2;
    }

    private boolean isQueryInDocument(WCMFilter wCMFilter, Channel channel) {
        if (wCMFilter != null) {
            if (wCMFilter.getWhere() != null && wCMFilter.getWhere().matches(this.m_sRegContainsDataTable)) {
                return true;
            }
            if (wCMFilter.getOrder() != null && wCMFilter.getOrder().matches(this.m_sRegContainsDataTable)) {
                return true;
            }
            if (wCMFilter.getSelect() != null && wCMFilter.getSelect().matches(this.m_sRegContainsDataTable)) {
                return true;
            }
        }
        if (channel == null) {
            return false;
        }
        String string = channel.getQuery();
        if (string != null && string.matches(this.m_sRegContainsDataTable)) {
            return true;
        }
        String string2 = channel.getOrderBy();
        return string2 != null && string2.matches(this.m_sRegContainsDataTable);
    }

    public static void main(String[] stringArray) {
        File[] fileArray;
        Object object;
        String[] stringArray2 = new String[]{"D:\\YHIntranet\\webapps\\wcm\\wcm_use\\", "D:\\YHIntranet\\webapps\\wcm\\test\\", "D:\\YHIntranet\\webapps\\wcm\\temp\\"};
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.println("\u76ee\u5f55:" + stringArray2[i] + "<BR>");
            object = new File(stringArray2[i]);
            fileArray = ((File)object).listFiles();
            for (int j = 0; j < fileArray.length; ++j) {
                if (fileArray[j].getName().indexOf("jsp") > 0) {
                    System.out.println("\u6587\u4ef6:" + fileArray[j].getName());
                }
                if (!fileArray[j].isDirectory()) continue;
                System.out.println("\u76ee\u5f55:" + fileArray[j].getName());
            }
        }
        try {
            DebugTimer debugTimer = new DebugTimer();
            object = null;
            fileArray = new WCMFilter();
            fileArray.setMaxRowNumber(1);
            WCMFilter wCMFilter = new WCMFilter("", "", "ChannelId");
            Channels channels = Channels.openWCMObjs(null, wCMFilter);
            int n = channels.size();
            for (int i = 0; i < n; ++i) {
                Channel channel = (Channel)channels.getAt(i);
                if (channel == null) continue;
                debugTimer.start();
                try {
                    object = DocumentsGetHelper.getDocuments(channel, (WCMFilter)fileArray);
                }
                catch (Throwable throwable) {
                    logger.error((Object)("[" + channel + "]\u51fa\u73b0\u5f02\u5e38!"), throwable);
                }
                debugTimer.stop();
                if (debugTimer.getTime() > 2000L && object != null) {
                    logger.info((Object)("Long!!! get [" + channel + "] documents use[" + debugTimer.getTime() + "]ms [" + ((Documents)object).size() + "] SQL:" + ((BaseObjs)object).getFilter().toSQL()));
                }
                if (object == null) continue;
                ((Documents)object).clear();
            }
        }
        catch (Exception exception) {
            logger.error((Object)"\u6d4b\u8bd5\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)exception);
        }
    }

    public void setNeedWithAuthFilter(User user, boolean bl) {
        this.m_oLoginUser = user;
        this.m_bNeedWithAuthFilter = bl;
    }

    private WCMFilter makeDeptFilter(Channel channel) throws WCMException {
        Channels channels = Channels.createNewInstance(this.m_oLoginUser);
        channels.addElement(channel);
        return this.makeDeptFilter(channels);
    }

    private WCMFilter makeDeptFilter(Channels channels) throws WCMException {
        Object object;
        if (this.m_oLoginUser.isAdministrator()) {
            return null;
        }
        boolean bl = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("WITH_DEPT_FILTER", "false"));
        if (DBManager.getDBManager().getFieldInfo("WCMCHNLDOC", "CRDEPT") == null) {
            bl = false;
        }
        if (!bl) {
            return null;
        }
        IDepartmentMgr iDepartmentMgr = (IDepartmentMgr)DreamFactory.createObjectById("IDepartmentMgr");
        String string = iDepartmentMgr.getDepartmentInfo(this.m_oLoginUser);
        boolean bl2 = iDepartmentMgr.isDepartmentAdmin(this.m_oLoginUser);
        Object object2 = null;
        boolean bl3 = CMyString.isEmpty(string);
        if (!bl3) {
            object = "WCMChnlDoc.CrDept = ?";
            object2 = bl2 ? "(" + (String)object + " or WCMChnlDoc.CrDept like ?)" : object;
        } else {
            object2 = "WCMCHNLDOC.CRUSER=?";
        }
        object = new WCMFilter();
        StringBuffer stringBuffer = new StringBuffer();
        int n = channels.size();
        for (int i = 0; i < n; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null || !channel.isDoDeptFilter()) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" or ");
            }
            stringBuffer.append("(WCMChnlDoc.docChannel=?");
            ((WCMFilter)object).addSearchValues(channel.getId());
            stringBuffer.append(" and ");
            stringBuffer.append((String)object2);
            if (!bl3) {
                ((WCMFilter)object).addSearchValues(string);
                if (bl2) {
                    ((WCMFilter)object).addSearchValues(string + "%");
                }
            } else {
                ((WCMFilter)object).addSearchValues(this.m_oLoginUser.getName());
            }
            stringBuffer.append(")");
        }
        ((WCMFilter)object).setWhere(stringBuffer.toString());
        return object;
    }

    private void makeDocLevelWhere(WCMFilter wCMFilter, StringBuffer stringBuffer) throws WCMException {
        DocLevel docLevel = this.m_oLoginUser.getDocLevel();
        int n = docLevel.getId();
        DocLevelMgr docLevelMgr = new DocLevelMgr();
        DocLevels docLevels = docLevelMgr.queryLowerDocLevels(this.m_oLoginUser, docLevel);
        stringBuffer.append(" and (");
        if (docLevels.isEmpty()) {
            stringBuffer.append("WCMChnlDoc.DOCLEVEL=?");
            wCMFilter.addSearchValues(n);
        } else {
            stringBuffer.append("WCMChnlDoc.DOCLEVEL in(");
            int n2 = docLevels.size();
            for (int i = 0; i < n2; ++i) {
                DocLevel docLevel2 = (DocLevel)docLevels.getAt(i);
                if (docLevel2 == null) continue;
                stringBuffer.append(" ?,");
                wCMFilter.addSearchValues(docLevel2.getId());
            }
            stringBuffer.append(" ?)");
            wCMFilter.addSearchValues(n);
        }
        stringBuffer.append(" or WCMChnlDoc.DOCLEVEL is null");
        stringBuffer.append(" or WCMChnlDoc.DOCLEVEL=0");
        stringBuffer.append(" or WCMChnlDoc.CrUser=?");
        wCMFilter.addSearchValues(this.m_oLoginUser.getName());
        stringBuffer.append(")");
    }
}

