/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.ContextHelper;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.persistent.ContentLink;
import com.trs.components.wcm.content.persistent.ContentLinks;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import org.apache.log4j.Logger;

public class ContentLinkMgr {
    private static Logger m_oLogger = Logger.getLogger(ChannelMgr.class);

    public ContentLinks getContentLinks(WebSite webSite, WCMFilter wCMFilter) throws WCMException {
        if (webSite == null) {
            throw new WCMException(10, I18NMessage.get(ContentLinkMgr.class, "ContentLinkMgr.label1", "\u65e0\u6548\u7684\u7ad9\u70b9\u5bf9\u8c61!"));
        }
        WCMFilter wCMFilter2 = new WCMFilter("", "SiteId=" + webSite.getId(), "ContentLinkId desc");
        wCMFilter2.mergeWith(wCMFilter);
        try {
            return ContentLinks.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
        }
        catch (WCMException wCMException) {
            m_oLogger.debug((Object)wCMException.getStackTraceText());
            throw new WCMException(1100, I18NMessage.get(ContentLinkMgr.class, "ContentLinkMgr.label2", "\u83b7\u53d6\u7ad9\u70b9\u7684\u6240\u6709\u5185\u5bb9\u8d85\u94fe\u63a5\u5931\u8d25!"), wCMException);
        }
    }

    public ContentLink save(ContentLink contentLink) throws WCMException {
        if (contentLink == null) {
            throw new WCMException(10, I18NMessage.get(ContentLinkMgr.class, "ContentLinkMgr.label3", "\u65e0\u6548\u7684\u5bf9\u8c61,\u65e0\u6cd5\u4fdd\u5b58!"));
        }
        contentLink.save();
        return contentLink;
    }

    public ContentLinks getContentLinks(int n, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("", "SiteId=" + n, "");
        wCMFilter2.mergeWith(wCMFilter);
        return ContentLinks.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }

    public void delete(ContentLink contentLink) throws WCMException {
        if (contentLink == null) {
            throw new WCMException(10, I18NMessage.get(ContentLinkMgr.class, "ContentLinkMgr.label4", "\u65e0\u6548\u7684\u5185\u5bb9\u8d85\u94fe\u63a5\u5bf9\u8c61,\u65e0\u6cd5\u5220\u9664!"));
        }
        contentLink.delete();
    }

    public void delete(ContentLinks contentLinks) throws WCMException {
        if (contentLinks == null || contentLinks.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(ContentLinkMgr.class, "ContentLinkMgr.label5", "\u65e0\u6548\u7684\u96c6\u5408\u5bf9\u8c61,\u65e0\u6cd5\u5220\u9664!"));
        }
        contentLinks.removeAll();
    }

    public void deleteContentLinks(WebSite webSite) throws WCMException {
        this.getContentLinks(webSite, null).removeAll();
    }
}

