/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.ExtendedField;
import com.trs.cms.content.WCMSystemObject;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ContentExtField;
import com.trs.components.wcm.content.persistent.ContentExtFields;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.TableInfo;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;

public class ContentExtFieldMgr {
    private static Logger logger = Logger.getLogger(ContentExtFieldMgr.class);
    private static final String CONEXTFIELD_INVALID_DESC = I18NMessage.get(ContentExtFieldMgr.class, "ContentExtFieldMgr.label1", "\u65e0\u6548\u7684\u6269\u5c55\u5b57\u6bb5!");
    private static final String BASECHANNEL_INVALID_DESC = I18NMessage.get(ContentExtFieldMgr.class, "ContentExtFieldMgr.label2", "\u6307\u5b9a\u7684\u7ad9\u70b9/\u9891\u9053\u8fd9\u65e0\u6548!");

    public ContentExtField save(CMSObj cMSObj, ContentExtField contentExtField, boolean bl) throws WCMException {
        this.assertNotNull(cMSObj, BASECHANNEL_INVALID_DESC);
        this.assertNotNull(contentExtField, CONEXTFIELD_INVALID_DESC);
        if (contentExtField.isAddMode()) {
            contentExtField.setObjId(cMSObj.getId());
            contentExtField.setObjType(cMSObj.getWCMType());
        }
        User user = this.getLoginUser();
        contentExtField.save(user);
        if (bl) {
            this.addExtFieldToChildren(cMSObj, contentExtField);
        }
        return contentExtField;
    }

    public void addExtField(CMSObj cMSObj, ContentExtField contentExtField, int n) throws WCMException {
        ContentExtField contentExtField2 = this.findMine((BaseChannel)cMSObj, contentExtField.getExtFieldId());
        if (contentExtField2 != null) {
            return;
        }
        contentExtField2 = (ContentExtField)contentExtField.cloneToNewObj();
        contentExtField2.setProperty("EXTORDER", n);
        this.save(cMSObj, contentExtField2, false);
    }

    public void addExtFieldToSpeicficChildren(String string, String string2, ContentExtField contentExtField) throws WCMException {
        int n;
        User user = this.getLoginUser();
        Channel channel = null;
        WebSite webSite = null;
        Channels channels = null;
        WebSites webSites = null;
        ContentExtField contentExtField2 = null;
        if (string2.trim().length() > 0) {
            channels = Channels.findByIds(user, string2);
            for (n = 0; n < channels.size(); ++n) {
                channel = (Channel)channels.getAt(n);
                if (channel == null || channel.getType() != 0 || channel.isDeleted() || (contentExtField2 = this.findMine(channel, contentExtField.getExtFieldId())) != null) continue;
                contentExtField2 = (ContentExtField)contentExtField.cloneToNewObj();
                int n2 = this.getMaxOrder(channel);
                contentExtField2.setProperty("EXTORDER", n2);
                this.save(channel, contentExtField2, false);
            }
        }
        if (string.trim().length() > 0) {
            webSites = WebSites.findByIds(user, string);
            for (n = 0; n < webSites.size(); ++n) {
                ContentExtField contentExtField3;
                webSite = (WebSite)webSites.getAt(n);
                if (webSite == null || webSite.isDeleted() || (contentExtField3 = this.findMine(webSite, contentExtField.getExtFieldId())) != null) continue;
                contentExtField3 = (ContentExtField)contentExtField.cloneToNewObj();
                this.save(webSite, contentExtField3, false);
            }
        }
    }

    public void addExtFieldToChildren(CMSObj cMSObj, ContentExtField contentExtField) throws WCMException {
        switch (cMSObj.getWCMType()) {
            case 1: {
                WCMFilter wCMFilter = new WCMFilter("", "SiteType=? AND Status=0", "");
                wCMFilter.addSearchValues(0, cMSObj.getId());
                WebSites webSites = WebSites.openWCMObjs(null, wCMFilter);
                int n = webSites.size();
                for (int i = 0; i < n; ++i) {
                    WebSite webSite = (WebSite)webSites.getAt(i);
                    if (webSite == null || webSite.isDeleted()) continue;
                    ContentExtField contentExtField2 = this.findMine(webSite, contentExtField.getExtFieldId());
                    if (contentExtField2 == null) {
                        contentExtField2 = (ContentExtField)contentExtField.cloneToNewObj();
                        this.save(webSite, contentExtField2, true);
                        continue;
                    }
                    this.addExtFieldToChildren(webSite, contentExtField);
                }
                break;
            }
            case 101: 
            case 103: {
                List list = ((BaseChannel)cMSObj).getChildren(this.getLoginUser(), 0);
                Channel channel = null;
                ContentExtField contentExtField3 = null;
                for (int i = 0; i < list.size(); ++i) {
                    channel = (Channel)list.get(i);
                    if (channel == null || channel.getType() != 0 || channel.isDeleted()) continue;
                    contentExtField3 = this.findMine(channel, contentExtField.getExtFieldId());
                    if (contentExtField3 == null) {
                        contentExtField3 = (ContentExtField)contentExtField.cloneToNewObj();
                        int n = this.getMaxOrder(channel);
                        contentExtField3.setProperty("EXTORDER", n);
                        this.save(channel, contentExtField3, true);
                        continue;
                    }
                    this.addExtFieldToChildren(channel, contentExtField);
                }
                break;
            }
        }
    }

    public int getMaxOrder(CMSObj cMSObj) throws WCMException {
        DBManager dBManager = DBManager.getDBManager();
        String string = "SELECT MAX(extorder) FROM WCMCONTENTEXTFIELD WHERE objtype=" + cMSObj.getWCMType() + " and objid=" + cMSObj.getId();
        int n = dBManager.sqlExecuteIntQuery(string) + 1;
        return n;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public void delete(CMSObj cMSObj, ContentExtField contentExtField, boolean bl) throws WCMException {
        this.assertNotNull(contentExtField, CONEXTFIELD_INVALID_DESC);
        User user = this.getLoginUser();
        if (bl) {
            if (cMSObj instanceof BaseChannel) {
                this.syncDeleteChildrenField((BaseChannel)cMSObj, contentExtField);
            } else {
                this.syncDeleteChildrenField((WCMSystemObject)cMSObj, contentExtField);
            }
        }
        contentExtField.delete(user);
        this.deleteRelatedContent(contentExtField);
        this.deletePhysicalInfoIfNecessary(contentExtField);
    }

    private void syncDeleteChildrenField(BaseChannel baseChannel, ContentExtField contentExtField) throws WCMException {
        List list = baseChannel.getAllChildren(this.getLoginUser());
        BaseChannel baseChannel2 = null;
        ContentExtField contentExtField2 = null;
        for (int i = 0; i < list.size(); ++i) {
            baseChannel2 = (BaseChannel)list.get(i);
            if (baseChannel2 == null || baseChannel2.isDeleted()) continue;
            contentExtField2 = this.findMine(baseChannel2, contentExtField.getExtFieldId());
            if (contentExtField2 == null) {
                this.syncDeleteChildrenField(baseChannel2, contentExtField);
                continue;
            }
            this.delete(baseChannel2, contentExtField2, true);
        }
    }

    private void syncDeleteChildrenField(WCMSystemObject wCMSystemObject, ContentExtField contentExtField) throws WCMException {
        String string = "SiteType=?";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        wCMFilter.addSearchValues(0, wCMSystemObject.getId());
        WebSites webSites = WebSites.openWCMObjs(null, wCMFilter);
        BaseChannel baseChannel = null;
        ContentExtField contentExtField2 = null;
        for (int i = 0; i < webSites.size(); ++i) {
            baseChannel = (BaseChannel)webSites.getAt(i);
            if (baseChannel == null || baseChannel.isDeleted()) continue;
            contentExtField2 = this.findMine(baseChannel, contentExtField.getExtFieldId());
            if (contentExtField2 == null) {
                this.syncDeleteChildrenField(baseChannel, contentExtField);
                continue;
            }
            this.delete(baseChannel, contentExtField2, true);
        }
    }

    public ContentExtFields getExtFields(BaseChannel baseChannel, WCMFilter wCMFilter) throws WCMException {
        return this.getExtFields(baseChannel, wCMFilter, false);
    }

    public ContentExtFields getExtFields(CMSObj cMSObj, WCMFilter wCMFilter, boolean bl) throws WCMException {
        this.assertNotNull(cMSObj, BASECHANNEL_INVALID_DESC);
        WCMFilter wCMFilter2 = this.makeHostExtendFilter(cMSObj, bl);
        wCMFilter2.mergeWith(this.analyze(wCMFilter));
        ContentExtFields contentExtFields = new ContentExtFields(this.getLoginUser());
        contentExtFields.open(wCMFilter2);
        if (bl) {
            ContentExtField contentExtField = null;
            CMSObj cMSObj2 = null;
            for (int i = 0; i < contentExtFields.size(); ++i) {
                contentExtField = (ContentExtField)contentExtFields.getAt(i);
                if (contentExtField == null || (cMSObj2 = contentExtField.getHost()) == null || !(cMSObj2 instanceof Channel) || !((Channel)cMSObj2).isOnlySearch()) continue;
                contentExtFields.remove(contentExtField, false);
            }
        }
        return contentExtFields;
    }

    private WCMFilter makeHostExtendFilter(CMSObj cMSObj, boolean bl) throws WCMException {
        StringBuffer stringBuffer;
        WCMFilter wCMFilter = new WCMFilter("", "", "wcmcontentextfield.extorder desc");
        switch (cMSObj.getWCMType()) {
            case 1: {
                int n = bl ? 400 : 50;
                stringBuffer = new StringBuffer(n);
                int n2 = 0;
                stringBuffer.append("(ObjId=? and ObjType=?)");
                wCMFilter.addSearchValues(n2++, cMSObj.getId());
                wCMFilter.addSearchValues(n2++, cMSObj.getWCMType());
                if (!bl) break;
                stringBuffer.append(" or ");
                stringBuffer.append("exists(select WCMWebSite.SiteId from WCMWebSite where WCMWebSite.SiteType=? and WCMCONTENTEXTFIELD.ObjType=103 and WCMCONTENTEXTFIELD.ObjId=WCMWebSite.SiteId AND Status=0)");
                wCMFilter.addSearchValues(n2++, cMSObj.getId());
                stringBuffer.append(" or ");
                stringBuffer.append("exists(select WCMChannel.ChannelId from WCMChannel where WCMCONTENTEXTFIELD.ObjType=101 and WCMCONTENTEXTFIELD.ObjId=WCMChannel.ChannelId and exists(select WCMWebSite.SiteId from WCMWebSite where WCMWebSite.SiteType=? and WCMCHANNEL.SiteId=WCMWebSite.SiteId) AND Status=0)");
                wCMFilter.addSearchValues(n2++, cMSObj.getId());
                break;
            }
            case 103: {
                int n = bl ? 300 : 50;
                stringBuffer = new StringBuffer(n);
                int n3 = 0;
                stringBuffer.append("(ObjId=? and ObjType=?)");
                wCMFilter.addSearchValues(n3++, cMSObj.getId());
                wCMFilter.addSearchValues(n3++, cMSObj.getWCMType());
                if (!bl) break;
                stringBuffer.append(" or ");
                stringBuffer.append("exists(select WCMChannel.ChannelId from WCMChannel where WCMCONTENTEXTFIELD.ObjType=101 and WCMCONTENTEXTFIELD.ObjId=WCMChannel.ChannelId and exists(select WCMWebSite.SiteId from WCMWebSite where WCMWebSite.SiteId=? and WCMCHANNEL.SiteId=WCMWebSite.SiteId) AND Status=0)");
                wCMFilter.addSearchValues(n3++, cMSObj.getId());
                break;
            }
            case 101: {
                int n = bl ? 200 : 50;
                stringBuffer = new StringBuffer(n);
                if (bl) {
                    stringBuffer.append("ObjType=? and ObjId in(?");
                    wCMFilter.addSearchValues(0, cMSObj.getWCMType());
                    wCMFilter.addSearchValues(1, cMSObj.getId());
                    this.makeChildrenWhere(wCMFilter, stringBuffer, (Channel)cMSObj);
                    stringBuffer.append(")");
                    break;
                }
                stringBuffer.append("(ObjId=? and ObjType=?)");
                wCMFilter.addSearchValues(0, cMSObj.getId());
                wCMFilter.addSearchValues(1, cMSObj.getWCMType());
                break;
            }
            default: {
                throw new WCMException(I18NMessage.get(ContentExtFieldMgr.class, "ContentExtFieldMgr.label3", "\u672a\u77e5\u7c7b\u578b[HostType=") + cMSObj.getWCMType() + ",HostId=" + cMSObj.getId() + "]\uff01");
            }
        }
        wCMFilter.setWhere(stringBuffer.toString());
        return wCMFilter;
    }

    private void makeChildrenWhere(WCMFilter wCMFilter, StringBuffer stringBuffer, Channel channel) throws WCMException {
        List list = channel.getChildren(null);
        if (list == null || list.isEmpty()) {
            return;
        }
        Channel channel2 = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            channel2 = (Channel)list.get(i);
            if (channel2 == null || channel2.isDeleted()) continue;
            stringBuffer.append(",?");
            wCMFilter.addSearchValues(wCMFilter.getSearchValues().size(), channel2.getId());
            this.makeChildrenWhere(wCMFilter, stringBuffer, channel2);
        }
    }

    private WCMFilter analyze(WCMFilter wCMFilter) throws WCMException {
        if (wCMFilter == null) {
            return null;
        }
        String string = "WCMContentExtField.ExtFieldId=WCMExtField.ExtFieldId";
        try {
            String string2 = this.analyzePart(wCMFilter.getWhere());
            if (this.empty(string2)) {
                wCMFilter.setWhere(string);
            } else {
                wCMFilter.setWhere(string + " AND (" + this.analyzePart(wCMFilter.getWhere()) + ")");
            }
            wCMFilter.setOrder(wCMFilter.getOrder());
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(ContentExtFieldMgr.class, "ContentExtFieldMgr.label4", "\u5206\u6790\u68c0\u7d22\u6761\u4ef6\u51fa\u9519!"), wCMException);
        }
        wCMFilter.setSelect("");
        wCMFilter.setFrom("WCMContentExtField,WCMExtField");
        return wCMFilter;
    }

    private String analyzePart(String string) throws WCMException {
        if (this.empty(string)) {
            return "";
        }
        String string2 = string;
        Enumeration enumeration = this.getTableFields("WCMEXTFIELD");
        while (enumeration.hasMoreElements()) {
            string2 = this.appendPreTableName(string2, (String)enumeration.nextElement(), "WCMEXTFIELD");
        }
        return string2;
    }

    private Enumeration getTableFields(String string) throws WCMException {
        DBManager dBManager = DBManager.getDBManager();
        TableInfo tableInfo = dBManager.getTableInfo(string);
        return tableInfo.getFieldNames();
    }

    private String appendPreTableName(String string, String string2, String string3) {
        if (string == null) {
            return "";
        }
        if (this.empty(string2)) {
            return string;
        }
        String string4 = string;
        String string5 = string2.toUpperCase();
        int n = string5.length();
        int n2 = 0;
        do {
            char c;
            int n3;
            String string6;
            if ((n2 = (string6 = string4.toUpperCase()).indexOf(string5, n2)) < 0) {
                return string4;
            }
            if (n2 > 0) {
                n3 = string6.charAt(n2 - 1);
                if (n3 >= 65 && n3 <= 90) continue;
                if (n3 == 46) {
                    n2 += n;
                    continue;
                }
            }
            if ((n3 = n2 + n) < string6.length() && (c = string6.charAt(n3)) >= 'A' && c <= 'Z') {
                n2 += n;
                continue;
            }
            String string7 = string3 + "." + string5;
            string4 = string4.substring(0, n2) + string7 + string4.substring(n3);
            n2 += string7.length();
        } while (n2 >= 0 && n2 < string4.length());
        return string4;
    }

    private boolean empty(String string) {
        return string == null || string.trim().length() == 0;
    }

    private void assertNotNull(Object object, String string) throws WCMException {
        if (object == null) {
            throw new WCMException(10, string);
        }
    }

    private void deleteRelatedContent(ContentExtField contentExtField) throws WCMException {
        String string = null;
        try {
            string = contentExtField.getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (CMyString.isEmpty(string)) {
            return;
        }
        if (101 == contentExtField.getObjType() && "WCMDOCUMENT".equals(contentExtField.getTableName())) {
            String string2 = " SET " + string + "=null Where DocChannel=" + contentExtField.getObjId();
            String[] stringArray = new String[]{"UPDATE WCMDOCUMENT" + string2, "UPDATE WCMDOCBAK" + string2};
            DBManager.getDBManager().sqlExecuteUpdate(stringArray);
        }
    }

    private void deletePhysicalInfoIfNecessary(ContentExtField contentExtField) throws WCMException {
        if (this.isInUse(contentExtField)) {
            return;
        }
        ExtendedField extendedField = ExtendedField.findById(contentExtField.getExtFieldId());
        if (logger.isDebugEnabled()) {
            String string = I18NMessage.get(ContentExtFieldMgr.class, "ContentExtFieldMgr.label5", "\u7cfb\u7edf\u6570\u636e\u53ef\u80fd\u51fa\u73b0\u5f02\u5e38:\nextfield[") + contentExtField.getExtFieldId() + "," + contentExtField.getDesc() + "]@" + contentExtField.getHost() + I18NMessage.get(ContentExtFieldMgr.class, "ContentExtFieldMgr.label6", "\u5bf9\u5e94\u7684\u7269\u7406\u5b57\u6bb5\u7f3a\u5931!");
            logger.debug((Object)string);
        }
        if (extendedField != null) {
            extendedField.delete(this.getLoginUser());
        }
    }

    private ContentExtField findMine(BaseChannel baseChannel, int n) throws WCMException {
        String string = "ExtFieldId=" + n;
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        wCMFilter.setMaxRowNumber(1);
        ContentExtFields contentExtFields = this.getExtFields(baseChannel, wCMFilter);
        if (contentExtFields.isEmpty()) {
            return null;
        }
        return (ContentExtField)contentExtFields.getAt(0);
    }

    private boolean isInUse(ContentExtField contentExtField) throws WCMException {
        String string = "SELECT COUNT(*) FROM WCMCONTENTEXTFIELD WHERE ExtFieldId=" + contentExtField.getExtFieldId();
        return DBManager.getDBManager().sqlExecuteIntQuery(string) > 0;
    }
}

