/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.components.wcm.content.domain.AutoDocBakMgr;
import com.trs.components.wcm.content.persistent.AutoBakConfig;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;

public class ChnlDocLCListenerForAutoDocBak
implements IObjectLCListenerOnModify {
    private AutoDocBakMgr m_oAutoDocBakMgr = (AutoDocBakMgr)DreamFactory.createObjectById("AutoDocBakMgr");

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        ChnlDoc chnlDoc;
        if (this.isListening(baseObj) && this.needAutoBak(chnlDoc = (ChnlDoc)baseObj)) {
            this.m_oAutoDocBakMgr.autoBakDocument(chnlDoc.getDocument(), 20);
        }
    }

    private boolean isListening(BaseObj baseObj) {
        if (baseObj == null || baseObj.getWCMType() != 614) {
            return false;
        }
        ChnlDoc chnlDoc = (ChnlDoc)baseObj;
        return chnlDoc.isChangeProperty("DOCSTATUS") && chnlDoc.getModal() == 1;
    }

    private boolean needAutoBak(ChnlDoc chnlDoc) throws WCMException {
        String string = chnlDoc.getNewPropertyAsString("DOCSTATUS");
        AutoBakConfig autoBakConfig = this.m_oAutoDocBakMgr.getAutoSaveConfig(chnlDoc.getChannel().getSite());
        if (autoBakConfig == null) {
            return false;
        }
        String string2 = autoBakConfig.getCanSavedDocStatusIds();
        return string2.indexOf(string) != -1;
    }
}

