/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.LockerMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.domain.ReplaceMgr;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.Replace;
import com.trs.components.wcm.content.persistent.Replaces;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ChannelMgr {
    private static Logger m_oLogger = Logger.getLogger(ChannelMgr.class);

    public Channel getChannelByName(int n, String string) {
        return Channel.findByName(n, string);
    }

    public WebSite getSiteByName(String string, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("", "SiteName=?", "SITEORDER desc");
        wCMFilter2.addSearchValues(string);
        wCMFilter2.mergeWith(wCMFilter);
        WebSites webSites = WebSites.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
        int n = webSites.size();
        for (int i = 0; i < n; ++i) {
            WebSite webSite = (WebSite)webSites.getAt(i);
            if (webSite == null) continue;
            return webSite;
        }
        return null;
    }

    public Channel getChannelByPath(String string) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return null;
        }
        String[] stringArray = string.replace('\\', '/').split("/");
        int n = 0;
        String string2 = null;
        for (n = 0; n < stringArray.length; ++n) {
            if (CMyString.isEmpty(stringArray[n])) continue;
            string2 = stringArray[n];
            break;
        }
        if (CMyString.isEmpty(string2)) {
            return null;
        }
        WebSite webSite = this.getSiteByName(string2, null);
        if (webSite == null) {
            if (m_oLogger.isDebugEnabled()) {
                m_oLogger.debug((Object)("\u6307\u5b9a\u7684\u7ad9\u70b9[" + string2 + "]\u6ca1\u6709\u627e\u5230!"));
            }
            return null;
        }
        String string3 = null;
        for (int i = stringArray.length - 1; i > n; --i) {
            if (CMyString.isEmpty(stringArray[n])) continue;
            string3 = stringArray[i];
            break;
        }
        if (CMyString.isEmpty(string3)) {
            return null;
        }
        return this.getChannelByName(webSite.getId(), string3);
    }

    public Channels getChannels(int n, int n2, boolean bl) throws WCMException {
        String string;
        String string2 = string = n2 == -1 ? "" : "ChnlType=" + n2;
        if (!bl) {
            if (string.length() != 0) {
                string = string + " and ";
            }
            string = string + "Status=0";
        }
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        return this.getChannels(n, wCMFilter);
    }

    public Channels getChannels(int n, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("", "SiteId=" + n, "CHNLORDER desc");
        wCMFilter2.mergeWith(wCMFilter);
        return Channels.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }

    public Channels getRecycleChannels(BaseChannel baseChannel, WCMFilter wCMFilter) throws WCMException {
        Cloneable cloneable;
        if (baseChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label1", "\u65e0\u6548\u7684\u7ad9\u70b9\u6216\u680f\u76ee\u5bf9\u8c61,\u65e0\u6cd5\u53d6\u5f97\u5176\u5b50\u680f\u76ee."));
        }
        String string = "Status=-1";
        if (baseChannel.isSite()) {
            string = string + " and SiteId=" + baseChannel.getId();
        } else {
            cloneable = (Channel)baseChannel;
            string = string + " and ParentId=" + ((BaseObj)cloneable).getId() + " and SiteId=" + ((Channel)cloneable).getSiteId();
        }
        cloneable = new WCMFilter("", string, "ChnlType desc,ChnlOrder desc");
        ((WCMFilter)cloneable).mergeWith(wCMFilter);
        return Channels.openWCMObjs(ContextHelper.getLoginUser(), (WCMFilter)cloneable);
    }

    public CMSBaseObjs getChildren(BaseChannel baseChannel, int n, boolean bl, WCMFilter wCMFilter) throws WCMException {
        if (baseChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label2", "\u65e0\u6548\u7684\u7ad9\u70b9/\u7236\u680f\u76ee,\u65e0\u6cd5\u83b7\u53d6\u5b83\u7684\u5b50\u680f\u76ee!"));
        }
        String string = "ParentId=" + (baseChannel.isSite() ? 0 : baseChannel.getId());
        if (n != -1) {
            string = string + " and ChnlType=" + n;
        }
        if (!bl) {
            string = string + " and Status=0";
        }
        WCMFilter wCMFilter2 = new WCMFilter("", string, "");
        wCMFilter2.mergeWith(wCMFilter);
        int n2 = baseChannel.isSite() ? baseChannel.getId() : ((Channel)baseChannel).getSiteId();
        return this.getChannels(n2, wCMFilter2);
    }

    public BaseChannel save(BaseChannel baseChannel) throws WCMException {
        this.prepareSaveBaseChannel(baseChannel);
        if (baseChannel.isAddMode()) {
            baseChannel.insert(ContextHelper.getLoginUser());
        } else {
            baseChannel = this.updateBaseChannel(baseChannel);
        }
        return baseChannel;
    }

    private BaseChannel prepareSaveChannel(Channel channel) throws WCMException {
        if (channel.getDesc() == null || channel.getDesc().length() == 0) {
            channel.setDesc(channel.getName());
        }
        if (channel.isAddMode() && channel.getType() != 12) {
            return channel;
        }
        if (!channel.isAddMode() && channel.getNewPropertyAsInt("CHNLTYPE", 0) != 12) {
            return channel;
        }
        String string = "";
        string = channel.isAddMode() ? channel.getSureFormFileName() : channel.getNewSureFormFileName();
        if (string == null) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label3", "\u4e66\u751f\u8868\u5355\u680f\u76ee\u5fc5\u987b\u5148\u8bbe\u7f6e\u4e66\u751f\u6a21\u677f\u6587\u4ef6\u624d\u80fd\u7ee7\u7eed\u4fdd\u5b58\uff01"));
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!filesMan.fileExists(string)) {
            throw new WCMException(50, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label4", "\u4e66\u751f\u8868\u5355\u6587\u4ef6\uff08") + string + I18NMessage.get(ChannelMgr.class, "ChannelMgr.label5", "\uff09\u5728\u670d\u52a1\u5668\u4e0a\u65e0\u6cd5\u627e\u5230\uff0c\u8bf7\u5148\u4e0a\u4f20\u5230\u670d\u52a1\u5668\u4e0a\u518d\u4fdd\u5b58\uff01"));
        }
        if (!CMyFile.extractFileExt(string).toUpperCase().equals("SEF")) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label6", "\u76ee\u524d\u53ea\u63a5\u6536sef\u683c\u5f0f\u7684\u4e66\u751f\u8868\u5355\u6587\u4ef6\uff0c\u60a8\u63d0\u4ea4\u7684\u6587\u4ef6\uff08") + string + I18NMessage.get(ChannelMgr.class, "ChannelMgr.label7", "\uff09\u683c\u5f0f\u65e0\u6548\uff01"));
        }
        if (filesMan.getFileFlag(string) == "U0") {
            string = filesMan.copyWCMFile(string, "W0");
            channel.setSureFormFile(string);
        }
        if (filesMan.getFileFlag(string) != "W0") {
            m_oLogger.warn((Object)I18NMessage.get(ChannelMgr.class, "ChannelMgr.label8", "\u4e66\u751f\u8868\u5355\u6587\u4ef6\u4e0d\u5728WebPic\u76ee\u5f55\u4e0b\uff0c\u53ef\u80fd\u4f1a\u4ea7\u751f\u5f02\u5e38\uff01"));
        }
        return channel;
    }

    private BaseChannel prepareSaveSite(WebSite webSite) throws WCMException {
        if (!webSite.isAddMode() && !webSite.isChangeProperty("SITEORDER")) {
            return webSite;
        }
        if (webSite.isAddMode() && !webSite.containsProperty("ParentId")) {
            webSite.setParent(webSite.getParentId());
        }
        return webSite;
    }

    private BaseChannel prepareSaveBaseChannel(BaseChannel baseChannel) throws WCMException {
        baseChannel = baseChannel.isSite() ? this.prepareSaveSite((WebSite)baseChannel) : this.prepareSaveChannel((Channel)baseChannel);
        return baseChannel;
    }

    private BaseChannel updateBaseChannel(BaseChannel baseChannel) throws WCMException {
        if (baseChannel.isSite()) {
            baseChannel.update(ContextHelper.getLoginUser());
        } else {
            Channel channel = (Channel)baseChannel;
            channel.update(ContextHelper.getLoginUser());
        }
        return baseChannel;
    }

    private void deleteChildren(BaseChannel baseChannel, boolean bl) throws WCMException {
        List list = null;
        list = bl ? baseChannel.getAllChildren(this.getLoginUser()) : baseChannel.getChildren(this.getLoginUser());
        for (int i = 0; i < list.size(); ++i) {
            Channel channel = (Channel)list.get(i);
            if (channel == null) continue;
            this.delete(channel, bl, true);
        }
    }

    public BaseChannel getHost(BaseChannel baseChannel) throws WCMException {
        if (baseChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label9", "\u65e0\u6548\u7684\u680f\u76ee\u5bf9\u8c61,\u65e0\u6cd5\u53d6\u5f97\u7236\u680f\u76ee"));
        }
        if (baseChannel.isSite()) {
            return baseChannel;
        }
        int n = ((Channel)baseChannel).getParentId();
        if (n == 0) {
            return baseChannel.getSite();
        }
        return Channel.findById(n);
    }

    public void restore(BaseChannel baseChannel) throws WCMException {
        this.restore(baseChannel, false);
    }

    public void restore(BaseChannel baseChannel, boolean bl) throws WCMException {
        if (baseChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label10", "\u65e0\u6548\u7684\u7ad9\u70b9/\u680f\u76ee\u5bf9\u8c61,\u65e0\u6cd5\u6062\u590d!"));
        }
        if (baseChannel.isDeleted()) {
            baseChannel.canEdit(this.getLoginUser());
            boolean bl2 = baseChannel.restore(bl);
            if (!bl2) {
                baseChannel.cancelUpdate(this.getLoginUser());
                return;
            }
            this.restoreChildren(baseChannel);
            baseChannel.setOperUser(ContextHelper.getLoginUser());
            baseChannel.setOperTime();
            baseChannel.update(ContextHelper.getLoginUser());
        }
        if (bl || baseChannel.isSite()) {
            return;
        }
        BaseChannel baseChannel2 = baseChannel.getHost();
        if (baseChannel2.isSite()) {
            return;
        }
        this.restore(baseChannel2, false);
    }

    private void restoreChildren(BaseChannel baseChannel) throws WCMException {
        List list = baseChannel.getAllChildren(this.getLoginUser());
        for (int i = 0; i < list.size(); ++i) {
            Channel channel = (Channel)list.get(i);
            if (channel == null) continue;
            this.restore(channel, true);
        }
    }

    public void delete(BaseChannel baseChannel, boolean bl) throws WCMException {
        this.delete(baseChannel, bl, false);
    }

    private void delete(BaseChannel baseChannel, boolean bl, boolean bl2) throws WCMException {
        if (baseChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label11", "\u65e0\u6548\u7684\u7ad9\u70b9/\u680f\u76ee\u5bf9\u8c61,\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\u64cd\u4f5c!"));
        }
        User user = this.getLoginUser();
        if (!baseChannel.canEdit(user)) {
            throw new WCMException(1013, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label12", "\u5bf9\u8c61\u5df2\u88ab[") + baseChannel.getLockerUser() + I18NMessage.get(ChannelMgr.class, "ChannelMgr.label13", "\u9501\u5b9a,\u7528\u6237[") + user.getName() + I18NMessage.get(ChannelMgr.class, "ChannelMgr.label14", "]\u65e0\u6cd5\u5bf9\u9501\u5b9a\u5bf9\u8c61\u8fdb\u884c\u64cd\u4f5c!"));
        }
        if (!bl2) {
            this.assertNoContentInFolderInEdit(user, baseChannel);
        }
        try {
            this.deleteChildren(baseChannel, bl);
        }
        catch (WCMException wCMException) {
            m_oLogger.debug((Object)"Failed to delete children", (Throwable)wCMException);
            throw new WCMException(1100, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label15", "\u5220\u9664\u5b50\u680f\u76ee\u5931\u8d25!"), wCMException);
        }
        if (!bl) {
            baseChannel.setDeleted(bl2);
            baseChannel.setOperUser(user);
            baseChannel.setOperTime();
            baseChannel.update(user);
            return;
        }
        baseChannel.delete(user);
        if (!baseChannel.isSite()) {
            this.deleteReplaceAfterDropChnl(baseChannel);
        }
    }

    private void deleteReplaceAfterDropChnl(BaseChannel baseChannel) throws WCMException {
        ReplaceMgr replaceMgr = (ReplaceMgr)DreamFactory.createObjectById("ReplaceMgr");
        try {
            if (baseChannel.isSite()) {
                return;
            }
            Replaces replaces = replaceMgr.getReplaces((Channel)baseChannel, null);
            for (int i = 0; i < replaces.size(); ++i) {
                Replace replace = (Replace)replaces.getAt(i);
                replaceMgr.delete(replace);
            }
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label41", "\u5f7b\u5e95\u5220\u9664\u680f\u76ee\u540e\u6e05\u9664\u680f\u76ee\u7684\u66ff\u6362\u5185\u5bb9\u5931\u8d25."), wCMException);
        }
    }

    private void assertNoContentInFolderInEdit(User user, BaseChannel baseChannel) throws WCMException {
        LockerMgr lockerMgr = (LockerMgr)DreamFactory.createObjectById("LockerMgr");
        String string = lockerMgr.getLockedObjIds(605);
        if (string.length() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DOCID");
        stringBuffer.append(" IN (").append(string).append(") AND ");
        stringBuffer.append("EXISTS (").append("SELECT ");
        stringBuffer.append("CHANNELID").append(" FROM ");
        stringBuffer.append("WCMCHANNEL").append(" WHERE ");
        stringBuffer.append("WCMDOCUMENT").append(".DocChannel=");
        stringBuffer.append("WCMCHANNEL").append('.');
        stringBuffer.append("CHANNELID").append(" AND ");
        if (baseChannel.isSite()) {
            stringBuffer.append("SiteId=").append(baseChannel.getId()).append(")");
        } else {
            stringBuffer.append("(").append("CHANNELID").append("=");
            stringBuffer.append(baseChannel.getId()).append(" OR ParentId=");
            stringBuffer.append(baseChannel.getId()).append("))");
        }
        String string2 = "DOCID, DocTitle";
        WCMFilter wCMFilter = new WCMFilter("", stringBuffer.toString(), "", string2);
        Documents documents = Documents.openWCMObjs(user, wCMFilter);
        if (documents.isEmpty()) {
            return;
        }
        stringBuffer.setLength(0);
        if (baseChannel.isSite()) {
            stringBuffer.append(I18NMessage.get(ChannelMgr.class, "ChannelMgr.label16", "\u7ad9\u70b9\u4e0b\u7684"));
        } else {
            stringBuffer.append(I18NMessage.get(ChannelMgr.class, "ChannelMgr.label17", "\u680f\u76ee\u4e0b\u7684"));
        }
        for (int i = 0; i < documents.size(); ++i) {
            Document document = (Document)documents.getAt(i);
            if (document == null) continue;
            stringBuffer.append("\n[").append(document);
            stringBuffer.append(I18NMessage.get(ChannelMgr.class, "ChannelMgr.label18", "]\u88ab[")).append(document.getLockerUser());
            stringBuffer.append(I18NMessage.get(ChannelMgr.class, "ChannelMgr.label19", "]\u9501\u5b9a!"));
        }
        throw new WCMException(1100, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label20", "\u4e0d\u80fd\u5220\u9664!\u56e0\u4e3a:\n") + stringBuffer);
    }

    private void moveToAsChild(Channel channel, BaseChannel baseChannel) throws WCMException {
        this.validateMoveToAsChild(channel, baseChannel);
        WebSite webSite = channel.getSite();
        if (!channel.canEdit(ContextHelper.getLoginUser())) {
            throw new WCMException(1013, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label21", "\u680f\u76ee\u5bf9\u8c61[") + channel.getName() + I18NMessage.get(ChannelMgr.class, "ChannelMgr.label22", "]\u5df2\u88ab\u7528\u6237[") + channel.getLockerUserName() + I18NMessage.get(ChannelMgr.class, "ChannelMgr.label23", "]\u9501\u5b9a\uff0c\u6682\u65f6\u4e0d\u80fd\u79fb\u52a8\uff01"));
        }
        try {
            this.changeDataPathOnMoveAsChild(channel, baseChannel);
            ArrayList<Object> arrayList = new ArrayList<Object>(1);
            arrayList.add(baseChannel.getKey());
            if (baseChannel.isSite()) {
                channel.setParent(0);
                channel.setSite(baseChannel.getId());
                channel.setOrder(DBManager.getDBManager().sqlExecuteQuery("select min(ChnlOrder) from WCMChannel where ParentId=0 and SiteId=?", (List)arrayList, -1));
            } else {
                channel.setParent(baseChannel.getId());
                channel.setSite(((Channel)baseChannel).getSiteId());
                channel.setOrder(DBManager.getDBManager().sqlExecuteQuery("select min(ChnlOrder) from WCMChannel where ParentId=?", (List)arrayList, -1));
            }
            this.save(channel);
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label24", "\u79fb\u52a8\u680f\u76ee\u5931\u8d25\uff01") + wCMException.getMyMessage(), wCMException);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label24", "\u79fb\u52a8\u680f\u76ee\u5931\u8d25\uff01"), exception);
        }
        if (webSite.getId() != channel.getSiteId()) {
            this.setChnlSite(channel);
        }
    }

    private void validateMoveToAsChild(BaseChannel baseChannel, BaseChannel baseChannel2) throws WCMException {
        Channel channel;
        if (baseChannel.isSite()) {
            return;
        }
        if (baseChannel.getSite().getId() != baseChannel2.getSiteId() && (channel = Channel.findByName(baseChannel2.getSiteId(), baseChannel.getName())) != null) {
            throw new WCMException(10, baseChannel2 + I18NMessage.get(ChannelMgr.class, "ChannelMgr.label25", "\u4e0b\u5df2\u5b58\u5728\u540d\u79f0\u4e3a[") + baseChannel.getName() + I18NMessage.get(ChannelMgr.class, "ChannelMgr.label26", "]\u7684\u680f\u76ee,\u680f\u76ee\u4e0d\u5141\u8bb8\u91cd\u540d!"));
        }
    }

    private void setChnlSite(Channel channel) throws WCMException {
        if (channel == null) {
            return;
        }
        int n = channel.getSiteId();
        List list = channel.getChildren(this.getLoginUser());
        Channel channel2 = null;
        if (list == null || list.isEmpty()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            channel2 = (Channel)list.get(i);
            if (channel2 != null) {
                try {
                    channel2.canEdit(ContextHelper.getLoginUser());
                    channel2.setSite(n);
                    this.save(channel2);
                }
                catch (Exception exception) {
                    m_oLogger.debug((Object)(I18NMessage.get(ChannelMgr.class, "ChannelMgr.label27", "\u4fee\u6539\u680f\u76ee\u7ad9\u70b9\u5c5e\u6027\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u6709\u680f\u76ee\u3010") + channel2.getId() + I18NMessage.get(ChannelMgr.class, "ChannelMgr.label28", "\u3011\u6ca1\u6709\u66f4\u65b0\uff1a") + exception.toString()));
                    throw new WCMException(1100, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label27", "\u4fee\u6539\u680f\u76ee\u7ad9\u70b9\u5c5e\u6027\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u6709\u680f\u76ee\u3010") + channel2.getId() + I18NMessage.get(ChannelMgr.class, "ChannelMgr.label29", "\u3011\u6ca1\u6709\u66f4\u65b0"), exception);
                }
                this.setChnlSite(channel2);
                continue;
            }
            m_oLogger.error((Object)I18NMessage.get(ChannelMgr.class, "ChannelMgr.label30", "\u4ece\u680f\u76ee\u96c6\u5408\u4e2d\u53d6\u51fa\u4e86\u4e00\u4e2a\u7a7a\u7684\u680f\u76ee\uff01setChnlSite"));
        }
    }

    public WebSites getWebSites(WCMFilter wCMFilter, boolean bl) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("WCMWEBSITE", "", "SiteOrder", "SiteId");
        if (!bl) {
            wCMFilter2.setWhere("Status=0");
        }
        wCMFilter2.mergeWith(wCMFilter);
        try {
            return WebSites.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
        }
        catch (WCMException wCMException) {
            m_oLogger.debug((Object)(I18NMessage.get(ChannelMgr.class, "ChannelMgr.label31", "\u83b7\u53d6\u7cfb\u7edf\u4e2d\u6240\u6709\u7684\u7ad9\u70b9\u5931\u8d25:") + wCMException.getStackTraceText()));
            throw new WCMException(1100, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label32", "\u83b7\u53d6\u7cfb\u7edf\u4e2d\u6240\u6709\u7684\u7ad9\u70b9\u5931\u8d25"), wCMException);
        }
    }

    public void moveTo(Channel channel, BaseChannel baseChannel, int n) throws WCMException {
        if (baseChannel.isSite()) {
            this.moveTo(channel, (WebSite)baseChannel, n);
        } else {
            this.moveTo(channel, (Channel)baseChannel, n);
        }
    }

    public void moveTo(Channel channel, WebSite webSite, int n) throws WCMException {
        this.validateChnl2Site(channel, webSite, n);
        if (n == 1) {
            this.moveToAsChild(channel, webSite);
        }
    }

    private void validateChnl2Site(Channel channel, WebSite webSite, int n) throws WCMException {
        if (n == 0) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label33", "\u76ee\u524d\u6682\u65f6\u4e0d\u652f\u6301\u5c06\u680f\u76ee\u79fb\u52a8\u6210\u4e3a\u7ad9\u70b9\uff01"));
        }
        if (channel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label34", "\u6b32\u79fb\u52a8\u7684\u680f\u76ee\u4e3a\u7a7a\uff01"));
        }
        if (webSite == null) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label35", "\u76ee\u6807\u7ad9\u70b9\u4e3a\u7a7a\uff01"));
        }
    }

    public void moveTo(Channel channel, Channel channel2, int n) throws WCMException {
        this.validateChnl2Chnl(channel, channel2);
        if (n == 1) {
            this.moveToAsChild(channel, channel2);
        } else {
            this.moveToAsBrother(channel, channel2);
        }
    }

    private void validateChnl2Chnl(Channel channel, Channel channel2) throws WCMException {
        if (channel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label34", "\u6b32\u79fb\u52a8\u7684\u680f\u76ee\u4e3a\u7a7a\uff01"));
        }
        if (channel2 == null) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label36", "\u76ee\u6807\u680f\u76ee\u4e3a\u7a7a\uff01"));
        }
    }

    private void moveToAsBrother(Channel channel, BaseChannel baseChannel) throws WCMException {
        BaseChannel baseChannel2 = null;
        if (baseChannel.getParentId() == 0) {
            if (baseChannel.getSite() == null) {
                throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label37", "\u76ee\u6807\u7ad9\u70b9\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u79fb\u52a8\uff01"));
            }
            baseChannel2 = baseChannel.getSite();
        } else {
            baseChannel2 = Channel.findById(baseChannel.getParentId());
            if (baseChannel2 == null) {
                throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label38", "\u76ee\u6807\u680f\u76ee\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u79fb\u52a8\uff01"));
            }
        }
        this.moveToAsChild(channel, baseChannel2);
    }

    protected DBManager getDBManager() throws WCMException {
        DBManager dBManager = DBManager.getDBManager();
        if (dBManager == null || !dBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label39", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!dBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(ChannelMgr.class, "ChannelMgr.label40", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        return dBManager;
    }

    public WebSites getRecycleSites(WCMFilter wCMFilter) throws WCMException {
        User user = this.getLoginUser();
        WCMFilter wCMFilter2 = new WCMFilter("", "Status=-1", "");
        wCMFilter2.mergeWith(wCMFilter);
        return WebSites.openWCMObjs(user, wCMFilter2);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void changeDataPathOnMoveAsChild(Channel channel, BaseChannel baseChannel) throws WCMException {
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
        WCMFolderPublishConfig wCMFolderPublishConfig = new WCMFolderPublishConfig(iPublishFolder);
        String string = wCMFolderPublishConfig.getDataPath();
        if (CMyString.isEmpty(string)) {
            return;
        }
        String string2 = string;
        int n = 1;
        while (this.existsDataPath(baseChannel, string2)) {
            string2 = string + "_" + n;
            ++n;
        }
        if (string2.equals(string)) {
            return;
        }
        wCMFolderPublishConfig.setDataPath(string2);
        User user = ContextHelper.getLoginUser();
        wCMFolderPublishConfig.canEdit(user);
        wCMFolderPublishConfig.save(user);
    }

    private boolean existsDataPath(BaseChannel baseChannel, String string) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return false;
        }
        WCMFilter wCMFilter = new WCMFilter("WCMFOLDERPUBLISHCONFIG", "", "", "FolderId");
        String string2 = baseChannel.isSite() ? "DataPath=? and FolderType=? and exists(select WCMChannel.ChannelId from WCMChannel where WCMChannel.SiteId=? and WCMChannel.ParentId=0 and WCMFOLDERPUBLISHCONFIG.FolderId=WCMChannel.ChannelId)" : " DataPath=? and FolderType=? and exists(select WCMChannel.ChannelId from WCMChannel where WCMChannel.ParentId=? and WCMFOLDERPUBLISHCONFIG.FolderId=WCMChannel.ChannelId)";
        wCMFilter.setWhere(string2);
        wCMFilter.addSearchValues(string);
        wCMFilter.addSearchValues(101);
        wCMFilter.addSearchValues(baseChannel.getId());
        return DBManager.getDBManager().sqlExecuteIntQuery(wCMFilter) > 0;
    }
}

