/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.logo.Logo;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.util.CMyDateTime;

public class ChannelLCListenerForWebSiteLastModifyTime
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnModify,
IObjectLCListenerOnDel {
    private WebSite getWebSite(BaseObj baseObj) throws WCMException {
        Logo logo;
        Channel channel = null;
        if (baseObj instanceof Channel) {
            channel = (Channel)baseObj;
        } else if (baseObj instanceof Logo && (logo = (Logo)baseObj).getHostType() == 101) {
            channel = Channel.findById(logo.getHostId());
        }
        if (channel != null) {
            return channel.getSite();
        }
        return null;
    }

    private void updateLastModifyTime(BaseObj baseObj) throws WCMException {
        WebSite webSite = this.getWebSite(baseObj);
        if (webSite == null) {
            return;
        }
        webSite.setProperty("lastmodifytime", CMyDateTime.now());
        webSite.save();
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        this.updateLastModifyTime(baseObj);
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        this.updateLastModifyTime(baseObj);
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        this.updateLastModifyTime(baseObj);
    }
}

