/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.publish.region.CellInfos;
import com.trs.components.wcm.publish.region.RegionEmployMgr;
import com.trs.components.wcm.publish.region.RegionEmploys;
import com.trs.components.wcm.publish.region.RegionInfo;
import com.trs.components.wcm.publish.region.RegionInfos;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import org.apache.log4j.Logger;

public class BaseChannelLCListener4Region
implements IObjectLCListenerOnDel {
    private static Logger s_logger = Logger.getLogger(BaseChannelLCListener4Region.class);

    public void notifyOnDelObj(BaseObj baseObj, int n) {
        if (baseObj instanceof BaseChannel) {
            RegionInfos regionInfos = null;
            try {
                regionInfos = this.getRegionInfosByObj((BaseChannel)baseObj);
            }
            catch (WCMException wCMException) {
                s_logger.error((Object)"\u83b7\u53d6\u5c5e\u4e8e\u5f53\u524d\u5bf9\u8c61\u4e0b\u7684\u5bfc\u8bfb\u96c6\u5408\u5931\u8d25\uff01", (Throwable)wCMException);
            }
            if (regionInfos == null || regionInfos.size() == 0) {
                return;
            }
            int n2 = regionInfos.size();
            for (int i = 0; i < n2; ++i) {
                RegionInfo regionInfo = (RegionInfo)regionInfos.getAt(i);
                if (regionInfo == null) continue;
                try {
                    regionInfo.delete();
                    this.deleteCellInfos(regionInfo);
                    this.deleteRegionEmploys(regionInfo);
                    continue;
                }
                catch (WCMException wCMException) {
                    s_logger.error((Object)("\u5220\u9664\u6307\u5b9a\u5bfc\u8bfb\u3010" + regionInfo.getName() + "\u3011\u5931\u8d25\uff01"), (Throwable)wCMException);
                }
            }
        } else {
            s_logger.error((Object)"\u5f53\u524d\u76d1\u542c\u7684\u5bf9\u8c61\u5fc5\u987b\u662f\u7ad9\u70b9\u6216\u8005\u680f\u76ee\uff01");
        }
    }

    private RegionInfos getRegionInfosByObj(BaseChannel baseChannel) throws WCMException {
        if (baseChannel == null) {
            return null;
        }
        int n = baseChannel.getWCMType();
        int n2 = baseChannel.getId();
        if (n == 103) {
            return RegionInfos.findBySiteId(n2, null);
        }
        if (n == 101) {
            return RegionInfos.findByChannelId(n2);
        }
        return null;
    }

    private void deleteCellInfos(RegionInfo regionInfo) throws WCMException {
        if (regionInfo == null) {
            return;
        }
        CellInfos cellInfos = CellInfos.findCellInfos(regionInfo, null);
        if (cellInfos != null) {
            cellInfos.removeAll();
        }
    }

    private void deleteRegionEmploys(RegionInfo regionInfo) throws WCMException {
        RegionEmployMgr regionEmployMgr = (RegionEmployMgr)DreamFactory.createObjectById("RegionEmployMgr");
        RegionEmploys regionEmploys = regionEmployMgr.getRegionEmploysByRegion(regionInfo);
        if (regionEmploys != null) {
            regionEmploys.removeAll();
        }
    }
}

