/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content;

import com.eprobiti.trs.TRSException;
import com.eprobiti.trs.TRSResultSet;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.wcm.content.ViewDocument;
import com.trs.components.wcm.content.domain.DatasWithChnlDocFilterHelper;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.content.trsserver.TRSToWCMFilter;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyMemory;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.DebugTimer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ViewDocuments
extends CMSBaseObjs {
    private static Logger logger = Logger.getLogger(ViewDocuments.class);
    public static final String DB_TABLE_NAME = "WCMCHNLDOC";
    public static final String ID_FIELD_NAME = "RECID";
    private boolean m_bFromRecycle = false;
    private String m_sSelectFieldsFromDocument = null;
    private String m_sSelectFieldsFromChnlDoc = "WCMCHNLDOC.RecId,WCMCHNLDOC.ChnlId,WCMCHNLDOC.DocId,WCMCHNLDOC.DocChannel";
    public static final Integer ID_NOT_LOAD = new Integer(0);
    private static final long ONE_MINUTES = 60000L;
    public static boolean QUERY_ACCORD_DOCUMENT_RIGHT = true;
    public static int MAX_FETCH_SIZE = 500;
    private Map m_hViewDocumentsCache = null;
    private HashMap m_oPublicCache = new HashMap(2);
    private int m_nRightIndex = -1;
    private DatasWithChnlDocFilterHelper m_oFilterMaker = new DatasWithChnlDocFilterHelper();

    public ViewDocuments(User user) {
        super(user);
    }

    public ViewDocuments(User user, int n, int n2) {
        super(user, n, n2);
    }

    protected String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public Class getElementClass() {
        return ViewDocument.class;
    }

    public String getIdFieldName() {
        return ID_FIELD_NAME;
    }

    public BaseObjs newInstance() throws Exception {
        return new ViewDocuments(null);
    }

    public BaseChannel getCurrChannelOrSite() {
        return (BaseChannel)this.getPublicCache().get(ViewDocument.KEY_CURR_HOST);
    }

    public boolean canSort() {
        BaseChannel baseChannel = this.getCurrChannelOrSite();
        if (baseChannel == null) {
            return false;
        }
        if (baseChannel.isSite()) {
            return false;
        }
        Channel channel = (Channel)baseChannel;
        if (channel.isOnlySearch()) {
            return false;
        }
        String string = channel.getOrderBy();
        return string == null || (string = string.trim()).length() <= 0 || string.toUpperCase().indexOf("DOCORDERPRI") >= 0;
    }

    public HashMap getPublicCache() {
        return this.m_oPublicCache;
    }

    protected WCMFilter getHostFilter(Object object, WCMFilter wCMFilter) throws WCMException {
        if (object instanceof Channels) {
            return this.m_oFilterMaker.makeChannelFilter((Channels)object, wCMFilter, this.isFromRecycle());
        }
        if (object instanceof Channel) {
            return this.m_oFilterMaker.makeChannelFilter((Channel)object, wCMFilter, true, this.isFromRecycle());
        }
        if (object instanceof WebSite) {
            return this.m_oFilterMaker.makeFilter((WebSite)object, wCMFilter, true, this.isFromRecycle());
        }
        if (object instanceof WebSites) {
            return this.m_oFilterMaker.makeFilter((WebSites)object, wCMFilter, true, this.isFromRecycle());
        }
        return wCMFilter;
    }

    public void open(Channels channels, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = this.getHostFilter(channels, wCMFilter);
        if (wCMFilter2 == null) {
            return;
        }
        if (channels.size() == 1) {
            this.getPublicCache().put(ViewDocument.KEY_CURR_HOST, channels.getAt(0));
        }
        this.openViewDocuments(wCMFilter2);
    }

    public void open(Channel channel, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = this.getHostFilter(channel, wCMFilter);
        if (wCMFilter2 == null) {
            return;
        }
        this.getPublicCache().put(ViewDocument.KEY_CURR_HOST, channel);
        this.openViewDocuments(wCMFilter2);
    }

    public void open(WebSite webSite, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = this.getHostFilter(webSite, wCMFilter);
        if (wCMFilter2 == null) {
            return;
        }
        this.getPublicCache().put(ViewDocument.KEY_CURR_HOST, webSite);
        this.openViewDocuments(wCMFilter2);
    }

    public void open(WebSites webSites, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = this.getHostFilter(webSites, wCMFilter);
        if (wCMFilter2 == null) {
            return;
        }
        if (webSites.size() == 1) {
            this.getPublicCache().put(ViewDocument.KEY_CURR_HOST, webSites.getAt(0));
        }
        this.openViewDocuments(wCMFilter2);
    }

    public void openViewDocuments(WCMFilter wCMFilter) throws WCMException {
        if (CMyString.isEmpty(wCMFilter.getFrom())) {
            wCMFilter.setFrom(DB_TABLE_NAME);
        }
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)"openViewDocuments SQL Info:");
            logger.fatal((Object)(wCMFilter + "\n"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
        DebugTimer debugTimer = new DebugTimer();
        debugTimer.start();
        int n = DBManager.getDBManager().sqlExecuteCountQuery(wCMFilter);
        debugTimer.stop();
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)("Query Count use [" + debugTimer.getTime() + "]ms!"));
            logger.fatal((Object)(wCMFilter.toCountQueryInfo() + "\n"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
        if (n == 0) {
            return;
        }
        CPager cPager = new CPager(this.getPageSize());
        cPager.setItemCount(n);
        cPager.setCurrentPageIndex(this.getCurrPage());
        debugTimer.start();
        this.loadPrePageDatas(wCMFilter, cPager);
        debugTimer.stop();
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)("loadPrePageDatas use [" + debugTimer.getTime() + "]ms!"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
        if (this.isEmpty() || !this.needDocumentFields()) {
            return;
        }
        debugTimer.start();
        this.loadPageDocuments(cPager.getCurrentPageIndex() - 1);
        debugTimer.stop();
        if (logger.isDebugEnabled()) {
            logger.fatal((Object)("loadPageDocuments use [" + debugTimer.getTime() + "]ms!"));
            logger.fatal((Object)CMyMemory.toMemoryInfo());
        }
    }

    protected boolean needDocumentFields() {
        return !CMyString.isEmpty(this.getSelectFieldsFromDocument());
    }

    /*
     * Loose catch block
     */
    private void loadPrePageDatas(WCMFilter wCMFilter, CPager cPager) throws WCMException {
        block29: {
            DebugTimer debugTimer = new DebugTimer();
            this.vIdList = new Vector(cPager.getItemCount());
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            String string = "";
            WCMFilter wCMFilter2 = null;
            if (this.currMode == 2) {
                throw new WCMException(1100, I18NMessage.get(ViewDocuments.class, "ViewDocuments.label1", "\u7f16\u8f91\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u5237\u65b0\u96c6\u5408\uff01") + this.getClass().getName());
            }
            wCMFilter2 = this.makeQueryPreDataFilter(wCMFilter);
            string = wCMFilter2.toSQL();
            connection = this.getDBManager().getConnection();
            statement = connection.prepareStatement(string);
            if (cPager.getPageSize() < 0) {
                if (cPager.getItemCount() < MAX_FETCH_SIZE) {
                    statement.setFetchSize(cPager.getItemCount());
                } else {
                    statement.setFetchSize(MAX_FETCH_SIZE);
                }
            } else if (cPager.getPageSize() < MAX_FETCH_SIZE) {
                statement.setFetchSize(cPager.getPageSize());
            } else {
                statement.setFetchSize(MAX_FETCH_SIZE);
            }
            DBManager.setParameters((PreparedStatement)statement, wCMFilter2);
            debugTimer.start();
            resultSet = statement.executeQuery();
            debugTimer.stop();
            if (logger.isDebugEnabled()) {
                logger.fatal((Object)wCMFilter2);
            }
            int n = 0;
            ResultSetMetaData resultSetMetaData = null;
            while (resultSet.next()) {
                if (++n < cPager.getFirstItemIndex()) {
                    this.vIdList.add(ID_NOT_LOAD);
                    continue;
                }
                if (resultSetMetaData == null) {
                    resultSetMetaData = resultSet.getMetaData();
                }
                ViewDocument viewDocument = (ViewDocument)this.createElementInstance();
                viewDocument.readChnlDocPropertyFromRs(resultSet, resultSetMetaData);
                if (this.m_nRightIndex != -1 && QUERY_ACCORD_DOCUMENT_RIGHT && DocumentAuthServer.isDefineRightOnDocument(viewDocument.getDocId())) {
                    RightValue rightValue = new RightValue();
                    rightValue.load(this.currUser, 605, viewDocument.getDocId(), true);
                    if (!this.hasRight(rightValue)) {
                        String string2 = DBManager.getDBManager().sqlExecuteStringQuery("select CrUser from WCMDocument where DocId=?", new int[]{viewDocument.getDocId()});
                        if (!this.currUser.getName().equals(string2)) {
                            --n;
                            cPager.setItemCount(cPager.getItemCount() - 1);
                            continue;
                        }
                    }
                }
                int n2 = resultSet.getInt(this.getIdFieldName());
                this.vIdList.add(new Integer(n2));
                if (this.m_oObjsBuffer == null) {
                    this.m_oObjsBuffer = new Hashtable();
                }
                this.m_oObjsBuffer.put(viewDocument.getKey(), viewDocument);
                this.putViewDocument(viewDocument.getDocId(), viewDocument);
                if (n < cPager.getLastItemIndex()) continue;
                break;
            }
            resultSet.close();
            for (int i = n; i < cPager.getItemCount(); ++i) {
                this.vIdList.add(ID_NOT_LOAD);
            }
            this.currIndex = this.size() > 0 ? 0 : -2;
            Object var17_18 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (connection != null) {
                this.getDBManager().freeConnection(connection);
            }
            break block29;
            {
                catch (SQLException sQLException) {
                    throw new WCMException(40, I18NMessage.get(ViewDocuments.class, "ViewDocuments.label2", "\u9884\u5148\u8bfb\u5165\u5c0f\u6570\u636e\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38\uff08") + this.getClass().getName() + ".refresh)\uff1a\n" + wCMFilter2, sQLException);
                }
                catch (Exception exception) {
                    throw new WCMException(0, I18NMessage.get(ViewDocuments.class, "ViewDocuments.label3", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".refresh)", exception);
                }
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (connection != null) {
                    this.getDBManager().freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    protected BaseObj createElementInstance() throws WCMException {
        return new ViewDocument(this.getPublicCache());
    }

    private boolean hasRight(RightValue rightValue) {
        if (this.m_nRightIndex == 64) {
            return rightValue.getValue() > 0L;
        }
        return rightValue.isHasRight(this.m_nRightIndex);
    }

    private WCMFilter makeQueryPreDataFilter(WCMFilter wCMFilter) {
        WCMFilter wCMFilter2 = new WCMFilter(wCMFilter);
        String string = wCMFilter.getFrom();
        if (string == null || (string = string.trim()).length() == 0) {
            wCMFilter2.setFrom(this.getDbTableName());
        }
        wCMFilter2.setSelect(this.m_sSelectFieldsFromChnlDoc);
        return wCMFilter2;
    }

    private boolean loadPageDocuments(int n) throws WCMException {
        if (this.pageSize == -1) {
            this.pageSize = MAX_FETCH_SIZE;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.size()) {
                this.loadPageDocuments(n2);
                n3 += MAX_FETCH_SIZE;
                ++n2;
            }
            return true;
        }
        return this.realLoadPageDocuments(n);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean realLoadPageDocuments(int var1_1) throws WCMException {
        block28: {
            block24: {
                var2_2 = this.makeLoadPageDocumentsSQL(var1_1);
                if (var2_2 == null) {
                    return false;
                }
                var3_3 = new DebugTimer();
                var4_4 = null;
                var5_5 = null;
                var6_6 = null;
                var7_7 = null;
                try {
                    try {
                        var4_4 = this.getDBManager().getConnection();
                        var5_5 = var4_4.prepareStatement(var2_2);
                        var5_5.setMaxRows(this.pageSize);
                        if (this.pageSize > ViewDocuments.MAX_FETCH_SIZE) {
                            var5_5.setFetchSize(ViewDocuments.MAX_FETCH_SIZE);
                        } else {
                            var5_5.setFetchSize(this.pageSize);
                        }
                        this.setPageDocumentsPreStmtParams(var1_1, var5_5);
                        var3_3.start();
                        var6_6 = var5_5.executeQuery();
                        var3_3.stop();
                        if (ViewDocuments.logger.isDebugEnabled() && var3_3.getTime() > ViewDocuments.DEBUG_USE_TIME) {
                            ViewDocuments.logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] executeQuery from db use [" + var3_3.getTime() + "]ms"));
                            ViewDocuments.logger.debug((Object)("strSQL:" + var2_2));
                        }
                        var3_3.start();
                        while (var6_6.next()) {
                            if (var7_7 == null) {
                                var7_7 = var6_6.getMetaData();
                            }
                            if ((var9_11 = this.getViewDocuments(var8_8 = var6_6.getInt("DOCID"))) == null) {
                                this.printErrorInfo(var8_8, var2_2, I18NMessage.get(ViewDocuments.class, "ViewDocuments.label4", "ViewDocument\u7f13\u51b2\u7ef4\u62a4\u6709\u95ee\u9898\uff1f\u6307\u5b9a\u7684DocId\u5bf9\u5e94\u7684ViewDocument\u4e0d\u80fd\u83b7\u5f97\uff01"));
                                continue;
                            }
                            var10_12 = var9_11[0];
                            var10_12.readFromRs(var6_6, var7_7);
                            var12_14 = var9_11.length;
                            for (var11_13 = 1; var11_13 < var12_14; ++var11_13) {
                                var9_11[var11_13].cloneDocumentProperties(var10_12);
                            }
                        }
                        var3_3.stop();
                        if (ViewDocuments.logger.isDebugEnabled() && var3_3.getTime() > ViewDocuments.DEBUG_USE_TIME) {
                            ViewDocuments.logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] get data from db use [" + var3_3.getTime() + "]ms"));
                            ViewDocuments.logger.debug((Object)("strSQL:" + var2_2));
                        }
                        var8_8 = 1;
                        var14_15 = null;
                        if (var6_6 == null) break block24;
                    }
                    catch (SQLException var8_9) {
                        throw new WCMException(40, I18NMessage.get(ViewDocuments.class, "ViewDocuments.label5", "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08") + this.getClass().getName() + ".loadPage)\uff1aSQL=" + var2_2, var8_9);
                    }
                    catch (Exception var8_10) {
                        throw new WCMException(0, I18NMessage.get(ViewDocuments.class, "ViewDocuments.label5", "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08") + this.getClass().getName() + ".loadPage)\uff1aSQL=" + var2_2, var8_10);
                    }
                }
                catch (Throwable var13_19) {
                    var14_16 = null;
                    if (var6_6 != null) {
                        try {
                            var6_6.close();
                        }
                        catch (Exception var15_18) {
                            // empty catch block
                        }
                    }
                    if (var5_5 != null) {
                        try {
                            var5_5.close();
                        }
                        catch (Exception var15_18) {
                            // empty catch block
                        }
                    }
                    if (var4_4 == null) throw var13_19;
                    this.getDBManager().freeConnection(var4_4);
                    throw var13_19;
                }
                ** try [egrp 2[TRYBLOCK] [4 : 560->570)] { 
lbl74:
                // 1 sources

                var6_6.close();
                break block24;
lbl76:
                // 1 sources

                catch (Exception var15_17) {
                    // empty catch block
                }
            }
            if (var5_5 != null) {
                ** try [egrp 3[TRYBLOCK] [5 : 577->587)] { 
lbl81:
                // 1 sources

                var5_5.close();
                break block28;
lbl83:
                // 1 sources

                catch (Exception var15_17) {
                    // empty catch block
                }
            }
        }
        if (var4_4 == null) return (boolean)var8_8;
        this.getDBManager().freeConnection(var4_4);
        return (boolean)var8_8;
    }

    protected void printErrorInfo(int n, String string, String string2) {
        logger.error((Object)string2);
        logger.error((Object)("DocId:" + n));
        logger.error((Object)("strSQL:" + string));
        logger.error((Object)("m_oObjsBuffer:" + this.m_oObjsBuffer));
        logger.error((Object)("m_oObjsBuffer.size:" + this.m_oObjsBuffer.size()));
    }

    private void setPageDocumentsPreStmtParams(int n, PreparedStatement preparedStatement) throws SQLException {
        int n2;
        int n3 = this.getStartPos(n);
        if (n3 >= (n2 = this.getEndPos(n3)) || n3 < 0) {
            return;
        }
        int n4 = n3;
        int n5 = 1;
        while (n4 < n2) {
            ViewDocument viewDocument = (ViewDocument)this.getAt(n4);
            if (viewDocument == null) {
                this.printErrorInfo(this.getIdAt(n4), null, I18NMessage.get(ViewDocuments.class, "ViewDocuments.label6", "setPageDocumentsPreStmtParams\u53d1\u73b0\u7a0b\u5e8f\u9519\u8bef\uff01"));
                preparedStatement.setInt(n5, 0);
            } else {
                preparedStatement.setInt(n5, viewDocument.getDocId());
            }
            ++n4;
            ++n5;
        }
    }

    private String makeLoadPageDocumentsSQL(int n) {
        this.setSelectFieldsFromDocument("DocId," + this.getSelectFieldsFromDocument());
        String string = "WCMDOCUMENT";
        String string2 = this.makeLoadPageWhere(n, "DOCID");
        StringBuffer stringBuffer = new StringBuffer(this.getSelectFieldsFromDocument().length() + string.length() + string2.length() + 21);
        stringBuffer.append("select ");
        stringBuffer.append(this.getSelectFieldsFromDocument());
        stringBuffer.append(" from ");
        stringBuffer.append(string);
        if (string2.length() > 0) {
            stringBuffer.append(" where ");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    protected String makeLoadPageWhere(int n, String string) {
        int n2;
        int n3 = this.getStartPos(n);
        if (n3 >= (n2 = this.getEndPos(n3)) || n3 < 0) {
            return "";
        }
        String string2 = string + " in(";
        string2 = string2 + "?";
        for (int i = n3 + 1; i < n2; ++i) {
            string2 = string2 + ", ?";
        }
        string2 = string2 + ")";
        return string2;
    }

    private void putViewDocument(int n, ViewDocument viewDocument) {
        if (this.m_hViewDocumentsCache == null) {
            this.m_hViewDocumentsCache = this.pageSize > 0 ? new HashMap(this.pageSize) : new HashMap(this.vIdList.capacity());
        }
        ViewDocument[] viewDocumentArray = null;
        Integer n2 = new Integer(n);
        viewDocumentArray = (ViewDocument[])this.m_hViewDocumentsCache.get(n2);
        if (viewDocumentArray == null) {
            viewDocumentArray = new ViewDocument[]{viewDocument};
        } else {
            int n3 = viewDocumentArray.length;
            ViewDocument[] viewDocumentArray2 = new ViewDocument[n3 + 1];
            if (n3 > 0) {
                System.arraycopy(viewDocumentArray, 0, viewDocumentArray2, 0, n3);
            }
            viewDocumentArray2[n3] = viewDocument;
            viewDocumentArray = viewDocumentArray2;
        }
        this.m_hViewDocumentsCache.put(n2, viewDocumentArray);
    }

    protected ViewDocument[] getViewDocuments(int n) {
        if (this.m_hViewDocumentsCache == null) {
            return null;
        }
        Integer n2 = new Integer(n);
        return (ViewDocument[])this.m_hViewDocumentsCache.get(n2);
    }

    public void open(CMSBaseObjs cMSBaseObjs, WCMFilter wCMFilter) throws WCMException {
        if (cMSBaseObjs instanceof Channels) {
            this.open((Channels)cMSBaseObjs, wCMFilter);
        } else if (cMSBaseObjs instanceof WebSites) {
            this.open((WebSites)cMSBaseObjs, wCMFilter);
        } else {
            throw new WCMException(I18NMessage.get(ViewDocuments.class, "ViewDocuments.label7", "\u672a\u77e5\u7684\u6570\u636e\u7c7b\u578b[") + cMSBaseObjs.getClassName(true) + "]\uff01");
        }
    }

    public boolean isFromRecycle() {
        return this.m_bFromRecycle;
    }

    public void setFromRecycle(boolean bl) {
        this.m_bFromRecycle = bl;
    }

    public void setSelectFieldsFromChnlDoc(String string) {
        if (string == null || (string = string.trim()).length() == 0) {
            return;
        }
        String[] stringArray = string.split(",");
        String string2 = "WCMCHNLDOC.";
        int n = string.indexOf(46) > 0 ? string2.length() : 0;
        StringBuffer stringBuffer = new StringBuffer(string.length() + n * stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            if (stringArray[i].indexOf(46) < 0) {
                stringBuffer.append(string2);
            }
            stringBuffer.append(stringArray[i]);
        }
        this.m_sSelectFieldsFromChnlDoc = stringBuffer.toString();
    }

    public void setSelectFieldsFromDocument(String string) {
        this.m_sSelectFieldsFromDocument = string;
    }

    public String getSelectFieldsFromDocument() {
        return this.m_sSelectFieldsFromDocument;
    }

    public void setSelectFields(String string, String string2) {
        this.setSelectFieldsFromChnlDoc(string);
        this.setSelectFieldsFromDocument(string2);
    }

    public int getRightIndex() {
        return this.m_nRightIndex;
    }

    public void setRightIndex(int n) {
        this.m_nRightIndex = n;
    }

    public void setNeedWithAuthFilter(User user, boolean bl) {
        this.m_oFilterMaker.setNeedWithAuthFilter(user, bl);
    }

    public void openTRSServerViewDocuments(TRSResultSet tRSResultSet, TRSToWCMFilter tRSToWCMFilter, CPager cPager) {
        int n;
        this.vIdList = new Vector(cPager.getItemCount());
        if (this.m_oObjsBuffer == null) {
            this.m_oObjsBuffer = new Hashtable();
        }
        int n2 = (cPager.getCurrentPageIndex() - 1) * cPager.getPageSize();
        DebugTimer debugTimer = new DebugTimer();
        int n3 = 0;
        for (n3 = 0; n3 < cPager.getFirstItemIndex() - 1; ++n3) {
            this.vIdList.add(ID_NOT_LOAD);
        }
        try {
            n = 0;
            debugTimer.start();
            tRSResultSet.moveTo(0, (long)n2);
            int n4 = cPager.getPageSize();
            while (n < n4) {
                Object object;
                ++n;
                ++n3;
                ViewDocument viewDocument = (ViewDocument)this.createElementInstance();
                Enumeration enumeration = tRSToWCMFilter.getTRSFields();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    String[] stringArray = tRSToWCMFilter.getWCMField((String)object);
                    if (((String)object).equalsIgnoreCase(tRSToWCMFilter.getIDFieldName())) {
                        viewDocument.setDocId(tRSResultSet.getInt((String)object));
                        continue;
                    }
                    if (((String)object).equalsIgnoreCase("doctitle")) {
                        viewDocument.setPropertyWithString((String)stringArray, tRSResultSet.getString((String)object, "red"));
                        continue;
                    }
                    if (((String)object).equalsIgnoreCase("doccontent")) {
                        viewDocument.setPropertyWithString((String)stringArray, tRSResultSet.getString((String)object));
                        viewDocument.setAttribute("doccontent", tRSResultSet.getStringWithCutsize((String)object, 200, "red"));
                        continue;
                    }
                    viewDocument.setPropertyWithString((String)stringArray, tRSResultSet.getString((String)object));
                }
                object = null;
                try {
                    int n5 = tRSResultSet.getInt("recid");
                    object = new Integer(n5);
                }
                catch (TRSException tRSException) {
                    continue;
                }
                viewDocument.setChnlDocProperty("recid", object);
                viewDocument.setChnlDocProperty("chnlid", new Integer(tRSResultSet.getInt("docchannel")));
                for (String string : new String[]{"docstatus", "docorderpri", "modal"}) {
                    viewDocument.setChnlDocProperty(string, new Integer(tRSResultSet.getInt(string)));
                }
                this.vIdList.add(object);
                this.m_oObjsBuffer.put(object, viewDocument);
                if (n3 < cPager.getLastItemIndex() && tRSResultSet.moveNext()) continue;
                break;
            }
            debugTimer.stop();
        }
        catch (Exception exception) {
            logger.error((Object)"load data from trsserver failed.", (Throwable)exception);
        }
        if (debugTimer.getTime() > 60000L) {
            logger.warn((Object)("load data from trsserver too long(ms): " + debugTimer.getTime()));
        }
        for (n = n3; n < cPager.getItemCount(); ++n) {
            this.vIdList.add(ID_NOT_LOAD);
        }
    }

    /*
     * Loose catch block
     */
    public void loadFrom(Documents documents, String string) throws WCMException {
        block22: {
            int n = documents.size();
            if (n <= 0) {
                return;
            }
            this.vIdList = new Vector(n);
            DBManager dBManager = DBManager.getDBManager();
            Connection connection = dBManager.getConnection();
            Statement statement = null;
            ResultSet resultSet = null;
            string = CMyString.showNull(string, "").toLowerCase();
            if (("," + string + ",").indexOf(",recid,") < 0) {
                string = CMyString.isEmpty(string) ? "recid" : string + ",recid";
            }
            String string2 = "select " + string + " from WCMChnlDoc where DocId=? and Modal=" + 1;
            int n2 = documents.size();
            for (int i = 0; i < n2; ++i) {
                Document document = (Document)documents.getAt(i);
                if (document == null) continue;
                ViewDocument viewDocument = (ViewDocument)this.createElementInstance();
                statement = connection.prepareStatement(string2);
                statement.setInt(1, document.getId());
                resultSet = statement.executeQuery();
                if (!resultSet.next()) continue;
                viewDocument.readChnlDocPropertyFromRs(resultSet, resultSet.getMetaData());
                int n3 = resultSet.getInt(this.getIdFieldName());
                this.vIdList.add(new Integer(n3));
                if (this.m_oObjsBuffer == null) {
                    this.m_oObjsBuffer = new Hashtable();
                }
                this.m_oObjsBuffer.put(viewDocument.getKey(), viewDocument);
                this.putViewDocument(viewDocument.getDocId(), viewDocument);
                resultSet.close();
                resultSet = null;
                statement.close();
                statement = null;
                viewDocument.setProperties(document.getProperties());
            }
            Object var15_15 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
            break block22;
            {
                catch (Exception exception) {
                    throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff01", exception);
                }
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (connection != null) {
                    dBManager.freeConnection(connection);
                }
                throw throwable;
            }
        }
    }
}

