/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.key.CKeyUtil;
import com.trs.license.License;
import com.trs.license.LicenseException;
import com.trs.license.LicenseUtil;

public class MySite
implements License {
    private static final String LICENSE = "license/LICENSE.trswcm";
    private static int m_nMaxSiteNum = -1;

    public int getMaxSiteNum() {
        if (m_nMaxSiteNum < 0) {
            this.validate();
        }
        return m_nMaxSiteNum;
    }

    public int getMaxUserNum() {
        return 0;
    }

    public int getPluginCode() {
        return 0;
    }

    public String validate() {
        try {
            String string = MySite.getProductKey();
            String string2 = string.substring(12, 14);
            int n = CKeyUtil.getKeyNum(string2);
            if (n == 99) {
                return I18NMessage.get(MySite.class, "MySite.label1", "Platform\u7684License");
            }
            m_nMaxSiteNum = n;
            return null;
        }
        catch (Throwable throwable) {
            return "Validate Exception\uff01Site" + throwable;
        }
    }

    private static String getProductKey() {
        String string = MySite.loadLicenseFile();
        string = LicenseUtil.decodeRadix64(string);
        return CKeyUtil.DecodeKey(string);
    }

    private static String loadLicenseFile() {
        String string = "";
        Class<MySite> clazz = MySite.class;
        String string2 = clazz.getClassLoader().getResource(LICENSE).getFile();
        try {
            string = CMyFile.readFile(string2).trim();
        }
        catch (CMyException cMyException) {
            int n = cMyException.getErrNo();
            if (55 == n) {
                throw new LicenseException(I18NMessage.get(MySite.class, "MySite.label2", "\u975e\u6cd5\u4f7f\u7528!\u6ca1\u6709\u627e\u5230\u5408\u6cd5\u7684License."));
            }
            throw new LicenseException(I18NMessage.get(MySite.class, "MySite.label3", "\u7cfb\u7edf\u542f\u52a8\u5f02\u5e38!\u6821\u9a8c\u4f7f\u7528\u8bb8\u53ef\u5931\u8d25"));
        }
        String string3 = LicenseUtil.decodeRadix64(string);
        return string3;
    }
}

