/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.DocBak;
import com.trs.components.wcm.content.persistent.DocBaks;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.update.IUpdateCommander;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.apache.log4j.Logger;

public class ContentUpdateCommanderImpl
implements IUpdateCommander {
    private static Logger s_logger = Logger.getLogger(ContentUpdateCommanderImpl.class);
    private AppendixMgr m_oAppendixMgr = null;
    public static boolean UPDATE_FROM_DB = true;

    public void doUpdate() {
        this.updateFileDocuments();
        this.updateFileDocBaks();
        if (!UPDATE_FROM_DB) {
            this.updateLinkDocuments();
            this.updateLinkDocBaks();
        }
    }

    private void updateLinkDocuments() {
        try {
            User user = User.findByName("admin");
            String string = "DocType=30";
            WCMFilter wCMFilter = new WCMFilter("", string, "");
            Documents documents = Documents.openWCMObjs(user, wCMFilter);
            int n = documents.size();
            for (int i = 0; i < n; ++i) {
                Document document = (Document)documents.getAt(i);
                if (document == null) continue;
                String string2 = null;
                try {
                    int n2;
                    string2 = document.getPlace();
                    if (string2 == null || string2.length() == 0) {
                        string2 = document.getContent();
                    }
                    if (string2 == null || string2.length() == 0) continue;
                    int n3 = string2.indexOf("/t200");
                    if (n3 > 0 && (n2 = string2.indexOf("_", n3)) > 0) {
                        string2 = string2.substring(0, n3 + 2) + string2.substring(n2 + 1);
                    }
                    document.setProperty("DOCLINK", string2);
                    document.update();
                }
                catch (Exception exception) {
                    s_logger.error((Object)(I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label1", "\u66f4\u65b0 ") + document + I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label2", " \u94fe\u63a5\u53d1\u751f\u5f02\u5e38")), (Throwable)exception);
                    continue;
                }
                s_logger.info((Object)(I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label3", "\u6210\u529f\u66f4\u65b0[") + document + I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label4", "]\u7684\u94fe\u63a5\u5730\u5740[") + string2 + I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label5", "]\u5b58\u50a8\uff01")));
            }
        }
        catch (Exception exception) {
            s_logger.error((Object)I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label6", "[updateFileDocuments]\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLinkDocBaks() {
        WCMFilter wCMFilter = new WCMFilter("", "DocType=30", "");
        DocBaks docBaks = null;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        String string = "UPDATE WcmDocBak SET DocLink=? WHERE DocBakId=?";
        try {
            try {
                docBaks = DocBaks.openWCMObjs(null, wCMFilter);
                connection = DBManager.getDBManager().getConnection();
                preparedStatement = connection.prepareStatement(string);
                for (int i = 0; i < docBaks.size(); ++i) {
                    int n;
                    DocBak docBak = (DocBak)docBaks.getAt(i);
                    if (docBak == null) continue;
                    String string2 = null;
                    string2 = docBak.getPlace();
                    if (CMyString.isEmpty(string2)) {
                        string2 = docBak.getContent();
                    }
                    if (CMyString.isEmpty(string2)) continue;
                    int n2 = string2.indexOf("/t200");
                    if (n2 > 0 && (n = string2.indexOf("_", n2)) > 0) {
                        string2 = string2.substring(0, n2 + 2) + string2.substring(n + 1);
                    }
                    preparedStatement.setString(1, string2);
                    preparedStatement.setInt(2, docBak.getId());
                    preparedStatement.execute();
                }
                Object var12_12 = null;
                this.freeResource(connection, preparedStatement, docBaks);
            }
            catch (Exception exception) {
                s_logger.error((Object)I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label7", "[updateLinkDocBaks]\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)exception);
                Object var12_13 = null;
                this.freeResource(connection, preparedStatement, docBaks);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.freeResource(connection, preparedStatement, docBaks);
            throw throwable;
        }
    }

    private void freeResource(Connection connection, PreparedStatement preparedStatement, DocBaks docBaks) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (connection != null) {
            DBManager.getDBManager().freeConnection(connection);
        }
        if (docBaks != null) {
            docBaks.clear();
        }
    }

    private void updateFileDocuments() {
        try {
            User user = User.findByName("admin");
            String string = "DocType=40";
            WCMFilter wCMFilter = new WCMFilter("", string, "");
            Documents documents = Documents.openWCMObjs(user, wCMFilter);
            int n = documents.size();
            for (int i = 0; i < n; ++i) {
                Document document = (Document)documents.getAt(i);
                if (document == null) continue;
                Appendix appendix = this.getAppendix(document, 0);
                if (appendix == null) {
                    s_logger.error((Object)("[" + document + I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label8", "]\u7684\u5916\u90e8\u6587\u4ef6\u4e0d\u5b58\u5728!")));
                    continue;
                }
                try {
                    document.setProperty("DOCFILENAME", appendix.getFile());
                    document.update();
                }
                catch (Exception exception) {
                    s_logger.error((Object)(I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label1", "\u66f4\u65b0 ") + document + I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label9", " \u5916\u90e8\u6587\u4ef6\u53d1\u751f\u5f02\u5e38")), (Throwable)exception);
                    continue;
                }
                s_logger.info((Object)(I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label3", "\u6210\u529f\u66f4\u65b0[") + document + I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label10", "]\u7684\u5916\u90e8\u6587\u4ef6[") + appendix.getFile() + I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label5", "]\u5b58\u50a8\uff01")));
            }
        }
        catch (Exception exception) {
            s_logger.error((Object)I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label6", "[updateFileDocuments]\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFileDocBaks() {
        String string = "DocType=40";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        DocBaks docBaks = null;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        String string2 = "UPDATE WcmDocBak SET DocFileName=? WHERE DocBakId=?";
        try {
            try {
                connection = DBManager.getDBManager().getConnection();
                preparedStatement = connection.prepareStatement(string2);
                docBaks = DocBaks.openWCMObjs(null, wCMFilter);
                for (int i = 0; i < docBaks.size(); ++i) {
                    DocBak docBak = (DocBak)docBaks.getAt(i);
                    if (docBak == null) continue;
                    Appendix appendix = this.getAppendix(docBak, 0);
                    if (appendix == null) {
                        s_logger.error((Object)("[" + docBak + I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label8", "]\u7684\u5916\u90e8\u6587\u4ef6\u4e0d\u5b58\u5728!")));
                        continue;
                    }
                    try {
                        preparedStatement.setString(1, appendix.getFile());
                        preparedStatement.setInt(2, docBak.getId());
                        preparedStatement.execute();
                    }
                    catch (Exception exception) {
                        s_logger.error((Object)(I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label1", "\u66f4\u65b0 ") + docBak + I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label9", " \u5916\u90e8\u6587\u4ef6\u53d1\u751f\u5f02\u5e38")), (Throwable)exception);
                        continue;
                    }
                    s_logger.info((Object)(I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label3", "\u6210\u529f\u66f4\u65b0[") + docBak + I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label10", "]\u7684\u5916\u90e8\u6587\u4ef6[") + appendix.getFile() + I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label5", "]\u5b58\u50a8\uff01")));
                }
                Object var12_12 = null;
                this.freeResource(connection, preparedStatement, docBaks);
            }
            catch (Exception exception) {
                s_logger.error((Object)I18NMessage.get(ContentUpdateCommanderImpl.class, "ContentUpdateCommanderImpl.label11", "[updateFileDocBaks]\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)exception);
                Object var12_13 = null;
                this.freeResource(connection, preparedStatement, docBaks);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.freeResource(connection, preparedStatement, docBaks);
            throw throwable;
        }
    }

    private Appendix getAppendix(Document document, int n) throws WCMException {
        this.m_oAppendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        Appendixes appendixes = this.m_oAppendixMgr.getAppendixes(document, n);
        if (appendixes.isEmpty()) {
            return null;
        }
        return (Appendix)appendixes.getAt(0);
    }
}

