/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.channel;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.WCMSystemObject;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.wcm.channel.VChannel;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.WCMPubStatusConfig;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.PinyinHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VChannelManager {
    private static final String[] ADDEDIT_PAGES = new String[]{"../document/document_addedit.jsp", "../photo/photo_upload.jsp", "", "", ""};
    private static final String[] LIST_PAGES = new String[]{"../document/document_list.html", "../photo/photo_thumb.html", "", "", ""};
    private static final String[] SHOW_PAGES = new String[]{"../document/document_detail.jsp", "../photo/photo_show.jsp", "", "", ""};

    public void save(WebSite webSite, VChannel vChannel) throws WCMException {
        Map map = vChannel.getProperties();
        if (!map.isEmpty()) {
            Channel channel = new Channel();
            channel.setDesc(vChannel.getDesc());
            channel.setCanPub(true);
            channel.setType(0);
            channel.setSite(webSite.getId());
            channel.setOrder(1);
            channel.setParent(0);
            int n = webSite.getType();
            channel.setProperty("CONTENTADDEDITPAGE", ADDEDIT_PAGES[n]);
            channel.setProperty("CONTENTLISTPAGE", LIST_PAGES[n]);
            channel.setProperty("CONTENTSHOWPAGE", SHOW_PAGES[n]);
            String string = vChannel.getName();
            if (Channel.findByName(webSite.getSiteId(), string) != null) {
                channel.setNextId();
                string = string + "_" + channel.getId();
            }
            channel.setName(string);
            channel.insert(ContextHelper.getLoginUser());
            List list = vChannel.getChildren();
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                this.save(channel, (VChannel)list.get(i));
            }
            this.savePubConf(channel, string);
        } else {
            List list = vChannel.getChildren();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.save(webSite, (VChannel)list.get(i));
            }
        }
    }

    public void save(Channel channel, VChannel vChannel) throws WCMException {
        Map map = vChannel.getProperties();
        if (!map.isEmpty()) {
            Channel channel2 = new Channel();
            channel2.setDesc(vChannel.getDesc());
            channel2.setCanPub(true);
            channel2.setType(0);
            channel2.setOrder(1);
            channel2.setSite(channel.getSiteId());
            channel2.setParent(channel.getId());
            int n = channel.getSite().getType();
            channel2.setProperty("CONTENTADDEDITPAGE", ADDEDIT_PAGES[n]);
            channel2.setProperty("CONTENTLISTPAGE", LIST_PAGES[n]);
            channel2.setProperty("CONTENTSHOWPAGE", SHOW_PAGES[n]);
            String string = vChannel.getName();
            if (Channel.findByName(channel.getSiteId(), string) != null) {
                channel2.setNextId();
                string = string + "_" + channel2.getId();
            }
            channel2.setName(string);
            channel2.insert(ContextHelper.getLoginUser());
            List list = vChannel.getChildren();
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                this.save(channel2, (VChannel)list.get(i));
            }
            this.savePubConf(channel2, string);
        } else {
            List list = vChannel.getChildren();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.save(channel, (VChannel)list.get(i));
            }
        }
    }

    private void savePubConf(BaseChannel baseChannel, String string) throws WCMException {
        Object object;
        FolderPublishConfig folderPublishConfig = new FolderPublishConfig();
        folderPublishConfig.setDataPath(this.getDatapath(baseChannel, string));
        folderPublishConfig.setFolder(baseChannel.getWCMType(), baseChannel.getId());
        if (baseChannel.isSite()) {
            folderPublishConfig.setPageEncoding("UTF-8");
            folderPublishConfig.setSiteLanguage(8);
            object = "";
            try {
                object = (String)ContextParameters.get(1, true);
                object = (String)object + "/pub/" + folderPublishConfig.getDataPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            folderPublishConfig.setRootDomain((String)object);
        }
        object = ContextHelper.getLoginUser();
        folderPublishConfig.save((User)object);
        if (baseChannel.isSite()) {
            WCMPubStatusConfig wCMPubStatusConfig = new WCMPubStatusConfig();
            wCMPubStatusConfig.setFolderType(baseChannel);
            wCMPubStatusConfig.setStatusesCanDoPub("16,10");
            wCMPubStatusConfig.setStatusIdAfterModify(1);
            wCMPubStatusConfig.save((User)object);
        }
    }

    private String getDatapath(BaseChannel baseChannel, String string) throws WCMException {
        DBManager dBManager;
        String string2 = PinyinHelper.getFirstLetter(string, true);
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        arrayList.add(new Integer(baseChannel.getWCMType()));
        arrayList.add(string2);
        String string3 = "select FOLDERPUBLISHCONFIGID from WCMFOLDERPUBLISHCONFIG where FOLDERTYPE=? and DATAPATH=?";
        if (!baseChannel.isSite()) {
            string3 = string3 + " and exists(select CHANNELID from WCMCHANNEL where PARENTID=? and channelid=WCMFOLDERPUBLISHCONFIG.FOLDERID and WCMFOLDERPUBLISHCONFIG.FOLDERTYPE=101";
            int n = baseChannel.getParentId();
            arrayList.add(new Integer(n));
            if (n == 0) {
                string3 = string3 + " and SITEID=?";
                arrayList.add(new Integer(baseChannel.getSiteId()));
            }
            string3 = string3 + ")";
        }
        if ((dBManager = DBManager.getDBManager()).sqlExecuteIntQuery(string3, arrayList) >= 1) {
            string2 = string2.replaceAll("(_\\d+)+", "");
            string2 = string2 + "_" + baseChannel.getId();
        }
        return string2;
    }

    public void save(WCMSystemObject wCMSystemObject, VChannel vChannel) throws WCMException {
        Map map = vChannel.getProperties();
        if (!map.isEmpty()) {
            WebSite webSite = new WebSite();
            webSite.setDesc(vChannel.getDesc());
            webSite.setOrder(1);
            webSite.setType(wCMSystemObject.getId());
            webSite.setParent(0);
            String string = vChannel.getName();
            if (this.existSite(string)) {
                webSite.setNextId();
                string = string + "_" + webSite.getId();
            }
            webSite.setName(string);
            User user = ContextHelper.getLoginUser();
            webSite.insert(user);
            List list = vChannel.getChildren();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.save(webSite, (VChannel)list.get(i));
            }
            this.savePubConf(webSite, string);
        } else {
            List list = vChannel.getChildren();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.save(wCMSystemObject, (VChannel)list.get(i));
            }
        }
    }

    private boolean existSite(String string) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string2 = "select SITEID from WCMWEBSITE where SITENAME=?";
        DBManager dBManager = DBManager.getDBManager();
        try {
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            return resultSet.next() && resultSet.getInt(1) > 0;
        }
        catch (Exception exception) {
            return true;
        }
    }
}

