/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.advisor;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.advisor.Advisor;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;

public class Step
extends CMSObj {
    public static final int OBJ_TYPE = 78549201;
    public static final String DB_TABLE_NAME = "XWCMSTEP";
    public static final String DB_ID_NAME = "STEPID";
    public static final int MULTI_SELECT_TYPE = 1;
    public static final int SINGLE_SELECT_TYPE = 0;
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;

    public static String getSelectTypeString(int n) {
        switch (n) {
            case 1: {
                return I18NMessage.get(Step.class, "Step.label1", "\u591a\u9009");
            }
            case 0: {
                return I18NMessage.get(Step.class, "Step.label2", "\u5355\u9009");
            }
        }
        return I18NMessage.get(Step.class, "Step.label2", "\u5355\u9009");
    }

    public static String getSelectTypeInfo(int n) {
        switch (n) {
            case 1: {
                return "checkbox";
            }
            case 0: {
                return "radio";
            }
        }
        return "radio";
    }

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 78549201;
    }

    public String getStepName() {
        return this.getPropertyAsString("STEPNAME");
    }

    public boolean setStepName(String string) throws WCMException {
        return this.setProperty("STEPNAME", string);
    }

    public String getStepDesc() {
        return this.getPropertyAsString("STEPDESC");
    }

    public boolean setStepDesc(String string) throws WCMException {
        return this.setProperty("STEPDESC", string);
    }

    public boolean isMultiSelect() {
        return this.getPropertyAsBoolean("ISMULTISELECT", false);
    }

    public boolean setMultiSelect(boolean bl) throws WCMException {
        return this.setProperty("ISMULTISELECT", bl);
    }

    public int getAdvisorId() {
        return this.getPropertyAsInt("ADVISORID", 0);
    }

    public boolean setAdvisorId(int n) throws WCMException {
        return this.setProperty("ADVISORID", n);
    }

    public int getOrder() {
        return this.getPropertyAsInt("AORDER", 0);
    }

    public boolean setOrder(int n) throws WCMException {
        return this.setProperty("AORDER", n);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("STEPNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(Step.class, "Step.label3", "\u5c5e\u6027StepName\u6ca1\u6709\u8bbe\u7f6e(Step.isValid)"));
            }
            if (this.getProperty("ISMULTISELECT") == null) {
                throw new WCMException(1106, I18NMessage.get(Step.class, "Step.label4", "\u5c5e\u6027IsMultiSelect\u6ca1\u6709\u8bbe\u7f6e(Step.isValid)"));
            }
            if (this.getProperty("ADVISORID") == null) {
                throw new WCMException(1106, I18NMessage.get(Step.class, "Step.label5", "\u5c5e\u6027AdvisorId\u6ca1\u6709\u8bbe\u7f6e(Step.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(Step.class, "Step.label6", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Step.isValid)"));
        }
        this.changeOrder();
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(user);
        }
    }

    private void changeOrder() throws WCMException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.isAddMode()) {
            n2 = this.getOrder();
            n = this.getMaxOrder();
            if (n2 == -1) {
                n2 = n + 1;
                this.setOrder(n2);
                return;
            }
            n5 = 1;
            n4 = n;
            n3 = n2;
        } else {
            if (!this.isChangeProperty("AORDER")) {
                return;
            }
            n2 = this.getNewPropertyAsInt("AORDER", -1);
            if (n2 == -1) {
                n = this.getMaxOrder();
                if (n == this.getOrder()) {
                    n2 = this.getOrder();
                } else {
                    n5 = -1;
                    n4 = n;
                    n3 = this.getOrder() + 1;
                    n2 = n;
                }
            } else if (n2 > this.getOrder()) {
                n5 = -1;
                n4 = n2;
                n3 = this.getOrder() + 1;
            } else {
                n5 = 1;
                n4 = this.getOrder() - 1;
                n3 = n2;
            }
        }
        String string = "AORDER>=" + n3 + " AND AORDER <= " + n4 + " and ADVISORID=" + this.getAdvisorId();
        String string2 = "UPDATE XWCMSTEP SET AORDER = AORDER+(" + n5 + ") WHERE " + string;
        DBManager.getDBManager().sqlExecuteUpdate(string2);
        this.setOrder(n2);
    }

    private int getMaxOrder() throws WCMException {
        return DBManager.getDBManager().sqlExecuteIntQuery("select max(AORDER) from XWCMSTEP where ADVISORID=?", new int[]{this.getAdvisorId()});
    }

    public static final Step findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (Step)BaseObj.findById(Step.class, n);
    }

    public static final Step createNewInstance() throws WCMException {
        return (Step)BaseObj.createNewInstance(Step.class);
    }

    public static final Step findByKey(Object object) throws WCMException {
        return (Step)BaseObj.findByKey(Step.class, object);
    }

    public Advisor getAdvisor() throws WCMException {
        return Advisor.findById(this.getAdvisorId());
    }
}

