/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.advisor;

import com.trs.components.wcm.advisor.Advisor;
import com.trs.components.wcm.advisor.Option;
import com.trs.components.wcm.advisor.OptionGroup;
import com.trs.components.wcm.advisor.OptionGroups;
import com.trs.components.wcm.advisor.Options;
import com.trs.components.wcm.advisor.Step;
import com.trs.components.wcm.advisor.Steps;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class AdvisorXMLMaker {
    private List m_arFiles = new ArrayList();

    public List getRelateFiles() {
        return this.m_arFiles;
    }

    public String parseToXML(Advisor advisor) throws WCMException {
        Element element = DocumentHelper.createElement((String)"consultant");
        element.addAttribute("name", advisor.getAdvisorName());
        element.addAttribute("viewName", advisor.getViewName());
        WCMFilter wCMFilter = new WCMFilter("", "ADVISORID=?", "AOrder");
        wCMFilter.addSearchValues(advisor.getId());
        Steps steps = Steps.openWCMObjs(null, wCMFilter);
        int n = steps.size();
        for (int i = 0; i < n; ++i) {
            Step step = (Step)steps.getAt(i);
            Element element2 = this.makeXMLElement(step);
            element.add(element2);
        }
        return element.asXML();
    }

    private Element makeXMLElement(Step step) throws WCMException {
        Element element = DocumentHelper.createElement((String)"step");
        element.addAttribute("id", String.valueOf(step.getId()));
        element.addAttribute("name", step.getStepName());
        element.addAttribute("seq", String.valueOf(step.getOrder()));
        int n = step.getPropertyAsInt("ISMULTISELECT", 0);
        element.addAttribute("type", String.valueOf(Step.getSelectTypeInfo(n)));
        WCMFilter wCMFilter = new WCMFilter("", "STEPID=?", "AOrder");
        wCMFilter.addSearchValues(step.getId());
        OptionGroups optionGroups = OptionGroups.openWCMObjs(null, wCMFilter);
        int n2 = optionGroups.size();
        for (int i = 0; i < n2; ++i) {
            OptionGroup optionGroup = (OptionGroup)optionGroups.getAt(i);
            Element element2 = this.makeXMLElement(optionGroup);
            element.add(element2);
        }
        return element;
    }

    private Element makeXMLElement(OptionGroup optionGroup) throws WCMException {
        Element element = DocumentHelper.createElement((String)"optiongroup");
        element.addAttribute("id", String.valueOf(optionGroup.getId()));
        element.addAttribute("name", optionGroup.getOptionGroupName());
        element.addAttribute("previousproblem", optionGroup.getLastOptions());
        element.addAttribute("inputName", optionGroup.getOptionGroupDesc());
        WCMFilter wCMFilter = new WCMFilter("", "GROUPID=?", "AOrder");
        wCMFilter.addSearchValues(optionGroup.getId());
        Options options = Options.openWCMObjs(null, wCMFilter);
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.getAt(i);
            Element element2 = this.makeXMLElement(option);
            element.add(element2);
        }
        return element;
    }

    private Element makeXMLElement(Option option) throws WCMException {
        Element element = DocumentHelper.createElement((String)"option");
        String string = option.getPicFileName();
        if (!CMyString.isEmpty(string)) {
            this.m_arFiles.add(string);
        }
        element.addAttribute("id", String.valueOf(option.getId()));
        element.addAttribute("seq", String.valueOf(option.getOrder()));
        element.addAttribute("desc", option.getOptionName());
        element.addAttribute("pic", option.getPicFileName());
        element.addAttribute("query", option.getSearchCondition());
        element.addAttribute("previousproblem", option.getLastOptions());
        element.addAttribute("uirelation", option.getNotAllowedSelectOptions());
        element.addAttribute("srcstep", String.valueOf(option.getStepId()));
        return element;
    }
}

