/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.advisor;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.advisor.Advisor;
import com.trs.components.wcm.advisor.Advisors;
import com.trs.components.wcm.advisor.Option;
import com.trs.components.wcm.advisor.OptionGroup;
import com.trs.components.wcm.advisor.OptionGroups;
import com.trs.components.wcm.advisor.Options;
import com.trs.components.wcm.advisor.Step;
import com.trs.components.wcm.advisor.Steps;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AdvisorMgr {
    private static Logger logger = Logger.getLogger(AdvisorMgr.class);
    private Map m_mOptionIdMapping;

    public Advisors queryByChannel(Channel channel, WCMFilter wCMFilter) throws WCMException {
        if (channel == null) {
            throw new WCMException(10, I18NMessage.get(AdvisorMgr.class, "AdvisorMgr.label1", "\u680f\u76ee\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u987e\u95ee\u6570\u636e\uff01"));
        }
        User user = this.getLoginUser();
        boolean bl = AuthServer.hasRight(user, (CMSObj)channel, 14);
        if (!bl) {
            throw new WCMException(CMyString.format(I18NMessage.get(AdvisorMgr.class, "AdvisorMgr.label2", "\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u770b\u680f\u76ee[{0}]\u4e0b\u7684\u987e\u95ee\uff01"), new String[]{channel.getDesc()}));
        }
        WCMFilter wCMFilter2 = new WCMFilter("", "ChannelId=?", "");
        wCMFilter2.addSearchValues(channel.getId());
        wCMFilter2.mergeWith(wCMFilter);
        return Advisors.openWCMObjs(user, wCMFilter2);
    }

    public Steps queryStepsByAdvisor(Advisor advisor, WCMFilter wCMFilter) throws WCMException {
        if (advisor == null) {
            throw new WCMException(10, I18NMessage.get(AdvisorMgr.class, "AdvisorMgr.label3", "\u987e\u95ee\u5bf9\u8c61\u65e0\u6548\uff0c\u65e0\u6cd5\u83b7\u53d6\u5176\u6b65\u9aa4\uff01"));
        }
        int n = advisor.getId();
        WCMFilter wCMFilter2 = new WCMFilter("", "ADVISORID=?", "AORDER ASC");
        wCMFilter2.addSearchValues(n);
        wCMFilter2.mergeWith(wCMFilter);
        return Steps.openWCMObjs(null, wCMFilter2);
    }

    public OptionGroups queryOptionGroupsByStep(Step step, WCMFilter wCMFilter) throws WCMException {
        if (step == null) {
            throw new WCMException(10, I18NMessage.get(AdvisorMgr.class, "AdvisorMgr.label4", "\u987e\u95ee\u6b65\u9a5f\u5bf9\u8c61\u65e0\u6548\uff0c\u65e0\u6cd5\u83b7\u53d6\u5176\u9009\u9879\u7ec4\uff01"));
        }
        int n = step.getId();
        WCMFilter wCMFilter2 = new WCMFilter("", "STEPID=?", "AORDER ASC");
        wCMFilter2.addSearchValues(n);
        wCMFilter2.mergeWith(wCMFilter);
        return OptionGroups.openWCMObjs(null, wCMFilter2);
    }

    public Options queryOptionsByOptionGroup(OptionGroup optionGroup, WCMFilter wCMFilter) throws WCMException {
        if (optionGroup == null) {
            throw new WCMException(10, I18NMessage.get(AdvisorMgr.class, "AdvisorMgr.label5", "\u987e\u95ee\u6b65\u9aa4\u5bf9\u8c61\u65e0\u6548\uff0c\u65e0\u6cd5\u83b7\u53d6\u5176\u9009\u9879\u7ec4\uff01"));
        }
        int n = optionGroup.getId();
        WCMFilter wCMFilter2 = new WCMFilter("", "GROUPID=?", "AORDER ASC");
        wCMFilter2.addSearchValues(n);
        wCMFilter2.mergeWith(wCMFilter);
        return Options.openWCMObjs(null, wCMFilter2);
    }

    public Options queryOptionsByAdvisor(Advisor advisor, WCMFilter wCMFilter) throws WCMException {
        String string = "EXISTS(SELECT 1 FROM XWCMOPTIONGROUP WHERE XWCMOPTIONGROUP.OPTIONGROUPID = XWCMOPTION.GROUPID AND EXISTS(SELECT 1 FROM XWCMSTEP WHERE XWCMSTEP.STEPID = XWCMOPTIONGROUP.STEPID AND EXISTS(SELECT 1 FROM XWCMADVISOR WHERE XWCMADVISOR.ADVISORID = ? AND XWCMADVISOR.ADVISORID = XWCMSTEP.ADVISORID)))";
        WCMFilter wCMFilter2 = new WCMFilter("", string, "AORDER ASC");
        wCMFilter2.addSearchValues(advisor.getId());
        wCMFilter2.mergeWith(wCMFilter);
        return Options.openWCMObjs(null, wCMFilter2);
    }

    public void deleteAdvisor(Advisor advisor) throws WCMException {
        if (advisor == null) {
            throw new WCMException(10, I18NMessage.get(AdvisorMgr.class, "AdvisorMgr.label6", "\u5f85\u5220\u9664\u7684\u987e\u95ee\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        Steps steps = this.queryStepsByAdvisor(advisor, null);
        for (int i = steps.size() - 1; i >= 0; --i) {
            Step step = (Step)steps.getAt(i);
            if (step == null) continue;
            this.deleteStep(step);
        }
        advisor.delete();
    }

    public void deleteStep(Step step) throws WCMException {
        if (step == null) {
            throw new WCMException(10, I18NMessage.get(AdvisorMgr.class, "AdvisorMgr.label7", "\u5f85\u5220\u9664\u7684\u6b65\u9aa4\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        OptionGroups optionGroups = this.queryOptionGroupsByStep(step, null);
        for (int i = optionGroups.size() - 1; i >= 0; --i) {
            OptionGroup optionGroup = (OptionGroup)optionGroups.getAt(i);
            if (optionGroup == null) continue;
            this.deleteOptionGroup(optionGroup);
        }
        step.delete();
    }

    public void deleteOptionGroup(OptionGroup optionGroup) throws WCMException {
        if (optionGroup == null) {
            throw new WCMException(10, I18NMessage.get(AdvisorMgr.class, "AdvisorMgr.label8", "\u5f85\u5220\u9664\u7684\u9009\u9879\u7ec4\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        Options options = this.queryOptionsByOptionGroup(optionGroup, null);
        for (int i = options.size() - 1; i >= 0; --i) {
            Option option = (Option)options.getAt(i);
            if (option == null) continue;
            this.deleteOption(option);
        }
        optionGroup.delete();
    }

    public void deleteOption(Option option) throws WCMException {
        if (option == null) {
            throw new WCMException(10, I18NMessage.get(AdvisorMgr.class, "AdvisorMgr.label9", "\u5f85\u5220\u9664\u7684\u9009\u9879\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        option.delete();
    }

    public void copy(Advisor advisor, Channels channels, User user) throws WCMException {
        int n = channels.size();
        for (int i = 0; i < n; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            this.copy(advisor, channel, user);
        }
    }

    public void copy(Advisor advisor, Channel channel, User user) throws WCMException {
        Object object;
        this.m_mOptionIdMapping = new HashMap();
        Advisor advisor2 = (Advisor)advisor.cloneToNewObj();
        advisor2.setChannelId(channel.getId());
        String string = advisor2.getAppendixFileName();
        if (!CMyString.isEmpty(string)) {
            object = FilesMan.getFilesMan();
            String string2 = ((FilesMan)object).copyWCMFile(string, "P0");
            advisor2.setAppendixFileName(string2);
        }
        advisor2.save(user);
        object = this.queryStepsByAdvisor(advisor, null);
        int n = ((BaseObjs)object).size();
        for (int i = 0; i < n; ++i) {
            Step step = (Step)((BaseObjs)object).getAt(i);
            if (step == null) continue;
            this.copy(step, advisor2, user);
        }
        this.afterAdvisorSave(advisor2);
    }

    private void afterAdvisorSave(Advisor advisor) throws WCMException {
        String string;
        Object object;
        int n;
        Object object2;
        Steps steps = this.queryStepsByAdvisor(advisor, null);
        int n2 = steps.size();
        for (int i = 0; i < n2; ++i) {
            Step step = (Step)steps.getAt(i);
            if (step == null) continue;
            object2 = this.queryOptionGroupsByStep(step, null);
            int n3 = ((BaseObjs)object2).size();
            for (n = 0; n < n3; ++n) {
                object = (OptionGroup)((BaseObjs)object2).getAt(n);
                if (object == null || CMyString.isEmpty(string = ((OptionGroup)object).getLastOptions())) continue;
                String string2 = this.getNewOptionIds(string);
                ((OptionGroup)object).setLastOptions(string2);
                ((CMSObj)object).save(ContextHelper.getLoginUser());
            }
        }
        Options options = this.queryOptionsByAdvisor(advisor, null);
        int n4 = options.size();
        for (n2 = 0; n2 < n4; ++n2) {
            object2 = (Option)options.getAt(n2);
            if (object2 == null) continue;
            n = 0;
            String string3 = ((Option)object2).getLastOptions();
            if (!CMyString.isEmpty(string3)) {
                object = this.getNewOptionIds(string3);
                ((Option)object2).setLastOptions((String)object);
                n = 1;
            }
            if (!CMyString.isEmpty((String)(object = ((Option)object2).getNotAllowedSelectOptions()))) {
                string = this.getNewOptionIds((String)object);
                ((Option)object2).setNotAllowedSelectOptions(string);
                n = 1;
            }
            if (n == 0) continue;
            ((CMSObj)object2).save(ContextHelper.getLoginUser());
        }
    }

    private void copy(Step step, Advisor advisor, User user) throws WCMException {
        Step step2 = (Step)step.cloneToNewObj();
        step2.setAdvisorId(advisor.getId());
        step2.save(user);
        OptionGroups optionGroups = this.queryOptionGroupsByStep(step, null);
        int n = optionGroups.size();
        for (int i = 0; i < n; ++i) {
            OptionGroup optionGroup = (OptionGroup)optionGroups.getAt(i);
            if (optionGroup == null) continue;
            this.copy(optionGroup, step2, user);
        }
    }

    private void copy(OptionGroup optionGroup, Step step, User user) throws WCMException {
        OptionGroup optionGroup2 = (OptionGroup)optionGroup.cloneToNewObj();
        optionGroup2.setStepId(step.getId());
        optionGroup2.save(user);
        Options options = this.queryOptionsByOptionGroup(optionGroup, null);
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)options.getAt(i);
            if (option == null) continue;
            this.copy(option, optionGroup2, user);
        }
    }

    private void copy(Option option, OptionGroup optionGroup, User user) throws WCMException {
        Option option2 = (Option)option.cloneToNewObj();
        option2.setGroupId(optionGroup.getId());
        String[] stringArray = new String[]{"PICTRUE"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = option.getPropertyAsString(stringArray[i]);
            if (CMyString.isEmpty(string)) continue;
            FilesMan filesMan = FilesMan.getFilesMan();
            if (!filesMan.fileExists(string)) {
                logger.error((Object)CMyString.format("\u987e\u95ee\u56fe\u7247\u65f6\u56fe\u7247\u4e0d\u5b58\u5728[{0}]", new String[]{string}));
                continue;
            }
            String string2 = filesMan.copyWCMFile(string, "P0");
            option2.setPropertyWithString(stringArray[i], string2);
        }
        option2.save(user);
        this.m_mOptionIdMapping.put(option.getKey(), option2.getKey());
    }

    private String getNewOptionIds(String string) {
        if (CMyString.isEmpty(string)) {
            return "";
        }
        int[] nArray = CMyString.splitToInt(string, ",");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            Integer n = (Integer)this.m_mOptionIdMapping.get(new Integer(nArray[i]));
            if (n == null) continue;
            stringBuffer.append(n).append(",");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

