/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.advisor;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;

public class Advisor
extends CMSObj {
    public static final int OBJ_TYPE = 1460271229;
    public static final String DB_TABLE_NAME = "XWCMADVISOR";
    public static final String DB_ID_NAME = "ADVISORID";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 1460271229;
    }

    public String getAdvisorName() {
        return this.getPropertyAsString("ADVISORNAME");
    }

    public boolean setAdvisorName(String string) throws WCMException {
        return this.setProperty("ADVISORNAME", string);
    }

    public String getViewName() {
        return this.getPropertyAsString("VIEWNAME");
    }

    public boolean setViewName(String string) throws WCMException {
        return this.setProperty("VIEWNAME", string);
    }

    public int getChannelId() {
        int n = this.getPropertyAsInt("CHANNELID", 0);
        return n;
    }

    public boolean setChannelId(int n) throws WCMException {
        return this.setProperty("CHANNELID", n);
    }

    public String getAppendixFileName() {
        return this.getPropertyAsString("APPENDIXFILENAME");
    }

    public boolean setAppendixFileName(String string) throws WCMException {
        return this.setProperty("APPENDIXFILENAME", string);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("ADVISORNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(Advisor.class, "Advisor.label1", "\u5c5e\u6027AdvisorName\u6ca1\u6709\u8bbe\u7f6e(Advisor.isValid)"));
            }
            String string = this.getPropertyAsString("APPENDIXFILENAME");
            if (!CMyString.isEmpty(string)) {
                string = FilesMan.getFilesMan().moveWCMFile(string, "P0", false);
                this.setAppendixFileName(string);
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Advisor.class, "Advisor.label2", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Advisor.isValid)"));
            }
            if (this.isChangeProperty("APPENDIXFILENAME")) {
                String string = this.getNewPropertyAsString("APPENDIXFILENAME");
                FilesMan filesMan = FilesMan.getFilesMan();
                String string2 = this.getAppendixFileName();
                if (!CMyString.isEmpty(string2)) {
                    String string3 = filesMan.mapFilePath(string2, 0) + string2;
                    CMyFile.deleteFile(string3);
                }
                if (!CMyString.isEmpty(string)) {
                    string = FilesMan.getFilesMan().moveWCMFile(string, "P0", false);
                    this.setAppendixFileName(string);
                }
            }
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(user);
        }
    }

    public int delete() throws WCMException {
        this.deleteRelationFiles();
        return super.delete();
    }

    public int delete(User user) throws WCMException {
        this.deleteRelationFiles();
        return super.delete(user);
    }

    private void deleteRelationFiles() throws WCMException {
        String string = this.getAppendixFileName();
        if (!CMyString.isEmpty(string)) {
            FilesMan filesMan = FilesMan.getFilesMan();
            String string2 = filesMan.mapFilePath(string, 0) + string;
            CMyFile.deleteFile(string2);
        }
    }

    public static final Advisor findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (Advisor)BaseObj.findById(Advisor.class, n);
    }

    public static final Advisor createNewInstance() throws WCMException {
        return (Advisor)BaseObj.createNewInstance(Advisor.class);
    }

    public static final Advisor findByKey(Object object) throws WCMException {
        return (Advisor)BaseObj.findByKey(Advisor.class, object);
    }

    public Channel getChannel() throws WCMException {
        return Channel.findById(this.getChannelId());
    }
}

