/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfigs;
import com.trs.components.stat.HostObjDomain;
import com.trs.components.stat.HostObjDomains;
import com.trs.components.stat.IURLParser;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class URLParser
implements IURLParser {
    private static Logger logger = Logger.getLogger(URLParser.class);
    private Map hostObjDomainMap;
    private Map urlsCache = new HashMap();
    private Pattern detailPattern = Pattern.compile("t\\d+_(\\d+)[^.]*\\.[^.]+$");

    public BaseObj parse(String string) throws WCMException {
        Matcher matcher;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u5f00\u59cb\u89e3\u6790\u8def\u5f84[" + string + "]"));
        }
        if ((matcher = this.detailPattern.matcher(string)).find()) {
            int n = Integer.parseInt(matcher.group(1));
            Document document = Document.findById(n);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u5c06url[" + string + "]\u89e3\u6790\u6210\u6587\u6863\u5bf9\u8c61[" + document + "]"));
            }
            return document;
        }
        return this.getBaseObj(string);
    }

    private BaseObj getBaseObj(String string) throws WCMException {
        int n;
        Stack<String> stack = new Stack<String>();
        String string2 = string;
        BaseObj baseObj = null;
        int n2 = string2.length() - 1;
        while ((n = string2.lastIndexOf("/", n2)) > 0) {
            stack.push(string2.substring(n + 1));
            string2 = string2.substring(0, n);
            baseObj = (BaseObj)this.urlsCache.get(string2);
            if (baseObj != null) {
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("\u4ece\u7f13\u5b58\u4e2d\u6620\u5c04url[" + string2 + "]->" + baseObj));
                break;
            }
            baseObj = this.getBaseObjFromHostObjDomain(string2);
            if (baseObj != null) {
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("\u4ece\u57df\u540d\u9690\u5c04\u4e2d\u6620\u5c04url[" + string2 + "]->" + baseObj));
                break;
            }
            baseObj = this.findWebSiteByRootDomain(string2);
            if (baseObj != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\u4ece\u6570\u636e\u5e93\u4e2d\u6620\u5c04\u7ad9\u70b9url[" + string2 + "]->" + baseObj));
                    logger.debug((Object)("\u5c06url[" + string2 + "]\u548cbaseObj[" + baseObj + "]\u653e\u5165cache"));
                }
                this.urlsCache.put(string2, baseObj);
                break;
            }
            n2 = n;
        }
        if (baseObj == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u6ca1\u6709\u627e\u5230url\u5bf9\u5e94\u7684\u5bf9\u8c61[" + string + "]"));
            }
            return null;
        }
        BaseChannel baseChannel = (BaseChannel)baseObj;
        while (!stack.empty()) {
            BaseChannel baseChannel2;
            String string3 = (String)stack.pop();
            if (CMyString.isEmpty(string3)) continue;
            if (string3.indexOf(".") > 0 || (baseChannel2 = this.findChannelByDataPath(baseChannel, string3)) == null) break;
            baseChannel = baseChannel2;
            string2 = string2 + "/" + string3;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u5c06url[" + string2 + "]\u548cbaseObj[" + baseChannel + "]\u653e\u5165cache"));
            }
            this.urlsCache.put(string2, baseChannel);
        }
        return baseChannel;
    }

    private WebSite findWebSiteByRootDomain(String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter();
        wCMFilter.setWhere("rootdomain=?");
        wCMFilter.addSearchValues(string);
        logger.debug((Object)wCMFilter);
        FolderPublishConfigs folderPublishConfigs = FolderPublishConfigs.openWCMObjs(null, wCMFilter);
        int n = folderPublishConfigs.size();
        for (int i = 0; i < n; ++i) {
            FolderPublishConfig folderPublishConfig = (FolderPublishConfig)folderPublishConfigs.getAt(i);
            if (folderPublishConfig == null) continue;
            return WebSite.findById(folderPublishConfig.getFolderId());
        }
        return null;
    }

    private BaseChannel findChannelByDataPath(BaseChannel baseChannel, String string) throws WCMException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" DATAPATH=? and FOLDERTYPE=?");
        stringBuffer.append(" and exists( select 1 from WCMCHANNEL where ");
        stringBuffer.append(" WCMCHANNEL.CHANNELID=WCMFOLDERPUBLISHCONFIG.FOLDERID");
        stringBuffer.append(" and ");
        stringBuffer.append(baseChannel.isSite() ? "WCMCHANNEL.SITEID" : "WCMCHANNEL.PARENTID");
        stringBuffer.append(" =?) ");
        WCMFilter wCMFilter = new WCMFilter(null, stringBuffer.toString(), null);
        wCMFilter.addSearchValues(string);
        wCMFilter.addSearchValues(101);
        wCMFilter.addSearchValues(baseChannel.getId());
        logger.debug((Object)wCMFilter);
        FolderPublishConfigs folderPublishConfigs = FolderPublishConfigs.openWCMObjs(null, wCMFilter);
        int n = folderPublishConfigs.size();
        for (int i = 0; i < n; ++i) {
            FolderPublishConfig folderPublishConfig = (FolderPublishConfig)folderPublishConfigs.getAt(i);
            if (folderPublishConfig == null) continue;
            return Channel.findById(folderPublishConfig.getFolderId());
        }
        return null;
    }

    private BaseObj getBaseObjFromHostObjDomain(String string) throws WCMException {
        if (this.hostObjDomainMap == null) {
            this.hostObjDomainMap = new HashMap();
            HostObjDomains hostObjDomains = HostObjDomains.openWCMObjs(null, null);
            int n = hostObjDomains.size();
            for (int i = 0; i < n; ++i) {
                BaseObj baseObj;
                HostObjDomain hostObjDomain = (HostObjDomain)hostObjDomains.getAt(i);
                if (hostObjDomain == null || (baseObj = BaseObj.findById(hostObjDomain.getHostType(), hostObjDomain.getHostId())) == null) continue;
                String string2 = hostObjDomain.getUrl();
                this.hostObjDomainMap.put(string2, baseObj);
            }
        }
        return (BaseObj)this.hostObjDomainMap.get(string);
    }
}

