/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;

public class TimeRange {
    public static final int STEP_DAY = 1;
    public static final int STEP_MONTH = 2;
    public static final int STEP_YEAR = 3;
    public static final int STEP_QUARTER = 4;
    private CMyDateTime mStartDate;
    private CMyDateTime mEndDate;
    private CMyDateTime mCurrRangeStartDate;
    private CMyDateTime mCurrRangeEndDate;
    private int mStepType;

    public TimeRange(CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2, int n) {
        this.mStartDate = new CMyDateTime(cMyDateTime.getTimeInMillis());
        this.mEndDate = new CMyDateTime(cMyDateTime2.getTimeInMillis());
        this.mStepType = n;
        this.mCurrRangeStartDate = (CMyDateTime)this.mStartDate.clone();
        this.mCurrRangeEndDate = (CMyDateTime)this.mStartDate.clone();
    }

    public boolean next() throws CMyException {
        this.countRangeTime();
        return this.mCurrRangeStartDate.compareTo(this.mEndDate) < 0L;
    }

    private void countRangeTime() throws CMyException {
        this.mCurrRangeStartDate = (CMyDateTime)this.mCurrRangeEndDate.clone();
        String string = "";
        String string2 = "";
        switch (this.mStepType) {
            case 1: {
                string = this.mCurrRangeStartDate.getDateTimeAsString("yyyy-MM-dd");
                this.mCurrRangeStartDate.setDateTimeWithString(string);
                this.mCurrRangeEndDate.dateAdd(3, 1);
                string2 = this.mCurrRangeEndDate.getDateTimeAsString("yyyy-MM-dd");
                this.mCurrRangeEndDate.setDateTimeWithString(string2);
                break;
            }
            case 2: {
                string = this.mCurrRangeStartDate.getDateTimeAsString("yyyy-MM");
                this.mCurrRangeStartDate.setDateTimeWithString(string);
                this.mCurrRangeEndDate.dateAdd(2, 1);
                string2 = this.mCurrRangeEndDate.getDateTimeAsString("yyyy-MM");
                this.mCurrRangeEndDate.setDateTimeWithString(string2);
                break;
            }
            case 3: {
                string = this.mCurrRangeStartDate.getDateTimeAsString("yyyy");
                this.mCurrRangeStartDate.setDateTimeWithString(string);
                this.mCurrRangeEndDate.dateAdd(1, 1);
                string2 = this.mCurrRangeEndDate.getDateTimeAsString("yyyy");
                this.mCurrRangeEndDate.setDateTimeWithString(string2);
                break;
            }
            case 4: {
                this.mCurrRangeStartDate.setDateTimeFormat("yyyy-MM-01");
                int n = this.mCurrRangeStartDate.getMonth();
                int n2 = this.mCurrRangeStartDate.getYear();
                String string3 = "";
                String string4 = "";
                if (n >= 10) {
                    string3 = "10";
                    string4 = "01";
                    ++n2;
                } else if (n >= 7) {
                    string3 = "07";
                    string4 = "10";
                } else if (n >= 4) {
                    string3 = "04";
                    string4 = "07";
                } else if (n >= 1) {
                    string3 = "01";
                    string4 = "04";
                }
                this.mCurrRangeStartDate.setDateTimeWithString(this.mCurrRangeStartDate.getYear() + "-" + string3 + "-01");
                this.mCurrRangeEndDate.setDateTimeWithString(n2 + "-" + string4 + "-01");
            }
        }
    }

    public String getXlabel() throws CMyException {
        return this.getLabelByStep(this.mCurrRangeStartDate);
    }

    private String getLabelByStep(CMyDateTime cMyDateTime) throws CMyException {
        String string = "";
        switch (this.mStepType) {
            case 1: {
                int n = cMyDateTime.getDay();
                int n2 = cMyDateTime.getMonth();
                if (n == 1) {
                    if (n2 == 1) {
                        string = cMyDateTime.getDateTimeAsString("yyyy-MM-dd");
                        break;
                    }
                    string = cMyDateTime.getDateTimeAsString("MM-dd");
                    break;
                }
                string = String.valueOf(n);
                break;
            }
            case 2: {
                int n = cMyDateTime.getMonth();
                if (n == 1) {
                    string = cMyDateTime.getDateTimeAsString("yyyy-MM");
                    break;
                }
                string = String.valueOf(n);
                break;
            }
            case 3: {
                string = String.valueOf(cMyDateTime.getYear());
                break;
            }
            case 4: {
                int n = cMyDateTime.getMonth();
                int n3 = cMyDateTime.getYear();
                if (n == 1) {
                    string = n3 + " Q1";
                    break;
                }
                if (n == 4) {
                    string = "Q2";
                    break;
                }
                if (n == 7) {
                    string = "Q3";
                    break;
                }
                if (n != 10) break;
                string = "Q4";
            }
        }
        return "\"" + string + "\"";
    }

    public CMyDateTime getRangeStart() {
        return this.mCurrRangeStartDate;
    }

    public CMyDateTime getRangeEnd() {
        return this.mCurrRangeEndDate;
    }
}

