/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class StatBonusResultForUser {
    private Logger logger = Logger.getLogger(StatBonusResultForUser.class);
    private HashMap[] m_pResult = null;
    private List m_arUserNames = null;
    private List m_arDocIds = null;
    private int m_nBonusType;
    private boolean m_bSortDesc;

    public StatBonusResultForUser(int n) {
        this.m_pResult = new HashMap[n];
    }

    protected void setResult(HashMap hashMap, int n) throws WCMException {
        if (n >= this.m_pResult.length) {
            throw new WCMException("\u6307\u5b9a\u7684\u7ed3\u679c\u6240\u5728\u6570\u7ec4\u4e2d\u7684\u4f4d\u7f6e\u5927\u4e8e\u6570\u7ec4\u7684\u957f\u5ea6\uff01");
        }
        this.m_pResult[n] = hashMap;
    }

    public float getBonus(String string, int n) throws WCMException {
        HashMap hashMap = this.m_pResult[n - 1];
        if (hashMap == null) {
            return 0.0f;
        }
        Object v = hashMap.get(string);
        if (n == 2) {
            return this.getHitBonus(string, hashMap);
        }
        if (v == null) {
            return 0.0f;
        }
        if (v instanceof String) {
            return Float.parseFloat(v.toString());
        }
        throw new WCMException("\u5956\u91d1\u4e0d\u662fFloat\u7c7b\u578b\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8c03\u7528\u63a5\u53e3\u9519\u8bef\uff01");
    }

    private float getHitBonus(String string, HashMap hashMap) throws WCMException {
        if (hashMap == null) {
            return 0.0f;
        }
        WCMFilter wCMFilter = new WCMFilter("", "CrUser = ?", "");
        wCMFilter.addSearchValues(string);
        Documents documents = Documents.openWCMObjs(null, wCMFilter);
        if (documents == null || documents.size() == 0) {
            return 0.0f;
        }
        String[] stringArray = documents.getIdListAsString().split(",");
        float f = 0.0f;
        for (int i = 0; i < stringArray.length; ++i) {
            Object v = hashMap.get(stringArray[i]);
            if (v == null) continue;
            f += Float.parseFloat(v.toString());
        }
        return f;
    }

    public float getTotalBonus(String string) throws WCMException {
        return this.getBonus(string, 1) + this.getBonus(string, 2);
    }

    public float getIssuesAmountBonusOfMonth(String string, CMyDateTime cMyDateTime) throws Exception {
        HashMap hashMap = this.m_pResult[0];
        Object v = hashMap.get(string + "&" + cMyDateTime.getDateTimeAsString("yyyy\u5e74MM\u6708"));
        if (v == null) {
            return 0.0f;
        }
        if (v instanceof String) {
            return Float.parseFloat(v.toString().split("&")[0]);
        }
        throw new WCMException("\u5956\u91d1\u7684\u7c7b\u578b\u4e0d\u5bf9\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u662f\u8c03\u7528\u63a5\u53e3\u9519\u8bef\uff01");
    }

    public int getIssuedAmountOfMonth(String string, CMyDateTime cMyDateTime) throws Exception {
        HashMap hashMap = this.m_pResult[0];
        Object v = hashMap.get(string + "&" + cMyDateTime.getDateTimeAsString("yyyy\u5e74MM\u6708"));
        if (v == null) {
            return 0;
        }
        if (v instanceof String) {
            return Integer.parseInt(v.toString().split("&")[1]);
        }
        throw new WCMException("\u83b7\u53d6\u5230\u7684\u6570\u636e\u7684\u7c7b\u578b\u4e0d\u5bf9\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8c03\u7528\u63a5\u53e3\u9519\u8bef\uff01");
    }

    public float getHitsBonusOfMonth(String string, int n, CMyDateTime cMyDateTime) throws Exception {
        Document document = Document.findById(n);
        if (document == null) {
            return 0.0f;
        }
        if (!string.equalsIgnoreCase(document.getCrUserName())) {
            return 0.0f;
        }
        HashMap hashMap = this.m_pResult[0];
        String string2 = cMyDateTime.getDateTimeAsString("yyyy\u5e74MM\u6708");
        Object v = hashMap.get(n + "&" + string2);
        if (v == null) {
            return 0.0f;
        }
        return Float.parseFloat(v.toString().split("&")[0]);
    }

    public int getHitsCountOfMonth(String string, int n, CMyDateTime cMyDateTime) throws Exception {
        Document document = Document.findById(n);
        if (document == null) {
            return 0;
        }
        if (!string.equalsIgnoreCase(document.getCrUserName())) {
            return 0;
        }
        HashMap hashMap = this.m_pResult[0];
        String string2 = cMyDateTime.getDateTimeAsString("yyyy\u5e74MM\u6708");
        Object v = hashMap.get(n + "&" + string2);
        if (v == null) {
            return 0;
        }
        return Integer.parseInt(v.toString().split("&")[1]);
    }

    protected void setUserNames(ArrayList arrayList) {
        this.m_arUserNames = arrayList;
    }

    public List getUserNames() {
        return this.m_arUserNames;
    }

    protected void setDocIds(ArrayList arrayList) {
        this.m_arDocIds = arrayList;
    }

    public List getDocIds() {
        return this.m_arDocIds;
    }

    public List sort(int n, boolean bl) {
        this.m_nBonusType = n;
        this.m_bSortDesc = bl;
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                try {
                    float f = StatBonusResultForUser.this.getBonus((String)object, StatBonusResultForUser.this.m_nBonusType);
                    float f2 = StatBonusResultForUser.this.getBonus((String)object2, StatBonusResultForUser.this.m_nBonusType);
                    if (StatBonusResultForUser.this.m_bSortDesc) {
                        return (int)(f2 - f);
                    }
                    return (int)(f - f2);
                }
                catch (Exception exception) {
                    StatBonusResultForUser.this.logger.error((Object)"\u6392\u5e8f\u5931\u8d25", (Throwable)exception);
                    return 0;
                }
            }
        };
        if (this.m_arUserNames != null && this.m_arUserNames.size() > 0) {
            Collections.sort(this.m_arUserNames, comparator);
        }
        return this.m_arUserNames;
    }
}

