/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.components.stat.HostObjHitsCount;
import com.trs.components.stat.IHitsCountHandler;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SiteHitsCountHandler
implements IHitsCountHandler {
    private Map hostHitsCountMap;
    private String hitsTime;
    private static Logger logger = Logger.getLogger(SiteHitsCountHandler.class);

    public void handle(BaseObj baseObj, Map map) throws WCMException {
        WebSite webSite;
        if (baseObj instanceof Document) {
            webSite = ((Document)baseObj).getChannel().getSite();
        } else if (baseObj instanceof Channel) {
            webSite = ((Channel)baseObj).getSite();
        } else if (baseObj instanceof WebSite) {
            webSite = (WebSite)baseObj;
        } else {
            return;
        }
        this.hitsTime = (String)map.get("hitsTime");
        if (this.hostHitsCountMap == null) {
            this.hostHitsCountMap = new HashMap();
        }
        int n = 0;
        Integer n2 = (Integer)this.hostHitsCountMap.get(webSite);
        if (n2 != null) {
            n = n2;
        }
        int n3 = Integer.parseInt((String)map.get("hitsCount"));
        n += n3;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u8ffd\u52a0\u7684\u70b9\u51fb\u91cf\u60c5\u51b5\uff1a\nobj[" + webSite + "],all[" + n + "],current[" + n3 + "]"));
        }
        this.hostHitsCountMap.put(webSite, new Integer(n));
    }

    public void notifyComplete() {
        if (this.hostHitsCountMap == null) {
            return;
        }
        for (Map.Entry entry : this.hostHitsCountMap.entrySet()) {
            WebSite webSite = (WebSite)entry.getKey();
            Integer n = (Integer)entry.getValue();
            try {
                HostObjHitsCount hostObjHitsCount = new HostObjHitsCount();
                hostObjHitsCount.setHostId(webSite.getId());
                hostObjHitsCount.setHostType(103);
                hostObjHitsCount.setObjCrTime(webSite.getCrTime());
                hostObjHitsCount.setObjCrUser(webSite.getCrUserName());
                hostObjHitsCount.setSpecial(false);
                hostObjHitsCount.setPropertyWithString("hitsTime", this.hitsTime);
                hostObjHitsCount.setHitsCount(n);
                hostObjHitsCount.save();
            }
            catch (Exception exception) {
                logger.error((Object)("\u8bbe\u7f6e\u7ad9\u70b9\u5bf9\u8c61[" + webSite + "]\u7684\u70b9\u51fb\u91cf\u4fe1\u606f\u65f6\u5931\u8d25"), (Throwable)exception);
            }
        }
    }
}

