/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.components.stat.BaseStatHandler;
import com.trs.components.stat.IChnlDeptMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.common.WCMException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class HitsStatHandler4ChnlDept
extends BaseStatHandler {
    private static Logger logger = Logger.getLogger(HitsStatHandler4ChnlDept.class);
    private HashMap m_hRelGroupsOfChannel = new HashMap();
    private IChnlDeptMgr m_oChnlDeptMgr = (IChnlDeptMgr)DreamFactory.createObjectById("IChnlDeptMgr");
    private Channels filterChannels = null;
    private boolean bFilterByChannel = false;

    public HitsStatHandler4ChnlDept() {
    }

    public HitsStatHandler4ChnlDept(Channels channels) {
        this.filterChannels = channels;
        this.bFilterByChannel = true;
    }

    public void visitStatItem(ResultSet resultSet, int n) throws WCMException {
        try {
            int n2 = resultSet.getInt(1);
            if (n2 == 0) {
                return;
            }
            int n3 = resultSet.getInt(2);
            if (this.bFilterByChannel && (this.filterChannels == null || this.filterChannels.indexOf(n3) < 0)) {
                return;
            }
            Channel channel = Channel.findById(n3);
            if (channel == null) {
                throw new WCMException("\u672a\u627e\u5230\u6307\u5b9a\u680f\u76ee! [ChannelId = " + n3 + "]");
            }
            Groups groups = this.makeCurrRelGroups(channel);
            int n4 = groups.size();
            for (int i = 0; i < n4; ++i) {
                Group group = (Group)groups.getAt(i);
                if (group == null) continue;
                String string = group.getId() + "";
                int n5 = this.getValue(n, string);
                this.setValue(n, string, n5 += n2);
                this.addMajorObject(string);
            }
        }
        catch (SQLException sQLException) {
            logger.debug((Object)"\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)sQLException);
            throw new WCMException("\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", sQLException);
        }
    }

    private Groups makeCurrRelGroups(Channel channel) throws WCMException {
        User user = ContextHelper.getLoginUser();
        Groups groups = (Groups)this.m_hRelGroupsOfChannel.get(channel);
        if (groups != null) {
            return groups;
        }
        groups = new Groups(null);
        String string = this.m_oChnlDeptMgr.getDepIdsByChannel(channel).toString();
        string = string.length() <= 2 ? "" : string.substring(1, string.length() - 1);
        groups = Groups.findByIds(user, string.trim());
        int n = groups.size();
        for (int i = 0; i < n; ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null) continue;
            for (Group group2 = group; group2 != null; group2 = group2.getParent()) {
                groups.addElement(group2);
            }
        }
        this.m_hRelGroupsOfChannel.put(channel.getKey(), groups);
        return groups;
    }
}

