/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.components.stat.BaseStatHandler;
import com.trs.components.stat.DocStatHandler4UserDept;
import com.trs.components.stat.IChnlDeptMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.DebugTimer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DocStatHandler4ChnlDeptSite
extends BaseStatHandler {
    private static Logger logger = Logger.getLogger(DocStatHandler4UserDept.class);
    private HashMap m_hRelGroupsOfChannel = null;
    private int m_SiteId = 0;
    private IChnlDeptMgr m_oChnlDeptMgr = null;

    public DocStatHandler4ChnlDeptSite(int n) {
        this.m_SiteId = n;
        this.m_hRelGroupsOfChannel = new HashMap();
        this.m_oChnlDeptMgr = (IChnlDeptMgr)DreamFactory.createObjectById("IChnlDeptMgr");
    }

    public void visitStatItem(ResultSet resultSet, int n) throws WCMException {
        try {
            int n2 = resultSet.getMetaData().getColumnCount();
            int n3 = resultSet.getInt(n2);
            if (n3 != this.m_SiteId) {
                return;
            }
            int n4 = resultSet.getInt(1);
            if (n4 == 0) {
                return;
            }
            int n5 = resultSet.getInt(2);
            Channel channel = Channel.findById(n5);
            if (channel == null) {
                throw new WCMException("\u672a\u627e\u5230\u6307\u5b9a\u680f\u76ee! [ChannelId = " + n5 + "]");
            }
            DebugTimer debugTimer = new DebugTimer();
            debugTimer.start();
            Groups groups = this.makeCurrRelGroups(channel);
            debugTimer.stop();
            logger.debug((Object)("makeCurrRelGroups of channel-" + n5 + " use[" + debugTimer.getTime() + "]ms"));
            debugTimer.start();
            int n6 = groups.size();
            for (int i = 0; i < n6; ++i) {
                Group group = (Group)groups.getAt(i);
                if (group == null) continue;
                String string = group.getId() + "";
                String string2 = this.makePrivateKey(string, resultSet);
                int n7 = this.getValue(n, string2);
                int n8 = n4;
                this.setValue(n, string2, n8 += n7);
                this.addMajorObject(string);
            }
            debugTimer.stop();
            logger.debug((Object)("merge datacount of channel-" + n5 + " use[" + debugTimer.getTime() + "]ms"));
        }
        catch (SQLException sQLException) {
            logger.debug((Object)"\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)sQLException);
            throw new WCMException("\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", sQLException);
        }
    }

    private String makePrivateKey(String string, ResultSet resultSet) throws SQLException {
        int n = resultSet.getMetaData().getColumnCount();
        String[] stringArray = new String[n - 2];
        stringArray[0] = string;
        for (int i = 2; i < n - 1; ++i) {
            stringArray[i - 1] = resultSet.getString(i + 1);
        }
        return this.makeKey(stringArray);
    }

    private Groups makeCurrRelGroups(Channel channel) throws WCMException {
        User user = ContextHelper.getLoginUser();
        Groups groups = (Groups)this.m_hRelGroupsOfChannel.get(channel);
        if (groups != null) {
            return groups;
        }
        groups = new Groups(null);
        String string = this.m_oChnlDeptMgr.getDepIdsByChannel(channel).toString();
        string = string.length() <= 2 ? "" : string.substring(1, string.length() - 1);
        groups = Groups.findByIds(user, string.trim());
        int n = groups.size();
        for (int i = 0; i < n; ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null) continue;
            for (Group group2 = group; group2 != null; group2 = group2.getParent()) {
                groups.addElement(group2);
            }
        }
        this.m_hRelGroupsOfChannel.put(channel.getKey(), groups);
        return groups;
    }
}

