/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.stat.BonusRule;
import com.trs.components.stat.BonusRules;
import com.trs.components.stat.IBonusCalculator;
import com.trs.components.stat.IBonusRuleMgr;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class BonusCalculator
implements IBonusCalculator {
    private static Logger logger = Logger.getLogger(BonusCalculator.class);
    private IBonusRuleMgr m_oBonusRuleMgr = (IBonusRuleMgr)DreamFactory.createObjectById("IBonusRuleMgr");

    public float caclulateIssuedAmountBonus(int n) throws WCMException {
        if (n == 0) {
            return 0.0f;
        }
        User user = User.getSystem();
        WCMFilter wCMFilter = new WCMFilter("", "BonusType = ?", "PRICEPERUNIT ASC");
        wCMFilter.addSearchValues(1);
        BonusRules bonusRules = this.m_oBonusRuleMgr.query(user, wCMFilter);
        if (bonusRules == null) {
            return 0.0f;
        }
        int n2 = 0;
        int n3 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        int n4 = bonusRules.size();
        for (int i = 0; i < n4; ++i) {
            BonusRule bonusRule = (BonusRule)bonusRules.getAt(i);
            if (bonusRule == null) continue;
            String string = bonusRule.getRange();
            if (CMyString.isEmpty(string)) {
                logger.error((Object)("\u5956\u52b1\u89c4\u5219\u3010id=" + bonusRule.getId() + "\u3011\u7684\u5956\u52b1\u8303\u56f4\u4e3a\u7a7a"));
                string = "0,0";
            }
            String[] stringArray = string.split(",");
            n3 = Integer.parseInt(stringArray[0]);
            if (stringArray[1].equalsIgnoreCase("#")) {
                stringArray[1] = "2147483647";
            }
            n2 = Integer.parseInt(stringArray[1]);
            f = bonusRule.getPricePerUnit();
            if (n <= n3) continue;
            if (n > n2) {
                f2 += (float)(n2 - n3) * f;
                continue;
            }
            f2 += (float)(n - n3) * f;
        }
        return f2;
    }

    public float caclulateHitsBonus(int n) throws WCMException {
        if (n == 0) {
            return 0.0f;
        }
        User user = User.getSystem();
        WCMFilter wCMFilter = new WCMFilter("", "BonusType = ?", "PRICEPERUNIT ASC");
        wCMFilter.addSearchValues(2);
        BonusRules bonusRules = this.m_oBonusRuleMgr.query(user, wCMFilter);
        if (bonusRules == null) {
            return 0.0f;
        }
        int n2 = 0;
        int n3 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        int n4 = bonusRules.size();
        for (int i = 0; i < n4; ++i) {
            BonusRule bonusRule = (BonusRule)bonusRules.getAt(i);
            if (bonusRule == null) continue;
            String string = bonusRule.getRange();
            if (CMyString.isEmpty(string)) {
                logger.error((Object)("\u5956\u52b1\u89c4\u5219\u3010id=" + bonusRule.getId() + "\u3011\u7684\u5956\u52b1\u8303\u56f4\u4e3a\u7a7a"));
                string = "0,0";
            }
            String[] stringArray = string.split(",");
            n3 = Integer.parseInt(stringArray[0]);
            if (stringArray[1].equalsIgnoreCase("#")) {
                stringArray[1] = "2147483647";
            }
            n2 = Integer.parseInt(stringArray[1]);
            f = bonusRule.getPricePerUnit();
            if (n <= n3) continue;
            if (n > n2) {
                f2 += (float)(n2 - n3) * f;
                continue;
            }
            f2 += (float)(n - n3) * f;
        }
        return f2;
    }
}

