/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.web;

import com.trs.components.metadata.web.HTMLMaker;
import com.trs.components.metadata.web.impl.DefaultHTMLMaker;
import com.trs.infra.I18NMessage;
import com.trs.infra.discover.IDiscovery;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class HTMLMakerFactory {
    private static Logger mLogger = Logger.getLogger(HTMLMakerFactory.class);
    private static boolean mIsLoaded = false;
    private static Map mHTMLMakerMapping = new HashMap();

    private static void load() {
        if (mIsLoaded) {
            return;
        }
        mIsLoaded = true;
        IDiscovery iDiscovery = WCMDiscoveryFactory.getDiscovery();
        Iterator iterator = iDiscovery.getImplementors(HTMLMaker.class.getName());
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                Class<?> clazz = Class.forName(string);
                HTMLMaker hTMLMaker = (HTMLMaker)clazz.newInstance();
                int[] nArray = hTMLMaker.getFieldTypes();
                for (int i = 0; i < nArray.length; ++i) {
                    HTMLMakerFactory.register(nArray[i], clazz);
                }
            }
            catch (Exception exception) {
                mLogger.debug((Object)(I18NMessage.get(HTMLMakerFactory.class, "HTMLMakerFactory.label1", "\u52a0\u8f7dHMTLMaker\u51fa\u73b0\u9519\u8bef[") + string + "]"), (Throwable)exception);
            }
        }
    }

    public static void register(int n, Class clazz) {
        mHTMLMakerMapping.put(new Integer(n), clazz);
    }

    public static HTMLMaker getHTMLMaker(int n) {
        HTMLMakerFactory.load();
        Class<DefaultHTMLMaker> clazz = (Class<DefaultHTMLMaker>)mHTMLMakerMapping.get(new Integer(n));
        if (clazz == null) {
            clazz = DefaultHTMLMaker.class;
        }
        try {
            return (HTMLMaker)clazz.newInstance();
        }
        catch (Exception exception) {
            mLogger.debug((Object)(I18NMessage.get(HTMLMakerFactory.class, "HTMLMakerFactory.label2", "\u521b\u5efaHTMLMaker\u51fa\u73b0\u9519\u8bef[") + clazz + "]"), (Throwable)exception);
            return null;
        }
    }
}

