/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service.xmlconvertors;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.HTMLContent;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.wcm.content.ViewDocument;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.NullValue;
import com.trs.infra.util.AttributesString;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.database.CDBText;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import com.trs.webframework.xmlserver.IXMLConvertor;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ViewDataToXML
implements IXMLConvertor {
    private static Logger logger = Logger.getLogger(ViewDataToXML.class);
    private IMetaDataDefCacheMgr m_oDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
    protected boolean m_bToXMLDependsOnSelectFields = true;

    public String[] registerTargetClassName() {
        return new String[]{MetaViewData.class.getName(), MetaViewDatas.class.getName()};
    }

    public String toXmlString(MethodContext methodContext, Object object) throws ConvertException {
        if (object instanceof BaseObjs) {
            return this.toXMLString(methodContext, (BaseObjs)object);
        }
        if (object instanceof BaseObj) {
            return this.toXMLString(methodContext, (BaseObj)object);
        }
        throw new ConvertException(I18NMessage.get(ViewDataToXML.class, "ViewDataToXML.label1", "\u7c7b\u578b[") + object.getClass().getName() + I18NMessage.get(ViewDataToXML.class, "ViewDataToXML.label2", "]\u4e0d\u5339\u914d\uff01"));
    }

    private String toXMLString(MethodContext methodContext, BaseObjs baseObjs) throws ConvertException {
        if (methodContext != null && methodContext.getValue("OnlyReturnIds", false)) {
            String string;
            int n = methodContext.getValue("IdsValueType", 0);
            switch (n) {
                case 0: {
                    string = baseObjs.getIdListAsString(',');
                    methodContext.setReturnHTML(true);
                    break;
                }
                case 1: {
                    string = "{Ids:\"" + baseObjs.getIdListAsString(',') + "\"}";
                    methodContext.setReturnJSON(true);
                    break;
                }
                default: {
                    string = "<Ids>" + baseObjs.getIdListAsString(',') + "</Ids>";
                }
            }
            return string;
        }
        String string = this.makeTagName(baseObjs.getClass());
        String string2 = this.makeTagName(baseObjs.getElementClass());
        int n = -1;
        int n2 = 1;
        if (methodContext != null) {
            n = methodContext.getPageIndex();
            n2 = methodContext.getPageIndex();
        }
        CPager cPager = new CPager(n);
        cPager.setCurrentPageIndex(n2);
        cPager.setItemCount(baseObjs.size());
        Element element = DocumentHelper.createElement((String)string);
        this.setPageAttributes(cPager, element);
        String[] stringArray = this.makeSelectFields(methodContext);
        if (stringArray != null && stringArray.length == 1 && stringArray[0].equalsIgnoreCase(baseObjs.getIdFieldName())) {
            String string3 = baseObjs.getIdFieldName();
            for (int i = cPager.getFirstItemIndex(); i <= cPager.getLastItemIndex(); ++i) {
                Element element2 = element.addElement(string2);
                element2.addElement(string3).addText(String.valueOf(baseObjs.getIdAt(i - 1)));
            }
        } else {
            for (int i = cPager.getFirstItemIndex(); i <= cPager.getLastItemIndex(); ++i) {
                BaseObj baseObj = baseObjs.getAt(i - 1);
                if (baseObj == null) continue;
                Element element3 = this.makeElementFromBaseObj(methodContext, string2, baseObj, false, stringArray);
                element.add(element3);
            }
        }
        return element.asXML();
    }

    private String[] makeSelectFields(MethodContext methodContext) {
        if (methodContext == null) {
            return null;
        }
        String[] stringArray = null;
        String string = methodContext.getValue("SelectFields");
        if (string != null && string.length() > 0 && !string.equals("*")) {
            stringArray = CMyString.split(string, ",");
        }
        return stringArray;
    }

    private void setElementAttributes(Element element, String[][] stringArray) throws ConvertException {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (stringArray[i].length < 2) {
                throw new ConvertException(I18NMessage.get(ViewDataToXML.class, "ViewDataToXML.label3", "getSpecialRootAttributes\u7684\u8fd4\u56de\u503c\u4e0d\u7b26\u5408\u89c4\u8303\uff01"));
            }
            element.addAttribute(stringArray[i][0], stringArray[i][1]);
        }
    }

    private String toXMLString(MethodContext methodContext, BaseObj baseObj) throws ConvertException {
        String[] stringArray = this.makeSelectFields(methodContext);
        String string = this.makeTagName(baseObj.getClass());
        Element element = this.makeElementFromBaseObj(methodContext, string, baseObj, true, stringArray);
        return element.asXML();
    }

    private String[][] getSpecialElementAttributes(MethodContext methodContext, BaseObj baseObj) throws ConvertException {
        MetaViewData metaViewData = (MetaViewData)baseObj;
        if (methodContext.getValue("ContainsRight", false)) {
            try {
                User user = ContextHelper.getLoginUser();
                if (user.isAdministrator()) {
                    return new String[][]{{"Right", RightValue.getAdministratorValues()}};
                }
                Channel channel = metaViewData.getChannel();
                ViewDocument viewDocument = ViewDocument.findById(channel, metaViewData.getChnlDocId(), null, "cruser");
                return new String[][]{{"Right", viewDocument.getRightValue(user).toString()}};
            }
            catch (Exception exception) {
                throw new ConvertException(I18NMessage.get(ViewDataToXML.class, "ViewDataToXML.label4", "\u6784\u9020[") + metaViewData + I18NMessage.get(ViewDataToXML.class, "ViewDataToXML.label5", "]\u6743\u9650\u4fe1\u606f\u5931\u8d25!"), exception);
            }
        }
        return null;
    }

    private void setPageAttributes(CPager cPager, Element element) {
        element.addAttribute("Num", String.valueOf(cPager.getItemCount()));
        if (cPager.getPageSize() <= 0) {
            return;
        }
        element.addAttribute("PageSize", String.valueOf(cPager.getPageSize()));
        element.addAttribute("PageCount", String.valueOf(cPager.getPageCount()));
        element.addAttribute("CurrPageIndex", String.valueOf(cPager.getCurrentPageIndex()));
    }

    protected boolean isToHTML(MethodContext methodContext, String string) {
        if (methodContext == null) {
            return false;
        }
        String string2 = methodContext.getValue("FieldsToHTML");
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        return ("," + string2 + ",").toUpperCase().indexOf("," + string.toUpperCase() + ",") >= 0;
    }

    protected Element makeElementFromBaseObj(MethodContext methodContext, String string, BaseObj baseObj, boolean bl, String[] stringArray) throws ConvertException {
        try {
            MetaViewData metaViewData = (MetaViewData)baseObj;
            int n = metaViewData.getMetaView().getId();
            Hashtable[] hashtableArray = this.getPropertiesArray(baseObj, bl);
            Element element = DocumentHelper.createElement((String)string);
            for (Hashtable hashtable : hashtableArray) {
                if (hashtable == null) continue;
                Object[] objectArray = null;
                objectArray = this.m_bToXMLDependsOnSelectFields && stringArray != null && stringArray.length > 0 ? stringArray : hashtable.keySet().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object;
                    Object object2;
                    String string2 = ((String)objectArray[i]).toUpperCase();
                    if (!hashtable.containsKey(string2)) continue;
                    Element element2 = element.addElement(string2);
                    Object object3 = hashtable.get(string2);
                    if (string2.equals("ATTRIBUTE") && object3 != null) {
                        object2 = new AttributesString(object3.toString());
                        object = ((AttributesString)object2).getNameList();
                        int n2 = object.size();
                        for (int j = 0; j < n2; ++j) {
                            String string3 = (String)object.get(j);
                            element2.addAttribute(string3, ((AttributesString)object2).getAttributeValue(string3));
                        }
                        continue;
                    }
                    if (object3 instanceof CMyDateTime && !((CMyDateTime)(object2 = (CMyDateTime)object3)).isNull()) {
                        object3 = this.convertDateTimeValueToString(methodContext, (CMyDateTime)object2);
                    }
                    if ((object2 = this.m_oDataDefCacheMgr.getMetaViewField(n, string2)) != null && this.isTransHTML((MetaViewField)object2, methodContext.getValue("isAddEdit", false))) {
                        object3 = CMyString.filterForHTMLValue(object3.toString());
                    }
                    object = null;
                    if (this.m_oDataDefCacheMgr.isFieldWithType(n, string2, 10)) {
                        this.makeClassInfoField(element2, object3);
                    }
                    if (this.m_oDataDefCacheMgr.isFieldWithType(n, string2, 14)) {
                        this.makeRelDocField(element2, object3);
                    }
                    if (object3 != null && this.m_oDataDefCacheMgr.isEditorField(n, string2)) {
                        HTMLContent hTMLContent = new HTMLContent(object3.toString());
                        object3 = hTMLContent.parseHTMLContent(null);
                    }
                    if (string2.equals("DOCSTATUS")) {
                        this.makeStatus(element2, metaViewData.getStatus());
                        continue;
                    }
                    if (this.isCData(object3)) {
                        if (object == null) {
                            object = object3 == null || object3 instanceof NullValue ? "" : object3.toString();
                        }
                        if (object == null || ((String)object).length() <= 0) continue;
                        if (this.isToHTML(methodContext, string2)) {
                            object = CMyString.transDisplay((String)object, false);
                        }
                        if (((String)object).matches("(?ism).*<!\\[CDATA\\[.*|.*\\]\\]>.*")) {
                            element2.setText((String)object);
                            continue;
                        }
                        element2.addCDATA((String)object);
                        continue;
                    }
                    if (object != null) {
                        element2.setText((String)object);
                        continue;
                    }
                    if (object3 instanceof CMyDateTime) {
                        CMyDateTime cMyDateTime = (CMyDateTime)object3;
                        if (cMyDateTime.isNull()) continue;
                        element2.setText(this.convertDateTimeValueToString(methodContext, cMyDateTime));
                        continue;
                    }
                    if (object == null) {
                        object = object3 == null || object3 instanceof NullValue ? "" : object3.toString();
                    }
                    if (object == null || ((String)object).length() <= 0) continue;
                    element2.setText((String)object);
                }
                String[][] stringArray2 = this.getSpecialElementAttributes(methodContext, baseObj);
                this.setElementAttributes(element, stringArray2);
            }
            return element;
        }
        catch (Exception exception) {
            throw new ConvertException(I18NMessage.get(ViewDataToXML.class, "ViewDataToXML.label6", "\u5904\u7406\u5355\u4e2a\u5143\u7d20\u5931\u8d25\uff01"), exception);
        }
    }

    private void makeClassInfoField(Element element, Object object) {
        String string = null;
        String string2 = "0";
        String string3 = null;
        if (object == null || object.toString().length() == 0) {
            string = "";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            ClassInfos classInfos = null;
            try {
                classInfos = ClassInfos.findByIds(null, object.toString());
            }
            catch (Exception exception) {
                logger.fatal((Object)(I18NMessage.get(ViewDataToXML.class, "ViewDataToXML.label7", "\u83b7\u53d6\u8bb0\u5f55\u7684\u5206\u7c7b\u6cd5\u5b57\u6bb5\u65f6\u51fa\u73b0\u9519\u8bef\uff0c\u5206\u7c7b\u6cd5\u7684ids:[") + string2 + I18NMessage.get(ViewDataToXML.class, "ViewDataToXML.label8", "]\u4e0d\u5408\u6cd5")));
                element.addAttribute("Name", "<font color='red'>ERROR-IDS</font>");
                element.addAttribute("Id", "0");
                return;
            }
            int n = classInfos.size();
            for (int i = 0; i < n; ++i) {
                ClassInfo classInfo = (ClassInfo)classInfos.getAt(i);
                if (classInfo == null) continue;
                if (classInfo.containsProperty("CCODE")) {
                    stringBuffer3.append(classInfo.getPropertyAsString("CCODE")).append(",");
                }
                stringBuffer.append(classInfo.getId()).append(",");
                stringBuffer2.append(classInfo.getName()).append(",");
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
                stringBuffer2.setLength(stringBuffer2.length() - 1);
            }
            if (stringBuffer3.length() > 0) {
                stringBuffer3.setLength(stringBuffer3.length() - 1);
                string3 = stringBuffer3.toString();
            }
            string2 = stringBuffer.toString();
            string = CMyString.filterForHTMLValue(stringBuffer2.toString());
        }
        element.addAttribute("Name", string);
        element.addAttribute("Id", string2);
        if (string3 != null) {
            element.addAttribute("Code", string3);
        }
    }

    private void makeRelDocField(Element element, Object object) {
        String string = null;
        String string2 = "0";
        if (object == null || object.toString().length() == 0) {
            string = "";
        } else {
            string2 = object.toString();
            StringBuffer stringBuffer = new StringBuffer();
            Documents documents = null;
            try {
                documents = Documents.findByIds(null, string2);
            }
            catch (Exception exception) {
                logger.fatal((Object)(I18NMessage.get(ViewDataToXML.class, "ViewDataToXML.label9", "\u83b7\u53d6\u8bb0\u5f55\u7684\u76f8\u5173\u6587\u6863\u5b57\u6bb5\u65f6\u51fa\u73b0\u9519\u8bef\uff0c\u76f8\u5173\u6587\u6863\u5b57\u6bb5\u503c:[") + string2 + I18NMessage.get(ViewDataToXML.class, "ViewDataToXML.label8", "]\u4e0d\u5408\u6cd5")));
                element.addAttribute("Name", "");
                element.addAttribute("Id", "-1");
                return;
            }
            int n = documents.size();
            for (int i = 0; i < n; ++i) {
                Document document = (Document)documents.getAt(i);
                if (document == null || document.isDeleted()) continue;
                stringBuffer.append(document.getTitle()).append("`");
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            string = stringBuffer.toString();
        }
        element.addAttribute("Name", string);
        element.addAttribute("Id", string2);
    }

    protected Hashtable[] getPropertiesArray(BaseObj baseObj, boolean bl) {
        Hashtable hashtable = bl ? baseObj.getAllProperty() : baseObj.getProperties();
        if (baseObj instanceof MetaViewData) {
            MetaViewData metaViewData = (MetaViewData)baseObj;
            return new Hashtable[]{hashtable, metaViewData.getChnlDocProperties()};
        }
        return new Hashtable[]{hashtable};
    }

    protected String convertDateTimeValueToString(MethodContext methodContext, CMyDateTime cMyDateTime) {
        String string = "yyyy-MM-dd HH:mm:ss";
        if (methodContext != null && (string = methodContext.getValue("DateTimeFormat")) == null) {
            string = "yyyy-MM-dd HH:mm:ss";
        }
        String string2 = cMyDateTime.toString(string);
        return string2;
    }

    private boolean isCData(Object object) {
        if (object instanceof CDBText) {
            return true;
        }
        return object instanceof String && ((String)object).length() > 0;
    }

    private String makeTagName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private void makeStatus(Element element, Status status) {
        if (status == null) {
            element.addAttribute("ID", "0");
            element.addAttribute("NAME", I18NMessage.get(ViewDataToXML.class, "ViewDataToXML.label10", "\u672a\u77e5"));
            return;
        }
        element.addAttribute("ID", status.getKey().toString());
        element.addAttribute("NAME", status.getDisp());
    }

    private boolean isTransHTML(MetaViewField metaViewField, boolean bl) throws WCMException {
        if (this.m_oDataDefCacheMgr.isEditorField(metaViewField)) {
            return false;
        }
        if (!bl) {
            return true;
        }
        int n = metaViewField.getType();
        switch (n) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 17: {
                return true;
            }
        }
        return false;
    }
}

