/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service.util;

import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class WCMJSPChecker {
    private static int RESPONSECODE_OK = 200;
    private static List _jsps = new ArrayList();
    private String _jsprooturi;
    private String _host = "localhost";
    private int _port = 80;
    private String _cookie;
    private String _username;
    private String _password;
    private String _authPage = "/j_security_check";
    protected Logger logger = Logger.getLogger(this.getClass());
    private boolean m_bNeedStore = false;
    private String m_sCheckPath = null;
    private String m_sApplicationRootPath = null;
    private String m_sApplicationName = null;

    public WCMJSPChecker(String string) {
        this._jsprooturi = string;
    }

    public WCMJSPChecker(String string, String string2, String string3, int n, String string4) {
        this.m_sApplicationRootPath = CMyString.setStrEndWith(string, File.separatorChar);
        this.m_sCheckPath = string2 == null || (string2 = string2.trim()).length() == 0 ? "" : CMyString.setStrEndWith(string2, File.separatorChar);
        this.m_sApplicationName = string4;
        this._jsprooturi = this.m_sApplicationRootPath + this.m_sCheckPath;
        this._host = string3;
        this._port = n;
    }

    public void setAuthDetail(String string, String string2, String string3) {
        this._username = string;
        this._password = string2;
        this._authPage = string3;
    }

    public void setResult(boolean bl) {
        this.m_bNeedStore = bl;
    }

    public void run() {
        this.logger.debug((Object)"loading jsp file source...");
        _jsps.clear();
        List list = this.loadJsps(this._jsprooturi);
        this.logger.debug((Object)("_jsprooturi:" + this._jsprooturi));
        this.logger.debug((Object)"loaded,checking the files...");
        try {
            this._cookie = this.getCookie();
            this.logger.debug((Object)this._cookie);
        }
        catch (Exception exception) {
            this.logger.error((Object)"Connect failed", (Throwable)exception);
            throw new RuntimeException(exception);
        }
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            String string = null;
            try {
                string = (String)list.get(i);
                int n2 = this.getResponseCodeForHttp(string);
                if (n2 == RESPONSECODE_OK) continue;
                this.logger.info((Object)("Error: " + string + "---RespCode=" + n2));
                arrayList.add(string);
                ++n;
                continue;
            }
            catch (Exception exception) {
                this.logger.error((Object)("Error: " + string), (Throwable)exception);
                arrayList.add(string);
                ++n;
            }
        }
        this.logger.info((Object)"============ done!");
        try {
            this.storeBadJsps(arrayList);
        }
        catch (Exception exception) {
            this.logger.error((Object)"produce a summary file failed", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    private List loadJsps(String string) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        File file2 = null;
        if (fileArray == null) {
            return _jsps;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            file2 = fileArray[i];
            if (file2.isDirectory()) {
                this.loadJsps(file2.getPath());
                continue;
            }
            if (!file2.getName().endsWith("jsp")) continue;
            String string2 = file2.getPath();
            string2 = string2.substring(this.m_sApplicationRootPath.length());
            string2 = string2.replace('\\', '/');
            _jsps.add("/" + this.m_sApplicationName + "/" + string2);
        }
        return _jsps;
    }

    private String getCookie() throws Exception {
        String string = null;
        Socket socket = new Socket(this._host, this._port);
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
        String string2 = this._authPage;
        printWriter.print("POST " + string2 + " HTTP/1.0" + "\r\n");
        printWriter.print("Connection: close\r\n");
        printWriter.print("Host: " + this._host + "\r\n");
        printWriter.print("ContentTypeConfig-type: application/x-www-form-urlencoded\r\n");
        String string3 = "j_username=" + this._username + "&j_password=" + this._password;
        printWriter.print("ContentTypeConfig-length: " + string3.length() + "\r\n");
        printWriter.print("\r\n");
        printWriter.print(string3 + "\r\n");
        printWriter.print("\r\n");
        printWriter.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        String string4 = null;
        while ((string4 = bufferedReader.readLine()) != null) {
            this.logger.debug((Object)string4);
            if (string4.trim().length() == 0) break;
            if (!string4.toLowerCase().startsWith("set-cookie:")) continue;
            string = string4.substring("Set-Cookie:".length()).trim();
            int n = string.indexOf(";");
            if (n == -1) break;
            string = string.substring(0, n).trim();
            break;
        }
        bufferedReader.close();
        printWriter.close();
        socket.close();
        return string;
    }

    protected int getResponseCode(String string) throws Exception {
        Object object;
        int n = -1;
        Socket socket = new Socket(this._host, this._port);
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
        String string2 = string + "?jsp_precompile=true";
        printWriter.print("GET " + string2 + " HTTP/1.0" + "\r\n");
        printWriter.print("Cookie: " + this._cookie + "\r\n");
        printWriter.print("Connection: close\r\n");
        printWriter.print("Host: " + this._host + "\r\n");
        printWriter.print("\r\n");
        printWriter.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        String string3 = bufferedReader.readLine();
        if (string3 != null) {
            object = new StringTokenizer(string3.trim());
            ((StringTokenizer)object).nextToken();
            n = Integer.parseInt(((StringTokenizer)object).nextToken());
        }
        while ((string3 = bufferedReader.readLine()) != null && string3.trim().length() != 0) {
        }
        object = new StringBuffer();
        while ((string3 = bufferedReader.readLine()) != null) {
            ((StringBuffer)object).append(string3).append("\n");
        }
        bufferedReader.close();
        printWriter.close();
        socket.close();
        return n;
    }

    private void storeBadJsps(List list) throws Exception {
        if (this.m_bNeedStore) {
            this.logger.debug((Object)"creating summary file:badjsps.xml");
            String string = "./badjsps.txt";
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("amount of badjsps:" + list.size() + "\n");
            for (int i = 0; i < list.size(); ++i) {
                stringBuffer.append((String)list.get(i));
                stringBuffer.append("\n");
            }
            CMyFile.writeFile(string, stringBuffer.toString());
            this.logger.debug((Object)"done,you can check the summary file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getResponseCodeForHttp(String string) throws Exception {
        int n;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("open " + string + " ..."));
        }
        HttpURLConnection httpURLConnection = null;
        try {
            String string2 = string + "?jsp_precompile=true";
            URL uRL = new URL("http", this._host, this._port, string2);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.connect();
            int n2 = httpURLConnection.getResponseCode();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("open " + string + ".ResponseCode=" + n2));
            }
            n = n2;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }
}

