/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service.util;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class MetaViewDataEditorContentAnalyzer {
    private static Logger logger = Logger.getLogger(MetaViewDataEditorContentAnalyzer.class);
    private List m_oFoundObj;
    private int m_nIndex = 0;
    private int m_nFoundCount = 0;
    private Pattern m_ignoreExp = Pattern.compile("(?im)<img[^>]*? (ignore=(\"|')1\\1)[^>]*>");
    private Pattern m_readImageExp = Pattern.compile("(?im)<img[^>]*? src=(\"|').*?read_image.jsp.*?\\1[^>]*>");
    private IMetaDataDefCacheMgr oMetaDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");

    public void analyze() throws WCMException {
        this.m_oFoundObj = new ArrayList();
        this.m_nIndex = 0;
        this.m_nFoundCount = 0;
        MetaViews metaViews = MetaViews.createNewInstance(ContextHelper.getLoginUser());
        metaViews.open(null);
        int n = metaViews.size();
        for (int i = 0; i < n; ++i) {
            MetaView metaView = (MetaView)metaViews.getAt(i);
            if (metaView == null) continue;
            this.analyze0(metaView);
        }
        logger.info((Object)("\u603b\u8fc7\u5206\u6790\u3010" + this.m_nIndex + "\u3011\u6761\u8bb0\u5f55"));
        logger.info((Object)("\u5171\u53d1\u73b0\u9700\u8981\u5904\u7406\u7684\u6587\u6863\u603b\u6570:" + this.m_nFoundCount));
        this.printFoundRecords();
    }

    public void analyze(MetaView metaView) throws WCMException {
        this.m_oFoundObj = new ArrayList();
        this.m_nIndex = 0;
        this.m_nFoundCount = 0;
        this.analyze0(metaView);
        logger.info((Object)("\u603b\u8fc7\u5206\u6790\u3010" + this.m_nIndex + "\u3011\u6761\u8bb0\u5f55"));
        logger.info((Object)("\u5171\u53d1\u73b0\u9700\u8981\u5904\u7406\u7684\u6587\u6863\u603b\u6570:" + this.m_nFoundCount));
        this.printFoundRecords();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyze0(MetaView metaView) throws WCMException {
        logger.info((Object)("\u5f00\u59cb\u5206\u6790\u89c6\u56fe:" + metaView.getDesc()));
        Map map = this.oMetaDataDefCacheMgr.getMetaViewFields(metaView.getId(), 12);
        String string = metaView.getTrueTableName();
        String string2 = "select MetaDataId from " + string;
        Connection connection = null;
        try {
            try {
                connection = DBManager.getDBManager().getConnection();
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(string2);
                while (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    MetaViewData metaViewData = MetaViewData.findById(n);
                    this.analyze(metaViewData, map);
                    ++this.m_nIndex;
                    if (this.m_nIndex % 50 != 0) continue;
                    logger.info((Object)("\u5f00\u59cb\u5206\u6790\u7b2c\u3010" + this.m_nIndex + "\u3011\u6761\u8bb0\u5f55......"));
                }
                Object var11_11 = null;
                if (connection != null) {
                    DBManager.getDBManager().freeConnection(connection);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var11_12 = null;
                if (connection != null) {
                    DBManager.getDBManager().freeConnection(connection);
                }
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (connection != null) {
                DBManager.getDBManager().freeConnection(connection);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeDocument() throws WCMException {
        this.m_oFoundObj = new ArrayList();
        this.m_nIndex = 0;
        this.m_nFoundCount = 0;
        String string = "select docid from WCMDOCUMENT";
        Connection connection = null;
        try {
            try {
                connection = DBManager.getDBManager().getConnection();
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    Document document = Document.findById(n);
                    document.setHtmlContent(this.analyze(document, document.getHtmlContent()));
                    ++this.m_nIndex;
                    if (this.m_nIndex % 50 != 0) continue;
                    logger.info((Object)("\u5f00\u59cb\u5206\u6790\u7b2c\u3010" + this.m_nIndex + "\u3011\u6761\u8bb0\u5f55......"));
                }
                Object var8_8 = null;
                if (connection != null) {
                    DBManager.getDBManager().freeConnection(connection);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var8_9 = null;
                if (connection != null) {
                    DBManager.getDBManager().freeConnection(connection);
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (connection != null) {
                DBManager.getDBManager().freeConnection(connection);
            }
            throw throwable;
        }
        logger.info((Object)("\u603b\u8fc7\u5206\u6790\u3010" + this.m_nIndex + "\u3011\u6761\u8bb0\u5f55"));
        logger.info((Object)("\u5171\u53d1\u73b0\u9700\u8981\u5904\u7406\u7684\u6587\u6863\u603b\u6570:" + this.m_nFoundCount));
        this.printFoundRecords();
    }

    private void analyze(MetaViewData metaViewData, Map map) throws WCMException {
        for (String string : map.keySet()) {
            String string2 = metaViewData.getPropertyAsString(string);
            if (CMyString.isEmpty(string2)) continue;
            metaViewData.setPropertyWithString(string, this.analyze((BaseObj)metaViewData, string2));
        }
    }

    private String analyze(BaseObj baseObj, String string) {
        Matcher matcher = this.m_readImageExp.matcher(string);
        boolean bl = false;
        while (matcher.find()) {
            logger.info((Object)("\u627e\u5230read_image.jsp:" + matcher.group()));
            bl = true;
        }
        if (bl) {
            ++this.m_nFoundCount;
            this.m_oFoundObj.add(baseObj);
        }
        return string;
    }

    private void printFoundRecords() {
        logger.info((Object)"-------------------------");
        for (int i = 0; i < this.m_oFoundObj.size(); ++i) {
            BaseObj baseObj = (BaseObj)this.m_oFoundObj.get(i);
            logger.info((Object)baseObj.toString());
        }
    }
}

